/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.engine;

import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.bibushandler.CancelManager;
import com.cognos.xqe.bibushandler.CancelableRequestRegistry;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.bibushandler.XQEEnvironment;
import com.cognos.xqe.bibushandler.content.ContentManager;
import com.cognos.xqe.bibushandler.datasource.DataSource;
import com.cognos.xqe.bibushandler.datasource.UsernamePasswordSignonNoEncryption;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.SimpleDataSource;
import com.cognos.xqe.data.providers.SimpleDataSourceConnection;
import com.cognos.xqe.data.providers.relational.AbstractConnection;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.pool.connection.IConnectionPool;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IContextable;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.Nag;
import com.cognos.xqe.query.engine.NagCollector;
import com.cognos.xqe.query.engine.NagMDO;
import com.cognos.xqe.query.engine.NagMigrate;
import com.cognos.xqe.query.engine.NagReuse;
import com.cognos.xqe.query.engine.NagSimple;
import com.cognos.xqe.query.engine.TestEnvironmentOptions;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.LocaleConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import org.dom4j.Element;

public abstract class BaseExecutionEnvironment<R extends IRequestEnvironment>
extends XQEEnvironment
implements IExecutionEnvironment {
    private static final String STR_NULL = "NULL";
    private R mRequestEnv = null;
    private Element connectionElement = null;
    private boolean dumpMDX = false;
    private List<String> xIteratorsToLog = null;
    private boolean rsapiTabularIteratorLogging = false;
    private TestEnvironmentOptions testEnvironmentOptions = null;
    private IConnectionPool mConnectionPool = null;
    private MultiRequestContext mMultiRequestContext = null;
    private IDataSource mExecutionDataSource = null;
    private CancelManager mCancelManager = null;
    private final NagCollector mNagCollector = new NagCollector();
    private final Set<String> serverCollationInfo = new TreeSet<String>();
    private final Set<String> localCollationInfo = new TreeSet<String>();
    private String cachedCollationSequenceKey = null;
    private boolean localSortIsCompatibleWithServer = false;
    private XDataContext mHeadDataContext = null;
    private Governors mGovernors = null;
    boolean doingIsMCStillValidForFlint = false;
    long maxRowsLocalProcessing = 0L;
    AtomicLong rowCounterForAllRequests = new AtomicLong(0L);

    @Override
    public String resolveDataSourceConnectionName(String dsName) {
        String searchPath = this.getConnectionSearchPath(dsName);
        if (searchPath != null) {
            return ContentManager.getSearchPathPropName(this.getRequestEnvironment(), searchPath, "dataSourceConnection");
        }
        return this.getDataSourceConnectionNameFilter(dsName);
    }

    @Override
    public String getDataSourceConnectionName() {
        return this.getDataSourceConnectionNameFilter(null);
    }

    public String getDataSourceConnectionNameFilter(String dsName) {
        String connectionName = null;
        if (this.connectionElement != null) {
            Element nameElement = this.connectionElement.element("name");
            connectionName = nameElement != null && this.checkDataSource(this.connectionElement, dsName) ? nameElement.attributeValue("value") : this.getNestedDataSourceConnectionName(this.connectionElement, dsName);
        }
        return connectionName;
    }

    private String getNestedDataSourceConnectionName(Element connectElement, String dsName) {
        if (connectElement != null) {
            List nestedConnectionElements = connectElement.elements("connection");
            if (nestedConnectionElements.size() == 0) {
                Element nameElement;
                String dataSourceTypeValue;
                Element dataSourceType = connectElement.element("QFProviderType");
                if (dataSourceType == null) {
                    dataSourceType = connectElement.element("dataSourceType");
                }
                if (dataSourceType != null && (dataSourceTypeValue = dataSourceType.attributeValue("value")) != null && dataSourceTypeValue.equals("Database") && this.checkDataSource(connectElement, dsName) && (nameElement = connectElement.element("name")) != null) {
                    return nameElement.attributeValue("value");
                }
            } else {
                for (Element nestedConnectionElement : nestedConnectionElements) {
                    String dataSourceName = this.getNestedDataSourceConnectionName(nestedConnectionElement, dsName);
                    if (dataSourceName == null) continue;
                    return dataSourceName;
                }
            }
        }
        return null;
    }

    private boolean checkDataSource(Element connectElement, String dsName) {
        boolean flagDs = false;
        if (dsName != null) {
            Element dataSource = connectElement.element("dataSource");
            if (dataSource != null) {
                flagDs = null != dataSource.attributeValue("value") && dataSource.attributeValue("value").equals(dsName);
            }
        } else {
            flagDs = true;
        }
        return flagDs;
    }

    @Override
    public Element getConnectionElement() {
        return this.connectionElement;
    }

    @Override
    public void setConnectionElement(Element connection) {
        if (connection != null) {
            connection = connection.createCopy();
            connection.detach();
        }
        this.connectionElement = connection;
    }

    @Override
    public String getConnectionSearchPath() {
        return this.getSearchPath(this.getConnectionElement());
    }

    @Override
    public String getSignOnSearchPath() {
        return this.getSignOnSearchPath(this.getConnectionElement());
    }

    @Override
    public String getConnectionSearchPath(String dsName) {
        return this.getSearchPathByDatasourceName(this.getConnectionElement(), dsName);
    }

    private String getSearchPath(Element connectElement) {
        if (null == connectElement) {
            return null;
        }
        Element nestedConnectionElement = connectElement.element("connection");
        while (nestedConnectionElement != null) {
            connectElement = nestedConnectionElement;
            nestedConnectionElement = connectElement.element("connection");
        }
        Element pathElement = connectElement.element("searchPath");
        if (pathElement != null) {
            return pathElement.attributeValue("value");
        }
        return null;
    }

    private String getSignOnSearchPath(Element connectElement) {
        Element pathElement;
        if (null == connectElement) {
            return null;
        }
        Element nestedConnectionElement = connectElement.element("connection");
        while (nestedConnectionElement != null) {
            connectElement = nestedConnectionElement;
            nestedConnectionElement = connectElement.element("connection");
        }
        Element signOnElement = connectElement.element("signon");
        if (signOnElement != null && (pathElement = signOnElement.element("searchPath")) != null) {
            return pathElement.attributeValue("value");
        }
        return null;
    }

    private String getSearchPathByDatasourceName(Element connectElement, String dsName) {
        if (null == connectElement) {
            return null;
        }
        List nestedConnectionElements = connectElement.elements("connection");
        if (nestedConnectionElements.size() == 0) {
            Element pathElement;
            Element dataSource = connectElement.element("dataSource");
            if (null != dataSource && null != dataSource.attributeValue("value") && dataSource.attributeValue("value").equals(dsName) && (pathElement = connectElement.element("searchPath")) != null) {
                return pathElement.attributeValue("value");
            }
        } else {
            for (Element nestedConnectionElement : nestedConnectionElements) {
                String searchPath = this.getSearchPathByDatasourceName(nestedConnectionElement, dsName);
                if (searchPath == null) continue;
                return searchPath;
            }
        }
        return null;
    }

    public <R1 extends IRequestEnvironment> void setRequestEnvironment(R1 env) {
        this.mRequestEnv = env;
    }

    @Override
    public R getRequestEnvironment() {
        return this.mRequestEnv;
    }

    @Override
    public void setDataSource(IDataSource source) {
        this.mExecutionDataSource = source;
    }

    @Override
    public IDataSource getDataSource() {
        return this.mExecutionDataSource;
    }

    @Override
    public IConnectionPool getConnectionPool() {
        return this.mConnectionPool;
    }

    @Override
    public void setConnectionPool(IConnectionPool connectionPool) {
        this.mConnectionPool = connectionPool;
    }

    @Override
    public void setMultiRequestContext(MultiRequestContext multiRequestContext) {
        this.mMultiRequestContext = multiRequestContext;
    }

    @Override
    public MultiRequestContext getMultiRequestContext() {
        if (null == this.mMultiRequestContext) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_MultiRequestContextMissing_INTERNAL);
        }
        return this.mMultiRequestContext;
    }

    @Override
    public MultiRequestContext getMultiRequestContextNoThrow() {
        return this.mMultiRequestContext;
    }

    @Override
    @Deprecated
    public IDataSource getDataSource(String cmName) throws XQERuntimeException {
        for (IDataSource ds : this.getDataSources()) {
            if (null == ds.getCMDataSourceName() || !ds.getCMDataSourceName().equals(cmName)) continue;
            return ds;
        }
        DataSource ds = new DataSource(cmName, cmName, null, null);
        this.getMultiRequestContext().addDataSource(ds);
        return ds;
    }

    public IDataSource getOrAddDataSource(String modelName, String interfaceType, Map<String, Object> metadataProps) {
        IDataSource ds = this.getDataSourceByModelNameNoThrow(modelName);
        if (null == ds) {
            String connectionString = (String)metadataProps.get("connectionString");
            String userID = (String)metadataProps.get("userID");
            String password = (String)metadataProps.get("password");
            UsernamePasswordSignonNoEncryption signon = null;
            if (userID != null && password != null) {
                signon = new UsernamePasswordSignonNoEncryption("JDBCConnectionSignon" + interfaceType, userID, password);
            }
            SimpleDataSourceConnection connection = new SimpleDataSourceConnection(connectionString, signon);
            ds = new SimpleDataSource(modelName, interfaceType, connection, metadataProps);
            this.getMultiRequestContext().addDataSource(ds);
        }
        return ds;
    }

    @Override
    public IDataSource getOrAddDataSource(String modelName, String cmDataSourceName, String interfaceType, Map<String, Object> metadataProps) {
        boolean foundMatch = false;
        IDataSource ds = this.getDataSourceByModelNameNoThrow(modelName);
        if (ds != null) {
            foundMatch = true;
            if (cmDataSourceName != null && !cmDataSourceName.equals(ds.getCMDataSourceName())) {
                foundMatch = this.matchesWithResolvedMacro(ds.getCMDataSourceName(), cmDataSourceName);
            }
            if (metadataProps != null) {
                Map<String, Object> foundMetadataProps = ds.getMetadataProperties();
                String catalog = (String)metadataProps.get("catalog");
                if (foundMatch && catalog != null && !catalog.equals(foundMetadataProps.get("catalog"))) {
                    foundMatch = this.matchesWithResolvedMacro((String)foundMetadataProps.get("catalog"), catalog);
                }
                String schema = (String)metadataProps.get("schema");
                if (foundMatch && schema != null && !schema.equals(foundMetadataProps.get("schema"))) {
                    foundMatch = this.matchesWithResolvedMacro((String)foundMetadataProps.get("schema"), schema);
                }
                String subType = (String)metadataProps.get("subType");
                if (foundMatch && subType != null && !subType.equals(foundMetadataProps.get("subType"))) {
                    foundMatch = this.matchesWithResolvedMacro((String)foundMetadataProps.get("subType"), subType);
                }
            }
        }
        if (!foundMatch) {
            ds = new DataSource(modelName, cmDataSourceName, interfaceType, metadataProps);
            if (null != cmDataSourceName) {
                this.getMultiRequestContext().addDataSource(ds);
            } else {
                String nagMsg = XQEMessages.getMessage(XQEMessageKeys.DS_DataSourceNotFound, XQEMessages.getCurrProductLocale(), modelName);
                this.addNag(nagMsg);
            }
        }
        return ds;
    }

    @Override
    public IDataSource getOrAddDataSource(ICube cube) {
        IModelDataSource modelDataSource = cube.getModelDataSource();
        return this.getOrAddDataSource(modelDataSource);
    }

    @Override
    public IDataSource getOrAddDataSource(IModelDataSource modelDataSource) {
        if (modelDataSource.isContentManager()) {
            if (modelDataSource.isROLAP() || modelDataSource.isDummy()) {
                return this.getOrAddDataSource(modelDataSource.getName(), modelDataSource.getCMDataSourceName(), modelDataSource.getInterface(), modelDataSource.getMetadataProperties());
            }
            return this.getOrAddDataSource(modelDataSource.getName(), modelDataSource.getCMDataSourceName(), null, modelDataSource.getMetadataProperties());
        }
        return this.getOrAddDataSource(modelDataSource.getName(), modelDataSource.getInterface(), modelDataSource.getMetadataProperties());
    }

    @Override
    public IDataSource getDataSourceByModelName(String modelName) throws XQERuntimeException {
        IDataSource dataSource = this.getDataSourceByModelNameNoThrow(modelName);
        if (null == dataSource) {
            throw new XQERuntimeException(XQEMessageKeys.DS_DataSourceNotFound, modelName);
        }
        return dataSource;
    }

    @Override
    public IDataSource getDataSourceByModelNameNoThrow(String modelName) {
        if (null == modelName) {
            return null;
        }
        return this.getMultiRequestContext().getDataSourceByModelName(modelName);
    }

    @Override
    public Collection<IDataSource> getDataSources() {
        return this.getMultiRequestContext().getDataSources();
    }

    @Override
    public String getRequestID() {
        if (null == this.mRequestEnv) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_RequestEnvironmentMissing_INTERNAL);
        }
        return this.mRequestEnv.getRequestID();
    }

    @Override
    public CancelManager getCancelManager() {
        if (this.mCancelManager == null) {
            this.mCancelManager = new CancelManager(this.mRequestEnv.getRequestID());
        }
        return this.mCancelManager;
    }

    @Override
    public void setCancelManager(CancelManager cancelManager) {
        this.mCancelManager = cancelManager;
    }

    @Override
    public boolean getDumpMDX() {
        return this.dumpMDX;
    }

    @Override
    public void setDumpMDX(boolean setting) {
        this.dumpMDX = setting;
    }

    @Override
    public boolean getXIteratorLogging(String iteratorClassName) {
        if (this.xIteratorsToLog == null) {
            return false;
        }
        return this.xIteratorsToLog.contains(iteratorClassName);
    }

    @Override
    public List<String> getXIteratorLoggingList() {
        if (this.xIteratorsToLog == null) {
            return null;
        }
        ArrayList<String> cl = new ArrayList<String>();
        cl.addAll(this.xIteratorsToLog);
        return cl;
    }

    @Override
    public void setXIteratorLoggingList(List<String> iteratorClassNameList) {
        this.xIteratorsToLog = iteratorClassNameList;
    }

    @Override
    public boolean getRSAPITabularIteratorLogging() {
        return this.rsapiTabularIteratorLogging;
    }

    @Override
    public void setRSAPITabularIteratorLogging(boolean setting) {
        this.rsapiTabularIteratorLogging = setting;
    }

    @Override
    public void registerDataSourceCollationInformation(String serverCollationName, String localCollationName) {
        if (null != serverCollationName) {
            this.serverCollationInfo.add(serverCollationName);
        }
        if (null != localCollationName) {
            this.localCollationInfo.add(localCollationName);
        }
    }

    @Override
    public String getLocalCollationSequenceKey() {
        if (this.cachedCollationSequenceKey == null) {
            this.setLocalCollationSequenceKeyAndCompatibilityFlag();
        }
        return this.cachedCollationSequenceKey;
    }

    @Override
    public boolean getLocalSortIsCompatibleWithServer() {
        if (this.cachedCollationSequenceKey == null) {
            this.setLocalCollationSequenceKeyAndCompatibilityFlag();
        }
        return this.localSortIsCompatibleWithServer;
    }

    @Override
    public boolean getLocalSortIsCompatibleWithServer(AbstractConnection connection) {
        String dbCollation;
        if (this.cachedCollationSequenceKey == null) {
            this.setLocalCollationSequenceKeyAndCompatibilityFlag();
        }
        if ((dbCollation = connection.getDatabaseCollationSequence()) != null) {
            return connection.getDatabaseCollationSequence().equals(this.cachedCollationSequenceKey);
        }
        return false;
    }

    private synchronized void setLocalCollationSequenceKeyAndCompatibilityFlag() {
        Locale runLocale;
        String[] parts = null;
        boolean weightOnly = false;
        if (this.cachedCollationSequenceKey != null) {
            return;
        }
        if (!this.serverCollationInfo.isEmpty()) {
            Iterator<String> iter = this.serverCollationInfo.iterator();
            while (iter.hasNext() && this.cachedCollationSequenceKey == null) {
                this.cachedCollationSequenceKey = iter.next();
            }
            if (this.cachedCollationSequenceKey != null) {
                parts = this.cachedCollationSequenceKey.split(":");
                boolean bl = weightOnly = parts[0].length() == 0;
                if (weightOnly) {
                    this.cachedCollationSequenceKey = null;
                }
            }
            if (!weightOnly && this.cachedCollationSequenceKey != null && this.serverCollationInfo.size() == 1) {
                this.localSortIsCompatibleWithServer = true;
            }
        }
        if (this.cachedCollationSequenceKey == null && this.localCollationInfo.size() == 1) {
            this.cachedCollationSequenceKey = this.localCollationInfo.iterator().next();
        }
        if (this.cachedCollationSequenceKey == null && this.getRequestEnvironment() != null && (runLocale = this.getRequestEnvironment().getRunLocale()) != null) {
            this.cachedCollationSequenceKey = LocaleConverter.toString(runLocale);
        }
        if (this.cachedCollationSequenceKey == null) {
            this.cachedCollationSequenceKey = LocaleConverter.toString(Locale.getDefault());
        }
        if (weightOnly) {
            this.cachedCollationSequenceKey = String.format("%1$s:%2$s", this.cachedCollationSequenceKey, parts[1]);
        }
    }

    @Override
    public void registerResource(IContextable resource) {
        this.getMultiRequestContext().registerResource(resource);
    }

    @Override
    public void unregisterResource(IContextable resource) {
        this.getMultiRequestContext().unregisterResource(resource);
    }

    @Override
    public String applyNestedLevelDecorationRules(ICube cube) {
        IDataSource dataSource;
        IModelDataSource modelDS;
        if (cube != null && (modelDS = cube.getModelDataSource()) != null && (dataSource = this.getDataSourceByModelNameNoThrow(modelDS.getName())) != null) {
            return dataSource.getCapabilities().getStringValue("applyNestedLevelDecorationRules", null);
        }
        return null;
    }

    @Override
    public boolean useCheckMemberRulesSecondaryQuery(ICube cube) {
        IDataSource dataSource;
        IModelDataSource modelDS;
        if (cube != null && (modelDS = cube.getModelDataSource()) != null && (dataSource = this.getDataSourceByModelNameNoThrow(modelDS.getName())) != null) {
            return dataSource.getCapabilities().getUseCheckMemberRulesSecondaryQuery();
        }
        return false;
    }

    @Override
    public CancelableRequestRegistry getCancelableRequestRegistry() {
        CancelableRequestRegistry cancelableRequestRegistry = null == this.mMultiRequestContext ? null : this.mMultiRequestContext.getCancelableRequestRegistry();
        return cancelableRequestRegistry;
    }

    @Override
    public XDataContext getDataContext() {
        return this.mHeadDataContext;
    }

    @Override
    public XDataContext pushDataContext() {
        XDataContext newDataContext = null != this.mHeadDataContext ? this.mHeadDataContext.createSubContext(this) : new XDataContext(null, this);
        newDataContext.incrementRefCount();
        this.mHeadDataContext = newDataContext;
        return newDataContext;
    }

    @Override
    public void popDataContext(XDataContext expected) {
        XDataContext oldDataContext = this.mHeadDataContext;
        if (null == oldDataContext) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "There was no XDataContext in scope.");
        }
        if (expected != oldDataContext) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "An unexpected XDataContext was in scope.");
        }
        this.mHeadDataContext = oldDataContext.getParent();
        oldDataContext.decrementRefCount();
    }

    @Override
    public void setGovernors(Governors governors) {
        this.mGovernors = governors;
    }

    @Override
    public Governors getGovernors() {
        return this.mGovernors;
    }

    @Override
    public void addNag(String nagMessage) {
        this.mNagCollector.addNag(new NagSimple(nagMessage));
    }

    @Override
    public void addMigrateNag(String nagMessage) {
        this.mNagCollector.addNag(new NagMigrate(nagMessage));
    }

    @Override
    public void addNag(Nag nag) {
        this.mNagCollector.addNag(nag);
    }

    @Override
    public void addReuseNag(String nagMessage) {
        this.mNagCollector.addNag(new NagReuse(nagMessage));
    }

    @Override
    public void addMDONag(String nagMessage) {
        this.mNagCollector.addNag(new NagMDO(nagMessage));
    }

    @Override
    public NagCollector getNagCollector() {
        return this.mNagCollector;
    }

    @Override
    public TestEnvironmentOptions getTestEnvironmentOptions() {
        return this.testEnvironmentOptions;
    }

    public void setTestEnvironmentOptions(TestEnvironmentOptions theTestEnvironmentOptions) {
        this.testEnvironmentOptions = theTestEnvironmentOptions;
    }

    public void copyCollationTo(IExecutionEnvironment targetEnv) {
        BaseExecutionEnvironment target = (BaseExecutionEnvironment)targetEnv;
        target.localCollationInfo.addAll(this.localCollationInfo);
        target.serverCollationInfo.addAll(this.serverCollationInfo);
    }

    @Override
    public void copyTo(IExecutionEnvironment targetEnv) {
        BaseExecutionEnvironment target = (BaseExecutionEnvironment)targetEnv;
        target.mRequestEnv = this.mRequestEnv;
        target.mMultiRequestContext = this.mMultiRequestContext;
        target.cachedCollationSequenceKey = this.cachedCollationSequenceKey;
        target.connectionElement = this.connectionElement;
        target.dumpMDX = this.dumpMDX;
        target.xIteratorsToLog = this.xIteratorsToLog;
        target.localCollationInfo.addAll(this.localCollationInfo);
        target.localSortIsCompatibleWithServer = this.localSortIsCompatibleWithServer;
        target.mCancelManager = this.mCancelManager;
        target.mConnectionPool = this.mConnectionPool;
        target.mExecutionDataSource = this.mExecutionDataSource;
        target.mTrace = this.mTrace;
        target.serverCollationInfo.addAll(this.serverCollationInfo);
        target.mHeadDataContext = this.mHeadDataContext;
    }

    public boolean matchesWithResolvedMacro(String valueToMatch, String macroToResolve) {
        if (MacroExpander.isMacro(macroToResolve)) {
            return MacroExpander.matchesWithResolvedMacro(this.mRequestEnv.getResolvedMacros(), null, macroToResolve, valueToMatch);
        }
        return false;
    }

    @Override
    public void setIsMCStillValidForFlint(boolean value) {
        this.doingIsMCStillValidForFlint = value;
    }

    @Override
    public boolean getIsMCStillValidForFlint() {
        return this.doingIsMCStillValidForFlint;
    }

    public void setMaxRowsLocalProcessing(long limit) {
        if (limit > 0L) {
            this.maxRowsLocalProcessing = this.maxRowsLocalProcessing > 0L ? Math.min(limit, this.maxRowsLocalProcessing) : limit;
        }
    }

    @Override
    public long getMaxRowsLocalProcessing() {
        return this.maxRowsLocalProcessing;
    }

    public void copyMaxRowsLocalProcessing(IExecutionEnvironment newExecEnv) {
        ((ExecutionEnvironment)newExecEnv).rowCounterForAllRequests = this.rowCounterForAllRequests;
    }

    @Override
    public long incrementAndGetMaxRowsLocalProcessing() {
        return this.rowCounterForAllRequests.incrementAndGet();
    }
}

