/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.engine;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.XQENodeIndex;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.provider.IMetadataConnection;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.PersistentQueryPlan;
import com.cognos.xqe.query.engine.ResponseMessageFolder;
import com.cognos.xqe.query.engine.TransformationEngineException;
import com.cognos.xqe.trace.TraceLogManager;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.symboltable.ISymbolTable;
import com.cognos.xqe.util.symboltable.SymbolTableForModel;
import com.cognos.xqe.util.symboltable.SymbolTableStack;
import com.cognos.xqemoser.MoserMetadataConnection;
import com.cognos.xqeqte.QTEAbstractPlanningEnvironment;
import com.cognos.xqeqte.QTEPlanningEnvironment;
import com.cognos.xqeqte.QTEQueryNode;
import java.io.IOException;
import java.io.Writer;

public class BasePlanningEnvironment<R extends IRequestEnvironment, E extends IExecutionEnvironment, M extends IMetadataConnection>
extends QTEAbstractPlanningEnvironment<IXQEQueryNode>
implements IPlanningEnvironment {
    private boolean planningActive = false;
    private XQENodeIndex nodeIndex = null;
    private R requestEnv;
    private XQENodeFactory nodeFactory;
    private Writer curTraceWriter;
    private Writer savedTraceWriter;
    protected M metadataConnection;
    protected IModelDataSource dataSource;
    protected Boolean useLocalQueryProcessing = Boolean.FALSE;
    protected Writer logWriter = null;
    protected String defaultSchema;
    private int contextNo;
    protected XQETrace mTrace = null;
    private String cubeName;
    private SymbolTableStack symbolTableStack = null;
    private QTEPlanningEnvironment.PlanningMode planningMode = QTEPlanningEnvironment.PlanningMode.None;
    private PersistentQueryPlan queryPlan = new PersistentQueryPlan();

    public BasePlanningEnvironment() {
        this.loadQueryLineageTrackingConfiguration();
        this.symbolTableStack = new SymbolTableStack();
        this.symbolTableStack.push(new SymbolTableForModel(this));
    }

    @Override
    public void setTrace(XQETrace trace) {
        this.mTrace = trace;
    }

    @Override
    public XQETrace getTrace() {
        return this.mTrace;
    }

    @Override
    public XQENodeIndex getNodeIndex() {
        if (null == this.nodeIndex) {
            this.nodeIndex = new XQENodeIndex();
        }
        return this.nodeIndex;
    }

    @Override
    public void clearNodeIndex() {
        this.nodeIndex = null;
    }

    @Override
    public void setTreeHasBeenModified() {
        if (!this.planningActive && this.getRequestEnvironment() != null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "setTreeHasBeenModified on inactive planning environment");
        }
        super.setTreeHasBeenModified();
    }

    @Override
    public boolean getUseLocalQueryProcessing() {
        return this.useLocalQueryProcessing;
    }

    public ISymbolTable popSymbolTable() {
        return this.symbolTableStack.pop();
    }

    public void pushSymbolTable(ISymbolTable symbolTable) {
        this.symbolTableStack.push(symbolTable);
    }

    public SymbolTableStack getSymbolTableStack() {
        return this.symbolTableStack;
    }

    public IMetadata bindMetadataReference(String ref) {
        return this.symbolTableStack.get(ref);
    }

    @Override
    public void setUseLocalQueryProcessing(Boolean value) {
        this.useLocalQueryProcessing = value;
    }

    @Override
    public void setNodeFactory(XQENodeFactory theNodeFactory) {
        this.nodeFactory = theNodeFactory;
    }

    @Override
    public XQENodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    @Override
    public IXQEQueryNode getRoot() {
        return (IXQEQueryNode)super.getRoot();
    }

    @Override
    public int getRandomSeed() {
        return this.requestEnv.getRandomSeed();
    }

    @Override
    public String getNodeTypeName(int type) {
        return this.getNodeFactory().getNodeTypeName(type);
    }

    private void setRequestEnvironment(R env) {
        this.requestEnv = env;
    }

    @Override
    public R getRequestEnvironment() {
        return this.requestEnv;
    }

    @Override
    public E getExecutionEnvironment() {
        E executionEnvironment = null;
        if (null != this.requestEnv) {
            executionEnvironment = this.requestEnv.getExecutionEnvironment();
        }
        return executionEnvironment;
    }

    @Override
    public MultiRequestContext getMultiRequestContext() {
        E execEnv = this.getExecutionEnvironment();
        if (execEnv != null) {
            return execEnv.getMultiRequestContext();
        }
        return null;
    }

    @Override
    public ResponseMessageFolder getResponseMessageFolder() {
        return this.getRequestEnvironment().getResponseMessageFolder();
    }

    @Override
    public M getMetadataConnection() {
        return this.metadataConnection;
    }

    public <M1 extends IMetadataConnection> void setMetdataConnection(M1 theMetadataConnection) {
        this.metadataConnection = theMetadataConnection;
        if (this.metadataConnection instanceof MoserMetadataConnection) {
            this.symbolTableStack.setAllowBindToSelf(false);
        }
    }

    @Override
    public void setMADataSource(IModelDataSource theDataSource) {
        this.dataSource = theDataSource;
    }

    @Override
    public IModelDataSource getMADataSource() {
        return this.dataSource;
    }

    @Override
    public boolean getQueryLineageTrackingEnabled() {
        boolean enabledInConfig = this.mQueryLineageEnabledInConfig;
        if (!enabledInConfig) {
            return false;
        }
        R reqEnv = this.getRequestEnvironment();
        if (reqEnv == null) {
            return false;
        }
        return reqEnv.isValidateRequest();
    }

    @Override
    public void enableLockNodeQueryPlanning(int theLockNodeType) {
        if (super.isLockNodeQueryPlanningEnabled()) {
            this.disableLockNodeQueryPlanning();
            throw new TransformationEngineException(XQEMessageKeys.QTE_LockedNodeModeAlreadyEnabled, this.getNodeFactory().getNodeTypeName(this.getLockNodeType()));
        }
        super.enableLockNodeQueryPlanning(theLockNodeType);
    }

    public XQETrace openPlanningLog(IRequestEnvironment reqEnv) {
        this.logWriter = TraceLogManager.getInstance().createPlanningTraceWriter(reqEnv);
        XQETrace trace = new XQETrace();
        if (this.logWriter != null) {
            trace.addStream(this.logWriter);
            this.setCurrentTraceWriter(this.logWriter);
        }
        this.setTrace(trace);
        return trace;
    }

    @Override
    public void closePlanningLog() {
        if (this.logWriter != null) {
            try {
                this.logWriter.close();
            }
            catch (IOException ioe) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)ioe);
            }
        }
    }

    public void determineJDBCTraceFileName(IRequestEnvironment reqEnv) {
        reqEnv.setJDBCTraceFileName(TraceLogManager.getInstance().createJDBCTraceWriter(reqEnv));
    }

    @Override
    public void setCurrentTraceWriter(Writer writer) {
        this.curTraceWriter = writer;
    }

    @Override
    public Writer getCurrentTraceWriter() {
        return this.curTraceWriter;
    }

    @Override
    public void saveCurrentTraceWriter() {
        this.savedTraceWriter = this.curTraceWriter;
    }

    @Override
    public Writer getSavedTraceWriter() {
        return this.savedTraceWriter;
    }

    public <R1 extends IRequestEnvironment> void setPlanningActive(R1 reqEnv) {
        this.planningActive = true;
        this.requestEnv = reqEnv;
    }

    @Override
    public void setPlanningInactive() {
        this.planningActive = false;
        this.closePlanningLog();
        this.setRequestEnvironment(null);
        this.clearNodeIndex();
    }

    @Override
    public String getModelPath() {
        return this.getRequestEnvironment().getModelPath();
    }

    @Override
    public void initializePlanning() {
    }

    @Override
    public void finalizePlanning() {
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    @Override
    public void setDefaultSchema(String schema) {
        this.defaultSchema = schema;
    }

    @Override
    public void addDataSource(IDataSource ds) {
        V5QuerySet rootQuerySet = null;
        if (this.getRoot().getType() == 101002) {
            rootQuerySet = (V5QuerySet)this.getRoot();
            rootQuerySet.addDataSource(ds);
        }
    }

    private void loadQueryLineageTrackingConfiguration() {
        if (this.mQueryLineageEnabledInConfig == null) {
            XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            this.mQueryLineageEnabledInConfig = configuration != null ? Boolean.valueOf(configuration.getBooleanProperty("queryPlanning.queryLineage.tracking[@enabled]", true)) : Boolean.FALSE;
        }
    }

    @Override
    public QTEQueryNode deepCopyNodeNonIndexed(QTEQueryNode node) {
        return this.getNodeFactory().deepCopyNodeNonIndexed(node);
    }

    public int incrementAndGetContextNo() {
        return ++this.contextNo;
    }

    @Override
    public boolean isBigSQL() {
        return false;
    }

    @Override
    public void setCubeName(String name) {
        this.cubeName = name;
    }

    @Override
    public String getCubeName() {
        return this.cubeName;
    }

    @Override
    public QTEPlanningEnvironment.PlanningMode getPlanningMode() {
        return this.planningMode;
    }

    public void setPlanningMode(QTEPlanningEnvironment.PlanningMode mode) {
        this.planningMode = mode;
    }

    @Override
    public PersistentQueryPlan getQueryPlan() {
        return this.queryPlan;
    }

    @Override
    public void recordNodeType(IXQEQueryNode node) {
        if (null == this.nodeIndex) {
            this.nodeIndex = new XQENodeIndex();
        }
        this.nodeIndex.recordNodeType(node);
    }
}

