/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.engine;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.RSVPProperties;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQECCLConfigurationFactory;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationEvent;
import com.cognos.xqe.config.XQEConfigurationListener;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.providers.rscache.ResultSetCacheManager;
import com.cognos.xqe.management.XqeMBeanServer;
import com.cognos.xqe.metadata.IMultiRequestGateway;
import com.cognos.xqe.metadata.provider.IMetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.pool.RefCountingMap;
import com.cognos.xqe.query.engine.CacheManagerMBean;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.PersistentPlanDiskCache;
import com.cognos.xqe.query.engine.PersistentPlanDiskCacheStatistics;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.QueryContext;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.query.engine.SessionContext;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.ParameterValues;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIPartialDataset;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.SecurityContext;
import com.cognos.xqe.runtree.relational.XSql;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.ArrayWrapper;
import com.cognos.xqe.util.FileUtil;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.MapCast;
import com.cognos.xqe.util.MemoryWalker;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.Triple;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.pool.XQEXMLOutputFactoryPool;
import com.cognos.xqe.util.usage.UsageTrackingService;
import com.cognos.xqe.util.usage.indicators.IUsageIndicator;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorCategory;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorType;
import com.cognos.xqe.zipi.ZipiBridge;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.ObjectName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.lang.time.DateFormatUtils;

public final class CacheManager
implements CacheManagerMBean,
XQEConfigurationListener {
    private static final String STRING_XQE_CACHE_STATE = "xqeCacheState";
    private static final String STRING_NEWLINE = System.getProperty("line.separator");
    private static final String FILE_CHAR_ENCODING_UTF_8 = "UTF-8";
    private static final String STRING_XML_FILE_EXTENSION = ".xml";
    private static final String LOGMSG_UNIQUE_ID = ", uniqueId=";
    private static final String LOGMSG_AND_REF_QUERY_NAME = " and refQueryName=";
    private static final String LOGMSG_FOR_MASTER_DATASET_WITH_NAME = " for master dataset with name=";
    private static final String LOGMSG_REF_COUNT_IS = " (ref count is ";
    private static final String LOGMSG_CACHE_MANAGER_LEAKED = "CacheManager leaked ";
    private static final String EXMSG_QUERYSETSTRING_WAS_NULL = "querySetString was null";
    private static final String EXMSG_PLANTREE_WAS_NULL = "planTree was null";
    private static final String EXMSG_RSAPIDATASET_WAS_NULL = "rsapiDataset was null";
    private static final String EXMSG_DATASETID_WAS_NULL = "datasetID was null";
    private static final String EXMSG_PARTIALDATASET_WAS_NULL = "partialDataset was null";
    private static final String EXMSG_PARTIALDATASETID_WAS_NULL = "partialDatasetId was null";
    private static final String EXMSG_MULTIREQUESTCONTEXT_WAS_NULL = "multiRequestContext was null";
    private static final String EXMSG_QUERY_CONTEXT_ID_WAS_NULL = "query context Id was null";
    private static final String EXMSG_SESSION_CONTEXT_ID_WAS_NULL = "session context Id was null";
    private static final String EXMSG_MARESULT_WAS_NULL = "MA result was null";
    private static final String MASTER_DATASET_IS = " - master dataset is ";
    private static final String MBEAN_NAME = "com.cognos.xqe:type=CacheManager";
    private static final double XQE_TO_RSVP_SESSION_TIMEOUT_RATIO = 1.1;
    private static final String DEFAULT_SESSION_TIMEOUT_VALUE = "3600";
    private static final String DEFAULT_QUERYCONTEXT_TIMEOUT_VALUE = "3600";
    private static final float TEN_PERCENT = 0.1f;
    private static final long SESSION_CLEANUP_PERIOD = 300000L;
    private static final int DEFAULT_PLAN_LIMIT = 600;
    private static final int DEFAULT_CACHE_TIMEOUT = 300000;
    private final int maxPlanCacheSize;
    private final int plansToEvict;
    private final long planCacheTimeout;
    protected volatile boolean cacheQueryPlans;
    protected volatile boolean cacheMAResult;
    private boolean useMemoryPlanCache = true;
    private boolean usePersistentPlanCache = false;
    private boolean writeCacheStatistics = false;
    PersistentPlanDiskCache persistentPlanCache = null;
    boolean clearAllAllowed = true;
    private final Map<ArrayWrapper<String>, PlannedV5QuerySet> planCache = MapCast.uncheckedCast(new ReferenceMap(0, 1));
    static final Comparator<PlannedV5QuerySet> PLANTIME_COMPARATOR = new Comparator<PlannedV5QuerySet>(){

        @Override
        public int compare(PlannedV5QuerySet plan1, PlannedV5QuerySet plan2) {
            long p2Time;
            long p1Time = plan1.getPlanDuration();
            if (p1Time < (p2Time = plan2.getPlanDuration())) {
                return -1;
            }
            if (p1Time == p2Time) {
                return 0;
            }
            return 1;
        }
    };
    private long oldestPlanTime = System.currentTimeMillis();
    private final ReadWriteLock planCacheLock = new ReentrantReadWriteLock(true);
    long planHitCount = 0L;
    long planMissCount = 0L;
    long planReadFromFileCount = 0L;
    long planEvictTooOldCount = 0L;
    long planEvictJMMSoftCount = 0L;
    long planEvictJMMHardSoftCount = 0L;
    long planEvictForcedCount = 0L;
    long planRemovedByCallCount = 0L;
    long planUpdateCount = 0L;
    long planRemovedForUseCount = 0L;
    long planClearAllCount = 0L;
    long planClearPlanTreesCount = 0L;
    long lastSizeOfPlanCache = 0L;
    private static final int DEFAULT_MARESULTCACHE_LIMIT = 100;
    private final int maxMAResultCacheSize;
    private final LinkedHashMap<Triple, Pair> maResultCache = new LinkedHashMap<Triple, Pair>(16, 0.75f, true){
        private static final long serialVersionUID = -5076260224755617590L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<Triple, Pair> eldest) {
            return this.size() > CacheManager.this.maxMAResultCacheSize;
        }
    };
    private final Map<String, RSAPIPartialDataset> partialDatasetCache = new ConcurrentHashMap<String, RSAPIPartialDataset>();
    private final RefCountingMap<String, RSAPIDataset> datasetRegistry = new RefCountingMap();
    private final ReadWriteLock datasetRegistryLock = new ReentrantReadWriteLock(true);
    private final Map<String, SessionContext> sessionContextRegistry = new HashMap<String, SessionContext>();
    private final Map<String, QueryContext> queryContextRegistry = new HashMap<String, QueryContext>();
    private final RefCountingMap<String, MultiRequestContext> multiRequestContextRegistry = new RefCountingMap();
    private final ReadWriteLock contextRegistryLock = new ReentrantReadWriteLock(true);
    private IUsageIndicator usageIndicatorPlanEvictCheapest = null;
    private static final XQELogger TRACE_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "CacheManager", LogLevel.INFO);
    private static final XQELogger MEM_PLAN_CACHE_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "MemPlanCache", LogLevel.INFO);
    private static final XQELogger PLAN_CACHE_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "PlanCache", LogLevel.INFO);
    private static final int DEFAULT_MIN_THRESHOLD = 30;
    private IUsageIndicator usageIndicatorPlanHits = null;
    private IUsageIndicator usageIndicatorPlanMisses = null;
    private IUsageIndicator usageIndicatoreEvictSoftRef = null;
    private IUsageIndicator usageIndicatoreEvictTooOld = null;
    private IUsageIndicator usageIndicatoreEvictForced = null;
    private int planMinThreshold = 30;
    private XMLStreamWriter stateWriter = null;
    private static int fileSeqNumber = 1;

    private void checkSize() {
        long currentSize = 0L;
        this.planCacheLock.readLock().lock();
        try {
            currentSize = this.planCache.size();
        }
        finally {
            this.planCacheLock.readLock().unlock();
        }
        if (currentSize < this.lastSizeOfPlanCache) {
            this.planEvictJMMHardSoftCount += this.lastSizeOfPlanCache - currentSize;
        }
        this.lastSizeOfPlanCache = currentSize;
    }

    private void rememberSize() {
        this.planCacheLock.readLock().lock();
        try {
            this.lastSizeOfPlanCache = this.planCache.size();
        }
        finally {
            this.planCacheLock.readLock().unlock();
        }
    }

    public CacheManager() {
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        this.cacheQueryPlans = config.getBooleanProperty("general.cacheQueryPlans", true);
        this.planCacheTimeout = config.getIntegerProperty("general.cacheQueryPlans[@timeout]", 300000).intValue();
        this.maxPlanCacheSize = config.getIntegerProperty("general.cacheQueryPlans[@maxSize]", 600);
        this.planMinThreshold = config.getIntegerProperty("general.cacheQueryPlans[@minPlanThresholdTime]", 30);
        this.useMemoryPlanCache = config.getBooleanProperty("general.cacheQueryPlans[@memory]", true);
        this.usePersistentPlanCache = config.getBooleanProperty("general.cacheQueryPlans[@persistent]", false);
        if (this.cacheQueryPlans) {
            this.cacheQueryPlans = this.useMemoryPlanCache || this.usePersistentPlanCache;
        }
        this.cacheMAResult = config.getBooleanProperty("general.cacheMAQueryResults", false);
        this.maxMAResultCacheSize = config.getIntegerProperty("general.cacheMAQueryResults[@maxSize]", 100);
        this.writeCacheStatistics = config.getBooleanProperty("general.cacheQueryPlans[@writeStats]", false);
        this.plansToEvict = Math.max(1, (int)((float)this.maxPlanCacheSize * 0.1f));
        if (this.usePersistentPlanCache) {
            this.persistentPlanCache = new PersistentPlanDiskCache();
        }
        this.clearAllAllowed = config.getBooleanProperty("general.cacheQueryPlans[@clearAllAllowed]", true);
        config.registerConfigurationListener(this);
        this.usageIndicatorPlanHits = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.PLANCACHE, "planHits");
        this.usageIndicatorPlanMisses = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.PLANCACHE, "planMisses");
        this.usageIndicatoreEvictSoftRef = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.PLANCACHE, "evictSoftRefs");
        this.usageIndicatorPlanEvictCheapest = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.PLANCACHE, "planEvictCheapest");
        this.usageIndicatoreEvictTooOld = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.PLANCACHE, "evictTooOld");
        this.usageIndicatoreEvictForced = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.PLANCACHE, "evictForced");
        TRACE_LOGGER.log(LogLevel.INFO, "CacheManager initialized");
    }

    public void initialize(Timer timer) {
        try {
            ObjectName name;
            XqeMBeanServer mbs;
            XQEConfiguration xqeConfig = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            if (xqeConfig.inStandaloneMode() && !(mbs = XqeMBeanServer.getInstance()).isRegistered(name = new ObjectName(MBEAN_NAME))) {
                mbs.registerMBean(this, name);
            }
            this.startSessionCleaner(timer);
        }
        catch (Throwable ex) {
            ex.printStackTrace(XQEDebugLog.err);
            TRACE_LOGGER.log(LogLevel.ERROR, ex);
        }
    }

    public void terminate() {
        try {
            ResultSetCacheManager.releaseInstance();
            XQEConfiguration xqeConfig = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            if (xqeConfig.inStandaloneMode()) {
                XqeMBeanServer mbs = XqeMBeanServer.getInstance();
                ObjectName name = new ObjectName(MBEAN_NAME);
                mbs.unregisterMBean(name);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace(XQEDebugLog.err);
            TRACE_LOGGER.log(LogLevel.ERROR, ex);
        }
        this.closeStatisticsFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storePlanTree(PlannedV5QuerySet planTree, IRequestEnvironment reqEnv, IMetadataConnection metadataConnection) {
        RSAPIDataset dataset;
        if (!this.cacheQueryPlans) {
            return;
        }
        if (null == planTree) {
            throw new IllegalArgumentException(EXMSG_PLANTREE_WAS_NULL);
        }
        if (planTree.getPlanDuration() < (long)this.planMinThreshold) {
            return;
        }
        if (this.usePersistentPlanCache && ((dataset = (RSAPIDataset)planTree.getFirstChildByType(401005)) == null || !dataset.forDMRReport()) && this.persistentPlanCache.storePlanTree(planTree, reqEnv)) {
            return;
        }
        if (!this.useMemoryPlanCache) {
            return;
        }
        if (!planTree.isCacheable()) {
            return;
        }
        String querySetString = planTree.getPlanKey();
        if (null == querySetString) {
            return;
        }
        ArrayWrapper<String> planCacheKey = this.constructPlanCacheKey(querySetString, reqEnv, metadataConnection);
        if (MEM_PLAN_CACHE_LOGGER.isOn(LogLevel.TRACE)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Stored plan tree for plan cache key ").append(querySetString);
            MEM_PLAN_CACHE_LOGGER.log(LogLevel.TRACE, buffer.toString());
        }
        if (MEM_PLAN_CACHE_LOGGER.isOn(LogLevel.INFO)) {
            MEM_PLAN_CACHE_LOGGER.log(LogLevel.INFO, "Stored plan for: " + reqEnv.getReportName());
        }
        this.planCacheLock.writeLock().lock();
        try {
            this.checkSize();
            ++this.planUpdateCount;
            this.planCache.remove(planCacheKey);
            this.planCache.put(planCacheKey, planTree);
        }
        finally {
            this.rememberSize();
            this.planCacheLock.writeLock().unlock();
        }
    }

    void removePlanTree(PlannedV5QuerySet querySet) {
        if (!this.cacheQueryPlans) {
            return;
        }
        if (this.usePersistentPlanCache) {
            this.persistentPlanCache.removePlanTree(querySet);
        }
        if (!this.useMemoryPlanCache) {
            return;
        }
        if (null == querySet) {
            throw new IllegalArgumentException(EXMSG_PLANTREE_WAS_NULL);
        }
        if (MEM_PLAN_CACHE_LOGGER.isOn(LogLevel.TRACE)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Removing plan tree with plan cache key ").append(querySet.getPlanKey());
            MEM_PLAN_CACHE_LOGGER.log(LogLevel.TRACE, buffer.toString());
        }
        this.planCacheLock.writeLock().lock();
        try {
            this.checkSize();
            this.planCache.values().remove(querySet);
            ++this.planRemovedByCallCount;
        }
        finally {
            this.rememberSize();
            this.planCacheLock.writeLock().unlock();
        }
    }

    private ArrayWrapper<String> constructPlanCacheKey(String queryKey, IRequestEnvironment reqEnv, IMetadataConnection metadataConnection) {
        String mcStr = "";
        if (metadataConnection != null) {
            mcStr = metadataConnection.toString();
        }
        String[] keyArray = new String[]{reqEnv.getCAMPassport(), LocaleConverter.localeToStr(reqEnv.getRunLocale()), LocaleConverter.localeToStr(reqEnv.getProductLocale()), queryKey, mcStr};
        return new ArrayWrapper<String>(keyArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlannedV5QuerySet getPlanTree(String querySetString, PlanningEnvironment planEnv) {
        RequestEnvironment reqEnv = (RequestEnvironment)planEnv.getRequestEnvironment();
        if (!this.cacheQueryPlans) {
            return null;
        }
        if (this.usePersistentPlanCache) {
            PlannedV5QuerySet p = this.persistentPlanCache.getPlanTree(querySetString, planEnv);
            if (p != null) {
                ++this.planHitCount;
                this.usageIndicatorPlanHits.increment();
                return p;
            }
            ++this.planMissCount;
        }
        if (!this.useMemoryPlanCache) {
            return null;
        }
        if (null == querySetString) {
            throw new IllegalArgumentException(EXMSG_QUERYSETSTRING_WAS_NULL);
        }
        MetadataConnection metadataConnection = null;
        metadataConnection = planEnv.getMetadataConnection();
        String modelPath = reqEnv.getModelPath();
        String modelType = reqEnv.getModelType();
        if (modelPath != null && modelPath.indexOf("/report") != -1) {
            modelPath = null;
            modelType = null;
        }
        if (metadataConnection == null && modelPath != null) {
            MetadataService metadataService = MetadataService.getInstance();
            MetricsService.startCollectingMetric(reqEnv, "mfwRequest");
            metadataConnection = metadataService.getConnection(MetadataService.getProviderTypeFromModelPath(modelType, modelPath), modelPath, (IExecutionEnvironment)reqEnv.getExecutionEnvironment(), true);
            MetricsService.endCollectingMetric(reqEnv, "mfwRequest");
            planEnv.setMetdataConnection(metadataConnection);
        }
        ArrayWrapper<String> planCacheKey = this.constructPlanCacheKey(querySetString, reqEnv, metadataConnection);
        PlannedV5QuerySet planTree = null;
        if (MEM_PLAN_CACHE_LOGGER.isOn(LogLevel.TRACE)) {
            MEM_PLAN_CACHE_LOGGER.log(LogLevel.TRACE, "Lookin in cache for: " + querySetString);
        }
        this.planCacheLock.writeLock().lock();
        try {
            this.checkSize();
            long currentTime = System.currentTimeMillis();
            planTree = this.planCache.get(planCacheKey);
            if (planTree != null) {
                if (currentTime - planTree.getPlanTime() > this.planCacheTimeout || !this.macrosResolveToSameValues(planTree.getResolvedMacros(), (PlanningEnvironment)planTree.getPlanningEnvironment(), reqEnv)) {
                    planTree = null;
                    this.usageIndicatorPlanMisses.increment();
                }
                if (planTree != null) {
                    boolean paramsAreEquivalent = true;
                    Parameters incomingParams = reqEnv.getRequestParameters();
                    TreeMap<String, ParameterValues> paramValuesMap = planTree.getParamValuesUsedByScrollCursor();
                    if (paramValuesMap != null) {
                        for (Map.Entry<String, ParameterValues> entry : paramValuesMap.entrySet()) {
                            String name = entry.getKey();
                            ParameterValues cachedParamValue = entry.getValue();
                            Parameter incomingParam = (Parameter)incomingParams.get(name);
                            if (incomingParam == null) {
                                paramsAreEquivalent = false;
                                break;
                            }
                            ParameterValues incomingParamValue = incomingParam.getParameterValueItems();
                            if (incomingParamValue != null && cachedParamValue.containsAll(incomingParamValue) && incomingParamValue.containsAll(cachedParamValue)) continue;
                            paramsAreEquivalent = false;
                        }
                        if (!paramsAreEquivalent) {
                            planTree = null;
                            this.usageIndicatorPlanMisses.increment();
                        }
                    }
                }
                if (planTree != null) {
                    this.usageIndicatorPlanHits.increment();
                    ++this.planHitCount;
                    planTree.setPlanTime(System.currentTimeMillis());
                    planTree.incrementUseCount();
                    this.usageIndicatorPlanHits.increment();
                    ++this.planRemovedForUseCount;
                    this.planCache.remove(planCacheKey);
                }
            } else {
                this.usageIndicatorPlanMisses.increment();
                ++this.planMissCount;
                this.usageIndicatorPlanMisses.increment();
            }
            if (this.planCache.size() > this.maxPlanCacheSize || currentTime - this.oldestPlanTime > this.planCacheTimeout) {
                this.cleanupPlanCache(reqEnv);
            }
        }
        finally {
            this.rememberSize();
            this.planCacheLock.writeLock().unlock();
        }
        if (MEM_PLAN_CACHE_LOGGER.isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            if (null == planTree) {
                buffer.append("Could not find cached plan tree for: ");
            } else {
                buffer.append("Retrieved cached plan tree for: ");
            }
            buffer.append(reqEnv.getReportName());
            MEM_PLAN_CACHE_LOGGER.log(LogLevel.INFO, buffer.toString());
        }
        return planTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean macrosResolveToSameValues(TreeMap<String, String> macroMap, PlanningEnvironment planEnv, RequestEnvironment reqEnv) {
        planEnv.setPlanningActive(reqEnv);
        try {
            boolean bl = MacroExpander.macrosResolveToSameValues(macroMap, planEnv);
            return bl;
        }
        finally {
            planEnv.setPlanningInactive();
        }
    }

    private void cleanupPlanCache(RequestEnvironment reqEnv) {
        long currentTime = System.currentTimeMillis();
        this.oldestPlanTime = Long.MAX_VALUE;
        Set<Map.Entry<ArrayWrapper<String>, PlannedV5QuerySet>> entries = this.planCache.entrySet();
        Iterator<Map.Entry<ArrayWrapper<String>, PlannedV5QuerySet>> entryIt = entries.iterator();
        while (entryIt.hasNext()) {
            Map.Entry<ArrayWrapper<String>, PlannedV5QuerySet> entry = entryIt.next();
            PlannedV5QuerySet planTree = entry.getValue();
            if (planTree == null) {
                ++this.planEvictJMMSoftCount;
                this.usageIndicatoreEvictSoftRef.increment();
                entryIt.remove();
                continue;
            }
            if (currentTime - planTree.getPlanTime() > this.planCacheTimeout) {
                ++this.planEvictTooOldCount;
                this.usageIndicatoreEvictTooOld.increment();
                entryIt.remove();
                continue;
            }
            if (this.oldestPlanTime <= planTree.getPlanTime()) continue;
            this.oldestPlanTime = planTree.getPlanTime();
        }
        if (this.planCache.size() > this.maxPlanCacheSize) {
            this.evictSoftReferences(entries);
            this.evictCheapestPlans(reqEnv);
        }
        if (this.planCache.size() == 0) {
            this.oldestPlanTime = currentTime;
        }
    }

    private void evictSoftReferences(Set<Map.Entry<ArrayWrapper<String>, PlannedV5QuerySet>> entries) {
        Iterator<Map.Entry<ArrayWrapper<String>, PlannedV5QuerySet>> entryIt = entries.iterator();
        while (entryIt.hasNext()) {
            Map.Entry<ArrayWrapper<String>, PlannedV5QuerySet> entry = entryIt.next();
            PlannedV5QuerySet planTree = entry.getValue();
            if (planTree != null) continue;
            ++this.planEvictJMMSoftCount;
            this.usageIndicatoreEvictSoftRef.increment();
            entryIt.remove();
        }
    }

    private void evictCheapestPlans(RequestEnvironment reqEnv) {
        Collection<PlannedV5QuerySet> plans = this.planCache.values();
        PlannedV5QuerySet[] plansArray = new PlannedV5QuerySet[plans.size()];
        plans.toArray(plansArray);
        List<PlannedV5QuerySet> orderedPlans = Arrays.asList(plansArray);
        Collections.sort(orderedPlans, PLANTIME_COMPARATOR);
        String[] planKeyArray = new String[1];
        ArrayWrapper<String> planKeyForLogging = new ArrayWrapper<String>(planKeyArray);
        if (PLAN_CACHE_LOGGER.isOn()) {
            PLAN_CACHE_LOGGER.log("Removing plans...");
        }
        for (PlannedV5QuerySet plan : orderedPlans) {
            this.planCache.values().remove(plan);
            planKeyArray[0] = plan.getPlanKey();
            this.logPlanRemoved(reqEnv, planKeyForLogging);
            if (PLAN_CACHE_LOGGER.isOn()) {
                PLAN_CACHE_LOGGER.log("Removing plan for: " + plan.getReportName() + " planTime=" + plan.getPlanDuration());
            }
            this.usageIndicatorPlanEvictCheapest.increment();
            if (this.planCache.size() + this.plansToEvict > this.maxPlanCacheSize) continue;
            break;
        }
    }

    private void logPlanRemoved(RequestEnvironment reqEnv, ArrayWrapper<String> planKey) {
        if (TRACE_LOGGER.isOn(LogLevel.TRACE)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Removed plan tree for report ").append(reqEnv.getReportName());
            buffer.append(" Num Plans: " + this.planCache.size());
            TRACE_LOGGER.log(LogLevel.TRACE, buffer.toString());
        }
    }

    void storeDataset(RSAPIDataset rsapiDataset) {
        if (null == rsapiDataset) {
            throw new IllegalArgumentException(EXMSG_RSAPIDATASET_WAS_NULL);
        }
        RefCountingMap.Entry<String, RSAPIDataset> entry = null;
        this.datasetRegistryLock.writeLock().lock();
        try {
            entry = this.datasetRegistry.put(rsapiDataset.getUniqueID(), rsapiDataset);
        }
        finally {
            this.datasetRegistryLock.writeLock().unlock();
        }
        if (TRACE_LOGGER.isOn(LogLevel.TRACE)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Stored RSAPI dataset with name=").append(rsapiDataset.getName());
            buffer.append(LOGMSG_UNIQUE_ID).append(rsapiDataset.getUniqueID());
            buffer.append(LOGMSG_AND_REF_QUERY_NAME).append(rsapiDataset.getRefQueryName());
            buffer.append(LOGMSG_REF_COUNT_IS).append(entry.getReferenceCount()).append(')');
            TRACE_LOGGER.log(LogLevel.TRACE, buffer.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replaceDataset(RSAPIDataset oldRsapiDataset, RSAPIDataset newRsapiDataset) {
        if (null == oldRsapiDataset || null == newRsapiDataset) {
            throw new IllegalArgumentException(EXMSG_RSAPIDATASET_WAS_NULL);
        }
        RefCountingMap.Entry<String, RSAPIDataset> entry = null;
        this.datasetRegistryLock.writeLock().lock();
        try {
            newRsapiDataset.setUniqueID(oldRsapiDataset.getUniqueID());
            entry = this.datasetRegistry.replace(oldRsapiDataset.getUniqueID(), newRsapiDataset);
        }
        finally {
            this.datasetRegistryLock.writeLock().unlock();
        }
        if (TRACE_LOGGER.isOn(LogLevel.TRACE)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Replaced RSAPI dataset with name=").append(oldRsapiDataset.getName());
            buffer.append(LOGMSG_UNIQUE_ID).append(oldRsapiDataset.getUniqueID());
            buffer.append(LOGMSG_AND_REF_QUERY_NAME).append(oldRsapiDataset.getRefQueryName());
            buffer.append(LOGMSG_REF_COUNT_IS).append(entry.getReferenceCount()).append(')');
            TRACE_LOGGER.log(LogLevel.TRACE, buffer.toString());
        }
    }

    RSAPIDataset getDatasetByID(String datasetId) {
        if (null == datasetId) {
            throw new IllegalArgumentException(EXMSG_DATASETID_WAS_NULL);
        }
        RefCountingMap.Entry<String, RSAPIDataset> entry = null;
        this.datasetRegistryLock.readLock().lock();
        try {
            entry = this.datasetRegistry.get(datasetId);
        }
        finally {
            this.datasetRegistryLock.readLock().unlock();
        }
        if (TRACE_LOGGER.isOn(LogLevel.TRACE)) {
            StringBuilder buffer = new StringBuilder();
            if (null == entry) {
                buffer.append("Could not find cached RSAPI dataset for uniqueId=").append(datasetId);
            } else {
                RSAPIDataset dataset = entry.getReferencedObject();
                buffer.append("Retrieved cached RSAPI dataset with name=").append(dataset.getName());
                buffer.append(LOGMSG_UNIQUE_ID).append(dataset.getUniqueID());
                buffer.append(LOGMSG_AND_REF_QUERY_NAME).append(dataset.getRefQueryName());
                buffer.append(LOGMSG_REF_COUNT_IS).append(entry.getReferenceCount()).append(')');
            }
            TRACE_LOGGER.log(LogLevel.TRACE, buffer.toString());
        }
        if (null != entry) {
            return entry.getReferencedObject();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RSAPIDataset removeDatasetByID(String datasetId, IRequestEnvironment reqEnv) {
        if (null == datasetId) {
            throw new IllegalArgumentException(EXMSG_DATASETID_WAS_NULL);
        }
        RefCountingMap.Entry<String, RSAPIDataset> entry = null;
        this.datasetRegistryLock.writeLock().lock();
        try {
            entry = this.datasetRegistry.remove(datasetId);
        }
        finally {
            this.datasetRegistryLock.writeLock().unlock();
        }
        if (TRACE_LOGGER.isOn(LogLevel.TRACE)) {
            StringBuilder buffer = new StringBuilder();
            if (null == entry) {
                buffer.append("Failed to remove cached RSAPI dataset for uniqueId=").append(datasetId);
            } else {
                RSAPIDataset dataset = entry.getReferencedObject();
                ZipiBridge.setZipiContextAndObjPath(dataset.getName());
                buffer.append("Removed cached RSAPI dataset with name=").append(dataset.getName());
                buffer.append(LOGMSG_UNIQUE_ID).append(dataset.getUniqueID());
                buffer.append(LOGMSG_AND_REF_QUERY_NAME).append(dataset.getRefQueryName());
                buffer.append(LOGMSG_REF_COUNT_IS).append(entry.getReferenceCount()).append(')');
            }
            TRACE_LOGGER.log(LogLevel.TRACE, buffer.toString());
        }
        if (null != entry) {
            if (entry.getReferenceCount() == 0) {
                RSAPIDataset dataset = entry.getReferencedObject();
                ZipiBridge.setZipiContextAndObjPath(dataset.getName());
                PlannedV5QuerySet plannedQuerySet = (PlannedV5QuerySet)dataset.getParent();
                if (plannedQuerySet.isCacheable() && !plannedQuerySet.getRequestParameters().hasOptionalParameter() && !plannedQuerySet.getMasterDetailProvider().hasMasterDetailQuery()) {
                    IPlanningEnvironment penv = dataset.getPlanningEnvironment();
                    IMetadataConnection mdConnection = null;
                    if (penv != null) {
                        mdConnection = (IMetadataConnection)penv.getMetadataConnection();
                    }
                    this.storePlanTree(plannedQuerySet, reqEnv, mdConnection);
                }
            }
            return entry.getReferencedObject();
        }
        return null;
    }

    public void storePartialDataset(RSAPIPartialDataset partialDataset) {
        if (null == partialDataset) {
            throw new IllegalArgumentException(EXMSG_PARTIALDATASET_WAS_NULL);
        }
        this.partialDatasetCache.put(partialDataset.getUniqueID(), partialDataset);
        if (TRACE_LOGGER.isOn(LogLevel.TRACE)) {
            StringBuilder buffer = new StringBuilder();
            RSAPIDataset masterDataset = partialDataset.getMasterDataset();
            buffer.append("Stored RSAPI partial dataset with uid=").append(partialDataset.getUniqueID());
            buffer.append(LOGMSG_FOR_MASTER_DATASET_WITH_NAME).append(masterDataset.getName());
            buffer.append(LOGMSG_UNIQUE_ID).append(masterDataset.getUniqueID());
            buffer.append(LOGMSG_AND_REF_QUERY_NAME).append(masterDataset.getRefQueryName());
            TRACE_LOGGER.log(LogLevel.TRACE, buffer.toString());
        }
    }

    RSAPIPartialDataset getPartialDatasetByID(String partialDatasetId) {
        if (null == partialDatasetId) {
            throw new IllegalArgumentException(EXMSG_PARTIALDATASETID_WAS_NULL);
        }
        RSAPIPartialDataset partialDataset = this.partialDatasetCache.get(partialDatasetId);
        if (TRACE_LOGGER.isOn(LogLevel.TRACE)) {
            StringBuilder buffer = new StringBuilder();
            if (null == partialDataset) {
                buffer.append("Could not find cached RSAPI partial dataset for uid=").append(partialDatasetId);
            } else {
                RSAPIDataset masterDataset = partialDataset.getMasterDataset();
                buffer.append("Retrieved cached RSAPI partial dataset with uid=").append(partialDatasetId);
                buffer.append(LOGMSG_FOR_MASTER_DATASET_WITH_NAME).append(masterDataset.getName());
                buffer.append(LOGMSG_UNIQUE_ID).append(masterDataset.getUniqueID());
                buffer.append(LOGMSG_AND_REF_QUERY_NAME).append(masterDataset.getRefQueryName());
            }
            TRACE_LOGGER.log(LogLevel.TRACE, buffer.toString());
        }
        return partialDataset;
    }

    RSAPIPartialDataset removePartialDatasetByID(String partialDatasetId) {
        if (null == partialDatasetId) {
            throw new IllegalArgumentException(EXMSG_PARTIALDATASETID_WAS_NULL);
        }
        RSAPIPartialDataset partialDataset = this.partialDatasetCache.remove(partialDatasetId);
        if (TRACE_LOGGER.isOn(LogLevel.TRACE)) {
            StringBuilder buffer = new StringBuilder();
            if (null == partialDataset) {
                buffer.append("Failed to remove cached RSAPI partial dataset for uid=").append(partialDatasetId);
            } else {
                RSAPIDataset masterDataset = partialDataset.getMasterDataset();
                buffer.append("Removed cached RSAPI partial dataset with uid=").append(partialDatasetId);
                buffer.append(LOGMSG_FOR_MASTER_DATASET_WITH_NAME).append(masterDataset.getName());
                buffer.append(LOGMSG_UNIQUE_ID).append(masterDataset.getUniqueID());
                buffer.append(LOGMSG_AND_REF_QUERY_NAME).append(masterDataset.getRefQueryName());
            }
            TRACE_LOGGER.log(LogLevel.TRACE, buffer.toString());
        }
        return partialDataset;
    }

    public boolean cacheMAQueryResult() {
        return this.cacheMAResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeMAResult(String resultKey, SecurityContext securityContext, TreeSet<String> allCookieNames, long modelModificationTime, byte[] maResult) {
        if (null == maResult) {
            throw new IllegalArgumentException(EXMSG_MARESULT_WAS_NULL);
        }
        Triple key = new Triple(resultKey, securityContext, allCookieNames);
        Pair value = new Pair(maResult, new Long(modelModificationTime));
        LinkedHashMap<Triple, Pair> linkedHashMap = this.maResultCache;
        synchronized (linkedHashMap) {
            this.maResultCache.put(key, value);
        }
        if (TRACE_LOGGER.isOn(LogLevel.TRACE)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Stored MA query result with key = ").append(key);
            TRACE_LOGGER.log(LogLevel.TRACE, buffer.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getMAResult(String resultKey, SecurityContext securityContext, TreeSet<String> allCookieNames, long modelModificationTime) {
        if (null == resultKey || null == securityContext) {
            throw new IllegalArgumentException(EXMSG_MARESULT_WAS_NULL);
        }
        byte[] maResult = null;
        Triple key = new Triple(resultKey, securityContext, allCookieNames);
        LinkedHashMap<Triple, Pair> linkedHashMap = this.maResultCache;
        synchronized (linkedHashMap) {
            if (this.maResultCache.containsKey(key)) {
                Pair value = this.maResultCache.get(key);
                if ((Long)value.getSecond() == modelModificationTime) {
                    maResult = (byte[])value.getFirst();
                } else if ((Long)value.getSecond() < modelModificationTime) {
                    this.maResultCache.remove(key);
                }
            }
        }
        if (TRACE_LOGGER.isOn(LogLevel.TRACE)) {
            StringBuilder buffer = new StringBuilder();
            if (null == maResult) {
                buffer.append("Could not find cached MA result for key = ").append(key);
            } else {
                buffer.append("Retrieved cached MA query result with key = ").append(key);
            }
            TRACE_LOGGER.log(LogLevel.TRACE, buffer.toString());
        }
        return maResult;
    }

    void storeMultiRequestContext(MultiRequestContext multiRequestContext) {
        if (null == multiRequestContext) {
            throw new IllegalArgumentException(EXMSG_MULTIREQUESTCONTEXT_WAS_NULL);
        }
        RefCountingMap.Entry<String, MultiRequestContext> entry = null;
        this.contextRegistryLock.writeLock().lock();
        try {
            entry = this.multiRequestContextRegistry.put(multiRequestContext.getSessionContextID(), multiRequestContext);
        }
        finally {
            this.contextRegistryLock.writeLock().unlock();
        }
        if (TRACE_LOGGER.isOn(LogLevel.TRACE)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Stored MultiRequestContext with id=").append(multiRequestContext.getSessionContextID());
            buffer.append(LOGMSG_REF_COUNT_IS).append(entry.getReferenceCount()).append(')');
            TRACE_LOGGER.log(LogLevel.TRACE, buffer.toString());
        }
    }

    MultiRequestContext getMultiRequestContext(String sessionContextID) {
        if (null == sessionContextID) {
            throw new IllegalArgumentException(EXMSG_SESSION_CONTEXT_ID_WAS_NULL);
        }
        RefCountingMap.Entry<String, MultiRequestContext> entry = null;
        this.contextRegistryLock.readLock().lock();
        try {
            entry = this.multiRequestContextRegistry.get(sessionContextID);
        }
        finally {
            this.contextRegistryLock.readLock().unlock();
        }
        if (TRACE_LOGGER.isOn(LogLevel.TRACE)) {
            StringBuilder buffer = new StringBuilder();
            if (null == entry) {
                buffer.append("Could not find cached MultiRequestContext for id=").append(sessionContextID);
            } else {
                buffer.append("Retrieved cached MultiRequestContext for id=").append(sessionContextID);
                buffer.append(LOGMSG_REF_COUNT_IS).append(entry.getReferenceCount()).append(')');
            }
            TRACE_LOGGER.log(LogLevel.TRACE, buffer.toString());
        }
        if (null != entry) {
            return entry.getReferencedObject();
        }
        return null;
    }

    MultiRequestContext removeMultiRequestContext(String sessionContextId) {
        if (null == sessionContextId) {
            throw new IllegalArgumentException(EXMSG_SESSION_CONTEXT_ID_WAS_NULL);
        }
        RefCountingMap.Entry<String, MultiRequestContext> entry = null;
        this.contextRegistryLock.writeLock().lock();
        try {
            entry = this.multiRequestContextRegistry.remove(sessionContextId);
        }
        finally {
            this.contextRegistryLock.writeLock().unlock();
        }
        if (TRACE_LOGGER.isOn(LogLevel.TRACE)) {
            StringBuilder buffer = new StringBuilder();
            if (null == entry) {
                buffer.append("Failed to remove cached MultiRequestContext with id=").append(sessionContextId);
            } else {
                buffer.append("Removed cached MultiRequestContext with id=").append(sessionContextId);
                buffer.append(LOGMSG_REF_COUNT_IS).append(entry.getReferenceCount()).append(')');
            }
            TRACE_LOGGER.log(LogLevel.TRACE, buffer.toString());
        }
        if (null != entry) {
            return entry.getReferencedObject();
        }
        return null;
    }

    void storeQueryContext(QueryContext queryContext) {
        if (null == queryContext) {
            throw new IllegalArgumentException(EXMSG_QUERY_CONTEXT_ID_WAS_NULL);
        }
        this.contextRegistryLock.writeLock().lock();
        try {
            this.queryContextRegistry.put(queryContext.getQueryContextID(), queryContext);
        }
        finally {
            this.contextRegistryLock.writeLock().unlock();
        }
        if (TRACE_LOGGER.isOn(LogLevel.TRACE)) {
            TRACE_LOGGER.log(LogLevel.TRACE, "Store QueryContext: " + queryContext.getQueryContextID());
        }
    }

    QueryContext getQueryContext(String queryContextId) {
        if (null == queryContextId) {
            throw new IllegalArgumentException(EXMSG_QUERY_CONTEXT_ID_WAS_NULL);
        }
        this.contextRegistryLock.readLock().lock();
        try {
            QueryContext queryContext = this.queryContextRegistry.get(queryContextId);
            return queryContext;
        }
        finally {
            this.contextRegistryLock.readLock().unlock();
        }
    }

    QueryContext removeQueryContext(String queryContextID) {
        TRACE_LOGGER.log(LogLevel.TRACE, "Release " + queryContextID);
        if (null == queryContextID) {
            TRACE_LOGGER.log(LogLevel.TRACE, EXMSG_QUERY_CONTEXT_ID_WAS_NULL);
            throw new IllegalArgumentException(EXMSG_QUERY_CONTEXT_ID_WAS_NULL);
        }
        this.contextRegistryLock.writeLock().lock();
        try {
            QueryContext queryContext = this.queryContextRegistry.remove(queryContextID);
            return queryContext;
        }
        finally {
            this.contextRegistryLock.writeLock().unlock();
        }
    }

    void storeSessionContext(SessionContext sessionContext) {
        if (null == sessionContext) {
            throw new IllegalArgumentException(EXMSG_MULTIREQUESTCONTEXT_WAS_NULL);
        }
        this.contextRegistryLock.writeLock().lock();
        try {
            this.sessionContextRegistry.put(sessionContext.getSessionContextID(), sessionContext);
        }
        finally {
            this.contextRegistryLock.writeLock().unlock();
        }
        if (TRACE_LOGGER.isOn(LogLevel.TRACE)) {
            TRACE_LOGGER.log(LogLevel.TRACE, "Store SessionContext: " + sessionContext.getSessionContextID());
        }
    }

    SessionContext getSessionContext(String sessionContextId) {
        if (null == sessionContextId) {
            throw new IllegalArgumentException(EXMSG_SESSION_CONTEXT_ID_WAS_NULL);
        }
        this.contextRegistryLock.readLock().lock();
        try {
            SessionContext sessionContext = this.sessionContextRegistry.get(sessionContextId);
            return sessionContext;
        }
        finally {
            this.contextRegistryLock.readLock().unlock();
        }
    }

    SessionContext removeSessionContext(String sessionContextID) {
        TRACE_LOGGER.log(LogLevel.TRACE, "Release " + sessionContextID);
        if (null == sessionContextID) {
            TRACE_LOGGER.log(LogLevel.TRACE, EXMSG_SESSION_CONTEXT_ID_WAS_NULL);
            throw new IllegalArgumentException(EXMSG_SESSION_CONTEXT_ID_WAS_NULL);
        }
        this.contextRegistryLock.writeLock().lock();
        try {
            SessionContext sessionContext = this.sessionContextRegistry.remove(sessionContextID);
            return sessionContext;
        }
        finally {
            this.contextRegistryLock.writeLock().unlock();
        }
    }

    private void startSessionCleaner(Timer timer) {
        XQEConfiguration xqeConfig = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        boolean cleanerEnabled = xqeConfig.getBooleanProperty("general.sessionContextCleaner[@enabled]", true);
        if (cleanerEnabled) {
            String cclConfigurationInactivityTimeoutString = new RSVPProperties(xqeConfig.getConfigDirectory()).getSessionTimeOut();
            if (null == cclConfigurationInactivityTimeoutString) {
                cclConfigurationInactivityTimeoutString = XQEConfiguration.getParameterValueFromCCLConfig("AAA", "inactivityTimeout", "3600");
            }
            long cclConfigurationInactivityTimeout = Long.valueOf(cclConfigurationInactivityTimeoutString) * 1000L;
            final long sessionTimeout = (long)(1.1 * (double)cclConfigurationInactivityTimeout);
            String queryContextTimeoutString = "3600";
            final long queryContextTimeout = Long.valueOf(queryContextTimeoutString) * 1000L;
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    CacheManager.this.cleanupIdleSessions(sessionTimeout, queryContextTimeout);
                }
            }, 300000L, 300000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupIdleSessions(long sessionTimeout, long queryContextTimeout) {
        TRACE_LOGGER.log(LogLevel.INFO, "Cleaning up idle sessions and querycontexts...");
        RequestEnvironment reqEnv = new RequestEnvironment();
        QueryEngine.getInstance().configureRequestEnvironment(reqEnv);
        ExecutionEnvironment execEnv = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
        ExecutionEnvironmentContext ctx = ExecutionEnvironmentContext.enter(execEnv);
        this.contextRegistryLock.writeLock().lock();
        try {
            Iterator<SessionContext> sessIter = this.sessionContextRegistry.values().iterator();
            long timeStamp = System.currentTimeMillis() - sessionTimeout;
            while (sessIter.hasNext()) {
                StringBuilder buffer;
                SessionContext sess = sessIter.next();
                if (!sess.isInUse()) {
                    if (!sess.accessedOrKeptAliveSince(timeStamp)) {
                        if (TRACE_LOGGER.isOn(LogLevel.ERROR)) {
                            buffer = new StringBuilder();
                            buffer.append("Destroying expired session").append(STRING_NEWLINE).append(sess.toString());
                            TRACE_LOGGER.log(LogLevel.ERROR, buffer.toString());
                        }
                        MultiRequestContext multiReqCtx = sess.getMultiRequestContext();
                        try {
                            sess.release();
                        }
                        catch (Throwable ex) {
                            TRACE_LOGGER.log(LogLevel.ERROR, ex);
                        }
                        try {
                            if (null != multiReqCtx) {
                                String sessionContextId = sess.getSessionContextID();
                                execEnv.setMultiRequestContext(multiReqCtx);
                                multiReqCtx.release();
                                while (null != this.removeMultiRequestContext(sessionContextId)) {
                                }
                                multiReqCtx = null;
                            }
                            sessIter.remove();
                        }
                        catch (Throwable ex) {
                            TRACE_LOGGER.log(LogLevel.ERROR, ex);
                            if (null == multiReqCtx) continue;
                            sess.linkMultiRequestContext(multiReqCtx);
                            StringBuilder buffer2 = new StringBuilder();
                            buffer2.append("Failed to release multi-request context for session").append(STRING_NEWLINE).append(sess.toString());
                            TRACE_LOGGER.log(LogLevel.ERROR, buffer2.toString());
                        }
                        continue;
                    }
                    if (!TRACE_LOGGER.isOn(LogLevel.INFO)) continue;
                    buffer = new StringBuilder();
                    buffer.append("Keeping alive inactive session").append(STRING_NEWLINE).append(sess.toString());
                    TRACE_LOGGER.log(LogLevel.INFO, buffer.toString());
                    continue;
                }
                if (sess.accessedOrKeptAliveSince(timeStamp) || !TRACE_LOGGER.isOn(LogLevel.INFO)) continue;
                buffer = new StringBuilder();
                buffer.append("Still using expired session. Timeout: ").append(sessionTimeout);
                buffer.append(STRING_NEWLINE).append(sess.toString());
                TRACE_LOGGER.log(LogLevel.INFO, buffer.toString());
            }
            Iterator<QueryContext> queryContextIter = this.queryContextRegistry.values().iterator();
            long queryContextTimeStamp = System.currentTimeMillis() - queryContextTimeout;
            while (queryContextIter.hasNext()) {
                StringBuilder buffer;
                QueryContext queryContext = queryContextIter.next();
                if (!queryContext.isInUse()) {
                    if (!queryContext.accessedSince(queryContextTimeStamp)) {
                        if (TRACE_LOGGER.isOn(LogLevel.ERROR)) {
                            buffer = new StringBuilder();
                            buffer.append("Destroying expired querycontext").append(STRING_NEWLINE).append(queryContext.toString());
                            TRACE_LOGGER.log(LogLevel.ERROR, buffer.toString());
                        }
                        queryContextIter.remove();
                        try {
                            queryContext.release();
                        }
                        catch (Throwable ex) {
                            TRACE_LOGGER.log(LogLevel.ERROR, ex);
                        }
                        continue;
                    }
                    if (!TRACE_LOGGER.isOn(LogLevel.INFO)) continue;
                    buffer = new StringBuilder();
                    buffer.append("Keeping alive inactive querycontext").append(STRING_NEWLINE).append(queryContext.toString());
                    TRACE_LOGGER.log(LogLevel.INFO, buffer.toString());
                    continue;
                }
                if (queryContext.accessedSince(queryContextTimeStamp) || !TRACE_LOGGER.isOn(LogLevel.INFO)) continue;
                buffer = new StringBuilder();
                buffer.append("Still using expired queryContext. Timeout: ").append(queryContextTimeout);
                buffer.append(STRING_NEWLINE).append(queryContext.toString());
                TRACE_LOGGER.log(LogLevel.INFO, buffer.toString());
            }
        }
        finally {
            this.contextRegistryLock.writeLock().unlock();
            ctx.exit();
        }
    }

    void keepAliveSessions(List<String> sessionContextIDs) {
        long currentTimeMillis = System.currentTimeMillis();
        for (String sessionContextID : sessionContextIDs) {
            SessionContext sessionContext = this.getSessionContext(sessionContextID);
            if (null == sessionContext) continue;
            sessionContext.setLastKeepAliveTime(currentTimeMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearAll() {
        TRACE_LOGGER.log(LogLevel.INFO, "Clearing all data from CacheManager");
        if (!this.clearAllAllowed) {
            TRACE_LOGGER.log(LogLevel.INFO, "Clearing is not enabled");
            return;
        }
        this.contextRegistryLock.writeLock().lock();
        try {
            if (!this.multiRequestContextRegistry.isEmpty()) {
                XQEDebugLog.err.println(LOGMSG_CACHE_MANAGER_LEAKED + this.multiRequestContextRegistry.size() + " multi-request contexts!");
            }
            this.multiRequestContextRegistry.clear();
            if (!this.sessionContextRegistry.isEmpty()) {
                XQEDebugLog.err.println(LOGMSG_CACHE_MANAGER_LEAKED + this.sessionContextRegistry.size() + " session-request contexts!");
            }
            this.sessionContextRegistry.clear();
            if (!this.queryContextRegistry.isEmpty()) {
                XQEDebugLog.err.println(LOGMSG_CACHE_MANAGER_LEAKED + this.queryContextRegistry.size() + " query contexts!");
            }
            this.queryContextRegistry.clear();
        }
        finally {
            this.contextRegistryLock.writeLock().unlock();
        }
        MEM_PLAN_CACHE_LOGGER.log(LogLevel.INFO, "Clear all.");
        this.planCacheLock.writeLock().lock();
        try {
            this.checkSize();
            this.planClearAllCount += (long)this.planCache.size();
            this.planCache.clear();
        }
        finally {
            this.rememberSize();
            this.planCacheLock.writeLock().unlock();
        }
        this.datasetRegistryLock.writeLock().lock();
        try {
            if (!this.datasetRegistry.isEmpty()) {
                XQEDebugLog.err.println(LOGMSG_CACHE_MANAGER_LEAKED + this.datasetRegistry.size() + " datasets!");
            }
            this.datasetRegistry.clear();
        }
        finally {
            this.datasetRegistryLock.writeLock().unlock();
        }
        if (!this.partialDatasetCache.isEmpty()) {
            XQEDebugLog.err.println(LOGMSG_CACHE_MANAGER_LEAKED + this.partialDatasetCache.size() + " partial datasets!");
        }
        this.partialDatasetCache.clear();
        LinkedHashMap<Triple, Pair> linkedHashMap = this.maResultCache;
        synchronized (linkedHashMap) {
            this.maResultCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMAResultCache() {
        LinkedHashMap<Triple, Pair> linkedHashMap = this.maResultCache;
        synchronized (linkedHashMap) {
            this.maResultCache.clear();
        }
    }

    @Override
    public void clearPlanTrees() {
        MEM_PLAN_CACHE_LOGGER.log(LogLevel.INFO, "Clearing plan cache from MBean interface.");
        this.planCacheLock.writeLock().lock();
        try {
            this.checkSize();
            this.planClearPlanTreesCount += (long)this.planCache.size();
            this.planCache.clear();
            this.oldestPlanTime = System.currentTimeMillis();
        }
        finally {
            this.rememberSize();
            this.planCacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getDatasetInfo() {
        this.datasetRegistryLock.readLock().lock();
        try {
            String[] info = new String[this.datasetRegistry.size()];
            StringBuilder buffer = new StringBuilder();
            int i = 0;
            for (RefCountingMap.Entry<String, RSAPIDataset> entry : this.datasetRegistry.entries()) {
                buffer.delete(0, buffer.length()).append(entry.getKey()).append(LOGMSG_REF_COUNT_IS).append(entry.getReferenceCount()).append(')');
                info[i++] = buffer.toString();
            }
            String[] stringArray = info;
            return stringArray;
        }
        finally {
            this.datasetRegistryLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getMultiRequestContextInfo() {
        this.contextRegistryLock.readLock().lock();
        try {
            String[] info = new String[this.multiRequestContextRegistry.size()];
            StringBuilder buffer = new StringBuilder();
            int i = 0;
            for (RefCountingMap.Entry<String, MultiRequestContext> entry : this.multiRequestContextRegistry.entries()) {
                buffer.delete(0, buffer.length()).append(entry.getKey()).append(entry.getReferencedObject().getIDSString()).append(LOGMSG_REF_COUNT_IS).append(entry.getReferenceCount()).append(')');
                info[i++] = buffer.toString();
            }
            String[] stringArray = info;
            return stringArray;
        }
        finally {
            this.contextRegistryLock.readLock().unlock();
        }
    }

    @Override
    public int getNumPlanTrees() {
        this.planCacheLock.readLock().lock();
        try {
            int n = this.planCache.size();
            return n;
        }
        finally {
            this.planCacheLock.readLock().unlock();
        }
    }

    @Override
    public String[] getPartialDatasetInfo() {
        ArrayList<String> infoList = new ArrayList<String>(this.partialDatasetCache.size());
        StringBuilder buffer = new StringBuilder();
        for (RSAPIPartialDataset partialDS : this.partialDatasetCache.values()) {
            buffer.delete(0, buffer.length()).append(partialDS.getUniqueID()).append(MASTER_DATASET_IS).append(partialDS.getMasterDataset().getUniqueID());
            infoList.add(buffer.toString());
        }
        return infoList.toArray(new String[0]);
    }

    @Override
    public String[] getPartialDatasetInfoForDataset(String datasetId) {
        RSAPIDataset dataset = this.getDatasetByID(datasetId);
        if (null == dataset) {
            return new String[0];
        }
        RSAPIPartialDataset[] partialDatasets = dataset.getActivePartialDatasets();
        String[] info = new String[partialDatasets.length];
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        for (RSAPIPartialDataset partialDS : partialDatasets) {
            buffer.delete(0, buffer.length()).append(partialDS.getUniqueID()).append(MASTER_DATASET_IS).append(partialDS.getMasterDataset().getUniqueID());
            info[i++] = buffer.toString();
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getQueryContextInfo() {
        this.contextRegistryLock.readLock().lock();
        try {
            String[] info = new String[this.queryContextRegistry.size()];
            int i = 0;
            for (String id : this.queryContextRegistry.keySet()) {
                info[i++] = id;
            }
            String[] stringArray = info;
            return stringArray;
        }
        finally {
            this.contextRegistryLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getSessionContextInfo() {
        this.contextRegistryLock.readLock().lock();
        try {
            String[] info = new String[this.sessionContextRegistry.size()];
            int i = 0;
            for (String id : this.sessionContextRegistry.keySet()) {
                info[i++] = id;
            }
            String[] stringArray = info;
            return stringArray;
        }
        finally {
            this.contextRegistryLock.readLock().unlock();
        }
    }

    @Override
    public void configurationChanged(XQEConfigurationEvent event) {
        if ("general.cacheQueryPlans".equals(event.getPropertyName())) {
            this.cacheQueryPlans = Boolean.parseBoolean((String)event.getPropertyValue());
        }
    }

    private void writeNameValue(XMLStreamWriter stream, String name, String value) throws XMLStreamException {
        stream.writeCharacters(STRING_NEWLINE);
        stream.writeStartElement(name);
        stream.writeCharacters(value);
        stream.writeEndElement();
    }

    public void writeStateAll() {
        StringBuilder baseFileName = new StringBuilder("CacheState");
        String dumpFilePath = CacheManager.getDumpFilePath(baseFileName);
        if (MEM_PLAN_CACHE_LOGGER.isOn(LogLevel.INFO)) {
            MEM_PLAN_CACHE_LOGGER.log(LogLevel.INFO, "writing statistics to:" + dumpFilePath);
            MEM_PLAN_CACHE_LOGGER.log(LogLevel.INFO, "number of plans: " + this.planCache.size());
        }
        try {
            XMLOutputFactory factory = XQEXMLOutputFactoryPool.getInstance().borrowXMLOutputFactory();
            FileOutputStream opStream = new FileOutputStream(dumpFilePath);
            XMLStreamWriter writer = factory.createXMLStreamWriter(opStream, FILE_CHAR_ENCODING_UTF_8);
            writer.writeStartDocument();
            writer.writeStartElement(STRING_XQE_CACHE_STATE);
            this.writePlanCacheStatistics(writer);
            this.planCacheLock.readLock().lock();
            for (Map.Entry<ArrayWrapper<String>, PlannedV5QuerySet> entry : this.planCache.entrySet()) {
                ArrayWrapper<String> k = entry.getKey();
                PlannedV5QuerySet p = entry.getValue();
                writer.writeCharacters(STRING_NEWLINE);
                writer.writeStartElement("plan");
                writer.writeStartElement("key");
                writer.writeCData(k.toString());
                writer.writeEndElement();
                this.writeNameValue(writer, "nodeCount", String.valueOf(p.getNumberNodes()));
                MemoryWalker.MemoryStatistics stats = MemoryWalker.deepStatistics(k);
                stats.printStats("CacheManager::writeState planCacheKey");
                stats = new MemoryWalker.MemoryStatistics();
                stats.enableCollectionOfClassStatistics();
                stats.skip(p.getMetadataConnection());
                IMultiRequestGateway mfw4jgw = p.getMetadataConnection().getGateway();
                stats.skip(mfw4jgw);
                stats.skip(p.getPlanningEnvironment());
                stats.skip(p.getRequestParameters());
                stats.skip(p.getMasterDetailProvider());
                for (IXQEQueryNode n : p.getDescendantsOfType(501013, false)) {
                    XSql x = (XSql)n;
                    stats.skip(x.getDataSource());
                }
                MemoryWalker.deepSizeof(p, stats);
                String pidStr = ManagementFactory.getRuntimeMXBean().getName();
                String atSign = "@";
                if (pidStr.indexOf(atSign) >= 0) {
                    pidStr = pidStr.substring(0, pidStr.indexOf(atSign));
                }
                int pidInt = Integer.parseInt(pidStr);
                pidStr = String.valueOf(pidInt);
                stats.writeClassStatsToCSVFile("c:/temp/cacheStats_" + pidStr + ".csv", "headerLine", false);
                this.writeNameValue(writer, "memory", String.valueOf(stats.totalSize));
                this.writeNameValue(writer, "objCount", String.valueOf(stats.numObjects));
                this.writeNameValue(writer, "lastAccessed", DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(p.getPlanTime()));
                writer.writeEndElement();
            }
            this.planCacheLock.readLock().unlock();
            writer.writeStartElement("datasetInfo");
            String[] lines = this.getDatasetInfo();
            for (int i = 0; i < lines.length; ++i) {
                writer.writeStartElement("entry");
                writer.writeCharacters(lines[i]);
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndDocument();
            XQEXMLOutputFactoryPool.getInstance().returnXMLOutputFactory(factory);
            opStream.close();
        }
        catch (Exception e) {
            MEM_PLAN_CACHE_LOGGER.log(LogLevel.WARN, e.getLocalizedMessage() + new Throwable().getStackTrace()[0]);
        }
    }

    private XMLStreamWriter getCacheStatisticsWriter() {
        try {
            if (this.stateWriter == null) {
                String cacheStateLog = CacheManager.getDumpFilePath();
                cacheStateLog = cacheStateLog + "/CacheState_";
                long currentTime = System.currentTimeMillis();
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy_mm_dd_hh_mm_ss");
                cacheStateLog = cacheStateLog + dateFormat.format(new Date(currentTime));
                cacheStateLog = cacheStateLog + STRING_XML_FILE_EXTENSION;
                XMLOutputFactory factory = XQEXMLOutputFactoryPool.getInstance().borrowXMLOutputFactory();
                FileOutputStream opStream = new FileOutputStream(cacheStateLog, true);
                this.stateWriter = factory.createXMLStreamWriter(opStream, FILE_CHAR_ENCODING_UTF_8);
                this.stateWriter.writeStartDocument();
                this.stateWriter.writeStartElement("doc");
                XQEXMLOutputFactoryPool.getInstance().returnXMLOutputFactory(factory);
            }
        }
        catch (Exception ex) {
            MEM_PLAN_CACHE_LOGGER.log(LogLevel.WARN, ex.getLocalizedMessage() + new Throwable().getStackTrace()[0]);
        }
        return this.stateWriter;
    }

    public void writeState() {
        if (!this.writeCacheStatistics) {
            return;
        }
        try {
            XMLStreamWriter writer = this.getCacheStatisticsWriter();
            writer.writeStartElement(STRING_XQE_CACHE_STATE);
            this.planCacheLock.readLock().lock();
            this.writePlanCacheStatistics(writer);
            this.planCacheLock.readLock().unlock();
            writer.writeEndElement();
            writer.flush();
        }
        catch (Exception ex) {
            MEM_PLAN_CACHE_LOGGER.log(LogLevel.WARN, ex.getLocalizedMessage() + new Throwable().getStackTrace()[0]);
        }
    }

    private void writePlanCacheStatistics(XMLStreamWriter writer) throws XMLStreamException {
        String ctime = DateFormatUtils.format((long)System.currentTimeMillis(), (String)"yyyy-MM-dd HH:mm:ss");
        this.writeNameValue(writer, "clock", String.valueOf(ctime));
        this.writeNameValue(writer, "maxPlanCacheSize", String.valueOf(this.maxPlanCacheSize));
        this.writeNameValue(writer, "planCacheTimeout", String.valueOf(this.planCacheTimeout));
        this.writeNameValue(writer, "numPlans", String.valueOf(this.getNumPlanTrees()));
        this.writeNameValue(writer, "hitCount", String.valueOf(this.planHitCount));
        this.writeNameValue(writer, "missCount", String.valueOf(this.planMissCount));
        this.writeNameValue(writer, "readFromFileCount", String.valueOf(this.planReadFromFileCount));
        this.writeNameValue(writer, "updateCount", String.valueOf(this.planUpdateCount));
        this.writeNameValue(writer, "removedByCallCount", String.valueOf(this.planRemovedByCallCount));
        this.writeNameValue(writer, "removedForUseCount", String.valueOf(this.planRemovedForUseCount));
        this.writeNameValue(writer, "clearAllCount", String.valueOf(this.planClearAllCount));
        this.writeNameValue(writer, "clearPlanTreesCount", String.valueOf(this.planClearPlanTreesCount));
        this.writeNameValue(writer, "evictTooOldCount", String.valueOf(this.planEvictTooOldCount));
        this.writeNameValue(writer, "evictJMMSoftCount", String.valueOf(this.planEvictJMMSoftCount));
        this.writeNameValue(writer, "evictJMMHardSoftCount", String.valueOf(this.planEvictJMMHardSoftCount));
        this.writeNameValue(writer, "evictForcedCount", String.valueOf(this.planEvictForcedCount));
    }

    private void closeStatisticsFile() {
        if (!this.writeCacheStatistics) {
            return;
        }
        try {
            XMLStreamWriter writer = this.getCacheStatisticsWriter();
            writer.writeEndElement();
            writer.close();
        }
        catch (Exception ex) {
            MEM_PLAN_CACHE_LOGGER.log(LogLevel.WARN, ex.getLocalizedMessage() + new Throwable().getStackTrace()[0]);
        }
    }

    protected static String getDumpFilePath(StringBuilder filename) {
        StringBuilder leadFilePath = new StringBuilder(CacheManager.getDumpFilePath());
        leadFilePath.append(File.separatorChar);
        leadFilePath.append(FileUtil.makeJavaIdentifier(filename.toString()));
        StringBuilder tempFilePath = null;
        File f = null;
        do {
            tempFilePath = new StringBuilder(leadFilePath);
            tempFilePath.append("_");
            tempFilePath.append(fileSeqNumber);
            tempFilePath.append(STRING_XML_FILE_EXTENSION);
            f = new File(tempFilePath.toString());
            ++fileSeqNumber;
        } while (f.exists());
        return tempFilePath.toString();
    }

    private static String getDumpFilePath() {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        String logsDir = configuration.getXqeLogsDirectory();
        ICCLConfiguration cclConfig = XQECCLConfigurationFactory.getInstance();
        String epath = cclConfig.resolveEffectivePath(logsDir);
        return epath;
    }

    public void storePlanForUnresolvedParameters(String planKey, IRequestEnvironment reqEnv, PlanningEnvironment planEnv) {
        if (!this.cacheQueryPlans) {
            return;
        }
        if (!this.usePersistentPlanCache) {
            return;
        }
        this.persistentPlanCache.storePlanForUnresolvedParameter(planKey, reqEnv, planEnv);
    }

    public PersistentPlanDiskCacheStatistics getPeristentPlanDiskCacheStatistics() {
        if (this.usePersistentPlanCache) {
            return this.persistentPlanCache.getPersistentPlanDiskCacheStatistics();
        }
        return null;
    }

    public void setMinThreshold(int threshold) {
        this.planMinThreshold = threshold;
    }

    public int getMinThreshold() {
        return this.planMinThreshold;
    }
}

