/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.engine;

import com.cognos.xqe.bibushandler.CancelRequestSourceEnum;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.query.engine.SessionContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.DumpCreator;
import com.cognos.xqe.util.ExcessiveCollectionNotificationDispatcher;
import com.cognos.xqe.util.ExcessiveCollectionNotifier;
import java.util.Observable;
import java.util.Observer;
import java.util.Timer;

class ExcessiveCollectionHandler {
    private static final XQELogger LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    private final ExcessiveCollectionNotifier mExcessiveCollectionNotifier;
    private final ExcessiveCollectionNotificationDispatcher mExcessiveCollectionNotificationDispatcher = new ExcessiveCollectionNotificationDispatcher();

    ExcessiveCollectionHandler(Timer timer) {
        XQEConfiguration xqeConfiguration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        boolean dumpEnabled = xqeConfiguration.getBooleanProperty("general.gc.excessiveCollectionSystemDumpEnabled", false);
        if (dumpEnabled) {
            this.mExcessiveCollectionNotificationDispatcher.registerListener(new SystemDumpCreator(this.mExcessiveCollectionNotificationDispatcher));
        }
        double threshold = xqeConfiguration.getDoubleProperty("general.gc.excessiveCollectionThreshold", 0.8);
        long period = xqeConfiguration.getLongProperty("general.gc.excessiveCollectionCheckPeriod", 60000L);
        this.mExcessiveCollectionNotifier = new ExcessiveCollectionNotifier(timer, threshold, period, this.mExcessiveCollectionNotificationDispatcher);
    }

    void register(SessionContext sessionContext) {
        new SessionContextAdapter(this.mExcessiveCollectionNotificationDispatcher, sessionContext);
    }

    void stop() {
        this.mExcessiveCollectionNotifier.stop();
    }

    private static class SystemDumpCreator
    implements ExcessiveCollectionNotifier.IExcessiveCollectionListener {
        private final ExcessiveCollectionNotificationDispatcher mExcessiveCollectionNotificationDispatcher;

        SystemDumpCreator(ExcessiveCollectionNotificationDispatcher excessiveCollectionNotificationDispatcher) {
            this.mExcessiveCollectionNotificationDispatcher = excessiveCollectionNotificationDispatcher;
        }

        @Override
        public void onExcessiveCollection(int consecutiveInvocationCount) {
            if (consecutiveInvocationCount > 0) {
                this.mExcessiveCollectionNotificationDispatcher.unregisterListener(this);
                try {
                    boolean dumpCreated = DumpCreator.createSystemDump();
                    if (dumpCreated) {
                        try {
                            LOGGER.log("Created System Dump on excessive collection");
                        }
                        catch (Throwable throwable) {}
                    }
                }
                catch (Throwable t) {
                    try {
                        LOGGER.log(t);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static class SessionContextAdapter
    implements ExcessiveCollectionNotificationDispatcher.IStampedExcessiveCollectionNotifier,
    Observer {
        private final ExcessiveCollectionNotificationDispatcher mExcessiveCollectionNotificationDispatcher;
        private final SessionContext mSessionContext;

        SessionContextAdapter(ExcessiveCollectionNotificationDispatcher excessiveCollectionNotificationDispatcher, SessionContext sessionContext) {
            this.mExcessiveCollectionNotificationDispatcher = excessiveCollectionNotificationDispatcher;
            this.mSessionContext = sessionContext;
            this.mExcessiveCollectionNotificationDispatcher.registerStampedListener(this);
            this.mSessionContext.addObserver(this);
        }

        @Override
        public void onExcessiveCollection(int consecutiveInvocationCount) {
            String requestID = this.mSessionContext.getRequestID();
            this.mSessionContext.getCancelableRequestRegistry().cancel(requestID, CancelRequestSourceEnum.EXCESSIVE_GARBAGE_COLLECTION);
            try {
                LOGGER.log(LogLevel.ERROR, "Cancelled " + requestID + " on excessive collection #" + consecutiveInvocationCount);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public void update(Observable o, Object arg) {
            this.unregister();
        }

        private void unregister() {
            this.mExcessiveCollectionNotificationDispatcher.unregisterStampedListener(this);
            this.mSessionContext.deleteObserver(this);
        }

        @Override
        public long getLastAccessTime() {
            return this.mSessionContext.getLastAccessTime();
        }
    }
}

