/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.engine;

import com.cognos.xqe.bibushandler.CancelableRequestRegistry;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.olap.SecuredOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.securecache.MemberStorage;
import com.cognos.xqe.data.values.ResultSetValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.pool.connection.IConnectionPool;
import com.cognos.xqe.query.engine.IContextable;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.query.engine.SessionContext;
import com.cognos.xqe.query.parameters.GlobalParametersUtil;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.RequestParameters;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIResultSet;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental.IncrementManager;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.RunStatsRecorder;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.transformation.v5tocogsql.util.FJOCache;
import com.cognos.xqe.util.IReleasable;
import com.cognos.xqe.util.LoopDetectionChain;
import com.cognos.xqe.util.ParameterMapCM;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.reference.ReferenceCountedBase;
import com.cognos.xqe.util.resource.ReleasableResourceTracker;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.dom4j.Document;
import org.dom4j.Element;

public final class MultiRequestContext
extends ReferenceCountedBase
implements IReleasable {
    private int traceEnabled = -1;
    private LogLevel dqaLoggingLevel = null;
    private String mSessionContextID;
    private String mRequestID;
    private SessionContext mSessionContext;
    private boolean mReleaseSessionContext;
    private IConnectionPool mConnectionPool = null;
    private Document mRequestDocument = null;
    private RequestParameters requestParameters = null;
    private final Map<RSAPIDataset, RSAPIResultSet> resultsets = new HashMap<RSAPIDataset, RSAPIResultSet>();
    private Map<String, PlannedV5QuerySet> singleExpressionCache = null;
    private final Map<String, Object> xqeConfigurationMap = new HashMap<String, Object>();
    private LoopDetectionChain qiParameterMapLDC = new LoopDetectionChain();
    private static XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
    private Map<String, Document> queriesRequiringReplan = new HashMap<String, Document>();
    private Map<String, Parameter> globalParametersMap = null;
    private boolean globalParametersEnabled = false;
    private boolean globalParametersInfoLoaded = false;
    private RequestProcessing requestProcessing;
    private final Map<MemberStorage.MemberStorageIdentifier, SecuredOLAPMetadataProvider> securedOLAPMetadataProvider = new HashMap<MemberStorage.MemberStorageIdentifier, SecuredOLAPMetadataProvider>();
    private final List<IReleasable> resources = new LinkedList<IReleasable>();
    private ROLAPContext rolapContext = null;
    private final XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "MultiRequestContext", LogLevel.INFO);
    private volatile boolean released = false;
    private final long creationTimestamp;
    private final ReleasableResourceTracker resourceTracker = new ReleasableResourceTracker();
    private static final boolean DISABLEGLOBALRESOURCTRACKING = System.getProperty("disableGlobalResourceTracking") != null;
    private FJOCache joinFilterCache;

    public Object fetchXQEConfigurationProperty(String key, Object defaultValue) {
        Object value = this.xqeConfigurationMap.get(key);
        if (value == null && configuration != null) {
            value = configuration.getPropertyValue(key, defaultValue);
            this.xqeConfigurationMap.put(key, value);
        }
        return value;
    }

    public boolean fetchBooleanConfiguration(String key, boolean defaultValue) {
        Boolean value = (Boolean)this.xqeConfigurationMap.get(key);
        if (value == null && configuration != null) {
            value = configuration.getBooleanProperty(key, defaultValue);
            this.xqeConfigurationMap.put(key, value);
        }
        return value != null && value != false;
    }

    public int fetchgetIntConfiguration(String key, int defaultValue) {
        Object value = this.xqeConfigurationMap.get(key);
        if (value == null && configuration != null) {
            value = configuration.getIntegerProperty(key, defaultValue);
            this.xqeConfigurationMap.put(key, value);
        }
        if (value != null) {
            return (Integer)value;
        }
        return 0;
    }

    public long fetchLongConfiguration(String key, long defaultValue) {
        Object value = this.xqeConfigurationMap.get(key);
        if (value == null && configuration != null) {
            value = configuration.getLongProperty(key, defaultValue);
            this.xqeConfigurationMap.put(key, value);
        }
        if (value != null) {
            return (Long)value;
        }
        return 0L;
    }

    public XQEConfiguration getXQEConfiguration() {
        return configuration;
    }

    public Map<String, Object> getXQEConfigurationMap() {
        return this.xqeConfigurationMap;
    }

    public void setXQEConfigurationMap(Map<String, Object> configurationMap) {
        this.xqeConfigurationMap.putAll(configurationMap);
    }

    public MultiRequestContext(SessionContext theSessionContext, boolean releaseSessionContext) {
        if (null == theSessionContext) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "null == theSessionContext ");
        }
        this.creationTimestamp = System.currentTimeMillis();
        this.mSessionContext = theSessionContext;
        this.mSessionContextID = theSessionContext.getSessionContextID();
        this.mRequestID = this.mSessionContext.getRequestID();
        this.mSessionContext.linkMultiRequestContext(this);
        this.mReleaseSessionContext = releaseSessionContext;
        this.requestProcessing = RequestProcessing.DEFAULT;
        if (!DISABLEGLOBALRESOURCTRACKING) {
            ResultSetValue.getStaticResourceTracker().addNestedTracker(this.resourceTracker);
        }
        if (this.logger.isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Created MultiRequestContext with id = ").append(this.mSessionContext.getIDSString());
            this.logger.log(LogLevel.INFO, buffer.toString());
        }
    }

    public void setSessionContext(SessionContext theSessionContext, boolean releaseSessionContext) {
        if (null == theSessionContext) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "null == theSessionContext");
        }
        if (this.mSessionContext != null) {
            this.mSessionContext.unlinkMultiRequestContext(this);
            if (this.mReleaseSessionContext) {
                this.mSessionContext.release();
            }
        }
        this.mSessionContext = theSessionContext;
        this.mSessionContextID = theSessionContext.getSessionContextID();
        this.mRequestID = this.mSessionContext.getRequestID();
        this.mSessionContext.linkMultiRequestContext(this);
        this.mReleaseSessionContext = releaseSessionContext;
    }

    public void setReleaseSessionContext(boolean releaseSessionContext) {
        this.mReleaseSessionContext = releaseSessionContext;
    }

    public String getSessionContextID() {
        return this.mSessionContextID;
    }

    public String getRequestID() {
        return this.mRequestID;
    }

    public String getIDSString() {
        return this.mSessionContext.getIDSString();
    }

    public boolean isInUse() {
        return this.getSessionContext().isInUse();
    }

    public void setInUse(boolean inUse) {
        this.getSessionContext().setInUse(inUse);
        this.getSessionContext().setLastAccessTime(System.currentTimeMillis());
    }

    public RSAPIResultSet getResultset(RSAPIDataset masterDataset) {
        this.assertNotReleased();
        return this.resultsets.get(masterDataset);
    }

    public RSAPIResultSet removeResultset(RSAPIDataset masterDataset) {
        this.assertNotReleased();
        return this.resultsets.remove(masterDataset);
    }

    public RSAPIResultSet setResultset(RSAPIDataset masterDataset, RSAPIResultSet result) {
        this.assertNotReleased();
        return this.resultsets.put(masterDataset, result);
    }

    public IConnectionPool getConnectionPool() {
        this.assertNotReleased();
        return this.mConnectionPool;
    }

    public void setConnectionPool(IConnectionPool connectionPool) {
        this.assertNotReleased();
        this.mConnectionPool = connectionPool;
    }

    public Document getRequestDocument() {
        this.assertNotReleased();
        return this.mRequestDocument;
    }

    public Document getDetailQueryRequestDocument(String queryName) {
        this.assertNotReleased();
        if (!this.queriesRequiringReplan.containsKey(queryName)) {
            return null;
        }
        return this.queriesRequiringReplan.get(queryName);
    }

    public void setRequestDocument(Document requestDocument) {
        this.assertNotReleased();
        this.mRequestDocument = requestDocument;
    }

    public RequestParameters getRequestParameters() {
        this.assertNotReleased();
        if (null == this.requestParameters) {
            this.requestParameters = new RequestParameters();
        }
        return this.requestParameters;
    }

    public void setRequestParameters(RequestParameters reqParameters) {
        this.assertNotReleased();
        this.requestParameters = reqParameters;
    }

    public ParameterMapCM getCMMap() {
        this.assertNotReleased();
        return this.mSessionContext.getCmMap();
    }

    public void setCMMap(ParameterMapCM map) {
        this.assertNotReleased();
        this.mSessionContext.setCmMap(map);
    }

    public IDataSource getDataSourceByModelName(String modelName) {
        this.assertNotReleased();
        return this.mSessionContext.getDataSourceCache().get(modelName);
    }

    public Collection<IDataSource> getDataSources() {
        this.assertNotReleased();
        return this.mSessionContext.getDataSourceCache().values();
    }

    public void addDataSource(IDataSource dataSource) {
        this.assertNotReleased();
        this.mSessionContext.getDataSourceCache().put(dataSource.getName(), dataSource);
    }

    public PlannedV5QuerySet getSingleExpressionQuery(String expression) {
        this.assertNotReleased();
        if (null == this.singleExpressionCache) {
            return null;
        }
        return this.singleExpressionCache.get(expression);
    }

    public void cacheSingleExpressionQuery(String expression, PlannedV5QuerySet plan) {
        this.assertNotReleased();
        if (null == this.singleExpressionCache) {
            this.singleExpressionCache = new TreeMap<String, PlannedV5QuerySet>();
        }
        this.singleExpressionCache.put(expression, plan);
    }

    public SecuredOLAPMetadataProvider getSecuredOLAPMetadataProvider(MemberStorage.MemberStorageIdentifier metadataProviderKey) {
        this.assertNotReleased();
        return this.securedOLAPMetadataProvider.get(metadataProviderKey);
    }

    public void setSecuredOLAPMetadataProvider(MemberStorage.MemberStorageIdentifier metadataProviderKey, SecuredOLAPMetadataProvider securedMetadataProvider) {
        this.assertNotReleased();
        this.securedOLAPMetadataProvider.put(metadataProviderKey, securedMetadataProvider);
    }

    public void registerResource(IContextable resource) {
        this.assertNotReleased();
        if (resource == null) {
            throw new IllegalStateException("Invalid releasable resource");
        }
        if (resource.isSessionScope()) {
            this.mSessionContext.registerResource(resource);
        } else {
            this.resources.add(resource);
        }
    }

    public void unregisterResource(IContextable resource) {
        if (resource == null) {
            throw new IllegalStateException("Invalid releasable resource ");
        }
        if (resource.isSessionScope()) {
            this.mSessionContext.unregisterResource(resource);
        } else {
            this.resources.remove(resource);
        }
    }

    Object getReferenceById(Long refId) {
        return this.mSessionContext.getReferencesById().get(refId);
    }

    void putReferenceById(Long refId, Object referent) {
        this.assertNotReleased();
        this.mSessionContext.getReferencesById().put(refId, referent);
    }

    void removeReferenceById(Long refId) {
        this.assertNotReleased();
        this.mSessionContext.getReferencesById().remove(refId);
    }

    @Override
    protected void onDecrementRefCount(int newRefCount) {
        if (0 == newRefCount) {
            this.release();
        }
    }

    @Override
    protected void onIncrementRefCount(int newRefCount) {
    }

    public SessionContext getSessionContext() {
        return this.mSessionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        if (this.released) {
            return;
        }
        String reportName = "unknown";
        String operationName = "";
        try {
            IReleasable[] resourcesArray;
            IExecutionEnvironment execEnv;
            StringBuilder buffer = new StringBuilder();
            if (this.logger.isOn(LogLevel.INFO)) {
                buffer.append("Releasing MultiRequestContext with id=").append(this.mSessionContext.getIDSString());
                this.logger.log(LogLevel.INFO, buffer.toString());
            }
            if (null == (execEnv = ExecutionEnvironmentContext.getExecutionEnvironment())) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
            }
            if (this != execEnv.getMultiRequestContextNoThrow()) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "this != execEnv.getMultiRequestContextNoThrow()");
            }
            Object reqEnv = execEnv.getRequestEnvironment();
            if (reqEnv != null) {
                reportName = reqEnv.getReportName();
                operationName = reqEnv.getOperationName();
            }
            if (!this.resultsets.isEmpty()) {
                buffer.delete(0, buffer.length()).append("Leaked resultset(s) detected from MultiRequestContext with id=").append(this.getIDSString());
                this.logger.log(LogLevel.ERROR, buffer.toString());
                RSAPIDataset[] leakedDatasets = this.resultsets.keySet().toArray(new RSAPIDataset[0]);
                QueryEngine.getInstance().cleanupLeakedDatasets(execEnv, leakedDatasets);
                this.resultsets.clear();
            }
            for (SecuredOLAPMetadataProvider provider : this.securedOLAPMetadataProvider.values()) {
                provider.release();
            }
            this.securedOLAPMetadataProvider.clear();
            for (IReleasable resource : resourcesArray = this.resources.toArray(new IReleasable[0])) {
                try {
                    resource.release();
                }
                catch (Throwable ex) {
                    buffer.delete(0, buffer.length()).append("An error occurred while releasing the MultiRequestContext with id=").append(this.getIDSString()).append("; Stack Trace: ");
                    this.logger.log(LogLevel.ERROR, buffer.toString(), ex);
                }
            }
            this.resources.clear();
            this.rolapContext = null;
            if (!DISABLEGLOBALRESOURCTRACKING) {
                this.resourceTracker.removeFromNestingTracker();
            }
            this.resourceTracker.reportAndCleanup(true);
            this.mSessionContext.unlinkMultiRequestContext(this);
            if (this.mReleaseSessionContext) {
                this.mSessionContext.release();
            }
        }
        finally {
            if (null != this.singleExpressionCache) {
                this.singleExpressionCache.clear();
                this.singleExpressionCache = null;
            }
            this.clearQueryRequiresReplan();
            RunStatsRecorder.getInstance().record(operationName, reportName, true, this.creationTimestamp);
            this.mConnectionPool = null;
            this.mRequestDocument = null;
            this.released = true;
        }
    }

    public boolean isReleased() {
        return this.released;
    }

    private void assertNotReleased() {
        if (this.released) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ResourceWasReleased);
        }
    }

    public void clearRequestParameters() {
        this.assertNotReleased();
        this.requestParameters = new RequestParameters();
    }

    CancelableRequestRegistry getCancelableRequestRegistry() {
        CancelableRequestRegistry cancelableRequestRegistry = null == this.mSessionContext ? null : this.mSessionContext.getCancelableRequestRegistry();
        return cancelableRequestRegistry;
    }

    public LogLevel getDQALoggingLevel() {
        return this.dqaLoggingLevel;
    }

    public void setDQALoggingLevel(LogLevel logLevel) {
        this.dqaLoggingLevel = logLevel;
    }

    public int getTraceEnabled() {
        return this.traceEnabled;
    }

    public void setTraceEnabled(int traceValue) {
        this.traceEnabled = traceValue;
    }

    public ROLAPContext getRolapContext() {
        if (this.rolapContext == null) {
            this.rolapContext = new ROLAPContext(this);
            this.registerResource(this.rolapContext);
        }
        return this.rolapContext;
    }

    public void setRolapContext(ROLAPContext context) {
        this.rolapContext = context;
    }

    public ReleasableResourceTracker getResourceTracker() {
        return this.resourceTracker;
    }

    public XQEConfiguration getConfiguration() {
        return configuration;
    }

    public int getIncrementId(ICube cube) {
        int incrementID = 0;
        if (cube instanceof ROLAPCube) {
            incrementID = IncrementManager.getIncrementID((ROLAPCube)cube);
        }
        return incrementID;
    }

    public static int getCurrentIncrementId(IExecutionEnvironment execEnv, ICube cube) {
        if (execEnv == null) {
            return 0;
        }
        MultiRequestContext multiRequestContext = execEnv.getMultiRequestContextNoThrow();
        if (multiRequestContext == null) {
            return 0;
        }
        return multiRequestContext.getIncrementId(cube);
    }

    public static int getCurrentIncrementId(ICube cube) {
        return MultiRequestContext.getCurrentIncrementId(ExecutionEnvironmentContext.getExecutionEnvironment(), cube);
    }

    public LoopDetectionChain getQIParameterMapLDC() {
        return this.qiParameterMapLDC;
    }

    public boolean queryRequiresReplan(String queryName) {
        return this.queriesRequiringReplan.containsKey(queryName);
    }

    public void addQueryRequiresReplan(String queryName) {
        if (!this.queriesRequiringReplan.containsKey(queryName)) {
            this.queriesRequiringReplan.put(queryName, this.mRequestDocument);
        } else {
            String name;
            Element propElement;
            Document cachedRequestDocument = this.getDetailQueryRequestDocument(queryName);
            if (cachedRequestDocument.equals(this.mRequestDocument)) {
                return;
            }
            Element cachedRootElement = cachedRequestDocument.getRootElement();
            Element cachedParametersElement = cachedRootElement.element("parameters");
            Element incomingRootElement = this.mRequestDocument.getRootElement();
            Element incomingParametersElement = incomingRootElement.element("parameters");
            if (cachedParametersElement == null || incomingParametersElement == null) {
                return;
            }
            if (cachedParametersElement.equals(incomingParametersElement)) {
                return;
            }
            List items = cachedParametersElement.elements();
            HashSet<String> cachedParameterNames = new HashSet<String>();
            for (Element element : items) {
                propElement = element.element("name");
                name = propElement.getText().trim();
                cachedParameterNames.add(name);
            }
            items = incomingParametersElement.elements();
            for (Element element : items) {
                propElement = element.element("name");
                name = propElement.getText().trim();
                if (cachedParameterNames.contains(name)) continue;
                this.queriesRequiringReplan.put(queryName, this.mRequestDocument);
                return;
            }
        }
    }

    private void clearQueryRequiresReplan() {
        for (String key : this.queriesRequiringReplan.keySet()) {
            this.queriesRequiringReplan.put(key, null);
        }
        this.queriesRequiringReplan.clear();
    }

    public boolean hasQueryRequiresReplan() {
        return !this.queriesRequiringReplan.isEmpty();
    }

    public synchronized FJOCache getOrCreateJoinFilterCache() {
        if (this.joinFilterCache == null) {
            this.joinFilterCache = new FJOCache();
        }
        return this.joinFilterCache;
    }

    public RequestProcessing getRequestProcessing() {
        return this.requestProcessing;
    }

    public void setRequestProcessing(RequestProcessing processing) {
        this.requestProcessing = processing;
    }

    public void setGlobalParametersMap(Map<String, Parameter> map) {
        this.globalParametersMap = map;
    }

    public Map<String, Parameter> getGlobalParametersMap() {
        if (this.globalParametersEnabled()) {
            return this.globalParametersMap;
        }
        return null;
    }

    public Parameter getEffectiveGlobalParameter(String paramName, RequestEnvironment reqEnv) {
        if (this.globalParametersEnabled() && this.globalParametersMap != null) {
            return this.globalParametersMap.get(paramName);
        }
        return null;
    }

    public boolean globalParametersEnabled() {
        if (!this.globalParametersInfoLoaded) {
            this.loadGlobalParametersInfo();
            this.globalParametersInfoLoaded = true;
        }
        return this.globalParametersEnabled;
    }

    public void setGlobalParametersInfoLoaded(boolean loaded) {
        this.globalParametersInfoLoaded = loaded;
    }

    public void setGlobalParametersEnabled(boolean val) {
        this.globalParametersEnabled = val;
    }

    private void loadGlobalParametersInfo() {
        String globalParamsEnabled;
        Element rootElement;
        Element globalParametersElement;
        if (this.mRequestDocument != null && (globalParametersElement = (rootElement = this.mRequestDocument.getRootElement()).element("globalParameters")) != null && "true".equalsIgnoreCase(globalParamsEnabled = globalParametersElement.attributeValue("enabled"))) {
            this.setGlobalParametersEnabled(true);
            Element paramValuesElement = globalParametersElement.element("parameterValues");
            if (paramValuesElement != null) {
                this.globalParametersMap = GlobalParametersUtil.parseGlobalParametersFromElement(paramValuesElement, this);
            }
        }
        if (this.globalParametersEnabled && this.globalParametersMap == null) {
            this.globalParametersMap = GlobalParametersUtil.loadGlobalParamsFromCM(ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment());
        }
    }

    public static enum RequestProcessing {
        DEFAULT,
        DATABASEONLY,
        LIMITEDLOCAL,
        MINIMIZELOCAL;

    }
}

