/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.engine;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.query.engine.Nag;
import com.cognos.xqe.query.engine.NagSubquery;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.util.ArrayList;
import java.util.List;

public class NagCollector {
    private List<Nag> mNags = new ArrayList<Nag>();
    private boolean isIPFLoggingEnabled = false;
    XQELogger nagLogger = null;

    public NagCollector() {
        XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Nag", LogLevel.INFO);
        if (logger != null) {
            this.isIPFLoggingEnabled = logger.isOn();
            if (this.isIPFLoggingEnabled) {
                this.nagLogger = logger;
            }
        }
    }

    public boolean addNag(Nag nag) {
        if (nag.getType() == Nag.NagType.SUBQUERY) {
            this.mNags.add(nag);
            if (this.isIPFLoggingEnabled) {
                this.nagLogger.log(nag.getMessage());
            }
            return true;
        }
        boolean found = false;
        for (Nag iNag : this.mNags) {
            if (!iNag.getMessage().equals(nag.getMessage())) continue;
            found = true;
            break;
        }
        if (!found) {
            this.mNags.add(nag);
            if (this.isIPFLoggingEnabled) {
                this.nagLogger.log(nag.getMessage());
            }
        }
        return !found;
    }

    public List<Nag> getNagMessages() {
        return this.mNags;
    }

    public List<Nag> getNagOfType(Nag.NagType type) {
        ArrayList<Nag> listOfNagOfType = new ArrayList<Nag>();
        for (Nag nag : this.mNags) {
            if (nag.getType() != type) continue;
            listOfNagOfType.add(nag);
        }
        return listOfNagOfType;
    }

    public List<Nag> getNagOfSubqueryType(NagSubquery.NagSubqueryType type) {
        ArrayList<Nag> listOfNagOfType = new ArrayList<Nag>();
        for (Nag nag : this.mNags) {
            if (nag.getType() != Nag.NagType.SUBQUERY || !((NagSubquery)nag).getNagSubQueryType().equals((Object)type)) continue;
            listOfNagOfType.add(nag);
        }
        return listOfNagOfType;
    }

    public boolean isIPFLoggingEnabled() {
        return this.isIPFLoggingEnabled;
    }
}

