/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.engine;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.Nag;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.Governors;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.dom4j.Element;

public class PersistentPlan {
    private static final String ATTRIBUTE_MSGKEY = "msgkey";
    private static final String ATTRIBUTE_SEVERITY = "severity";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_USES_OLD_FORMAT = "usesOldFormat";
    private static final String ATTRIBUTE_VALUE = "value";
    private static final String ELEMENT_LOCATION = "location";
    private static final String ELEMENT_MACRO_RESULT = "macroResult";
    private static final String ELEMENT_MACRO_TEXT = "macroText";
    private static final String ELEMENT_MACROS = "macros";
    private static final String ELEMENT_MESSAGE = "message";
    private static final String ELEMENT_MESSAGE_FOLDER = "messageFolder";
    private static final String ELEMENT_NAG = "nag";
    private static final String ELEMENT_NAGS = "nags";
    private static final String ELEMENT_PARAMETER = "parameter";
    private static final String ELEMENT_PARAMETERS = "parameters";
    private static final String ELEMENT_PLAN_KEY = "planKey";
    private static final String ELEMENT_PLANNED_V5_QUERY_SET = "PlannedV5QuerySet";
    private static final String VALUE_TRUE = "true";
    private String reportName;
    private PlannedV5QuerySet plannedV5QuerySet = null;
    private Parameters parameters = new Parameters();
    private long planDurationMilli;
    private String planKey = null;
    private Governors governors = null;
    private TreeMap<String, String> resolvedMacros = null;
    private List<ResponseMessage> planningResponseMessages = null;
    private List<Nag> nags = null;
    public static final String STR_PERSISTENTPLAN = "PersistentPlan";

    public void capture(PlanningEnvironment env, Element inputNode) {
        this.parameters = new Parameters();
        List childList = inputNode.elements();
        for (Element c : childList) {
            if (c.getName().equals(ELEMENT_PARAMETERS)) {
                this.parameters.capture(env, c);
                continue;
            }
            if (c.getName().equals(ELEMENT_MESSAGE_FOLDER)) {
                this.capturePlanningResponseMessages(env, c);
                continue;
            }
            if (c.getName().equals(ELEMENT_NAGS)) {
                this.captureNags(env, c);
                continue;
            }
            if (ELEMENT_MACROS.equals(c.getName())) {
                this.captureMacros(env, c);
                continue;
            }
            if (c.getName().equals(ELEMENT_PLAN_KEY)) {
                this.planKey = c.getText();
                continue;
            }
            if (!c.getName().equals(ELEMENT_PLANNED_V5_QUERY_SET)) continue;
            this.plannedV5QuerySet = new PlannedV5QuerySet();
            this.plannedV5QuerySet.setPlanningEnvironment(env);
            this.plannedV5QuerySet.capture(env, c);
        }
    }

    public void captureMacros(PlanningEnvironment env, Element inputNode) {
        this.resolvedMacros = new TreeMap();
        List childList = inputNode.elements();
        for (Element c : childList) {
            if (!"macro".equals(c.getName())) continue;
            List ms = c.elements();
            String macroText = null;
            String macroResult = null;
            for (Element m : ms) {
                if (ELEMENT_MACRO_TEXT.equals(m.getName())) {
                    macroText = m.getText();
                    continue;
                }
                if (!ELEMENT_MACRO_RESULT.equals(m.getName())) continue;
                macroResult = m.getText();
            }
            this.resolvedMacros.put(macroText, macroResult);
        }
    }

    public void captureNags(PlanningEnvironment env, Element inputNode) {
        this.nags = new ArrayList<Nag>();
        List childList = inputNode.elements();
        for (Element c : childList) {
            if (!c.getName().equals(ELEMENT_NAG)) continue;
            String sType = c.attributeValue(ATTRIBUTE_TYPE);
            String sMsg = c.getText();
            Nag.NagType nagType = Nag.NagType.valueOf(sType);
            this.nags.add(new Nag(nagType, sMsg));
        }
    }

    public void capturePlanningResponseMessages(PlanningEnvironment env, Element inputNode) {
        this.planningResponseMessages = new ArrayList<ResponseMessage>();
        List childList = inputNode.elements();
        for (Element c : childList) {
            List parmList;
            if (!c.getName().equals(ELEMENT_MESSAGE)) continue;
            boolean usesOldFormat = false;
            if (c.attribute(ATTRIBUTE_USES_OLD_FORMAT) != null) {
                usesOldFormat = VALUE_TRUE.equals(c.attributeValue(ATTRIBUTE_USES_OLD_FORMAT));
            }
            String sSeverity = c.attributeValue(ATTRIBUTE_SEVERITY);
            String sType = c.attributeValue(ATTRIBUTE_TYPE);
            String sMsgKey = c.attributeValue(ATTRIBUTE_MSGKEY);
            int severity = Integer.parseInt(sSeverity);
            String[] parms = new String[]{};
            Element parametersElement = c.element(ELEMENT_PARAMETERS);
            if (parametersElement != null && (parmList = parametersElement.elements(ELEMENT_PARAMETER)) != null && parmList.size() > 0) {
                parms = new String[parmList.size()];
                for (int i = 0; i < parmList.size(); ++i) {
                    parms[i] = ((Element)parmList.get(i)).attributeValue(ATTRIBUTE_VALUE);
                }
            }
            Element locationElement = c.element(ELEMENT_LOCATION);
            String location = null;
            if (locationElement != null) {
                location = locationElement.attributeValue(ATTRIBUTE_VALUE);
            }
            ResponseMessage.ResponseMessageType rType = ResponseMessage.ResponseMessageType.UNKNOWN;
            if (sType.equals("planningStats")) {
                rType = ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT;
            } else if (sType.equals("cognosSQL")) {
                rType = ResponseMessage.ResponseMessageType.RQP_NODE_TYPE_INT;
            }
            if (!usesOldFormat) {
                IMessageKey messageKey = this.getMessageKey(sMsgKey);
                List<IXQEQueryNode> contextNull = null;
                XQEMessage xm = null;
                switch (parms.length) {
                    case 0: {
                        xm = new XQEMessage((IMessageKey.Param0)messageKey, contextNull);
                        break;
                    }
                    case 1: {
                        xm = new XQEMessage((IMessageKey.Param1)messageKey, parms[0], contextNull);
                        break;
                    }
                    case 2: {
                        xm = new XQEMessage((IMessageKey.Param3)messageKey, parms[0], parms[1], parms[2], contextNull);
                        break;
                    }
                    case 4: {
                        xm = new XQEMessage((IMessageKey.Param4)messageKey, parms[0], parms[1], parms[2], parms[3], contextNull);
                        break;
                    }
                    case 5: {
                        xm = new XQEMessage((IMessageKey.Param5)messageKey, parms[0], parms[1], parms[2], parms[3], parms[4], contextNull);
                        break;
                    }
                    default: {
                        xm = null;
                    }
                }
                if (xm == null) continue;
                ResponseMessage r = new ResponseMessage(severity, rType, xm);
                r.setLocation(location);
                this.planningResponseMessages.add(r);
                continue;
            }
            ResponseMessage r = null;
            IMessageKey messageKey = this.getMessageKey(sMsgKey);
            switch (parms.length) {
                case 0: {
                    r = new ResponseMessage(severity, rType, (IMessageKey.Param0)messageKey);
                    break;
                }
                case 1: {
                    r = new ResponseMessage(severity, rType, (IMessageKey.Param1)messageKey, parms[0]);
                    break;
                }
                case 2: {
                    r = new ResponseMessage(severity, rType, (IMessageKey.Param2)messageKey, parms[0], parms[1]);
                    break;
                }
                case 4: {
                    r = new ResponseMessage(severity, rType, (IMessageKey.Param4)messageKey, parms[0], parms[1], parms[2], parms[3]);
                    break;
                }
                case 5: {
                    r = new ResponseMessage(severity, rType, (IMessageKey.Param5)messageKey, parms[0], parms[1], parms[2], parms[3], parms[4]);
                    break;
                }
                default: {
                    r = null;
                }
            }
            if (r == null) continue;
            r.setLocation(location);
            this.planningResponseMessages.add(r);
        }
    }

    public void dumpMacros(XQETrace trace) {
        if (this.resolvedMacros == null) {
            return;
        }
        trace.beginElement(ELEMENT_MACROS);
        for (Map.Entry<String, String> entry : this.resolvedMacros.entrySet()) {
            trace.beginElement(ELEMENT_MACRO_TEXT);
            trace.cdata(entry.getKey());
            trace.endElement();
            trace.beginElement(ELEMENT_MACRO_RESULT);
            trace.cdata(entry.getValue());
            trace.endElement();
        }
        trace.endElement();
    }

    public void dumpNags(XQETrace trace) {
        if (this.nags == null) {
            return;
        }
        trace.beginElement(ELEMENT_NAGS);
        for (Nag n : this.nags) {
            trace.beginElement(ELEMENT_NAG);
            trace.attribute(ATTRIBUTE_TYPE, n.getType().toString());
            trace.cdata(n.getMessage());
            trace.endElement();
        }
        trace.endElement();
    }

    public void dumpPlan(XQETrace trace) {
        trace.beginElement(STR_PERSISTENTPLAN);
        if (this.getReportName() != null) {
            trace.writeAttribute("reportName", this.getReportName());
        }
        if (this.getPlanDurationMilli() != 0L) {
            trace.writeAttribute("planDurationMilli", String.valueOf(this.getPlanDurationMilli()));
        }
        this.dumpPlanningResponseMessages(trace);
        this.dumpNags(trace);
        StringBuilder pbuf = new StringBuilder();
        this.parameters.createParametersString(pbuf);
        trace.xml(pbuf.toString());
        trace.xml("\n");
        trace.beginElement(ELEMENT_PLAN_KEY);
        trace.cdata(this.planKey);
        trace.endElement();
        this.getPlannedV5QuerySet().dump(trace);
        trace.endElement();
    }

    public void dumpPlanningResponseMessages(XQETrace trace) {
        if (this.planningResponseMessages == null) {
            return;
        }
        trace.beginElement(ELEMENT_MESSAGE_FOLDER);
        for (ResponseMessage m : this.planningResponseMessages) {
            String loc;
            trace.beginElement(ELEMENT_MESSAGE);
            if (m.usesOldFormat().booleanValue()) {
                trace.attribute(ATTRIBUTE_USES_OLD_FORMAT, VALUE_TRUE);
            }
            trace.attribute(ATTRIBUTE_SEVERITY, m.getSeverity());
            trace.attribute(ATTRIBUTE_TYPE, ResponseMessage.typeToString(m.getType()));
            trace.attribute(ATTRIBUTE_MSGKEY, m.getMessageKey().getName());
            String[] parms = m.getParameters();
            if (parms.length > 0) {
                trace.beginElement(ELEMENT_PARAMETERS);
                for (int i = 0; i < parms.length; ++i) {
                    trace.beginElement(ELEMENT_PARAMETER);
                    trace.attribute(ATTRIBUTE_VALUE, (Object)parms[i]);
                    trace.endElement();
                }
                trace.endElement();
            }
            if ((loc = m.getLocation()) != null) {
                trace.beginElement(ELEMENT_LOCATION);
                trace.attribute(ATTRIBUTE_VALUE, loc);
                trace.endElement();
            }
            trace.endElement();
        }
        trace.endElement();
    }

    public Governors getGovernorsObj() {
        return this.governors;
    }

    IMessageKey getMessageKey(String msgCode) {
        Field[] fields;
        XQEMessageKeys mclass = new XQEMessageKeys();
        Class<?> objClass = mclass.getClass();
        for (Field field : fields = objClass.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || field.getType().isPrimitive()) continue;
            field.setAccessible(true);
            String fname = field.getName();
            if (!fname.equals(msgCode)) continue;
            try {
                Object obj = field.get(mclass);
                return (IMessageKey)obj;
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
        }
        return null;
    }

    public MetadataConnection getMetadataConnection() {
        return null;
    }

    public List<Nag> getNags() {
        return this.nags;
    }

    public long getPlanDurationMilli() {
        return this.planDurationMilli;
    }

    public String getPlanKey() {
        return this.planKey;
    }

    public PlannedV5QuerySet getPlannedV5QuerySet() {
        return this.plannedV5QuerySet;
    }

    public Object getPropertyValue(String key) {
        if (key.equals("governors")) {
            return this.governors;
        }
        throw new UnsupportedOperationException();
    }

    public String getReportName() {
        return this.reportName;
    }

    public Parameters getRequestParameters() {
        return this.parameters;
    }

    public TreeMap<String, String> getResolvedMacros() {
        return this.resolvedMacros;
    }

    public List<ResponseMessage> getResponseMessages() {
        return this.planningResponseMessages;
    }

    public void setGovernorsObj(Governors iGovernors) {
        this.governors = iGovernors;
    }

    public void setNags(List<Nag> theNags) {
        this.nags = theNags;
    }

    public void setPlanDurationMilli(long thePlanDurationMilli) {
        this.planDurationMilli = thePlanDurationMilli;
    }

    public void setPlanKey(String thePlanKey) {
        this.planKey = thePlanKey;
    }

    public void setPlannedV5QuerySet(PlannedV5QuerySet thePlannedV5QuerySet) {
        this.plannedV5QuerySet = thePlannedV5QuerySet;
    }

    public void setPlanningResponseMessages(List<ResponseMessage> planningRMs) {
        this.planningResponseMessages = planningRMs;
    }

    public void setReportName(String theReportName) {
        this.reportName = theReportName;
    }

    public void setRequestParameters(Parameters aParameters) {
        this.parameters = new Parameters();
        for (Parameter parameter : aParameters.values()) {
            if (parameter.getDataType() == null) continue;
            this.parameters.addParameter(parameter.getName(), parameter);
        }
    }

    public void setResolvedMacros(TreeMap<String, String> map) {
        this.resolvedMacros = map;
    }
}

