/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.engine;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEIDGenerator;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.parser.ParseException;
import com.cognos.xqe.ast.sql.parser.SQLProcessor;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5QuerySubject;
import com.cognos.xqe.ast.v5.update.V5UpdateSet;
import com.cognos.xqe.bibushandler.CancelableRequestRegistry;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.XQEService;
import com.cognos.xqe.bibushandler.content.ContentManager;
import com.cognos.xqe.bibushandler.recorder.V5RequestRecorder;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.DataSourceException;
import com.cognos.xqe.data.providers.connection.ConnectionPoolHelper;
import com.cognos.xqe.exception.XQEAbortGetParametersQueryException;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.query.engine.CacheManager;
import com.cognos.xqe.query.engine.EnvironmentFactory;
import com.cognos.xqe.query.engine.ExcessiveCollectionHandler;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.MalformedExecuteRequestException;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.Nag;
import com.cognos.xqe.query.engine.NagSubquery;
import com.cognos.xqe.query.engine.PersistentPlanDiskCacheStatistics;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.QueryContext;
import com.cognos.xqe.query.engine.QueryEngineLoggingUtils;
import com.cognos.xqe.query.engine.SessionContext;
import com.cognos.xqe.query.engine.TransformationLibraryManager;
import com.cognos.xqe.query.engine.UnresolvedParameterException;
import com.cognos.xqe.query.executor.QueryExecutor;
import com.cognos.xqe.query.masterdetail.MasterDetailProvider;
import com.cognos.xqe.query.missingMember.MissingMemberException;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIPartialDataset;
import com.cognos.xqe.rsapi.RSAPIResultSet;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.olap.XMissingMemberValidate;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.HighPrecisionStopWatch;
import com.cognos.xqe.trace.CollectXQELogs;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.OperationEnum;
import com.cognos.xqe.trace.TraceContext;
import com.cognos.xqe.trace.TraceLogManager;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.MapCast;
import com.cognos.xqe.util.SingletonHelper;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.monitor.ResourceMonitor;
import com.cognos.xqe.util.usage.UsageTrackingService;
import com.cognos.xqe.util.usage.indicators.IUsageIndicator;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorCategory;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorType;
import com.cognos.xqe.util.xml.XMLUtils;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqemoser.MoserParameterUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.UUID;
import org.apache.commons.collections.map.Flat3Map;
import org.dom4j.Document;
import org.dom4j.Element;

public final class QueryEngine {
    public static final String MFW4J = "MFW4J";
    public static final String NATIVEODP = "NATIVEODP";
    public static final String SERVICE_NAME = "XQE";
    private static final String MILLI_SECONDS = "ms";
    public static final boolean REGISTER_RSAPIDATASET_INSTANCES = true;
    private static final String ERRMSG_QUERY_CTX_NOT_REG = "No query context was registered for ";
    private static final String ERRMSG_SESS_CTX_NOT_REG = "No session context was registered for ";
    private static final String PROVIDERQUERY = "providerQuery";
    private static final String NULL_EXECUTION_ENVIRONMENT = "null == executionEnvironment";
    private static final String NULL_SESSION_CONTEXT_ID = "null == sessionContextID";
    private static final String ID_ATTRIBUTE = "id";
    private static final String SQLQUERY = "sqlQuery";
    private static final XQELogger ERROR_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    private static final XQELogger PERF_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Timing", LogLevel.INFO);
    private static final XQELogger ENGINE_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "QueryEngine", LogLevel.INFO);
    private static SingletonHelper<QueryEngine> singletonHelper = new SingletonHelper<QueryEngine>(){

        @Override
        protected QueryEngine newInstance() {
            return new QueryEngine();
        }

        @Override
        protected void releaseImpl(QueryEngine theInstance) {
            theInstance.release();
        }

        @Override
        protected void initializeImpl(QueryEngine theInstance) {
            theInstance.initialize();
        }
    };
    private static IUsageIndicator reportCounter;
    private final Timer timer;
    private final ConnectionPoolHelper connectionPoolHelper;
    private final ExcessiveCollectionHandler excessiveCollectionHandler;
    private final V5RequestRecorder requestRecorder;
    private CacheManager cacheManager = null;
    private final EnvironmentFactory baseEnvironmentFactory = new EnvironmentFactory();
    private long lastClearCacheTime = 0L;

    private QueryEngine() {
        this.timer = new Timer("XQE-QueryEngine-Timer", true);
        XQEConfigurationManager.getInstance().setTimer(this.timer);
        this.connectionPoolHelper = new ConnectionPoolHelper(this.timer);
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        if (config.inStandaloneMode()) {
            this.excessiveCollectionHandler = new ExcessiveCollectionHandler(this.timer);
            this.requestRecorder = new V5RequestRecorder();
        } else {
            this.excessiveCollectionHandler = null;
            this.requestRecorder = null;
        }
        reportCounter = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.REPORT, "numberOfReports");
    }

    public static QueryEngine getInstance() {
        return singletonHelper.getInstance(false);
    }

    public static QueryEngine getInstanceNoInit() {
        return singletonHelper.getInstance(true);
    }

    public static void releaseInstance() {
        singletonHelper.releaseInstance();
    }

    protected void initialize() {
        if (!XQEService.isInitialized()) {
            throw new XQERuntimeException(XQEMessageKeys.INI_XQEServiceWasNotInitialized);
        }
        long ticks = System.currentTimeMillis();
        XQELog.logConsole("Initializing XQE...");
        TransformationLibraryManager.getInstance();
        this.cacheManager = new CacheManager();
        this.cacheManager.initialize(this.timer);
        if (this.requestRecorder != null) {
            this.requestRecorder.initialize();
            if (null != System.getenv("RECORD_V5_SESSION")) {
                this.requestRecorder.startSession();
            }
        }
        ticks = System.currentTimeMillis() - ticks;
        XQELog.logConsole("Initialized XQE in " + ticks + MILLI_SECONDS);
    }

    protected void release() {
        if (null != this.timer) {
            this.timer.cancel();
        }
        if (null != this.excessiveCollectionHandler) {
            this.excessiveCollectionHandler.stop();
        }
        if (null != this.connectionPoolHelper) {
            this.connectionPoolHelper.release();
        }
        if (null != this.cacheManager) {
            this.writeState();
            this.cacheManager.terminate();
        }
        if (this.requestRecorder != null) {
            try {
                if (this.requestRecorder.isSessionStarted()) {
                    this.requestRecorder.endSession();
                }
            }
            finally {
                this.requestRecorder.terminate();
            }
        }
    }

    public V5RequestRecorder getRequestRecorder() {
        return this.requestRecorder;
    }

    public ConnectionPoolHelper getConnectionPoolHelper() {
        return this.connectionPoolHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IXQEQueryNode[] executeRequest(Document requestDocument, RequestEnvironment reqEnv) throws MalformedExecuteRequestException {
        Element v5RootElement;
        Element querySetElement;
        if (ENGINE_LOGGER.isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Executing request document: ").append(requestDocument.asXML());
            ENGINE_LOGGER.log(LogLevel.INFO, buffer.toString());
        }
        if ((querySetElement = (v5RootElement = requestDocument.getRootElement()).element("querySet")) == null) {
            throw new MalformedExecuteRequestException(XQEMessageKeys.EXE_InvalidExecuteRequest);
        }
        Element queriesElement = querySetElement.element("queries");
        if (queriesElement == null) {
            throw new MalformedExecuteRequestException(XQEMessageKeys.EXE_InvalidExecuteRequest);
        }
        ArrayList<IXQEQueryNode> datasetList = null;
        IXQEQueryNode[] queryNodes = null;
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
        ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(executionEnvironment);
        try {
            MultiRequestContext multiRequestContext = executionEnvironment.getMultiRequestContext();
            multiRequestContext.incrementRefCount();
            try {
                List<Element> providerQueries = this.getRequestedDatasets(v5RootElement, queriesElement);
                if (providerQueries.size() <= 1) {
                    Element providerQueryElement = null;
                    if (1 == providerQueries.size()) {
                        providerQueryElement = providerQueries.get(0);
                    }
                    IXQEQueryNode[] iXQEQueryNodeArray = this.fetchRSAPIDatasets(requestDocument, reqEnv, queriesElement, providerQueryElement);
                    return iXQEQueryNodeArray;
                }
                datasetList = new ArrayList<IXQEQueryNode>();
                for (Element providerQueryElement : providerQueries) {
                    IXQEQueryNode[] datasets = this.fetchRSAPIDatasets(requestDocument, reqEnv, queriesElement, providerQueryElement);
                    for (int i = 0; i < datasets.length; ++i) {
                        datasetList.add(datasets[i]);
                    }
                }
                queryNodes = new IXQEQueryNode[datasetList.size()];
            }
            finally {
                multiRequestContext.decrementRefCount();
            }
        }
        finally {
            executionEnvironmentContext.exit();
        }
        return datasetList.toArray(queryNodes);
    }

    public IXQEQueryNode prepareRequest(Document requestDocument, RequestEnvironment reqEnv) {
        return this.prepareRequest(requestDocument, reqEnv, false);
    }

    public PlannedV5QuerySet prepareRequest(Document requestDocument, RequestEnvironment reqEnv, boolean registerRSAPIDataset) {
        reportCounter.increment();
        PlannedV5QuerySet planTree = this.prepareV5Request(reqEnv, requestDocument, registerRSAPIDataset);
        if (planTree != null && planTree.isExecutingSqlQuery()) {
            Set<String> sqlQueryFM = planTree.getSqlQueryFMPackages();
            if (sqlQueryFM == null) {
                this.throwIfUserDefinedSQLDeny(ContentManager.getUserCapabilities(reqEnv));
            } else if (!sqlQueryFM.isEmpty()) {
                for (String path : sqlQueryFM) {
                    this.throwIfUserDefinedSQLDeny(ContentManager.getPackageUserCapabilities(reqEnv, path));
                }
            }
        }
        return planTree;
    }

    protected void throwIfUserDefinedSQLDeny(Set<String> capabilities) {
        if (!capabilities.contains("canUseUserDefinedSQL")) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_UserDefinedSQLDeniedCapability);
        }
    }

    public IXQEQueryNode prepareV5Request(IRequestEnvironment reqEnv, Document requestDocument) {
        return this.prepareV5Request(reqEnv, requestDocument, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public PlannedV5QuerySet prepareV5Request(IRequestEnvironment reqEnv, Document requestDocument, boolean registerRSAPIDataset) {
        if (QueryEngine.ENGINE_LOGGER.isOn(LogLevel.INFO)) {
            buffer = new StringBuilder();
            buffer.append("Preparing request document: ").append(requestDocument.asXML());
            QueryEngine.ENGINE_LOGGER.log(LogLevel.INFO, buffer.toString());
        }
        if (QueryEngine.PERF_LOGGER.isOn()) {
            QueryEngine.PERF_LOGGER.log(OperationEnum.START, "Start of preparing data query.");
        }
        planTree = null;
        rootElement = requestDocument.getRootElement();
        planKey = this.getV5CommandPlanKey(rootElement);
        reqEnv.setMaxSeverityLevelForFeedback(rootElement);
        hasUnresolvedParameters = false;
        executionEnvironment = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
        multiRequestContext = executionEnvironment.getMultiRequestContext();
        executionEnvironmentContext = ExecutionEnvironmentContext.enter(executionEnvironment);
        multiRequestContext.incrementRefCount();
        try {
            planEnv = null;
            try {
                parameters = reqEnv.getRequestParameters();
                planEnv = QueryPlanner.setupEnvironment(reqEnv);
                parametersElement = rootElement.element("parameters");
                if (reqEnv.isGetParametersRequest()) {
                    multiRequestContext.clearRequestParameters();
                    parameters = reqEnv.getRequestParameters();
                    if (parametersElement != null) {
                        parameters.prepare(parametersElement, planEnv);
                    }
                    planTree = QueryPlanner.getInstance().planQueryAllowPlanReuse(requestDocument, planEnv, planKey);
                    QueryPlanner.setCachingPropertiesOnPlanTree(planTree, planKey, reqEnv);
                } else {
                    multiRequestContext.setGlobalParametersInfoLoaded(false);
                    QueryEngine.clearModuleParameters(parameters);
                    if (parametersElement != null) {
                        parameterNames = Parameters.getParameterNames(parametersElement);
                        isMasterDetailContext = parameters.hasMasterDetailParameter();
                        config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
                        configRetainParamDataTypeFromPrevReq = config.getBooleanProperty("general.retainParamDataTypeFromPrevReq[@enabled]", false);
                        it = parameters.entrySet().iterator();
                        while (it.hasNext()) {
                            pair = it.next();
                            param = (Parameter)pair.getValue();
                            if (param.isMasterDetailLinkParameter()) continue;
                            param.removeParameterValues();
                            if (!configRetainParamDataTypeFromPrevReq) {
                                if (isMasterDetailContext && parameterNames.contains(param.getParameterName())) continue;
                                it.remove();
                                continue;
                            }
                            if (parameterNames.contains(param.getParameterName())) continue;
                            it.remove();
                        }
                        parameters.clearParametersRequiredValuesBeforePlanning();
                        parameters.prepare(parametersElement, planEnv);
                    }
                    planTree = QueryPlanner.getInstance().planQueryAllowPlanReuse(requestDocument, planEnv, planKey);
                }
                v0 = hasUnresolvedParameters = QueryEngine.getParameters(reqEnv).size() > 0;
                if (registerRSAPIDataset && (!hasUnresolvedParameters || planTree.isNoDataMode())) {
                    this.storePlannedDatasetsAndMultiRequestContext(executionEnvironment, planTree, multiRequestContext);
                }
                executionEnvironment.setGovernors(planTree.getGovernorsObj());
                ** GOTO lbl75
            }
            catch (DataSourceException dsException) {
                throw dsException;
            }
            catch (XQEAbortGetParametersQueryException e) {
                var13_17 = null;
                multiRequestContext.decrementRefCount();
                executionEnvironmentContext.exit();
                return var13_17;
            }
            catch (XQERuntimeException e) {
                v1 = hasUnresolvedParameters = QueryEngine.getParameters(reqEnv).size() > 0;
                if (!hasUnresolvedParameters) {
                    throw e;
                }
lbl75:
                // 3 sources

                if (hasUnresolvedParameters && (planTree == null || !planTree.isNoDataMode())) {
                    if (!(planTree != null && planTree.getReadFromPersistentStore() || (unresolvedParameters = QueryEngine.getParameters(reqEnv).getUnresolvedParameters()).hasParameterWithBadValue())) {
                        this.cacheManager.storePlanForUnresolvedParameters(planKey, reqEnv, planEnv);
                    }
                    throw new UnresolvedParameterException(reqEnv, planTree, QueryEngine.getParameters(reqEnv));
                }
            }
        }
        finally {
            multiRequestContext.decrementRefCount();
            executionEnvironmentContext.exit();
        }
        if (QueryEngine.PERF_LOGGER.isOn()) {
            QueryEngine.PERF_LOGGER.log(OperationEnum.END, "End of preparing data query.");
        }
        return planTree;
    }

    protected static void clearModuleParameters(Parameters parameters) {
        Iterator it = parameters.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry pair = it.next();
            Parameter param = (Parameter)pair.getValue();
            if (param.getLocation() != Parameter.LOCATION.MODULE) continue;
            param.removeParameterValues();
            it.remove();
        }
    }

    public XNode prepareSQLRequest(IRequestEnvironment reqEnv, String modelPath, String defaultDS, String query) {
        return this.prepareSQLRequest(reqEnv, modelPath, defaultDS, query, false);
    }

    public XNode prepareSQLRequest(IRequestEnvironment reqEnv, String modelPath, String defaultDS, String query, boolean isPassThru) {
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
        MultiRequestContext multiRequestContext = executionEnvironment.getMultiRequestContext();
        ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(executionEnvironment);
        multiRequestContext.incrementRefCount();
        XNode xTree = null;
        try {
            PlanningEnvironment planEnv = QueryPlanner.setupEnvironment(reqEnv);
            MetadataConnection metadataConnection = MetadataService.getInstance().getConnection(MetadataService.getProviderTypeFromModelPath(null, modelPath), modelPath, executionEnvironment, true);
            planEnv.setMetdataConnection(metadataConnection);
            XQENodeFactory nodeFactory = planEnv.getNodeFactory();
            SQLProcessor parser = new SQLProcessor(nodeFactory);
            IXQEQueryNode root = parser.parseQuery(query, isPassThru);
            V5QuerySet querySet = (V5QuerySet)nodeFactory.createNode(101002);
            root.insertParent(querySet);
            querySet.setGovernors(new Governors());
            if (defaultDS != null) {
                Map<String, Object> metadataProps = MapCast.uncheckedCast(new Flat3Map());
                metadataProps.put("cmDataSource", defaultDS);
                metadataProps.put("name", defaultDS);
                metadataProps.put("queryType", "relational");
                executionEnvironment.getOrAddDataSource(defaultDS, defaultDS, null, metadataProps);
            }
            QueryPlanner.getInstance().plan(querySet, planEnv);
            xTree = (XNode)querySet.getChild(0);
        }
        catch (ParseException e) {
            throw new XQERuntimeException(e);
        }
        finally {
            multiRequestContext.decrementRefCount();
            executionEnvironmentContext.exit();
        }
        return xTree;
    }

    public static Parameters getParameters(IRequestEnvironment reqEnv) {
        Parameters parameters = reqEnv.getRequestParameters();
        parameters = reqEnv.isGetParametersRequest() ? parameters.getNonMasterDetailParameters() : parameters.getUnresolvedParameters();
        return parameters;
    }

    public IXQEQueryNode migrateRequest(Document requestDocument, Document responseDocument, RequestEnvironment reqEnv) {
        return this.validateRequest(requestDocument, responseDocument, reqEnv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IXQEQueryNode validateRequest(Document requestDocument, Document responseDocument, RequestEnvironment reqEnv) {
        XNode planTree;
        block16: {
            if (ENGINE_LOGGER.isOn(LogLevel.INFO)) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("Validating request document: ").append(requestDocument.asXML());
                ENGINE_LOGGER.log(LogLevel.INFO, buffer.toString());
            }
            planTree = null;
            ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
            MultiRequestContext multiRequestContext = executionEnvironment.getMultiRequestContext();
            ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(executionEnvironment);
            multiRequestContext.incrementRefCount();
            try {
                reqEnv.setMaxSeverityLevelForFeedback(requestDocument.getRootElement());
                reqEnv.setResolveIsNullable(requestDocument.getRootElement());
                Element updateSetElement = requestDocument.getRootElement().element("updateSet");
                if (updateSetElement != null) {
                    V5UpdateSet v5UpdateSet = this.prepareUpdateQueryRequest(requestDocument, reqEnv);
                    return v5UpdateSet;
                }
                Element querySetElement = requestDocument.getRootElement().element("querySet");
                if (querySetElement == null) {
                    throw new MalformedExecuteRequestException(XQEMessageKeys.EXE_InvalidExecuteRequest);
                }
                Element queriesElement = querySetElement.element("queries");
                if (queriesElement == null) {
                    throw new MalformedExecuteRequestException(XQEMessageKeys.EXE_InvalidExecuteRequest);
                }
                Element providerQueryElement = queriesElement.element(PROVIDERQUERY);
                if (providerQueryElement != null) {
                    IXQEQueryNode iXQEQueryNode = this.validateProviderQueryRequest(providerQueryElement);
                    return iXQEQueryNode;
                }
                Element queryElement = queriesElement.element("query");
                Element modQueryElement = null;
                if (queryElement == null) {
                    modQueryElement = queriesElement.element("modQuery");
                }
                if (queryElement != null || modQueryElement != null) {
                    planTree = this.prepareRequest(requestDocument, reqEnv, true);
                    if (planTree != null && QueryEngine.isForMissingMembers(requestDocument)) {
                        this.validateMissingMembers(planTree, executionEnvironment);
                    }
                    break block16;
                }
                throw new MalformedExecuteRequestException(XQEMessageKeys.EXE_InvalidExecuteRequest);
            }
            catch (MissingMemberException mme) {
                QueryEngine.handleMissingMemberException(requestDocument, mme, responseDocument);
            }
            finally {
                if (planTree != null) {
                    planTree.clearPlanningEnvironment();
                }
                multiRequestContext.decrementRefCount();
                executionEnvironmentContext.exit();
            }
        }
        return planTree;
    }

    public static void addMissingMembersToResponse(MissingMemberException mme, Document responseDocument) {
        Element responseElement = mme.getMissingMembersResponse();
        Element mMsElement = responseElement.element("missingMembers");
        if (mMsElement != null) {
            responseDocument.getRootElement().add((Element)mMsElement.clone());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IXQEQueryNode transformRequest(Document requestDocument, RequestEnvironment reqEnv) {
        PlannedV5QuerySet planTree = null;
        this.configureRequestEnvironment(reqEnv);
        ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(reqEnv.getExecutionEnvironment());
        try {
            PlanningEnvironment planEnv = QueryPlanner.setupEnvironment(reqEnv);
            planTree = QueryPlanner.getInstance().planQuery(requestDocument, planEnv);
        }
        finally {
            executionEnvironmentContext.exit();
        }
        return planTree;
    }

    public RSAPIPartialDataset getPartialDataset(Document requestDocument, ExecutionEnvironment environment, boolean reExecute) throws XQEException {
        Element masterDatasetElement;
        if (ENGINE_LOGGER.isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Get partial dataset for request document: ").append(requestDocument.asXML());
            ENGINE_LOGGER.log(LogLevel.INFO, buffer.toString());
        }
        if ((masterDatasetElement = requestDocument.getRootElement().element("masterDataset")) == null) {
            throw new XQEException();
        }
        String datasetId = masterDatasetElement.attributeValue("masterDatasetId");
        if (datasetId == null) {
            throw new XQEException();
        }
        RSAPIDataset masterDataset = this.cacheManager.getDatasetByID(datasetId);
        if (masterDataset == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Missing RSAPIDataset " + datasetId);
        }
        RSAPIPartialDataset partialDataset = this.getPartialDataset(masterDatasetElement, masterDataset, environment, reExecute);
        return partialDataset;
    }

    public RSAPIPartialDataset getPartialDataset(Element masterDatasetElement, RSAPIDataset masterDataset, ExecutionEnvironment environment, boolean reExecute) throws XQEException {
        RSAPIPartialDataset partialDataset = null;
        XQETrace trace = new XQETrace();
        QueryEngineLoggingUtils.addExecutionTraceLevels(trace, environment.getRequestEnvironment());
        trace.setNodeIDGenerator(new XQEIDGenerator());
        environment.setTrace(trace);
        this.loadQueryExecutionConfigurationSettings(environment);
        this.configureExecutionEnvironment(environment);
        ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(environment);
        try {
            partialDataset = QueryExecutor.getInstance().execute(masterDatasetElement, masterDataset, environment, reExecute);
        }
        catch (MissingMemberException mme) {
            throw mme;
        }
        finally {
            executionEnvironmentContext.exit();
        }
        return partialDataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RSAPIResultSet executeRSAPIDataset(RSAPIDataset rsapiDataset, ExecutionEnvironment environment) {
        RSAPIResultSet rsapiResultSet;
        PlannedV5QuerySet plannedQuerySet;
        if (PERF_LOGGER.isOn()) {
            PERF_LOGGER.log(OperationEnum.START, "Start of executing data query.");
        }
        this.loadQueryExecutionConfigurationSettings(environment);
        this.configureExecutionEnvironment(environment);
        if (environment.getGovernors() == null && (plannedQuerySet = (PlannedV5QuerySet)rsapiDataset.getAncestorOfType(501133)) != null) {
            environment.setGovernors(plannedQuerySet.getGovernorsObj());
        }
        ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(environment);
        try {
            rsapiDataset.getPlanningEnvironment().setPlanningActive(environment.getRequestEnvironment());
            ROLAPContext.queryEnter(environment);
            try {
                rsapiResultSet = rsapiDataset.execute(environment, false);
            }
            finally {
                ROLAPContext.queryExit(environment);
            }
            rsapiDataset.clearPlanningEnvironment();
        }
        finally {
            executionEnvironmentContext.exit();
        }
        if (PERF_LOGGER.isOn()) {
            PERF_LOGGER.log(OperationEnum.END, "End of executing data query.");
        }
        return rsapiResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RSAPIPartialDataset getPartialDataset(RSAPIDataset masterDataset, int[] startRowNumber, int[] numRows, boolean includeContext, boolean includeContextValues, IExecutionEnvironment environment) {
        XQETrace trace = new XQETrace();
        trace.setNodeIDGenerator(new XQEIDGenerator());
        QueryEngineLoggingUtils.addExecutionTraceLevels(trace, environment.getRequestEnvironment());
        environment.setTrace(trace);
        this.loadQueryExecutionConfigurationSettings(environment);
        this.configureExecutionEnvironment(environment);
        ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(environment);
        RSAPIPartialDataset dataset = null;
        try {
            dataset = QueryExecutor.getInstance().getPartialDataset(masterDataset, startRowNumber, numRows, includeContext, includeContextValues, environment);
        }
        finally {
            executionEnvironmentContext.exit();
        }
        return dataset;
    }

    public RSAPIPartialDataset releasePartialDataset(String partialDatasetId) {
        RSAPIPartialDataset dataset = null;
        if (ENGINE_LOGGER.isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Releasing partial dataset for request document: ").append(partialDatasetId);
            ENGINE_LOGGER.log(LogLevel.INFO, buffer.toString());
        }
        if (partialDatasetId != null && (dataset = this.cacheManager.removePartialDatasetByID(partialDatasetId)) != null) {
            if (this.getRequestRecorder() != null) {
                this.getRequestRecorder().addPartialDatasetReleased(dataset);
            }
            dataset.release();
        }
        return dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMasterDatasetAndMultiRequestContext(String masterDatasetId, RequestEnvironment reqEnv) {
        if (ENGINE_LOGGER.isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Removing master dataset and MRC ").append(masterDatasetId);
            ENGINE_LOGGER.log(LogLevel.INFO, buffer.toString());
        }
        this.cacheManager.removeDatasetByID(masterDatasetId, reqEnv);
        String sessionContextID = reqEnv.getSessionContextID();
        if (null == sessionContextID) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, NULL_SESSION_CONTEXT_ID);
        }
        MultiRequestContext multiRequestContext = this.cacheManager.removeMultiRequestContext(sessionContextID);
        if (null != multiRequestContext) {
            ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(reqEnv.getExecutionEnvironment());
            try {
                multiRequestContext.decrementRefCount();
            }
            finally {
                executionEnvironmentContext.exit();
            }
        }
        TraceLogManager.getInstance().packageTraceOutput(reqEnv);
    }

    public void setCachedMultiRequestContext(RequestEnvironment reqEnv) {
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
        if (null == executionEnvironment) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, NULL_EXECUTION_ENVIRONMENT);
        }
        String sessionContextID = reqEnv.getSessionContextID();
        if (null == sessionContextID) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, NULL_SESSION_CONTEXT_ID);
        }
        MultiRequestContext multiRequestContext = this.cacheManager.getMultiRequestContext(sessionContextID);
        if (null == multiRequestContext) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "MultiRequestContext " + sessionContextID + " not found");
        }
        this.connectionPoolHelper.setMultiRequestConnectionPool(executionEnvironment, multiRequestContext);
    }

    public RSAPIDataset releaseMasterDataset(ExecutionEnvironment execEnv, String masterDatasetId) {
        RSAPIDataset dataset = null;
        if (masterDatasetId != null && (dataset = this.cacheManager.getDatasetByID(masterDatasetId)) != null) {
            ZipiBridge.setZipiContextAndObjPath(dataset.getName());
            if (this.getRequestRecorder() != null) {
                this.getRequestRecorder().addDatasetReleased(dataset);
            }
            dataset.releaseResultset(execEnv);
        }
        return dataset;
    }

    public String getV5CommandPlanKey(Element rootElement) {
        Element key = rootElement.element("V5CommandPlanKey");
        if (key != null) {
            key.detach();
            String keyString = key.attributeValue("value");
            if (keyString != null) {
                return keyString;
            }
        }
        StringWriter writer = new StringWriter();
        try {
            if (rootElement.element("querySet") != null) {
                rootElement.element("querySet").write((Writer)writer);
            } else {
                rootElement.element("V5QuerySet").write((Writer)writer);
            }
            XMLUtils.write(rootElement.elements("property"), writer);
            XMLUtils.write(rootElement.elements("retrieveDataset"), writer);
            XMLUtils.write(rootElement.elements("queryFeedback"), writer);
            writer.flush();
        }
        catch (IOException ex) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)ex);
        }
        return writer.toString();
    }

    public void configureRequestEnvironment(RequestEnvironment requestEnvironment) {
        TraceContext traceContext;
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)requestEnvironment.getExecutionEnvironment();
        if (null == executionEnvironment) {
            ExecutionEnvironment newExecutionEnvironment = this.createExecutionEnvironment();
            newExecutionEnvironment.setRequestEnvironment(requestEnvironment);
            requestEnvironment.setExecutionEnvironment(newExecutionEnvironment);
        } else {
            this.configureExecutionEnvironment(executionEnvironment);
        }
        if (requestEnvironment.getEnvFactory() == null) {
            requestEnvironment.setEnvFactory(this.baseEnvironmentFactory);
        }
        if (null != (traceContext = TraceContext.get())) {
            traceContext.addAttribute("requestId", requestEnvironment.getRequestID());
        }
    }

    public MultiRequestContext configureMultiRequestContext(RequestEnvironment requestEnvironment, Document requestDocument) {
        CancelableRequestRegistry cancelableRequestRegistry;
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)requestEnvironment.getExecutionEnvironment();
        if (null == executionEnvironment) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, NULL_EXECUTION_ENVIRONMENT);
        }
        String sessionContextID = requestEnvironment.getSessionContextID();
        if (null == sessionContextID) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, NULL_SESSION_CONTEXT_ID);
        }
        MultiRequestContext multiRequestContext = executionEnvironment.getMultiRequestContextNoThrow();
        if (null == multiRequestContext) {
            multiRequestContext = this.cacheManager.getMultiRequestContext(sessionContextID);
            if (null == multiRequestContext) {
                SessionContext sessionContext = new SessionContext(sessionContextID, requestEnvironment);
                if (this.excessiveCollectionHandler != null) {
                    this.excessiveCollectionHandler.register(sessionContext);
                }
                ResourceMonitor.register(sessionContext);
                multiRequestContext = new MultiRequestContext(sessionContext, true);
                if (CollectXQELogs.isLoggingEnabled(requestEnvironment)) {
                    UsageTrackingService.setRecordPerReport(true);
                }
            }
            executionEnvironment.setMultiRequestContext(multiRequestContext);
        }
        if (null != requestDocument) {
            multiRequestContext.setRequestDocument(requestDocument);
        }
        this.connectionPoolHelper.setMultiRequestConnectionPool(executionEnvironment, multiRequestContext);
        TraceContext traceContext = TraceContext.get();
        if (null != traceContext) {
            traceContext.addAttribute("sessionId", sessionContextID);
        }
        if ((cancelableRequestRegistry = executionEnvironment.getMultiRequestContext().getCancelableRequestRegistry()) != null) {
            cancelableRequestRegistry.registerCancelable(requestEnvironment.getRequestID(), executionEnvironment.getCancelManager());
        }
        return multiRequestContext;
    }

    public void configureSessionAndMultiRequestContext(RequestEnvironment requestEnvironment, SessionContext sessionContext, boolean createMultiRequestContext) throws XQERuntimeException {
        TraceContext traceContext;
        String sessionContextID = requestEnvironment.getSessionContextID();
        if (null == sessionContextID) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, NULL_SESSION_CONTEXT_ID);
        }
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)requestEnvironment.getExecutionEnvironment();
        if (null == executionEnvironment) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, NULL_EXECUTION_ENVIRONMENT);
        }
        if (null != executionEnvironment.getMultiRequestContextNoThrow()) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Unexpected MultiRequestContext already configured");
        }
        if (createMultiRequestContext) {
            MultiRequestContext multiRequestContext = sessionContext.getMultiRequestContext();
            if (null == multiRequestContext) {
                if (null != this.cacheManager.getMultiRequestContext(sessionContextID)) {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Detected a leaked MultiRequestContext in CacheManager with id=" + sessionContextID);
                }
                multiRequestContext = new MultiRequestContext(sessionContext, false);
            }
            executionEnvironment.setMultiRequestContext(multiRequestContext);
        }
        if (null != (traceContext = TraceContext.get())) {
            traceContext.addAttribute("sessionId", sessionContext.getSessionContextID());
        }
    }

    public QueryContext createQueryContext() {
        String queryContextId = UUID.randomUUID().toString();
        QueryContext queryContext = new QueryContext(queryContextId);
        QueryEngine.getInstance().getCacheManager().storeQueryContext(queryContext);
        return queryContext;
    }

    public QueryContext getQueryContext(String queryContextId) {
        return this.cacheManager.getQueryContext(queryContextId);
    }

    public void releaseQueryContext(String queryContextID) {
        QueryContext queryContext = this.cacheManager.removeQueryContext(queryContextID);
        if (null == queryContext) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, ERRMSG_QUERY_CTX_NOT_REG + queryContextID);
        }
        queryContext.release();
    }

    public SessionContext createOrGetSessionContext(String sessionContextID, boolean createSessionContext) {
        SessionContext sessionContext;
        if (createSessionContext) {
            if (null != this.cacheManager.getSessionContext(sessionContextID)) {
                sessionContext = this.cacheManager.getSessionContext(sessionContextID);
                ERROR_LOGGER.log(LogLevel.INFO, (Throwable)new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "null != sessionContext for " + sessionContext.toString()));
            } else {
                sessionContext = new SessionContext(sessionContextID);
                if (this.excessiveCollectionHandler != null) {
                    this.excessiveCollectionHandler.register(sessionContext);
                }
                ResourceMonitor.register(sessionContext);
                this.cacheManager.storeSessionContext(sessionContext);
            }
        } else {
            sessionContext = this.cacheManager.getSessionContext(sessionContextID);
            if (null == sessionContext) {
                boolean tryWithCreateSessionContext = true;
                return this.createOrGetSessionContext(sessionContextID, tryWithCreateSessionContext);
            }
        }
        return sessionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSessionContext(RequestEnvironment reqEnv) {
        String sessionContextID = reqEnv.getSessionContextID();
        SessionContext sessionContext = this.cacheManager.removeSessionContext(sessionContextID);
        if (null == sessionContext) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, ERRMSG_SESS_CTX_NOT_REG + sessionContextID);
        }
        MultiRequestContext multiReqCtx = sessionContext.getMultiRequestContext();
        try {
            sessionContext.release();
        }
        finally {
            if (null != multiReqCtx && !multiReqCtx.isReleased()) {
                ERROR_LOGGER.log(LogLevel.ERROR, "Detected a leaked MultiRequestContext (" + multiReqCtx.getIDSString() + ") for SessionContext with id=" + sessionContextID);
                if (multiReqCtx.isInUse()) {
                    ERROR_LOGGER.log(LogLevel.ERROR, "Detected concurrent access to MultiRequestContext with id=" + multiReqCtx.getIDSString());
                }
                while (null != this.cacheManager.removeMultiRequestContext(multiReqCtx.getSessionContextID())) {
                }
                ExecutionEnvironment execEnv = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
                execEnv.setMultiRequestContext(multiReqCtx);
                multiReqCtx.release();
            }
        }
    }

    public void releaseSessionContext(String sessionContextID) {
        SessionContext sessionContext = this.cacheManager.removeSessionContext(sessionContextID);
        if (null == sessionContext) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, ERRMSG_SESS_CTX_NOT_REG + sessionContextID);
        }
        sessionContext.release();
    }

    public void keepAliveSessions(List<String> sessionContextIDs) {
        this.cacheManager.keepAliveSessions(sessionContextIDs);
    }

    public void cleanupLeakedDatasets(IExecutionEnvironment execEnv, RSAPIDataset[] leakedDatasets) {
        StringBuilder buffer = new StringBuilder();
        for (RSAPIDataset dataset : leakedDatasets) {
            RSAPIPartialDataset[] partialDatasets;
            buffer.delete(0, buffer.length()).append("Releasing a leaked RSAPIDataset with id=").append(dataset.getUniqueID());
            ENGINE_LOGGER.log(LogLevel.ERROR, buffer.toString());
            for (RSAPIPartialDataset partialDataset : partialDatasets = dataset.getActivePartialDatasets()) {
                buffer.delete(0, buffer.length()).append("Releasing a leaked RSAPIPartialDataset with id=").append(partialDataset.getUniqueID());
                ENGINE_LOGGER.log(LogLevel.ERROR, buffer.toString());
                try {
                    this.releasePartialDataset(partialDataset.getUniqueID());
                }
                catch (Throwable ex) {
                    buffer.delete(0, buffer.length()).append("An error occurred while releasing a leaked RSAPIPartialDataset with id=").append(partialDataset.getUniqueID()).append("; Stack Trace: ");
                    ENGINE_LOGGER.log(LogLevel.ERROR, buffer.toString(), ex);
                }
            }
            while (null != this.cacheManager.removeDatasetByID(dataset.getUniqueID(), (IRequestEnvironment)execEnv.getRequestEnvironment())) {
            }
            try {
                dataset.releaseResultset(execEnv);
            }
            catch (Throwable ex) {
                buffer.delete(0, buffer.length()).append("An error occurred while releasing a leaked RSAPIDataset with id=").append(dataset.getUniqueID()).append("; Stack Trace: ");
                ENGINE_LOGGER.log(LogLevel.ERROR, buffer.toString(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IXQEQueryNode prepareMetadataRequest(Document requestDocument, RequestEnvironment reqEnv) {
        HighPrecisionStopWatch planTimer = new HighPrecisionStopWatch(true);
        IXQEQueryNode planTree = null;
        Element rootElement = requestDocument.getRootElement();
        this.configureRequestEnvironment(reqEnv);
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
        MultiRequestContext multiRequestContext = executionEnvironment.getMultiRequestContext();
        ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(executionEnvironment);
        multiRequestContext.incrementRefCount();
        try {
            PlanningEnvironment planEnv = QueryPlanner.setupEnvironment(reqEnv);
            Parameters parameters = reqEnv.getRequestParameters();
            Element parametersElement = rootElement.element("parameters");
            if (parametersElement != null) {
                parameters.prepare(parametersElement, planEnv);
            }
            planTree = QueryPlanner.getInstance().planMetadataQuery(requestDocument, reqEnv);
        }
        finally {
            IUsageIndicator planTimeIndicator = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.PLAN_TIME, reqEnv.getReportName());
            if (planTimeIndicator != null) {
                planTimeIndicator.add(planTimer.getElapsedTimeInMilliseconds());
            }
            multiRequestContext.decrementRefCount();
            executionEnvironmentContext.exit();
        }
        return planTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IXQEQueryNode prepareMoserRequest(Document requestDocument, RequestEnvironment reqEnv) {
        HighPrecisionStopWatch planTimer = new HighPrecisionStopWatch(true);
        IXQEQueryNode planTree = null;
        Element rootElement = requestDocument.getRootElement();
        this.configureRequestEnvironment(reqEnv);
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
        MultiRequestContext multiRequestContext = executionEnvironment.getMultiRequestContext();
        ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(executionEnvironment);
        multiRequestContext.incrementRefCount();
        try {
            PlanningEnvironment planEnv = QueryPlanner.setupEnvironment(reqEnv);
            Parameters parameters = reqEnv.getRequestParameters();
            Element parametersElement = rootElement.element("parameters");
            if (parametersElement != null) {
                parameters.prepare(parametersElement, planEnv);
            }
            MoserParameterUtil.addRequestParameterValue(rootElement, reqEnv, planEnv);
            planTree = QueryPlanner.getInstance().planMoserQuery(requestDocument, reqEnv);
        }
        finally {
            IUsageIndicator planTimeIndicator = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.PLAN_TIME, reqEnv.getReportName());
            if (planTimeIndicator != null) {
                planTimeIndicator.add(planTimer.getElapsedTimeInMilliseconds());
            }
            multiRequestContext.decrementRefCount();
            executionEnvironmentContext.exit();
        }
        return planTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IXQEQueryNode describeDataSourceQueryRequest(Document requestDocument, RequestEnvironment reqEnv) {
        IXQEQueryNode planTree = null;
        ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(reqEnv.getExecutionEnvironment());
        try {
            V5QuerySubject v5QuerySubject;
            reqEnv.setMaxSeverityLevelForFeedback(requestDocument.getRootElement());
            Element modelPathElement = requestDocument.getRootElement().element("modelPath");
            if (modelPathElement == null) {
                throw new MalformedExecuteRequestException(XQEMessageKeys.EXE_InvalidDescribeDataSourceQueryRequest);
            }
            Element sqlQueryElement = requestDocument.getRootElement().element(SQLQUERY);
            Element querySubjectElement = requestDocument.getRootElement().element("querySubject");
            if (sqlQueryElement == null && querySubjectElement == null) {
                throw new MalformedExecuteRequestException(XQEMessageKeys.EXE_InvalidDescribeDataSourceQueryRequest);
            }
            planTree = this.prepareDescribeDataSourceQueryRequest(requestDocument, reqEnv);
            if (planTree.getType() == 101074 && (v5QuerySubject = (V5QuerySubject)planTree).isStoredProcedure()) {
                this.executeStoredProcedure(planTree, reqEnv);
            }
        }
        finally {
            executionEnvironmentContext.exit();
        }
        return planTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IXQEQueryNode prepareDescribeDataSourceQueryRequest(Document requestDocument, RequestEnvironment reqEnv) {
        IXQEQueryNode planTree = null;
        Element rootElement = requestDocument.getRootElement();
        reqEnv.setMaxSeverityLevelForFeedback(rootElement);
        this.configureRequestEnvironment(reqEnv);
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
        MultiRequestContext multiRequestContext = executionEnvironment.getMultiRequestContext();
        ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(executionEnvironment);
        multiRequestContext.incrementRefCount();
        try {
            PlanningEnvironment planEnv = QueryPlanner.setupEnvironment(reqEnv);
            Parameters parameters = reqEnv.getRequestParameters();
            Element parametersElement = rootElement.element("parameters");
            if (parametersElement != null) {
                parameters.prepare(parametersElement, planEnv);
            }
            planTree = QueryPlanner.getInstance().planDescribeDataSourceQuery(requestDocument, reqEnv);
        }
        finally {
            multiRequestContext.decrementRefCount();
            executionEnvironmentContext.exit();
        }
        return planTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateQueryRequest(Document requestDocument, RequestEnvironment reqEnv) {
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
        MultiRequestContext multiRequestContext = executionEnvironment.getMultiRequestContext();
        ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(executionEnvironment);
        multiRequestContext.incrementRefCount();
        try {
            V5UpdateSet planTree = this.prepareUpdateQueryRequest(requestDocument, reqEnv);
            this.executeUpdateQueryRequest(planTree, reqEnv);
        }
        finally {
            multiRequestContext.decrementRefCount();
            executionEnvironmentContext.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V5UpdateSet prepareUpdateQueryRequest(Document requestDocument, RequestEnvironment reqEnv) {
        boolean hasUnresolvedParameters = false;
        V5UpdateSet planTree = null;
        Parameters parameters = reqEnv.getRequestParameters();
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
        MultiRequestContext multiRequestContext = executionEnvironment.getMultiRequestContext();
        ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(executionEnvironment);
        multiRequestContext.incrementRefCount();
        try {
            block11: {
                try {
                    Element updateSet = requestDocument.getRootElement().element("updateSet");
                    if (updateSet == null) {
                        throw new MalformedExecuteRequestException(XQEMessageKeys.EXE_InvalidUpdateQueryRequest);
                    }
                    Element modelPathElement = updateSet.element("modelPath");
                    if (modelPathElement == null) {
                        throw new MalformedExecuteRequestException(XQEMessageKeys.EXE_InvalidUpdateQueryRequest);
                    }
                    Element updateSubjectElement = updateSet.element("updateSubject");
                    if (updateSubjectElement == null) {
                        throw new MalformedExecuteRequestException(XQEMessageKeys.EXE_InvalidUpdateQueryRequest);
                    }
                    Element rootElement = requestDocument.getRootElement();
                    reqEnv.setMaxSeverityLevelForFeedback(rootElement);
                    PlanningEnvironment planEnv = QueryPlanner.setupEnvironment(reqEnv);
                    Element parametersElement = rootElement.element("parameters");
                    if (parametersElement != null) {
                        parameters.prepare(parametersElement, planEnv);
                    }
                    this.configureRequestEnvironment(reqEnv);
                    planTree = QueryPlanner.getInstance().planUpdateQuery(requestDocument, reqEnv);
                    hasUnresolvedParameters = parameters.hasUnresolvedParameters();
                }
                catch (DataSourceException dsException) {
                    throw dsException;
                }
                catch (XQERuntimeException e) {
                    hasUnresolvedParameters = parameters.hasUnresolvedParameters();
                    if (hasUnresolvedParameters) break block11;
                    throw e;
                }
            }
            if (hasUnresolvedParameters && planTree != null && !planTree.isNoDataMode()) {
                throw new UnresolvedParameterException(reqEnv, planTree, parameters.getUnresolvedParameters());
            }
        }
        finally {
            multiRequestContext.decrementRefCount();
            executionEnvironmentContext.exit();
        }
        return planTree;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public boolean cacheQueryPlans() {
        return this.cacheManager.cacheQueryPlans;
    }

    public void cacheClearAll() {
        this.cacheManager.clearAll();
    }

    public RSAPIDataset getDatasetByID(String datasetId) {
        return this.cacheManager.getDatasetByID(datasetId);
    }

    public void replaceDataset(RSAPIDataset oldRsapiDataset, RSAPIDataset newRsapiDataset) {
        this.cacheManager.replaceDataset(oldRsapiDataset, newRsapiDataset);
    }

    public RSAPIPartialDataset getPartialDatasetByID(String partialDatasetId) {
        return this.cacheManager.getPartialDatasetByID(partialDatasetId);
    }

    public void storePartialDataset(RSAPIPartialDataset partialDataset) {
        if (ENGINE_LOGGER.isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Storing partial dataset ").append(partialDataset.getUniqueID());
            ENGINE_LOGGER.log(LogLevel.INFO, buffer.toString());
        }
        if (this.getRequestRecorder() != null) {
            this.getRequestRecorder().addPartialDatasetCreated(partialDataset);
        }
        this.cacheManager.storePartialDataset(partialDataset);
    }

    public void removePlanTree(PlannedV5QuerySet querySet) {
        this.cacheManager.removePlanTree(querySet);
    }

    public EnvironmentFactory getBaseEnvironmentFactory() {
        return this.baseEnvironmentFactory;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void clearPlanCache() {
        this.cacheManager.clearPlanTrees();
    }

    public void writeState() {
        this.cacheManager.writeState();
    }

    public long getPlanCacheHitCount() {
        return this.cacheManager.planHitCount;
    }

    public PersistentPlanDiskCacheStatistics getPeristentPlanDiskCacheStatistics() {
        return this.cacheManager.getPeristentPlanDiskCacheStatistics();
    }

    public long getLastClearCacheTime() {
        return this.lastClearCacheTime;
    }

    public void setLastClearCacheTime(long theLastClearCacheTime) {
        this.lastClearCacheTime = theLastClearCacheTime;
    }

    private void loadQueryExecutionConfigurationSettings(IExecutionEnvironment environment) {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        if (configuration == null) {
            return;
        }
        MultiRequestContext multiRequestContext = environment.getMultiRequestContext();
        if (multiRequestContext.fetchBooleanConfiguration("queryExecution.dumpMDX[@value]", false)) {
            environment.setDumpMDX(true);
        }
        Object oClassList = multiRequestContext.fetchXQEConfigurationProperty("queryExecution.iteratorLogging.XIterator[@classList]", null);
        ArrayList<String> classList = null;
        if (oClassList != null && oClassList instanceof List) {
            classList = (ArrayList<String>)oClassList;
        } else if (oClassList != null && oClassList instanceof String) {
            classList = new ArrayList<String>();
            classList.add((String)oClassList);
        }
        if (classList != null && !classList.equals("")) {
            environment.setXIteratorLoggingList(classList);
        }
        if (multiRequestContext.fetchBooleanConfiguration("queryExecution.iteratorLogging.RSAPITabularIterator[@traceEnabled]", false)) {
            environment.setRSAPITabularIteratorLogging(true);
        }
    }

    private IXQEQueryNode[] fetchRSAPIDatasets(Document requestDocument, RequestEnvironment reqEnv, Element queriesElement, Element providerQueryElement) {
        if (ENGINE_LOGGER.isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Fetching RSAPI datasets for request document: ").append(requestDocument.asXML());
            ENGINE_LOGGER.log(LogLevel.INFO, buffer.toString());
        }
        if (providerQueryElement == null) {
            if (queriesElement.element("query") != null || queriesElement.element("modQuery") != null) {
                IXQEQueryNode[] nodes;
                ArrayList<RSAPIDataset> datasets = new ArrayList<RSAPIDataset>();
                PlannedV5QuerySet planTree = this.prepareRequest(requestDocument, reqEnv, false);
                MasterDetailProvider masterDetailProvider = null == planTree ? null : planTree.getMasterDetailProvider();
                ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
                MultiRequestContext multiRequestContext = executionEnvironment.getMultiRequestContext();
                for (IXQEQueryNode node : nodes = planTree.getChildrenOfType(401005)) {
                    RSAPIDataset dataset = (RSAPIDataset)node;
                    boolean isDetail = masterDetailProvider.isDetailRSAPIDataset(dataset);
                    if (isDetail) continue;
                    this.executeRSAPIDataset(dataset, executionEnvironment);
                    datasets.add(dataset);
                    if (!dataset.forDMRReport() || reqEnv.getMaxSeverityLevel() != 3) continue;
                    List<Nag> dmrSQL = executionEnvironment.getNagCollector().getNagOfSubqueryType(NagSubquery.NagSubqueryType.DMR);
                    for (int i = 0; i < dmrSQL.size(); ++i) {
                        NagSubquery nag = (NagSubquery)dmrSQL.get(i);
                        if (nag.getReportQueryName() != null) continue;
                        nag.setReportQueryName(dataset.getRefQueryName());
                    }
                }
                IXQEQueryNode[] datasetsArray = datasets.toArray(new IXQEQueryNode[datasets.size()]);
                this.storePlannedDatasetsAndMultiRequestContext(executionEnvironment, planTree, multiRequestContext);
                return datasetsArray;
            }
            throw new MalformedExecuteRequestException(XQEMessageKeys.EXE_InvalidExecuteRequest);
        }
        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "providerQueryElement must be provided.");
    }

    private void storePlannedDatasetsAndMultiRequestContext(ExecutionEnvironment execEnv, PlannedV5QuerySet planTree, MultiRequestContext multiRequestContext) {
        if (ENGINE_LOGGER.isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Storing planned datasets and MRC ").append(multiRequestContext.getIDSString());
            ENGINE_LOGGER.log(LogLevel.INFO, buffer.toString());
        }
        IXQEQueryNode[] rsapiDataSets = planTree.getChildrenOfType(401005);
        for (int i = 0; i < rsapiDataSets.length; ++i) {
            RSAPIDataset dataset = (RSAPIDataset)rsapiDataSets[i];
            String id = dataset.getUniqueID();
            if (null == id) {
                throw new XQERuntimeException(XQEMessageKeys.EXE_MissingMasterDatasetId);
            }
            if (id.length() == 0) {
                throw new XQERuntimeException(XQEMessageKeys.EXE_EmptyMasterDatasetId);
            }
            if (ENGINE_LOGGER.isOn(LogLevel.INFO)) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("Storing planned dataset ").append(dataset.getUniqueID());
                ENGINE_LOGGER.log(LogLevel.INFO, buffer.toString());
            }
            if (this.getRequestRecorder() != null) {
                this.getRequestRecorder().addDatasetCreated(dataset);
            }
            this.cacheManager.storeDataset(dataset);
            this.cacheManager.storeMultiRequestContext(multiRequestContext);
            multiRequestContext.incrementRefCount();
            boolean tryAdjustDataTypes = true;
            if (((RequestEnvironment)execEnv.getRequestEnvironment()).getMasterDetailProvider().isDetailRSAPIDataset(dataset)) {
                tryAdjustDataTypes = multiRequestContext.getRequestParameters().getParameters().hasUnresolvedMasterDetailParameters();
            }
            if (!tryAdjustDataTypes) continue;
            dataset.adjustDataItemTypes(execEnv);
        }
    }

    private void validateMissingMembers(IXQEQueryNode planTree, ExecutionEnvironment execEnv) {
        RequestEnvironment re = (RequestEnvironment)execEnv.getRequestEnvironment();
        re.setValidateMissingMembers(true);
        IXQEQueryNode[] listOfChildren = planTree.getDescendantsOfType(501117, true);
        if (listOfChildren.length > 0) {
            XMissingMemberValidate xMMValidate = (XMissingMemberValidate)listOfChildren[0];
            xMMValidate.validateMuns(execEnv);
        }
        re.setValidateMissingMembers(false);
    }

    private IXQEQueryNode validateProviderQueryRequest(Element providerQueryElement) {
        String datasetId = providerQueryElement.attributeValue(ID_ATTRIBUTE);
        if (datasetId == null) {
            throw new MalformedExecuteRequestException(XQEMessageKeys.EXE_MissingMasterDetailLinks);
        }
        IXQEQueryNode planTree = null;
        RSAPIDataset rsapiNode = this.cacheManager.getDatasetByID(datasetId);
        if (rsapiNode == null) {
            throw new MalformedExecuteRequestException(XQEMessageKeys.EXE_InvalidExecuteRequest);
        }
        planTree = rsapiNode;
        while (planTree.getParent() != null) {
            planTree = planTree.getParent();
        }
        return planTree;
    }

    private void configureExecutionEnvironment(IExecutionEnvironment executionEnvironment) {
        this.connectionPoolHelper.setConnectionPool(executionEnvironment);
    }

    private ExecutionEnvironment createExecutionEnvironment() {
        ExecutionEnvironment executionEnvironment = new ExecutionEnvironment();
        this.configureExecutionEnvironment(executionEnvironment);
        return executionEnvironment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeStoredProcedure(IXQEQueryNode planTree, RequestEnvironment reqEnv) {
        V5QuerySubject v5QuerySubject = (V5QuerySubject)planTree;
        ExecutionEnvironment execEnv = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
        XDataContext dataContext = execEnv.pushDataContext();
        try {
            v5QuerySubject.execute(dataContext);
        }
        finally {
            execEnv.popDataContext(dataContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeUpdateQueryRequest(IXQEQueryNode planTree, RequestEnvironment reqEnv) {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
        XDataContext dataContext = execEnv.pushDataContext();
        try {
            ((V5UpdateSet)planTree).execute(dataContext);
        }
        finally {
            execEnv.popDataContext(dataContext);
        }
    }

    private List<Element> getRequestedDatasets(Element v5RootElement, Element queriesElement) {
        ArrayList<Element> providerQueries;
        List requestedDatasets = v5RootElement.elements("retrieveDataset");
        ArrayList<String> datasetNames = new ArrayList<String>();
        for (Element dataset : requestedDatasets) {
            datasetNames.add(dataset.attributeValue("value"));
        }
        ArrayList<Element> allProviderQueries = queriesElement.elements(PROVIDERQUERY);
        if (0 == requestedDatasets.size()) {
            providerQueries = allProviderQueries;
        } else {
            providerQueries = new ArrayList<Element>();
            for (Element providerQuery : allProviderQueries) {
                if (!datasetNames.contains(providerQuery.attributeValue("name"))) continue;
                providerQueries.add(providerQuery);
            }
        }
        return providerQueries;
    }

    private static void handleMissingMemberException(Document requestDocument, MissingMemberException missingMemberException, Document responseDocument) {
        if (!QueryEngine.isForMissingMembers(requestDocument)) {
            throw missingMemberException;
        }
        QueryEngine.addMissingMembersToResponse(missingMemberException, responseDocument);
    }

    private static boolean isForMissingMembers(Document requestDocument) {
        boolean isForMissingMembers = false;
        List propertyNodes = requestDocument.getRootElement().elements("property");
        for (Element propertyNode : propertyNodes) {
            String value;
            String name = propertyNode.attributeValue("name");
            if (null == name || !name.equals("forMissingMembers") || null == (value = propertyNode.attributeValue("value")) || !value.equals("true")) continue;
            isForMissingMembers = true;
            break;
        }
        return isForMissingMembers;
    }
}

