/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.engine;

import com.cognos.mfw4j.utilities.IMFWCMRequestExecutor;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibushandler.CancelManager;
import com.cognos.xqe.bibushandler.CancelableRequestRegistry;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.RequestMetrics;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IEnvironmentFactory;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.query.engine.TestEnvironmentOptions;
import com.cognos.xqe.query.parameters.RequestParameters;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.trace.TraceContext;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.context.ContextTransfer;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.primitive.HashMapLongObject;
import com.cognos.xqe.zipi.ZipiBridge;
import java.rmi.server.UID;
import java.util.concurrent.Callable;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public final class QueryEnvironmentHelper {
    private static final String SETUP_NOT_CALLED = "XQE environment was not setup.";
    private Element mRequestHeader = null;
    private BIBusEnvelope mRequestEnvelope = null;
    private IMFWCMRequestExecutor mCMRequestExecutor = null;
    private Element mConnectionSpec = null;
    private String mProductLocale = null;
    private String mRunLocale = null;
    private String mExpressionLocale = null;
    private String mSessionContextId = null;
    private String mRequestId = null;
    private boolean mManagingMRC = false;
    private ExecutionEnvironment mExecutionEnvironment = null;
    private IDataSource mExecutionDataSource = null;
    private CancelManager mExecutionCancelManager = null;
    private String mReportName = null;
    private String mPackageName = null;
    private ROLAPContext mMRCRolapContext = null;
    private RequestParameters mMRCRequestParameters = null;
    HashMapLongObject<Object> mMRCReferencesById = null;
    private RequestEnvironment mRequestEnvironment = null;
    private ExecutionEnvironmentContext mExecEnvContext = null;
    private TestEnvironmentOptions mTestEnvOptions = null;
    private XQETrace mExecutionTrace = null;
    private RequestMetrics mRequestMetrics = null;
    private boolean mSetup = false;
    private boolean mInternalUse = false;
    protected IEnvironmentFactory mEnvironmentFactory = null;

    public void setRequestHeader(Element theRequestHeader) {
        this.mRequestHeader = theRequestHeader;
    }

    public void setRequestEnvelope(BIBusEnvelope theRequestEnvelope) {
        this.mRequestEnvelope = theRequestEnvelope;
    }

    public void setCMRequestExecutor(IMFWCMRequestExecutor requestExecutor) {
        this.mCMRequestExecutor = requestExecutor;
    }

    public void setConnectionSpec(Element theConnectionSpec) {
        this.mConnectionSpec = theConnectionSpec;
    }

    public void setProductLocale(String theProductLocale) {
        this.mProductLocale = theProductLocale;
    }

    public void setRunLocale(String theRunLocale) {
        this.mRunLocale = theRunLocale;
    }

    public void setExpressionLocale(String theExpressionLocale) {
        this.mExpressionLocale = theExpressionLocale;
    }

    public void setSessionContextId(String theSessionContextId) {
        this.mSessionContextId = theSessionContextId;
    }

    public void setRequestId(String theRequestId) {
        this.mRequestId = theRequestId;
    }

    public void setExecutionDataSource(IDataSource dataSource) {
        this.mExecutionDataSource = dataSource;
    }

    public IDataSource getExecutionDataSource() {
        return this.mExecutionDataSource;
    }

    public void setCancelManager(CancelManager cancelManager) {
        this.mExecutionCancelManager = cancelManager;
    }

    public void setRequestEnvironmentReportName(String reportName) {
        this.mReportName = reportName;
    }

    public void setRequestEnvironmentPackageName(String packageName) {
        this.mPackageName = packageName;
    }

    public void setMRCRolapContext(ROLAPContext context) {
        this.mMRCRolapContext = context;
    }

    public void setMRCRequestParameters(RequestParameters requestParameters) {
        this.mMRCRequestParameters = requestParameters;
    }

    private void setMRCReferencesById(HashMapLongObject<Object> mReferencesById) {
        this.mMRCReferencesById = mReferencesById;
    }

    public void setInternalUse(boolean internalUse) {
        this.mInternalUse = internalUse;
    }

    public void setExecutionTrace(XQETrace trace) {
        this.mExecutionTrace = trace;
    }

    public void setRequestMetrics(RequestMetrics metrics) {
        this.mRequestMetrics = metrics;
    }

    public void setTestEnvironmentOptions(TestEnvironmentOptions teo) {
        this.mTestEnvOptions = teo;
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        if (!this.mSetup) {
            throw new IllegalStateException(SETUP_NOT_CALLED);
        }
        return this.mExecutionEnvironment;
    }

    public RequestEnvironment getRequestEnvironment() {
        if (!this.mSetup) {
            throw new IllegalStateException(SETUP_NOT_CALLED);
        }
        return this.mRequestEnvironment;
    }

    public void setUpEnvironment(boolean standalone) {
        this.setUpEnvironment(standalone, true, false);
    }

    public void setUpEnvironment(boolean standalone, boolean monitorResources) {
        this.setUpEnvironment(standalone, true, monitorResources);
    }

    public void setUpEnvironment(boolean standalone, boolean copyReferencesIds, boolean monitorResources) {
        if (this.mSetup) {
            throw new IllegalStateException("XQE environment was already setup - call tearDownEnvironment() first.");
        }
        ExecutionEnvironment threadBoundExecEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (!standalone && null != threadBoundExecEnv && null != threadBoundExecEnv.getRequestEnvironment()) {
            this.mRequestEnvironment = ((RequestEnvironment)threadBoundExecEnv.getRequestEnvironment()).duplicate();
            this.mExecutionEnvironment = (ExecutionEnvironment)this.mRequestEnvironment.getExecutionEnvironment();
            threadBoundExecEnv.copyTo(this.mExecutionEnvironment);
            this.mExecutionEnvironment.setRequestEnvironment(this.mRequestEnvironment);
            this.mExecutionEnvironment.getMultiRequestContext();
            this.mManagingMRC = false;
        } else {
            CancelableRequestRegistry cancelableRequestRegistry;
            if (this.mCMRequestExecutor != null) {
                this.mRequestEnvelope = new BIBusEnvelope();
                this.mRequestEnvironment = new RequestEnvironment(this.mCMRequestExecutor);
            } else {
                if (null == this.mRequestEnvelope) {
                    if (null == this.mRequestHeader) {
                        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Either a valid BIBusEnvelope is required to setup an XQE Environment.");
                    }
                    this.mRequestEnvelope = new BIBusEnvelope();
                    this.mRequestEnvelope.setBIBusHeader(this.mRequestHeader);
                }
                this.mRequestEnvironment = new RequestEnvironment(this.mRequestEnvelope);
            }
            if (null == this.mConnectionSpec) {
                this.mConnectionSpec = DocumentHelper.createElement((String)"connection");
            }
            if (null != this.mEnvironmentFactory) {
                this.mRequestEnvironment.setEnvFactory(this.mEnvironmentFactory);
            }
            if (null != this.mProductLocale) {
                this.mRequestEnvironment.setProductLocale(this.mProductLocale);
            }
            if (null != this.mRunLocale) {
                this.mRequestEnvironment.setRunLocale(this.mRunLocale);
            }
            if (null != this.mExpressionLocale) {
                this.mRequestEnvironment.setExpressionLocale(this.mExpressionLocale);
            }
            if (null != this.mRequestId) {
                this.mRequestEnvironment.setRequestID(this.mRequestId);
            } else {
                this.mRequestEnvironment.setRequestID(new UID().toString());
            }
            if (null != this.mSessionContextId) {
                this.mRequestEnvironment.setSessionContextID(this.mSessionContextId);
            } else {
                this.mRequestEnvironment.setSessionContextID(new UID().toString());
            }
            if (null != this.mReportName) {
                this.mRequestEnvironment.setReportName(this.mReportName);
            }
            if (null != this.mPackageName) {
                this.mRequestEnvironment.setPackageName(this.mPackageName);
            }
            if (null != this.mRequestMetrics) {
                this.mRequestEnvironment.setRequestMetrics(this.mRequestMetrics);
            }
            this.mRequestEnvironment.setInternal(true);
            this.mRequestEnvironment.setMonitorResources(monitorResources);
            QueryEngine.getInstance().configureRequestEnvironment(this.mRequestEnvironment);
            this.mExecutionEnvironment = (ExecutionEnvironment)this.mRequestEnvironment.getExecutionEnvironment();
            this.mExecutionEnvironment.setConnectionElement(this.mConnectionSpec);
            if (null != this.mExecutionTrace) {
                this.mExecutionEnvironment.setTrace(this.mExecutionTrace);
            }
            if (null != this.mExecutionDataSource) {
                this.mExecutionEnvironment.setDataSource(this.mExecutionDataSource);
            }
            if (null != this.mExecutionCancelManager) {
                this.mExecutionEnvironment.setCancelManager(this.mExecutionCancelManager);
            }
            if (null != this.mTestEnvOptions) {
                this.mExecutionEnvironment.setTestEnvironmentOptions(this.mTestEnvOptions);
            }
            QueryEngine.getInstance().configureMultiRequestContext(this.mRequestEnvironment, null);
            if (null != this.mMRCRolapContext) {
                this.mExecutionEnvironment.getMultiRequestContext().setRolapContext(this.mMRCRolapContext);
            } else if (this.mInternalUse) {
                ROLAPContext rolapContext = ROLAPContext.get(this.mExecutionEnvironment);
                rolapContext.setInternalUse();
                this.mExecutionEnvironment.getMultiRequestContext().setRolapContext(rolapContext);
            }
            if (null != this.mMRCRequestParameters && this.mMRCRequestParameters.hasParameters()) {
                this.mExecutionEnvironment.getMultiRequestContext().setRequestParameters(this.mMRCRequestParameters);
            }
            if (copyReferencesIds && null != this.mMRCReferencesById && !this.mMRCReferencesById.isEmpty()) {
                this.mExecutionEnvironment.getMultiRequestContext().getSessionContext().getReferencesById().putAll(this.mMRCReferencesById);
            }
            if ((cancelableRequestRegistry = this.mExecutionEnvironment.getMultiRequestContext().getCancelableRequestRegistry()) != null) {
                cancelableRequestRegistry.registerCancelable(this.mRequestEnvironment.getRequestID(), this.mExecutionEnvironment.getCancelManager());
            }
            this.mManagingMRC = true;
        }
        if (this.mManagingMRC && 1 != this.mExecutionEnvironment.getMultiRequestContext().incrementRefCount()) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Expected ref count 1, but found " + this.mExecutionEnvironment.getMultiRequestContext().getRefCount());
        }
        this.mExecEnvContext = ExecutionEnvironmentContext.enter(this.mExecutionEnvironment);
        this.mSetup = true;
    }

    public void tearDownEnvironment() {
        if (!this.mSetup) {
            throw new IllegalStateException(SETUP_NOT_CALLED);
        }
        try {
            if (this.mManagingMRC && 0 != this.mExecutionEnvironment.getMultiRequestContext().decrementRefCount()) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Expected ref count 0, but found " + this.mExecutionEnvironment.getMultiRequestContext().getRefCount());
            }
        }
        finally {
            if (this.mExecEnvContext != null) {
                this.mExecEnvContext.exit();
                this.mExecEnvContext = null;
            }
            this.mExecutionEnvironment = null;
            this.mRequestEnvironment = null;
            this.mSetup = false;
        }
    }

    public Runnable decorateRunnable(Runnable task, boolean isStandalone) {
        return new RunnableDecorator(task, isStandalone);
    }

    public <V> Callable<V> decorateCallable(Callable<V> task, boolean isStandalone, String zipiAction, String zipiObjPath, int zipiStepsToJumpFactor) {
        return ZipiBridge.wrapCallable(new CallableDecorator<V>(task, isStandalone), zipiAction, zipiObjPath, zipiStepsToJumpFactor);
    }

    public <V> Callable<V> decorateCallable(Callable<V> task, boolean isStandalone) {
        return new CallableDecorator<V>(task, isStandalone);
    }

    public void copyRequestEnvironmentInfo() {
        ExecutionEnvironment env = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        RequestEnvironment reqEnv = (RequestEnvironment)env.getRequestEnvironment();
        if (reqEnv.isCMRequestExecutorDefined()) {
            this.setCMRequestExecutor(reqEnv.getCMRequestExecutor());
        } else {
            Element header = reqEnv.getBibusHeader();
            this.setRequestHeader((Element)header.clone());
        }
        this.setExecutionDataSource(env.getDataSource());
        this.setCancelManager(env.getCancelManager());
        this.setRequestEnvironmentReportName(reqEnv.getReportName());
        this.setRequestEnvironmentPackageName(reqEnv.getPackageName());
        this.setRequestMetrics(reqEnv.getRequestMetrics());
        this.setEnvironmentFactory(reqEnv.getEnvFactory());
        this.setRequestId(reqEnv.getRequestID());
        this.setExecutionTrace(env.getTrace());
        this.setTestEnvironmentOptions(env.getTestEnvironmentOptions());
        MultiRequestContext mrc = env.getMultiRequestContextNoThrow();
        if (mrc != null) {
            HashMapLongObject<Object> mReferencesById;
            this.setMRCRolapContext(mrc.getRolapContext());
            RequestParameters requestParameters = mrc.getRequestParameters();
            if (requestParameters != null && requestParameters.hasParameters()) {
                this.setMRCRequestParameters(requestParameters);
            }
            if ((mReferencesById = mrc.getSessionContext().getReferencesById()) != null && !mReferencesById.isEmpty()) {
                this.setMRCReferencesById(mReferencesById);
            }
        }
    }

    public void copyRequestEnvironmentInfo(boolean cloneRequestParams) {
        this.copyRequestEnvironmentInfo();
        if (cloneRequestParams && this.mMRCRequestParameters != null) {
            this.setMRCRequestParameters(new RequestParameters(this.mMRCRequestParameters));
        }
    }

    public void setEnvironmentFactory(IEnvironmentFactory environmentFactory) {
        this.mEnvironmentFactory = environmentFactory;
    }

    public ContextTransfer getContextTransfer() {
        ContextTransfer contextTransfer = ExecutionEnvironmentContext.createTransfer();
        this.mExecEnvContext.exit();
        this.mExecEnvContext = null;
        this.mManagingMRC = false;
        return contextTransfer;
    }

    private final class CallableDecorator<V>
    implements Callable<V> {
        private final Callable<V> mDelegate;
        private final boolean mStandalone;
        private final ContextTransfer mTraceCtxTransfer;

        CallableDecorator(Callable<V> delegate, boolean isStandalone) {
            this.mDelegate = delegate;
            this.mStandalone = isStandalone;
            this.mTraceCtxTransfer = TraceContext.createTransfer();
        }

        @Override
        public V call() throws Exception {
            this.mTraceCtxTransfer.push();
            try {
                V v;
                QueryEnvironmentHelper.this.setUpEnvironment(this.mStandalone, false, false);
                try {
                    v = this.mDelegate.call();
                    QueryEnvironmentHelper.this.tearDownEnvironment();
                }
                catch (Throwable throwable) {
                    QueryEnvironmentHelper.this.tearDownEnvironment();
                    throw throwable;
                }
                return v;
            }
            finally {
                this.mTraceCtxTransfer.pop();
            }
        }

        public String toString() {
            return this.mDelegate.toString();
        }
    }

    private final class RunnableDecorator
    implements Runnable {
        private final Runnable mDelegate;
        private final boolean mStandalone;
        private final ContextTransfer mTraceCtxTransfer;

        RunnableDecorator(Runnable delegate, boolean isStandalone) {
            this.mDelegate = delegate;
            this.mStandalone = isStandalone;
            this.mTraceCtxTransfer = TraceContext.createTransfer();
        }

        @Override
        public void run() {
            this.mTraceCtxTransfer.push();
            try {
                QueryEnvironmentHelper.this.setUpEnvironment(this.mStandalone);
                try {
                    this.mDelegate.run();
                }
                finally {
                    QueryEnvironmentHelper.this.tearDownEnvironment();
                }
            }
            finally {
                this.mTraceCtxTransfer.pop();
            }
        }
    }
}

