/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.engine;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.util.usage.UsageTrackingService;
import com.cognos.xqe.util.usage.indicators.IUsageIndicator;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorCategory;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorType;
import com.cognos.xqe.util.xml.XMLWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class ResponseMessageFolder {
    private static final String MESSAGE_FOLDER = "messageFolder";
    public static final String SLASH = "/";
    private List<ResponseMessage> mPlanningResponseMessages = new ArrayList<ResponseMessage>();
    private List<ResponseMessageFolder> mResponseMessageFolders = new ArrayList<ResponseMessageFolder>();
    private List<ResponseMessage> mExecutionResponseMessages = new ArrayList<ResponseMessage>();
    private List<ResponseMessage> mValidationResponseMessages = new ArrayList<ResponseMessage>();
    int maxSeverityLevel = -1;

    public final List<ResponseMessage> getPlanningResponseMessages() {
        return this.mPlanningResponseMessages;
    }

    public List<ResponseMessageFolder> getResponseMessageFolders() {
        return this.mResponseMessageFolders;
    }

    public final List<ResponseMessage> getExecutionResponseMessages() {
        return this.mExecutionResponseMessages;
    }

    public final List<ResponseMessage> getValidationResponseMessages() {
        return this.mValidationResponseMessages;
    }

    public final List<ResponseMessage> getResponseMessages(String operationName) {
        if (operationName.equals("execute")) {
            return this.getExecutionResponseMessages();
        }
        if (operationName.equals("validate")) {
            return this.getValidationResponseMessages();
        }
        return this.getPlanningResponseMessages();
    }

    public int getMaxSeverityLevel() {
        return this.maxSeverityLevel;
    }

    public void setMaxSeverityLevel(int maxSeverity) {
        this.maxSeverityLevel = maxSeverity;
    }

    private void addMessage(List<ResponseMessage> list, ResponseMessage responseMessage) {
        int severity = responseMessage.getSeverity();
        this.updateIndicators(severity, responseMessage.getType(), responseMessage.getMessageKey());
        if (severity <= this.maxSeverityLevel) {
            list.add(responseMessage);
        }
    }

    public void appendInfoResponseMessage(ResponseMessage.ResponseMessageType aType, String msg, String operationName) {
        this.addMessage(this.getResponseMessages(operationName), new ResponseMessage(3, aType, msg));
    }

    public void appendResponseMessage(int aSeverity, ResponseMessage.ResponseMessageType aType, String aMsg, String operationName) {
        List<ResponseMessage> responseMessages = this.getResponseMessages(operationName);
        ResponseMessage responseMessage = new ResponseMessage(aSeverity, aType, aMsg);
        this.addMessage(responseMessages, responseMessage);
    }

    public void appendPlanningResponseMessage(ResponseMessage responseMessage) {
        this.appendPlanningResponseMessage(responseMessage, null, null);
    }

    public ResponseMessageFolder appendResponseMessageFolder() {
        ResponseMessageFolder nestedMessageFolder = new ResponseMessageFolder();
        nestedMessageFolder.setMaxSeverityLevel(this.getMaxSeverityLevel());
        this.getResponseMessageFolders().add(nestedMessageFolder);
        return nestedMessageFolder;
    }

    public void appendPlanningResponseMessage(ResponseMessage responseMessage, IXQEQueryNode node, IXQEQueryNode root) {
        String path = null;
        if (node != null) {
            path = ResponseMessageFolder.calculatePath(node);
        }
        if (path != null) {
            String loc = responseMessage.getLocation();
            if (loc != null) {
                path = loc + " " + path;
            }
            responseMessage.setLocation(path);
        }
        this.addMessage(this.getPlanningResponseMessages(), responseMessage);
    }

    public void appendPlanningResponseMessageIfNotExist(int aSeverity, ResponseMessage.ResponseMessageType aType, IMessageKey.Param1 messageKey, String par1) {
        if (aSeverity <= this.maxSeverityLevel) {
            ResponseMessage responseMsg = new ResponseMessage(1, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_DMRIngoreScopeCalculatedMeasure, par1);
            if (!this.getPlanningResponseMessages().contains(responseMsg)) {
                this.addMessage(this.getPlanningResponseMessages(), responseMsg);
            }
        }
    }

    private static String calculateIndex(IXQEQueryNode node) {
        String indexStr = "";
        if (node != null) {
            IXQEQueryNode parent = node.getParent();
            IXQEQueryNode startNodeOfType = parent.getFirstChildByType(node.getNodeType());
            int startPos = parent.getPositionOfChild(startNodeOfType);
            int pos = parent.getPositionOfChild(node) - startPos + 1;
            if (parent.getNumberChildrenOfType(node.getNodeType()) > 1) {
                indexStr = "[" + Integer.valueOf(pos) + "]";
            }
        }
        return indexStr;
    }

    public static String calculatePath(IXQEQueryNode errorNode) {
        String elementXPath = null;
        block11: for (IXQEQueryNode currentNode = errorNode; currentNode != null; currentNode = currentNode.getParent()) {
            String xpathStepStr = null;
            boolean determinePosition = false;
            switch (currentNode.getNodeType()) {
                case 101003: 
                case 801008: 
                case 801033: 
                case 801035: {
                    String moduleLocation = (String)currentNode.getPropertyValue("moduleLocation");
                    if (moduleLocation != null) {
                        return moduleLocation;
                    }
                    xpathStepStr = "dataItem";
                    determinePosition = true;
                    break;
                }
                case 101013: {
                    xpathStepStr = "filterExpression";
                    break;
                }
                case 101008: {
                    String moduleLocation = (String)currentNode.getPropertyValue("moduleLocation");
                    if (moduleLocation != null) {
                        return moduleLocation;
                    }
                    xpathStepStr = "detailFilters/detailFilter";
                    determinePosition = true;
                    break;
                }
                case 101011: {
                    xpathStepStr = "summaryFilters/summaryFilter";
                    determinePosition = true;
                    break;
                }
                case 101009: {
                    xpathStepStr = "selection";
                    break;
                }
                case 101007: {
                    xpathStepStr = "source";
                    break;
                }
                case 101019: {
                    xpathStepStr = "joinOperation/joinFilter";
                    break;
                }
                case 101006: 
                case 401005: {
                    xpathStepStr = "query";
                    determinePosition = true;
                    break;
                }
                case 101002: {
                    xpathStepStr = "./queries";
                    break;
                }
                default: {
                    continue block11;
                }
            }
            if (determinePosition) {
                xpathStepStr = xpathStepStr + ResponseMessageFolder.calculateIndex(currentNode);
            }
            elementXPath = elementXPath == null ? xpathStepStr : xpathStepStr + SLASH + elementXPath;
            if (currentNode.getNodeType() == 101003) {
                elementXPath = elementXPath + "/expression";
            }
            if (currentNode.getNodeType() == 101002) break;
        }
        return elementXPath;
    }

    public void appendExecutionResponseMessage(ResponseMessage responseMessage) {
        this.addMessage(this.getExecutionResponseMessages(), responseMessage);
    }

    public void appendValidationResponseMessage(ResponseMessage responseMessage) {
        this.addMessage(this.getValidationResponseMessages(), responseMessage);
    }

    public void appendValidationInfoResponseMessage(ResponseMessage.ResponseMessageType aType, String messageStr) {
        this.appendValidationResponseMessage(new ResponseMessage(aType, messageStr));
    }

    public void appendValidationKeyTransformationResponseMessage(ResponseMessage.ResponseMessageType aType, String messageStr) {
        this.appendValidationResponseMessage(new ResponseMessage(2, aType, messageStr));
    }

    public void appendMigrateResponseMessage(String messageStr) {
        this.appendPlanningResponseMessage(new ResponseMessage(1, ResponseMessage.ResponseMessageType.MIGRATE_TYPE_INT, messageStr));
    }

    public boolean toXMLString(RequestEnvironment environment, XMLWriter writer) {
        return this.toXMLString(environment, writer, null);
    }

    public boolean toXMLString(RequestEnvironment environment, XMLWriter writer, Locale aLocale) {
        ArrayList<ResponseMessage> responseMessages = new ArrayList<ResponseMessage>();
        responseMessages.addAll(this.getPlanningResponseMessages());
        responseMessages.addAll(this.getExecutionResponseMessages());
        if (!responseMessages.isEmpty() && this.getMessagesNumber() > 1) {
            Collections.sort(responseMessages);
        }
        responseMessages.addAll(this.getValidationResponseMessages());
        return ResponseMessageFolder.writeMessageFolderToXML(writer, responseMessages, this.getResponseMessageFolders(), aLocale, environment);
    }

    public static boolean writeMessageFolderToXML(XMLWriter writer, List<ResponseMessage> responseMessageList, List<ResponseMessageFolder> responseMessageFolders, Locale aLocale, RequestEnvironment environment) {
        Iterator<ResponseMessage> it = responseMessageList.iterator();
        Iterator<ResponseMessageFolder> folderIt = responseMessageFolders.iterator();
        boolean folderHasContent = false;
        boolean foundError = false;
        if (it.hasNext() || folderIt.hasNext()) {
            while (it.hasNext()) {
                ResponseMessage responseMessage = it.next();
                if (ResponseMessageFolder.suppressMessage(environment, responseMessage.getLocalizedMessage(aLocale))) continue;
                if (!folderHasContent) {
                    folderHasContent = true;
                    writer.beginElement(MESSAGE_FOLDER, -1);
                }
                foundError |= responseMessage.getSeverity() <= 0;
                responseMessage.toXMLString(writer, aLocale);
            }
            while (folderIt.hasNext()) {
                if (!folderHasContent) {
                    folderHasContent = true;
                    writer.beginElement(MESSAGE_FOLDER, -1);
                }
                foundError |= folderIt.next().toXMLString(environment, writer, aLocale);
            }
            if (folderHasContent) {
                writer.endElement();
            }
            writer.flush();
        }
        return foundError;
    }

    private static boolean suppressMessage(RequestEnvironment environment, String message) {
        String[] ignoreList = ((ExecutionEnvironment)environment.getExecutionEnvironment()).getGovernors().getSuppressMessages();
        if (ignoreList != null) {
            for (String regEx : ignoreList) {
                if (!message.matches(regEx)) continue;
                return true;
            }
        }
        return false;
    }

    public final void clearExecutionResponseMessages() {
        this.getExecutionResponseMessages().clear();
    }

    public final int getMessagesNumber() {
        return this.getPlanningResponseMessages().size() + this.getResponseMessageFolders().size() + this.getExecutionResponseMessages().size() + this.getValidationResponseMessages().size();
    }

    private void updateIndicators(int aSeverity, ResponseMessage.ResponseMessageType aType, IMessageKey aCode) {
        String indName = ResponseMessage.severityLevelToString(aSeverity) + SLASH + ResponseMessage.typeToString(aType);
        if (aCode != null) {
            indName = indName + SLASH + aCode.toString();
        }
        IUsageIndicator ind = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.WARNING, indName);
        ind.increment();
    }
}

