/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.engine;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5Exp_new2.parser.SimpleNode;
import com.cognos.xqe.bibushandler.CancelableRequestRegistry;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.trace.CollectXQELogs;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.LoggingConstants;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.IReleasable;
import com.cognos.xqe.util.ParameterMapCM;
import com.cognos.xqe.util.primitive.HashMapLongObject;
import com.cognos.xqe.util.usage.UsageTrackingService;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.TreeMap;
import org.dom4j.Element;

public class SessionContext
extends Observable {
    static final String LOGMSG_STACK_TRACE = "; Stack Trace: ";
    private static final String NULL_MULTI_REQUEST_CONTEXT = "null == multiRequestContext";
    private final String mSessionContextID;
    private RequestEnvironment mRequestEnvironment;
    protected final CancelableRequestRegistry mCancelableRequestRegistry;
    private final Map<String, IDataSource> mDataSourceCache;
    private ParameterMapCM mCMMap = null;
    private final HashMapLongObject<Object> mReferencesById;
    private final List<IReleasable> mResources;
    private MultiRequestContext mMultiRequestContext;
    private MultiRequestContext.RequestProcessing requestProcessing;
    private boolean mReleased;
    private volatile boolean mInUse;
    private volatile long mLastAccessTime;
    private volatile long mLastKeepAliveTime;
    private Map<String, IXQEQueryNode> v5cache = null;
    private Map<String, SimpleNode> newV5cache = null;
    private static final XQELogger SESSION_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Resources.Session", LogLevel.INFO);
    private Element mHeader;
    private File mReportLogsDir = null;
    private Object mSequentialLockObject = new Object();

    public SessionContext(String sessionContextID, RequestEnvironment requestEnv) {
        this.mCancelableRequestRegistry = new CancelableRequestRegistry();
        this.mDataSourceCache = new TreeMap<String, IDataSource>();
        this.mReferencesById = new HashMapLongObject();
        this.mResources = new LinkedList<IReleasable>();
        this.v5cache = new HashMap<String, IXQEQueryNode>();
        this.newV5cache = new HashMap<String, SimpleNode>();
        this.mSessionContextID = sessionContextID;
        this.mRequestEnvironment = requestEnv;
        this.mMultiRequestContext = null;
        this.mReleased = false;
        this.mInUse = false;
        this.mLastAccessTime = System.currentTimeMillis();
        this.mLastKeepAliveTime = 0L;
        this.requestProcessing = MultiRequestContext.RequestProcessing.DEFAULT;
        if (SESSION_LOGGER.isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Created SessionContext:").append(this.getIDSString());
            SESSION_LOGGER.log(LogLevel.INFO, buffer.toString());
        }
    }

    public SessionContext(String sessionContextID) {
        this(sessionContextID, null);
    }

    ParameterMapCM getCmMap() {
        this.assertNotReleased();
        return this.mCMMap;
    }

    void setCmMap(ParameterMapCM cmMap) {
        this.assertNotReleased();
        this.mCMMap = cmMap;
    }

    Map<String, IDataSource> getDataSourceCache() {
        this.assertNotReleased();
        return this.mDataSourceCache;
    }

    HashMapLongObject<Object> getReferencesById() {
        this.assertNotReleased();
        return this.mReferencesById;
    }

    public void registerResource(IReleasable resource) {
        this.assertNotReleased();
        if (resource == null) {
            throw new IllegalStateException("resource == null");
        }
        this.mResources.add(resource);
    }

    public void unregisterResource(IReleasable resource) {
        this.assertNotReleased();
        if (resource == null) {
            throw new IllegalStateException("resource == null ");
        }
        this.mResources.remove(resource);
    }

    MultiRequestContext getMultiRequestContext() {
        return this.mMultiRequestContext;
    }

    void linkMultiRequestContext(MultiRequestContext multiRequestContext) throws XQERuntimeException {
        if (null == multiRequestContext) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, NULL_MULTI_REQUEST_CONTEXT);
        }
        if (null != this.mMultiRequestContext) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "null != mMultiRequestContext");
        }
        this.mMultiRequestContext = multiRequestContext;
        this.mMultiRequestContext.setRequestProcessing(this.requestProcessing);
    }

    void unlinkMultiRequestContext(MultiRequestContext multiRequestContext) throws XQERuntimeException {
        if (this.mReleased) {
            if (null != this.mMultiRequestContext) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "null != multiRequestContext");
            }
        } else {
            if (null == multiRequestContext) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, NULL_MULTI_REQUEST_CONTEXT);
            }
            if (multiRequestContext != this.mMultiRequestContext) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "multiRequestContext != mMultiRequestContext");
            }
            this.requestProcessing = this.mMultiRequestContext.getRequestProcessing();
            this.mMultiRequestContext = null;
        }
    }

    public String getSessionContextID() {
        return this.mSessionContextID;
    }

    public String getRequestID() {
        if (this.mRequestEnvironment == null) {
            return null;
        }
        return this.mRequestEnvironment.getRequestID();
    }

    public void setRequestEnvironment(RequestEnvironment reqEnv) {
        this.mRequestEnvironment = reqEnv;
    }

    public RequestEnvironment getRequestEnvironment() {
        return this.mRequestEnvironment;
    }

    public String getReportName() {
        if (this.mRequestEnvironment == null) {
            return "";
        }
        return this.mRequestEnvironment.getReportName();
    }

    public boolean isInUse() {
        return this.mInUse;
    }

    public void setInUse(boolean inUse) {
        this.mInUse = inUse;
    }

    long getLastAccessTime() {
        return this.mLastAccessTime;
    }

    void setLastAccessTime(long lastAccessTime) {
        this.mLastAccessTime = lastAccessTime;
    }

    long getLastKeepAliveTime() {
        return this.mLastKeepAliveTime;
    }

    void setLastKeepAliveTime(long lastKeepAliveTime) {
        this.mLastKeepAliveTime = lastKeepAliveTime;
    }

    public boolean accessedOrKeptAliveSince(long timeStamp) {
        boolean live;
        long accTime = this.mLastAccessTime;
        long keepTime = this.mLastKeepAliveTime;
        boolean bl = live = accTime >= timeStamp || keepTime >= timeStamp;
        if (!live) {
            long currTime = System.currentTimeMillis();
            String str = String.format("Session %s is expiring:\n  Current time: %s (%,d ms)\n  Last valid time: %s (%,d ms)\n  Last accessed: %s (%,d ms)\n  Last keep-alive: %s (%,d ms)", this.mSessionContextID, LoggingConstants.TIMESTAMP_FORMAT.format((Object)currTime), currTime, LoggingConstants.TIMESTAMP_FORMAT.format((Object)timeStamp), timeStamp, LoggingConstants.TIMESTAMP_FORMAT.format((Object)accTime), accTime, LoggingConstants.TIMESTAMP_FORMAT.format((Object)keepTime), keepTime);
            SESSION_LOGGER.log(LogLevel.ERROR, str);
        }
        return live;
    }

    public String getIDSString() {
        String reqID = null;
        if (this.mRequestEnvironment != null) {
            reqID = this.mRequestEnvironment.getRequestID();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.mSessionContextID).append(':').append(reqID);
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (this.mReleased) {
            return;
        }
        try {
            IReleasable[] resourcesArray;
            StringBuilder buffer = new StringBuilder();
            if (SESSION_LOGGER.isOn(LogLevel.INFO)) {
                buffer.append("Releasing SessionContext with id=").append(this.getIDSString());
                SESSION_LOGGER.log(LogLevel.INFO, buffer.toString());
            }
            try {
                this.setChanged();
                this.notifyObservers();
                CollectXQELogs l = new CollectXQELogs(this.getReportLogsDir());
                l.logUsage(UsageTrackingService.getReportName(this));
            }
            catch (Throwable ex) {
                buffer.delete(0, buffer.length()).append("An error occurred while notifying observers of SessionContext with id=").append(this.getIDSString()).append(LOGMSG_STACK_TRACE);
                SESSION_LOGGER.log(LogLevel.ERROR, buffer.toString(), ex);
            }
            for (IReleasable resource : resourcesArray = this.mResources.toArray(new IReleasable[0])) {
                try {
                    resource.release();
                }
                catch (Throwable ex) {
                    buffer.delete(0, buffer.length()).append("An error occurred while releasing a resource from SessionContext with id=").append(this.getIDSString()).append(LOGMSG_STACK_TRACE);
                    SESSION_LOGGER.log(LogLevel.ERROR, buffer.toString(), ex);
                }
            }
        }
        finally {
            this.mDataSourceCache.clear();
            this.mReferencesById.clear();
            this.mResources.clear();
            this.v5cache.clear();
            this.mCMMap = null;
            this.mMultiRequestContext = null;
            this.mReleased = true;
            this.v5cache = null;
        }
    }

    private void assertNotReleased() {
        if (this.mReleased) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ResourceWasReleased);
        }
    }

    public CancelableRequestRegistry getCancelableRequestRegistry() {
        return this.mCancelableRequestRegistry;
    }

    public Element getBIBusHeader() {
        return this.mHeader;
    }

    public void setBIBusHeader(Element header) {
        this.mHeader = header;
    }

    public IXQEQueryNode getV5(String expression) {
        this.assertNotReleased();
        return this.v5cache.get(expression);
    }

    public void cacheV5(String expression, IXQEQueryNode node) {
        this.assertNotReleased();
        this.v5cache.put(expression, node);
    }

    public SimpleNode getNewV5(String expression) {
        this.assertNotReleased();
        return this.newV5cache.get(expression);
    }

    public void cacheNewV5(String expression, SimpleNode node) {
        this.assertNotReleased();
        this.newV5cache.put(expression, node);
    }

    public String toString() {
        long now = System.currentTimeMillis();
        String keepAliveTime = "<no keepalive sent>";
        if (this.mLastKeepAliveTime != 0L) {
            keepAliveTime = String.format("%s (ms)", now - this.mLastKeepAliveTime);
        }
        String msg = String.format("SessionContext %s:\n   In use: %s\n   Time since last access: %d (ms)\n   Time since last keepalive: %s\n", this.mSessionContextID, Boolean.toString(this.mInUse), now - this.mLastAccessTime, keepAliveTime);
        return msg;
    }

    public void setReportLogsDir(File logDirectory) {
        this.mReportLogsDir = logDirectory;
    }

    public File getReportLogsDir() {
        return this.mReportLogsDir;
    }

    public Object getSequentailLockObject() {
        return this.mSequentialLockObject;
    }
}

