/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.engine;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.TransformationEngineException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.usage.UsageTrackingService;
import com.cognos.xqe.util.usage.indicators.IUsageIndicator;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorCategory;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorType;
import com.cognos.xqeqte.QTEAbstractTransformation;
import com.cognos.xqeqte.QTESharedPassNumbers;

public abstract class Transformation
extends QTEAbstractTransformation<IXQEQueryNode, IPlanningEnvironment> {
    public static final String PASSES_QUERY_CONDITION = "passesQueryCondition";
    public static final String PASSES_NODE_CONDITION = "passesNodeCondition";
    private static final String VALUE_TRUE = "true";
    private static final String VALUE_FALSE = "false";
    private static final String REASON = "reason";
    private IUsageIndicator usageCount;
    private IUsageIndicator reportUsageCount;
    private IUsageIndicator passTime;
    private IUsageIndicator failTime;
    private IUsageIndicator applyTime;
    private long mPassesTime = 0L;
    private long mApplyTime = 0L;

    public Transformation() {
        this.initUsageCount();
    }

    public Transformation(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.initUsageCount();
    }

    private void initUsageCount() {
        if (UsageTrackingService.transformationUsageTrackingEnabled()) {
            String name = this.getClass().getCanonicalName().substring("com.cognos.xqe.transformation.".length()).replace('.', '/');
            this.usageCount = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.TRANSFORMATION, name);
            this.reportUsageCount = UsageTrackingService.getIndicator(UsageIndicatorType.ONCE_PER_REPORT_INDICATOR, UsageIndicatorCategory.REPORTS_PER_TRANSFORMATION, name);
            this.passTime = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.TRANSFORMATION_PASS_TIME, name);
            this.failTime = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.TRANSFORMATION_FAIL_TIME, name);
            this.applyTime = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.TRANSFORMATION_APPLY_TIME, name);
        }
    }

    @Override
    public void incrementUsage() {
        if (UsageTrackingService.transformationUsageTrackingEnabled()) {
            if (this.usageCount == null) {
                this.initUsageCount();
            }
            this.usageCount.increment();
            this.reportUsageCount.increment();
        }
    }

    @Override
    public void beginPassesNodeConditionUsage() {
        if (UsageTrackingService.transformationUsageTrackingEnabled()) {
            if (this.passTime == null || this.failTime == null) {
                this.initUsageCount();
            }
            this.mPassesTime = System.currentTimeMillis();
        }
    }

    @Override
    public void endPassesNodeConditionUsage(boolean pass) {
        long ms;
        if (UsageTrackingService.transformationUsageTrackingEnabled() && (ms = System.currentTimeMillis() - this.mPassesTime) > 0L) {
            if (this.passTime == null || this.failTime == null) {
                this.initUsageCount();
            }
            if (pass) {
                this.passTime.add(ms);
            } else {
                this.failTime.add(ms);
            }
        }
    }

    @Override
    public void beginApplyUsage() {
        if (UsageTrackingService.transformationUsageTrackingEnabled()) {
            if (this.applyTime == null) {
                this.initUsageCount();
            }
            this.mApplyTime = System.currentTimeMillis();
        }
    }

    @Override
    public void endApplyUsage() {
        long ms;
        if (UsageTrackingService.transformationUsageTrackingEnabled() && (ms = System.currentTimeMillis() - this.mApplyTime) > 0L) {
            if (this.applyTime == null) {
                this.initUsageCount();
            }
            this.applyTime.add(ms);
        }
    }

    @Override
    protected void handleNoOpTransformation() throws TransformationEngineException {
        StringBuilder transfName = new StringBuilder();
        transfName.append(this.getTransformationLibrary().getLibraryName());
        transfName.append(" - ");
        transfName.append(this.getClass().getSimpleName());
        if (this.getApplicableIterations() == QTEAbstractTransformation.ApplicableIterations.UNLIMITED) {
            throw new TransformationEngineException(XQEMessageKeys.QTE_NoOpTransformation, transfName.toString());
        }
        XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "QueryEngine", LogLevel.WARN);
        if (logger.getLogLevel() == LogLevel.INFO || logger.getLogLevel() == LogLevel.TRACE) {
            TransformationEngineException e = new TransformationEngineException(XQEMessageKeys.QTE_NoOpTransformation, transfName.toString());
            logger.log(LogLevel.INFO, (Throwable)e);
        } else {
            XQEMessage fmtMsg = new XQEMessage(XQEMessageKeys.QTE_NoOpTransformation, transfName.toString(), (IXQEQueryNode)null);
            logger.log(fmtMsg.getTitle(null));
        }
    }

    @Override
    protected boolean transformationNamePreceededByLibraryName() {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        if (configuration == null) {
            return false;
        }
        return configuration.getBooleanProperty("transformations[@namePreceededByLibrary]", true);
    }

    public final void traceQueryCondition(boolean status, String reason, XQETrace trace) {
        if (status) {
            if ((trace.getTraceLevel() & 2) != 0) {
                trace.beginElement(PASSES_QUERY_CONDITION);
                trace.attribute("pass", VALUE_TRUE);
                trace.attribute(REASON, reason);
                trace.endElement();
            }
        } else if ((trace.getTraceLevel() & 4) != 0) {
            trace.beginElement(PASSES_QUERY_CONDITION);
            trace.attribute("pass", VALUE_FALSE);
            trace.attribute(REASON, reason);
            trace.endElement();
        }
    }

    public final void traceNodeCondition(boolean status, String reason, XQETrace trace) {
        if (status) {
            if ((trace.getTraceLevel() & 2) != 0) {
                trace.beginElement(PASSES_NODE_CONDITION);
                trace.attribute("pass", VALUE_TRUE);
                trace.attribute(REASON, reason);
                trace.endElement();
            }
        } else if ((trace.getTraceLevel() & 4) != 0) {
            trace.beginElement(PASSES_NODE_CONDITION);
            trace.attribute("pass", VALUE_FALSE);
            trace.attribute(REASON, reason);
            trace.endElement();
        }
    }

    public static final void traceExceptionMessage(Throwable t, XQETrace trace) {
        if (trace.getTraceLevel() != 0) {
            trace.beginElement("exceptionMessage");
            trace.data(t.getLocalizedMessage());
            trace.endElement();
        }
    }

    public void dump(XQETrace trace) {
        trace.beginElement("transformation");
        trace.attribute("name", this.getName());
        trace.attribute("className", this.getClass().getName());
        this.dumpSpecificationReferences(trace);
        trace.endElement();
    }

    public void dumpSpecificationReferences(XQETrace trace) {
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        this.apply(node, (PlanningEnvironment)environment);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        return this.passesNodeCondition(node, (PlanningEnvironment)environment);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        return this.passesQueryCondition(node, (PlanningEnvironment)environment);
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
    }

    public void applyToCompiledPlan(IXQEQueryNode node, PlanningEnvironment environment) {
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status = true;
        XQETrace trace = environment.getTrace();
        this.traceNodeCondition(status, "No Node Condition", trace);
        return status;
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status = true;
        XQETrace trace = environment.getTrace();
        this.traceQueryCondition(status, "No Query Condition", trace);
        return status;
    }
}

