/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.engine;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.bibushandler.CancelManager;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.TransformationEngineException;
import com.cognos.xqe.query.engine.TransformationEventListener;
import com.cognos.xqe.query.engine.TransformationLibraryManager;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqe.zipi.ZipiContext;
import com.cognos.xqeqte.QTETransformationEngine;
import com.cognos.xqeqte.QTETransformationLibraryManager;
import com.cognos.xqeqte.exceptions.QTEEmptyQueryTreeException;
import com.cognos.xqeqte.exceptions.QTEMaximumNodesExceededException;
import com.cognos.xqeqte.exceptions.QTENoApplicableTransformationsForLockedNodeException;
import com.cognos.xqeqte.exceptions.QTENoOpTransformationAppliedException;
import com.cognos.xqeqte.exceptions.QTENoPlanningEnvironmentException;
import com.cognos.xqeqte.exceptions.QTENodeNotAddedToTreeException;
import com.cognos.xqeqte.exceptions.QTEPlanningTimeoutException;
import com.cognos.xqeqte.exceptions.QTETransformationAppliedTwiceToSameNodeException;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.util.Map;
import java.util.Random;

public final class TransformationEngine
extends QTETransformationEngine<IXQEQueryNode, IPlanningEnvironment> {
    static final String STRING_QUERY = "query";
    static final String STRING_PASS = "pass";
    static final String STRING_PASS_NAME = "passName";
    static final String STRING_PASS_NUMBER = "passNumber";
    static final String STRING_N_TRANSFORMS_APPLIED = "nTransformsApplied";
    static final String STRING_NAME = "name";
    static final String STRING_NODE_TYPE = "nodeType";
    private static final String STRING_XQE_RANDOMIZE_TRANSFORMATIONS = "_XQE_RANDOMIZE_TRANSFORMATIONS";
    public static final int TRACE_QUERY_NODE_CHANGES = 256;
    public static final int TRACE_QUERY_EXECUTION = 512;
    public static final int TRACE_ITERATOR_PROFILING = 1024;
    public static final int TRACE_COMPLEX_NODE_PROPERTIES = 64;
    public static final int TRACE_RUNTREE = 128;
    public static final int TRACE_RUNTREE_EXECUTION = 2048;
    public static final int TRACE_QUERY_PLANNING = 1;
    public static final int TRACE_WHY_TRANSFORMATION_APPLIED = 2;
    public static final int TRACE_WHY_TRANSFORMATION_NOT_APPLIED = 4;
    public static final int TRACE_TREE_AFTER_TRANSFORMATION = 8;
    public static final int TRACE_ALL = -1;
    private static final int DEFAULT_QUERY_NODE_MULTIPLIER_LIMIT = 0;
    private static final int DEFAULT_QUERY_NODE_INDEX_MULTIPLIER_LIMIT = 0;
    private static final int DEFAULT_QUERY_PLANNING_TIME_LIMIT = 0;
    private static TransformationEngine instance = new TransformationEngine();

    public static TransformationEngine getInstance() {
        return instance;
    }

    private TransformationEngine() {
    }

    @Override
    protected void loadConfigurationInformation(IPlanningEnvironment environment) {
        XQEConfiguration configuration;
        if ((environment.getTrace().getTraceLevel() & 1) != 0) {
            environment.getTrace().addTraceLevel(256);
        }
        if ((configuration = environment.getMultiRequestContext().getXQEConfiguration()) == null) {
            return;
        }
        this.loadRandomizeConfigurationSettings(environment);
        this.loadQueryPlanningConfigurationSettings(environment);
    }

    @Override
    protected void checkIfRequestCancelled(IPlanningEnvironment environment) {
        CancelManager cancelMgr = environment.getExecutionEnvironment().getCancelManager();
        if (cancelMgr.isRequestCancelled()) {
            throw new OperationCanceledException();
        }
    }

    @Override
    public boolean applyTransformations(IXQEQueryNode root, IPlanningEnvironment environment) throws XQERuntimeException {
        if (this.getTransformationLibraryManager() == null) {
            this.setTransformationLibraryManager(TransformationLibraryManager.getInstance());
        }
        if (this.getEventListener() == null) {
            this.setEventListener(new TransformationEventListener(this.getTransformationLibraryManager()));
        }
        String objPath = "";
        if (root != null) {
            objPath = root.getNodeTypeName();
        }
        ZipiTimer zipiTimer = ZipiBridge.startTimer("DQQueryPlanning", objPath, ZipiContext.getQRDName());
        try {
            boolean bl = super.applyTransformations(root, environment);
            return bl;
        }
        catch (QTEEmptyQueryTreeException e) {
            throw new TransformationEngineException(XQEMessageKeys.QTE_EmptyQueryTree);
        }
        catch (QTENoPlanningEnvironmentException e) {
            throw new TransformationEngineException(XQEMessageKeys.QTE_EmptyQueryTree);
        }
        catch (QTENoApplicableTransformationsForLockedNodeException e) {
            throw new TransformationEngineException(XQEMessageKeys.QTE_NoApplicableTransformationsForLockedNode, e.getNodeTypeName());
        }
        catch (QTENodeNotAddedToTreeException e) {
            throw new TransformationEngineException(XQEMessageKeys.QTE_NodeNotAddedToTree, e.getClassName());
        }
        catch (QTEMaximumNodesExceededException e) {
            throw new TransformationEngineException(XQEMessageKeys.QTE_MaximumNodesExceeded, e.getMaxNodes());
        }
        catch (QTEPlanningTimeoutException e) {
            throw new TransformationEngineException(XQEMessageKeys.QTE_PlanningTimeout, e.getPlanningTimeLimit());
        }
        catch (QTENoOpTransformationAppliedException e) {
            throw new TransformationEngineException(XQEMessageKeys.QTE_NoOpTransformation, e.getTransformation().getName());
        }
        catch (QTETransformationAppliedTwiceToSameNodeException e) {
            throw new TransformationEngineException(XQEMessageKeys.QTE_TransformationAppliedTwiceToSameNode, e.getTransformationName(), e.getNodeId());
        }
        finally {
            if (zipiTimer != null) {
                zipiTimer.stop();
            }
        }
    }

    QTETransformationLibraryManager<IXQEQueryNode, IPlanningEnvironment> getLibraryManager() {
        return this.libraryManager;
    }

    private void loadRandomizeConfigurationSettings(IPlanningEnvironment environment) {
        Map<String, String> envVars = System.getenv();
        MultiRequestContext multiRequestContext = environment.getMultiRequestContext();
        if (envVars.containsKey(STRING_XQE_RANDOMIZE_TRANSFORMATIONS) && envVars.get(STRING_XQE_RANDOMIZE_TRANSFORMATIONS).equalsIgnoreCase("Y") || multiRequestContext.fetchBooleanConfiguration("queryPlanning.randomizeTransformations[@enabled]", false)) {
            environment.setRandomizeTransformations(true);
            Object reqEnv = environment.getRequestEnvironment();
            if (!reqEnv.isRandomSeedSet()) {
                int newRandomSeed = multiRequestContext.fetchgetIntConfiguration("queryPlanning.randomizeTransformations[@seed]", 0);
                if (newRandomSeed == 0) {
                    Random seedGenerator = new Random();
                    newRandomSeed = seedGenerator.nextInt();
                }
                reqEnv.setRandomSeed(newRandomSeed);
            }
            environment.setRandom(new Random(reqEnv.getRandomSeed()));
        } else {
            environment.setRandomizeTransformations(false);
        }
    }

    private void loadQueryPlanningConfigurationSettings(IPlanningEnvironment environment) {
        if (!environment.getLoadingOfConfigurationInformation()) {
            return;
        }
        MultiRequestContext multiRequestContext = environment.getMultiRequestContext();
        int queryPlanningTimeLimit = multiRequestContext.fetchgetIntConfiguration("queryPlanning.queryPlanningTimeLimit[@value]", 0);
        environment.setQueryPlanningTimeLimit(queryPlanningTimeLimit);
        int queryNodeMultiplierLimit = multiRequestContext.fetchgetIntConfiguration("queryPlanning.queryNodeMultiplierLimit[@value]", 0);
        environment.setQueryNodeMultiplierLimit(queryNodeMultiplierLimit);
        int queryNodeIndexMultiplierLimit = multiRequestContext.fetchgetIntConfiguration("queryPlanning.queryNodeIndexMultiplierLimit[@value]", 0);
        environment.setQueryNodeIndexMultiplierLimit(queryNodeIndexMultiplierLimit);
        if (multiRequestContext.fetchBooleanConfiguration("queryPlanning.checkTransformationAppliedTwice[@value]", false)) {
            environment.setCheckTransformationAppliedTwiceToNodeInSamePass(0);
        } else {
            environment.setCheckTransformationAppliedTwiceToNodeInSamePass(1);
        }
    }
}

