/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.engine;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.util.usage.UsageTrackingService;
import com.cognos.xqe.util.usage.indicators.IUsageIndicator;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorCategory;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorType;
import com.cognos.xqeqte.QTETransformationLibrary;

public abstract class TransformationLibrary
extends QTETransformationLibrary<IXQEQueryNode, IPlanningEnvironment> {
    private long mStartTime = 0L;
    private IUsageIndicator passTime;
    private IUsageIndicator failTime;

    public TransformationLibrary(int startingPassNumber, int numberOfPasses) {
        super(startingPassNumber, numberOfPasses);
    }

    private void initUsageCount() {
        if (UsageTrackingService.transformationUsageTrackingEnabled()) {
            String name = this.getClass().getCanonicalName().substring("com.cognos.xqe.transformation.".length()).replace('.', '/');
            this.passTime = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.LIBRARY_PASS_TIME, name);
            this.failTime = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.LIBRARY_FAIL_TIME, name);
        }
    }

    @Override
    public void beginPassesConditionUsage() {
        if (UsageTrackingService.transformationUsageTrackingEnabled()) {
            if (this.passTime == null || this.failTime == null) {
                this.initUsageCount();
            }
            this.mStartTime = System.currentTimeMillis();
        }
    }

    @Override
    public void endPassesConditionUsage(boolean pass) {
        long ms;
        if (UsageTrackingService.transformationUsageTrackingEnabled() && (ms = this.mStartTime - System.currentTimeMillis()) > 0L) {
            if (this.passTime == null || this.failTime == null) {
                this.initUsageCount();
            }
            if (pass) {
                this.passTime.add(ms);
            } else {
                this.failTime.add(ms);
            }
        }
    }
}

