/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.engine;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Fault;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.query.engine.UnresolvedParametersException;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqemoser.MoserParameterUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.dom4j.Element;

public class UnresolvedParameterException
extends UnresolvedParametersException {
    private static final long serialVersionUID = 1L;
    private static final String CODE = "code";
    private final IXQEQueryNode planTree;
    private final Parameters unresolvedParameters;
    private String retJSONResponse = null;

    public UnresolvedParameterException(IRequestEnvironment reqEnv, IXQEQueryNode aPlanTree, Parameters parameters) {
        super(XQEMessageKeys.QTE_UnresolvedParameterFound, parameters.asString());
        this.planTree = aPlanTree;
        this.unresolvedParameters = parameters;
    }

    @Override
    public String getFaultCode() {
        ParameterErrorCodeEnum errorCode = this.parametersHaveBadValue() ? ParameterErrorCodeEnum.INVALID_FORMAT : ParameterErrorCodeEnum.PROMPTS_NEEDED;
        return "QF-" + errorCode.getFaultCode().getFaultCodeInt();
    }

    @Override
    public String getFaultString() {
        String localizedMessage = XQEMessages.getMessage(XQEMessageKeys.PLN_NeedToResolvePrompts, XQEMessages.getCurrProductLocale());
        TreeMap<String, Parameter> orderedParams = new TreeMap<String, Parameter>(this.unresolvedParameters);
        for (Map.Entry<String, Parameter> entry : orderedParams.entrySet()) {
            Parameter parameter = entry.getValue();
            localizedMessage = localizedMessage + System.getProperty("line.separator");
            localizedMessage = localizedMessage + this.generateParameterErrorMesage(parameter);
        }
        return localizedMessage;
    }

    protected String generateParameterErrorMesage(Parameter param) {
        String errMsg = "";
        if (param.getErrorCode() != null) {
            switch (param.getErrorCode()) {
                case INVALID_FORMAT: {
                    String promptName = param.getName();
                    if (param.getDataType().isNumeric()) {
                        errMsg = XQEMessages.getMessage(XQEMessageKeys.PLN_ErrorInvalidFormatForNumeric, XQEMessages.getCurrProductLocale(), promptName);
                        break;
                    }
                    if (param.getDataType().isDate()) {
                        errMsg = XQEMessages.getMessage(XQEMessageKeys.PLN_ErrorInvalidFormatForDate, XQEMessages.getCurrProductLocale(), promptName);
                        break;
                    }
                    if (param.getDataType().isTime()) {
                        errMsg = XQEMessages.getMessage(XQEMessageKeys.PLN_ErrorInvalidFormatForTime, XQEMessages.getCurrProductLocale(), promptName);
                        break;
                    }
                    if (param.getDataType().isInterval()) {
                        errMsg = XQEMessages.getMessage(XQEMessageKeys.PLN_ErrorInvalidFormatForInterval, XQEMessages.getCurrProductLocale(), promptName);
                        break;
                    }
                    if (param.getDataType().isTimestamp()) {
                        errMsg = XQEMessages.getMessage(XQEMessageKeys.PLN_ErrorInvalidFormatForDateTime, XQEMessages.getCurrProductLocale(), promptName);
                        break;
                    }
                    errMsg = XQEMessages.getMessage(XQEMessageKeys.PLN_ErrorInvalidFormatForUnknownType, XQEMessages.getCurrProductLocale(), promptName);
                    break;
                }
                case NIL_VALUE_REQ_PROMPT: {
                    String promptName = param.getName();
                    errMsg = XQEMessages.getMessage(XQEMessageKeys.PLN_NilValueForRequiredPrompt, XQEMessages.getCurrProductLocale(), promptName);
                }
            }
        }
        return errMsg;
    }

    @Override
    public BIBusEnvelope getFaultEnvelope() {
        BIBusEnvelope faultEnvelope = new BIBusEnvelope();
        faultEnvelope.createFaultElement(this.getFaultCode(), this.getFaultString());
        Element responseElement = null;
        if (this.retJSONResponse == null) {
            responseElement = this.getUnresolvedParametersResponse(false);
            Element detailElement = faultEnvelope.getFaultDetail();
            detailElement.add(responseElement);
        } else {
            Element detailElement = faultEnvelope.getFaultDetail();
            detailElement.setText(this.retJSONResponse);
        }
        return faultEnvelope;
    }

    @Override
    public Fault getFault() {
        return this.getFaultFromEnvelope();
    }

    @Override
    public String getResult() {
        BIBusEnvelope envelope = this.getFaultEnvelope();
        String sResult = new String();
        try {
            sResult = envelope.getAsString();
        }
        catch (IOException e) {
            sResult = "";
        }
        return sResult;
    }

    public Element getUnresolvedParametersResponse(boolean includeInfo) {
        return this.unresolvedParameters.generateDOMResponse(includeInfo);
    }

    public Element getUnresolvedParametersResponse(Set<String> queries) {
        return this.unresolvedParameters.getUnresolvedParameters(queries).generateDOMResponse(false);
    }

    public final IXQEQueryNode getPlanTree() {
        return this.planTree;
    }

    private boolean parametersHaveBadValue() {
        return this.unresolvedParameters.hasParameterWithBadValue();
    }

    public Parameters getUnresolvedParameters() {
        return this.unresolvedParameters;
    }

    public JSONObject getUnresolvedParametersResponseJSON(boolean includeInfo) {
        JSONObject jResponse = new JSONObject();
        JSONArray jItems = new JSONArray();
        jResponse.put((Object)"msg", (Object)jItems);
        JSONObject jResult = new JSONObject();
        jItems.add((Object)jResult);
        jResult.put((Object)"severity", (Object)"error");
        jResult.put((Object)"exception", (Object)this.getClass().getSimpleName());
        jResult.put((Object)CODE, (Object)this.getFaultCode());
        jResult.put((Object)"msg", (Object)this.getFaultString());
        if (this.unresolvedParameters != null && this.unresolvedParameters.size() > 0) {
            this.unresolvedParameters.appendUnresolvedParametersResponseJSON(includeInfo, jResult);
        }
        return jResponse;
    }

    public void setJSONResponse() {
        this.retJSONResponse = this.getUnresolvedParametersResponseJSON(false).toString();
    }

    public void setJSONResponseMoserXSD() {
        this.retJSONResponse = MoserParameterUtil.generatePromptFault(this);
    }

    public static enum ParameterErrorCodeEnum {
        PROMPTS_NEEDED(1, ParameterFaultCodeEnum.PROMPTS_NEEDED),
        CONFLICTING_DATATYPES(2, ParameterFaultCodeEnum.PROMPTS_NEEDED),
        NO_SUBSTITUTION_VALUES(3, ParameterFaultCodeEnum.PROMPTS_NEEDED),
        UNKNOWN_DATATYPE(4, ParameterFaultCodeEnum.PROMPTS_NEEDED),
        INVALID_FORMAT(5, ParameterFaultCodeEnum.INVALID_FORMAT),
        NIL_VALUE_REQ_PROMPT(6, ParameterFaultCodeEnum.PROMPTS_NEEDED);

        private int errorCode;
        private ParameterFaultCodeEnum theFault;

        private ParameterErrorCodeEnum(int code, ParameterFaultCodeEnum fault) {
            this.errorCode = code;
            this.theFault = fault;
        }

        public int getErrorCodeInt() {
            return this.errorCode;
        }

        public ParameterFaultCodeEnum getFaultCode() {
            return this.theFault;
        }
    }

    public static enum ParameterFaultCodeEnum {
        PROMPTS_NEEDED(888),
        INVALID_FORMAT(892);

        private int faultCode;

        private ParameterFaultCodeEnum(int code) {
            this.faultCode = code;
        }

        public int getFaultCodeInt() {
            return this.faultCode;
        }
    }
}

