/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.executor;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIPartialDataset;
import com.cognos.xqe.util.datasets.DatasetBuilder;
import com.cognos.xqe.util.datasets.DatasetBuilderFactory;
import com.cognos.xqe.util.usage.UsageTrackingService;
import com.cognos.xqe.util.usage.indicators.IUsageIndicator;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorCategory;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorType;
import com.cognos.xqe.zipi.ZipiBridge;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;

public final class QueryExecutor {
    private static QueryExecutor instance = new QueryExecutor();

    private QueryExecutor() {
    }

    public static QueryExecutor getInstance() {
        return instance;
    }

    public RSAPIPartialDataset execute(Element masterDatasetElement, RSAPIDataset masterDataset, IExecutionEnvironment environment, boolean reExecute) throws XQEException {
        IUsageIndicator simpleReportCount;
        long startExecuteTime = System.currentTimeMillis();
        if (masterDataset != null) {
            ZipiBridge.setZipiContextAndObjPath(masterDataset.getName());
        }
        String includeContextValues = masterDatasetElement.attributeValue("includeContextValues");
        String includeContext = masterDatasetElement.attributeValue("includeContext");
        if (includeContextValues == null) {
            throw new XQEException();
        }
        if (includeContext == null) {
            throw new XQEException();
        }
        List edgeElements = masterDatasetElement.elements("edge");
        int[] startRowNumber = new int[edgeElements.size()];
        int[] numRows = new int[edgeElements.size()];
        Iterator edgeIterator = edgeElements.iterator();
        int i = 0;
        while (edgeIterator.hasNext()) {
            Element edgeElement = (Element)edgeIterator.next();
            String sizeStr = edgeElement.attributeValue("size");
            if (sizeStr == null) {
                throw new XQEException();
            }
            String startStr = edgeElement.attributeValue("start");
            if (startStr == null) {
                throw new XQEException();
            }
            try {
                startRowNumber[i] = Integer.parseInt(startStr);
                numRows[i] = Integer.parseInt(sizeStr);
            }
            catch (NumberFormatException e) {
                throw new XQEException(e);
            }
            ++i;
        }
        masterDataset.getPlanningEnvironment().setPlanningActive(environment.getRequestEnvironment());
        RSAPIPartialDataset partialDataset = masterDataset.getPartialDataset(startRowNumber, numRows, Boolean.valueOf(includeContext), Boolean.valueOf(includeContextValues), environment, reExecute);
        masterDataset.clearPlanningEnvironment();
        long executeTime = System.currentTimeMillis() - startExecuteTime;
        IUsageIndicator executeTimeIndicator = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.EXECUTE_TIME, environment.getRequestEnvironment().getReportName());
        if (executeTimeIndicator != null) {
            executeTimeIndicator.add(executeTime);
        }
        if ((simpleReportCount = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.REPORT, environment.getRequestEnvironment().getReportName())) != null) {
            simpleReportCount.increment();
        }
        return partialDataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RSAPIPartialDataset getPartialDataset(RSAPIDataset masterDataset, int[] startRowNumber, int[] numRows, boolean includeContext, boolean includeContextValues, IExecutionEnvironment environment) {
        masterDataset.getPlanningEnvironment().setPlanningActive(environment.getRequestEnvironment());
        try {
            RSAPIPartialDataset partialDataset;
            RSAPIPartialDataset rSAPIPartialDataset = partialDataset = masterDataset.getPartialDataset(startRowNumber, numRows, includeContext, includeContextValues, environment, false);
            return rSAPIPartialDataset;
        }
        finally {
            masterDataset.getPlanningEnvironment().setPlanningInactive();
        }
    }

    public String executeDatasetOperation(RSAPIDataset masterDataset, IExecutionEnvironment environment) {
        if (!XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE).getBooleanProperty("general.datasetOperations[@enabled]", true)) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Dataset operations are not supported.");
        }
        masterDataset.getPlanningEnvironment().setPlanningActive(environment.getRequestEnvironment());
        RSAPIPartialDataset resultset = null;
        try {
            if (!masterDataset.isListReport()) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Dataset is only supported on top of list report.");
            }
            int[] allRows = new int[masterDataset.getNumEdges()];
            resultset = masterDataset.getPartialDataset(allRows, allRows, false, false, environment, false);
            DatasetBuilder builder = DatasetBuilderFactory.getBuilder("parquet", environment);
            String datasetName = masterDataset.getRefQueryName();
            builder.deleteDataset(datasetName);
            String string = builder.createDataset(masterDataset, resultset, datasetName);
            return string;
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
        finally {
            masterDataset.clearPlanningEnvironment();
            if (null != resultset) {
                resultset.release();
            }
        }
    }
}

