/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.masterdetail;

import com.cognos.xqe.ast.IXQEPersist;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.result.V5MasterDetailLink;
import com.cognos.xqe.query.masterdetail.MasterDetailLink;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class MasterDetailQuery
implements IXQEPersist {
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ELEMENT_MD_LINKS = "mdLinks";
    private String name = new String();
    private final Map<String, MasterDetailLink> mdLinks = new TreeMap<String, MasterDetailLink>();

    public MasterDetailQuery(String aname) {
        this.name = aname;
    }

    public MasterDetailQuery() {
    }

    public String addLink(V5MasterDetailLink linkNode, V5QuerySet querySet) {
        MasterDetailLink mdLink = new MasterDetailLink(linkNode, querySet);
        String linkName = mdLink.getName();
        if (this.mdLinks.get(linkName) == null) {
            this.mdLinks.put(linkName, mdLink);
        }
        return linkName;
    }

    public String getName() {
        return this.name;
    }

    public MasterDetailLink getLink(String linkName) {
        return this.mdLinks.get(linkName);
    }

    public boolean isDetailQrd(String qrdName) {
        for (MasterDetailLink mdLink : this.mdLinks.values()) {
            if (!mdLink.getDetailQrdName().equals(qrdName)) continue;
            return true;
        }
        return false;
    }

    public boolean isDetailQuery(String queryName) {
        for (MasterDetailLink mdLink : this.mdLinks.values()) {
            if (!mdLink.getDetailQueryName().equals(queryName)) continue;
            return true;
        }
        return false;
    }

    public boolean isMasterQuery(String queryName) {
        for (MasterDetailLink mdLink : this.mdLinks.values()) {
            if (!mdLink.getMasterQueryName().equals(queryName)) continue;
            return true;
        }
        return false;
    }

    public String getDetailQueryName(String qrdName) {
        for (MasterDetailLink mdLink : this.mdLinks.values()) {
            if (!mdLink.getDetailQrdName().equals(qrdName)) continue;
            return mdLink.getDetailQueryName();
        }
        return null;
    }

    public boolean isMasterDetailLinkParameter(String paramName, String queryName) {
        for (MasterDetailLink mdLink : this.mdLinks.values()) {
            if (!mdLink.isMasterDetailLinkParameter(paramName, queryName)) continue;
            return true;
        }
        return false;
    }

    public List<String> getMasterDetailLinkNamesForParameter(String paramName, String queryName) {
        ArrayList<String> mdLinkNames = null;
        for (MasterDetailLink mdLink : this.mdLinks.values()) {
            if (!mdLink.isMasterDetailLinkParameter(paramName, queryName)) continue;
            if (null == mdLinkNames) {
                mdLinkNames = new ArrayList<String>();
            }
            mdLinkNames.add(mdLink.getName());
        }
        return mdLinkNames;
    }

    public List<MasterDetailLink> getMasterDetailLinks() {
        ArrayList<MasterDetailLink> masterDetailLinks = new ArrayList<MasterDetailLink>();
        for (MasterDetailLink mdLink : this.mdLinks.values()) {
            masterDetailLinks.add(mdLink);
        }
        return masterDetailLinks;
    }

    public List<MasterDetailLink> getMasterDetailLinksForDetailQrd(String detailQueryQRD) {
        ArrayList<MasterDetailLink> masterDetailLinks = new ArrayList<MasterDetailLink>();
        for (MasterDetailLink mdLink : this.mdLinks.values()) {
            if (!mdLink.getDetailQrdName().equals(detailQueryQRD)) continue;
            masterDetailLinks.add(mdLink);
        }
        return masterDetailLinks;
    }

    public MasterDetailLink getParentOf(MasterDetailLink link) {
        MasterDetailLink parent = null;
        String linkMasterQrdName = link.getMasterQrdName();
        String linkMasterDataItemName = link.getMasterRefDataItem();
        for (MasterDetailLink mdLink : this.mdLinks.values()) {
            if (mdLink == link || !mdLink.getDetailQrdName().equals(linkMasterQrdName) || !mdLink.getDetailRefDataItem().equals(linkMasterDataItemName)) continue;
            parent = mdLink;
            break;
        }
        return parent;
    }

    public MasterDetailLink getParentOf(MasterDetailLink link, String dataItemName) {
        MasterDetailLink parent = null;
        String linkMasterQrdName = link.getMasterQrdName();
        String linkMasterDataItemName = link.getMasterRefDataItem();
        for (MasterDetailLink mdLink : this.mdLinks.values()) {
            if (mdLink == link || (!mdLink.getDetailQrdName().equals(linkMasterQrdName) || !linkMasterDataItemName.equals(mdLink.getDetailRefDataItem())) && !linkMasterDataItemName.equals(dataItemName)) continue;
            parent = mdLink;
            break;
        }
        return parent;
    }

    public String getMasterQueryName(String detailQueryName) {
        for (MasterDetailLink mdLink : this.mdLinks.values()) {
            if (!mdLink.getDetailQueryName().equals(detailQueryName)) continue;
            return mdLink.getMasterQueryName();
        }
        return null;
    }

    @Override
    public void persist(XQEPersistContext ctx, String optionalName) {
        if (ctx.beginElement(this, optionalName, -1)) {
            this.persistAttributeProperties(ctx);
            this.persistElementProperties(ctx);
            ctx.endElement();
        }
    }

    public void persistAttributeProperties(XQEPersistContext ctx) {
        ctx.property(ATTRIBUTE_NAME, this.name);
    }

    public void persistElementProperties(XQEPersistContext ctx) {
        if (this.mdLinks != null) {
            ctx.elementProperty(ELEMENT_MD_LINKS, this.mdLinks);
        }
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
        this.restoreAttributes(ctx, node);
        this.restoreChildren(ctx, node);
    }

    public void restoreAttributes(XQERestoreContext ctx, Element node) {
        int size = node.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = node.attribute(i);
            this.restoreAttributeProperty(ctx, att, node);
        }
    }

    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element node) {
        String attName = att.getName();
        if (attName.equals(ATTRIBUTE_NAME)) {
            Object val = ctx.attributeValue(att);
            this.name = (String)val;
        }
    }

    protected void restoreChildren(XQERestoreContext ctx, Element node) {
        List childList = node.elements();
        int nChildren = childList.size();
        for (int i = 0; i < nChildren; ++i) {
            Element child = (Element)childList.get(i);
            if (child.getNamespace().getURI().isEmpty()) continue;
            this.restoreElementProperty(ctx, child, node);
        }
    }

    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(ELEMENT_MD_LINKS)) {
            Object val = ctx.elementValue(node);
            this.mdLinks.clear();
            this.mdLinks.putAll((Map)val);
        }
    }
}

