/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.parameters;

import com.cognos.xqe.ast.IXQEPersist;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.macro.MacroPromptUtils;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5MemberUniqueName;
import com.cognos.xqe.ast.v5Exp_new2.binding.V5NameBinding;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.types.BooleanType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.DateType;
import com.cognos.xqe.data.types.DecimalType;
import com.cognos.xqe.data.types.DoubleType;
import com.cognos.xqe.data.types.FloatType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.data.types.IntervalDayTimeType;
import com.cognos.xqe.data.types.LongType;
import com.cognos.xqe.data.types.MemberType;
import com.cognos.xqe.data.types.MemberUniqueNameType;
import com.cognos.xqe.data.types.SmallintType;
import com.cognos.xqe.data.types.StringType;
import com.cognos.xqe.data.types.TimeType;
import com.cognos.xqe.data.types.TimestampType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IVariable;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.VariableEntryTypeEnum;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.UnresolvedParameterException;
import com.cognos.xqe.query.parameters.ParameterCapabilities;
import com.cognos.xqe.query.parameters.ParameterValueItem;
import com.cognos.xqe.query.parameters.ParameterValues;
import com.cognos.xqe.query.parameters.SimpleParameterValueItem;
import com.cognos.xqe.query.parameters.V5ParameterValueItem;
import com.cognos.xqe.util.StringSubstitutionEngine;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Attribute;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class Parameter
implements IXQEPersist {
    public static final String VALUE_ELEMENT = "value";
    public static final String VALUES_ELEMENT = "values";
    public static final String ITEM_ELEMENT = "item";
    public static final String USE_ELEMENT = "use";
    public static final String XSD_STRING_ATTRIBUTE_VALUE = "xsd:string";
    public static final String XSI_TYPE_ATTRIBUTE = "xsi:type";
    public static final String SOAP_ENC_ARRAY_ATTRIBUTE_VALUE = "SOAP-ENC:Array";
    public static final String SOAP_ENC_ARRAY_TYPE_ATTRIBUTE = "SOAP-ENC:arrayType";
    public static final String NAME_PROPERTY = "name";
    public static final String TYPE_PROPERTY = "type";
    public static final String SINGLE_QUOTE = "'";
    public static final String DOT = ".";
    public static final String COMMA = ",";
    public static final String PARAMETER_VALUE_DT_INTEGER = "integer";
    public static final String PARAMETER_VALUE_DT_DATE = "date";
    public static final String PARAMETER_VALUE_DT_TIME = "time";
    public static final String PARAMETER_VALUE_DT_DATETIME = "datetime";
    public static final String PARAMETER_VALUE_DT_INTERVAL = "interval";
    public static final String PARAMETER_VALUE_DT_DECIMAL = "decimal";
    public static final String PARAMETER_VALUE_DT_BOOLEAN = "boolean";
    public static final String PARAMETER_VALUE_DT_STRING = "string";
    public static final String PARAMETER_VALUE_DT_MUN = "memberUniqueName";
    private static final String CLOSINGITEM = "</item>";
    private static final String PARAMETER_TYPE = "parameterType";
    private static final String PARAMETER_DATASOURCE = "parameterDataSource";
    private static final String PARAMETER_VALUE = "parameterValue";
    private static final String PARAMETER_STR = "parameter";
    private static final String LOCALE_ATTR = "locale";
    static final Pattern PATTERN_NUMBER = Pattern.compile("^[0-9]+$");
    static final Pattern PATTERN_SCI_FLOAT = Pattern.compile("^[E|e]?[0-9]+[.|,]?[0-9]+$");
    private static final String ATTRIUTE_ORIG_NAME = "origName";
    private static final String ATTRIBUTE_CAPTION = "caption";
    private static final String ATTRIBUTE_CAPTION_LOCALE = "captionLocale";
    private static final String ATTRIBUTE_MODEL_ITEM = "modelItem";
    private static final String ATTRIBUTE_VALUE_EXPRESSION = "valueExpression";
    private static final String ATTRIBUTE_PROMPT_TYPE = "promptType";
    private static final String ATTRIBUTE_DATAITEM_REF = "dataItemRef";
    private static final String ATTRIBUTE_MASTER_DETAIL_LINK_FLAG = "masterDetailLinkFlag";
    private static final String ATTRIBUTE_IS_LITERAL = "isLiteral";
    private static final String ATTRIBUTE_DATATYPE_NAME = "dataTypeName";
    private static final String ATTRIBUTE_MODEL_SIZE = "modelSize";
    private static final String ATTRIBUTE_IS_DATA_SOURCE_PARAMETER = "isDataSourceParameter";
    private static final String ATTRIBUTE_PROVIDER_HIERARCHY_UNIQUE_NAME = "providerHierarchyUniqueName";
    private static final String ATTRIBUTE_PROVIDER_NAME = "providerName";
    private static final String ATTRIBUTE_QUERY_NAME = "queryName";
    private static final String ATTRIBUTE_IS_PARAMETER_VALUE_REQUIRED = "isParameterValueRequired";
    private static final String ATTRIBUTE_IS_SAME_MASTER_DETAIL_LINK_LEVEL = "isSameMasterDetailLinkLevel";
    private static final String ATTRIBUTE_ORDER_INDEX = "orderIndex";
    private static final String ATTRIBUTE_COLUMNNO = "columnNo";
    private static final String ATTRIBUTE_ERROR_CODE = "errorCode";
    private static final String ATTRIBUTE_EXPLICIT_VALUE_REQUIRED = "explicityValueRequired";
    private static final String ATTRIBUTE_PARAMETER_REPLACED_BY_VALUE = "parameterReplacedByValue";
    private static final String ATTRIBUTE_IS_SAP_VARIABLE_FIXED_VALUE = "isSAPVariableFixedValue";
    private static final String ATTRIBUTE_INVERT = "invert";
    private static final String ELEMENT_CAPABILITIES = "capabilities";
    private static final String ELEMENT_LEVELS = "levels";
    private static final String ATTRIBUTE_MODULE_PATH = "modulePath";
    private static final String ATTRIBUTE_MODEL_PATH = "modelPath";
    private static final String DEFAULT_VALUE = "defaultValue";
    private static final String MODEL_FILTER_ITEM = "modelFilterItem";
    private static final String USE_VALUE_EXPRESSION = "useValueExpression";
    private String name = new String();
    private String origName = new String();
    private String caption = new String();
    private Locale captionLocale = null;
    private String modelItem = new String();
    private String valueExpression = new String();
    private String promptType = new String();
    private String dataItemRef = new String();
    private boolean masterDetailLinkFlag = false;
    private boolean isLiteral = true;
    private boolean isDMRParameter = false;
    private boolean isUsedByScrollCursor = false;
    private IDataType dataType = null;
    private ParameterCapabilities capabilities = new ParameterCapabilities();
    private String dataTypeName = new String();
    private int modelSize = 0;
    private boolean isDataSourceParameter = false;
    private List<ILevel> levels = new ArrayList<ILevel>();
    private String providerHierarchyUniqueName = null;
    private String providerName = null;
    private String queryName = new String();
    private boolean isParameterValueRequired = false;
    private boolean isGlobalParameter = false;
    private boolean isSameMasterDetailLinkLevel = false;
    private int orderIndex = -1;
    private int columnNo;
    private boolean hasValueProvidedWithRequest = false;
    private UnresolvedParameterException.ParameterErrorCodeEnum errorCode = null;
    private boolean explicitValueRequired = false;
    private boolean parameterReplacedByValue = false;
    private boolean isSAPVariableFixedValue;
    private boolean nameVariable = false;
    private String modulePath = null;
    private String modelPath = null;
    private int queryReferenceCount = 0;
    private boolean isOnlyReferencedInQuery = false;
    private boolean isModelPartReset = false;
    private boolean promptHandlingNoFault = false;
    private LOCATION paramLocation = null;
    private boolean invert = false;

    public Parameter() {
    }

    public Parameter(String aParameterName) {
        this.name = aParameterName;
    }

    public Parameter(String aParameterName, int aColumnNo) {
        this.name = aParameterName;
        this.columnNo = aColumnNo;
    }

    public Parameter(String aParameterName, int aColumnNo, IDataType dType) {
        this.name = aParameterName;
        this.columnNo = aColumnNo;
        this.dataType = dType;
    }

    public Parameter(String aParameterName, IDataType dType) {
        this.name = aParameterName;
        this.setDataType(dType);
    }

    public Parameter(String aParameterName, String aQueryName) {
        this.name = aParameterName;
        this.queryName = aQueryName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String theName) {
        this.name = theName;
    }

    public void setCaption(String theCaption) {
        if (theCaption != null) {
            this.caption = theCaption;
        }
    }

    public void setCaptionLocale(Locale theCaptionLocale) {
        if (theCaptionLocale != null) {
            this.captionLocale = theCaptionLocale;
        }
    }

    public String getCaption() {
        return this.caption;
    }

    public Locale getCaptionLocale() {
        return this.captionLocale;
    }

    public boolean isResolved() {
        if (this.promptHandlingNoFault) {
            return true;
        }
        if (this.isOnlyReferencedInQuery && this.queryReferenceCount == 0) {
            return true;
        }
        ParameterValues value = this.getParameterValueItems();
        return value.containsValues() || value.isValueExplicitlyNotSupplied() && !this.isExplicitValueRequired();
    }

    public boolean isSAPVariableIgnored() {
        ParameterValues value = this.getParameterValueItems();
        return value.containsValues() && this.isSAPVariableFixedValue();
    }

    public boolean isIgnored() {
        return this.getParameterValueItems().isValueExplicitlyNotSupplied();
    }

    public void setModelItem(String theModelItem) {
        if (theModelItem != null) {
            this.modelItem = theModelItem;
        }
    }

    public String getModelItem() {
        return this.modelItem;
    }

    public String getValueExpression() {
        return this.valueExpression;
    }

    public void setValueExpression(String value) {
        if (value != null) {
            this.valueExpression = value;
        }
    }

    public void setPromptType(String thePromptType) {
        if (thePromptType != null) {
            this.promptType = thePromptType;
        }
    }

    public String getPromptType() {
        return this.promptType;
    }

    public boolean parse(Element parameterValueElement) {
        this.name = Parameter.getValueProperty(parameterValueElement, NAME_PROPERTY);
        return this.getParameterValueItems().parse(parameterValueElement.element(VALUE_ELEMENT));
    }

    public void setValueToNil() {
        this.getParameterValueItems().clear();
        this.getParameterValueItems().setValueExplicitlyNotSupplied(true);
    }

    public boolean parseJSON(JSONObject item) {
        this.name = (String)item.get((Object)NAME_PROPERTY);
        ParameterValues vs = this.getParameterValueItems();
        return vs.parseJSON((JSONArray)item.get((Object)VALUE_ELEMENT));
    }

    public void bind(PlanningEnvironment environment) {
        this.bindToRequest((RequestEnvironment)environment.getRequestEnvironment());
        if (this.isResolved() && !this.isDataSourceParameter()) {
            this.getParameterValueItems().bind(environment);
        }
    }

    public void bindToRequest(RequestEnvironment environment) {
        if (!this.isMasterDetailLinkParameter()) {
            environment.bindParameter(this);
        }
    }

    public void setExternalValues(PlanningEnvironment environment) {
        if (this.isResolved()) {
            this.getParameterValueItems().setExternalValues(environment);
        }
    }

    public ParameterValues getDefaultValues() {
        MultiRequestContext multiRequestContext = ExecutionEnvironmentContext.getExecutionEnvironment().getMultiRequestContext();
        return multiRequestContext.getRequestParameters().getParameterDefaultValues(this);
    }

    public ParameterValues getParameterValueItems() {
        MultiRequestContext multiRequestContext = ExecutionEnvironmentContext.getExecutionEnvironment().getMultiRequestContext();
        return multiRequestContext.getRequestParameters().getParameterValueItems(this);
    }

    void setParameterValueItems(List<ParameterValueItem> items) {
        this.clearParameterValueItems();
        if (items instanceof ParameterValues) {
            this.getParameterValueItems().setValueExplicitlyNotSupplied(((ParameterValues)items).isValueExplicitlyNotSupplied());
        }
        this.getParameterValueItems().addAll(items);
    }

    public void clearParameterValueItems() {
        this.getParameterValueItems().clear();
        this.getParameterValueItems().setValueExplicitlyNotSupplied(false);
    }

    public void removeParameterValues() {
        MultiRequestContext multiRequestContext = ExecutionEnvironmentContext.getExecutionEnvironment().getMultiRequestContext();
        multiRequestContext.getRequestParameters().removeParameterValues(this);
    }

    public void addValue(String value) {
        this.getParameterValueItems().addValue(value);
    }

    public void addValue(IValue value) {
        this.getParameterValueItems().addValue(value);
    }

    public void addValue(boolean inclusive, String theDisplayValue, String theInternalValue) {
        this.getParameterValueItems().addValue(inclusive, theDisplayValue, theInternalValue);
    }

    public IValue[] getParameterValues() {
        IValue[] values = new Value[this.getParameterValueItems().size()];
        for (int i = 0; i < values.length; ++i) {
            SimpleParameterValueItem valueItem = (SimpleParameterValueItem)this.getParameterValueItems().get(i);
            values[i] = valueItem.getValueFromInternalValue();
        }
        return values;
    }

    public void setMasterDetailLinkParameter(boolean aMasterDetailLinkFlag) {
        this.masterDetailLinkFlag = aMasterDetailLinkFlag;
    }

    public boolean isMasterDetailLinkParameter() {
        return this.masterDetailLinkFlag;
    }

    private static String getValueProperty(Element parameterValueElement, String propertyName) {
        String propText = new String();
        Element propElement = parameterValueElement.element(propertyName);
        if (null != propElement) {
            propText = propElement.getText();
        }
        return propText;
    }

    public String getDataItemRef() {
        return this.dataItemRef;
    }

    public void setDataItemRef(String adataItemRef) {
        this.dataItemRef = adataItemRef;
    }

    public boolean isDataSourceParameter() {
        return this.isDataSourceParameter;
    }

    public void setIsDataSourceParameter(boolean value) {
        this.isDataSourceParameter = value;
    }

    public boolean isSAPVariableFixedValue() {
        return this.isSAPVariableFixedValue;
    }

    public void setSAPVariableHasFixedValue(boolean value) {
        this.isSAPVariableFixedValue = value;
    }

    public boolean isLiteral() {
        return this.isLiteral;
    }

    public void setIsLiteral(boolean value) {
        this.isLiteral = value;
    }

    public IDataType getDataType() {
        return this.dataType;
    }

    public IDataType getDataType(String value) {
        if (this.dataType == null || value == null || value.length() == 0) {
            return this.dataType;
        }
        if (this.dataType.isInteger() && this.modelSize == 8) {
            return LongType.LONGTYPE;
        }
        IDataType adjustedDataType = this.dataType;
        if (this.dataType.isInteger() && this.modelSize == 2) {
            adjustedDataType = SmallintType.SMALLINTTYPE;
        }
        switch (adjustedDataType.getCCLTypeCode()) {
            case 4: {
                adjustedDataType = this.adjustType(adjustedDataType, PATTERN_NUMBER, value, StringType.DEFAULTSTRINGTYPE);
                break;
            }
            case 6: {
                if (value.contains("E") || value.contains("e") || value.contains(DOT) || value.contains(COMMA)) {
                    adjustedDataType = this.adjustType(FloatType.FLOATTYPE, PATTERN_SCI_FLOAT, value, DoubleType.DOUBLETYPE);
                    break;
                }
                adjustedDataType = this.adjustType(adjustedDataType, PATTERN_NUMBER, value, StringType.DEFAULTSTRINGTYPE);
                break;
            }
            case 26: {
                if (!DataSourceTypeEnum.isRelational(this.getProviderName())) break;
                adjustedDataType = DataTypeFactory.getVarcharType(value.length());
                break;
            }
            case 45: {
                try {
                    Value dataValue = (Value)this.dataType.createValue();
                    dataValue.set(value);
                }
                catch (ValueConversionException e) {
                    adjustedDataType = DataTypeFactory.getVarcharType(value.length());
                }
                break;
            }
            case 56: {
                try {
                    Value dataValue = (Value)this.dataType.createValue();
                    dataValue.set(value);
                }
                catch (ValueConversionException e) {
                    adjustedDataType = DataTypeFactory.getNVarcharType(value.length());
                }
                break;
            }
        }
        return adjustedDataType;
    }

    public IDataType adjustType(IDataType expectedDataType, Pattern pattern, String value, IDataType alternateDataType) {
        IDataType newDataType;
        block2: {
            newDataType = expectedDataType;
            try {
                Value dataValue = (Value)expectedDataType.createValue();
                dataValue.set(value);
            }
            catch (ValueConversionException e) {
                Matcher m = pattern.matcher(value);
                if (!m.matches()) break block2;
                newDataType = alternateDataType;
            }
        }
        return newDataType;
    }

    public void setDataType(IDataType dType) {
        IDataType compatibleType = dType;
        if (null != this.dataType) {
            compatibleType = DataTypeComparator.getMoreRestrictiveDataType(this.getName(), this.dataType, dType);
        }
        this.dataType = compatibleType;
        this.setDataTypeName();
    }

    public void setAdjustedDataType(IDataType dType) {
        this.dataType = dType;
        this.setDataTypeName();
    }

    public ParameterCapabilities getCapabilities() {
        return this.capabilities;
    }

    public void setDataTypeName() {
        int cclDataType = this.dataType.getCCLTypeCode();
        if (this.dataType instanceof MemberType) {
            cclDataType = 43;
        }
        switch (cclDataType) {
            case 8: {
                this.dataTypeName = "xsdLong";
                break;
            }
            case 6: {
                this.dataTypeName = "xsdInt";
                break;
            }
            case 4: {
                this.dataTypeName = "xsdShort";
                break;
            }
            case 13: 
            case 57: {
                this.dataTypeName = "xsdDate";
                break;
            }
            case 14: 
            case 52: 
            case 58: {
                this.dataTypeName = "xsdTime";
                break;
            }
            case 15: 
            case 53: 
            case 59: {
                this.dataTypeName = "xsdDateTime";
                break;
            }
            case 17: 
            case 60: {
                this.dataTypeName = "xsdDuration";
                break;
            }
            case 10: {
                this.dataTypeName = "xsdFloat";
                break;
            }
            case 12: {
                this.dataTypeName = "xsdDecimal";
                break;
            }
            case 11: {
                this.dataTypeName = "xsdDouble";
                break;
            }
            case 23: 
            case 24: {
                this.dataTypeName = "xsdHexBinary";
                break;
            }
            case 27: {
                this.dataTypeName = "hierarchyUniqueName";
                break;
            }
            case 25: 
            case 30: 
            case 34: 
            case 43: {
                this.dataTypeName = PARAMETER_VALUE_DT_MUN;
                break;
            }
            default: {
                this.dataTypeName = "xsdString";
            }
        }
    }

    public String getDataTypeName() {
        return this.dataTypeName;
    }

    public void setModelSize(int size) {
        this.modelSize = size;
    }

    public int getModelSize() {
        return this.modelSize;
    }

    public List<String> getExternalValues(boolean replaceNulls) {
        return this.getParameterValueItems().getExternalValues(replaceNulls);
    }

    public List<ILevel> getLevels() {
        return this.levels;
    }

    public void setLevels(List<ILevel> theLevels) {
        this.levels.clear();
        this.levels.addAll(theLevels);
    }

    public void setHierarchy(IHierarchy theHierarchy) {
        if (theHierarchy != null) {
            this.setLevels(theHierarchy.getLevels());
        }
    }

    public String getHierarchyUniqueName() {
        if (this.isDataSourceParameter() || this.levels.isEmpty()) {
            return null;
        }
        return this.levels.get(0).getHierarchy().getV5UniqueName();
    }

    public String getProviderHierarchyUniqueName() {
        return this.providerHierarchyUniqueName;
    }

    public void setProviderHierarchyUniqueName(String value) {
        this.providerHierarchyUniqueName = value;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(IPlanningEnvironment planningEnvironment, IMetadata metadata) {
        ICube cube;
        if (this.providerName == null && null != metadata && null != (cube = MetadataUtil.getCube(metadata))) {
            this.setProviderName(cube.getModelDataSource().getInterface());
            return;
        }
    }

    public void setProviderName(String value) {
        this.providerName = value;
    }

    public final String getQueryName() {
        return this.queryName;
    }

    public void setQueryName(String aQueryName) {
        this.queryName = aQueryName;
    }

    public void appendDefaultValueString(StringBuilder buffer) {
        String defaultValuesString = this.getDefaultValues().asDOMString(DEFAULT_VALUE);
        if (defaultValuesString.length() > 0) {
            buffer.append(defaultValuesString);
        }
    }

    public void appendItemString(StringBuilder buffer, boolean resolvedParameter) {
        if (this.isDataSourceParameter()) {
            buffer.append("<item xsi:type=\"bus:parameterDataSource\">");
        } else if (resolvedParameter) {
            buffer.append("<item xsi:type=\"bus:parameterValue\">");
        } else {
            buffer.append("<item xsi:type=\"bus:parameter\">");
        }
        if (this.getParameterName().length() > 0) {
            buffer.append("<name xsi:type=\"xsd:string\">");
            buffer.append(StringSubstitutionEngine.escapeString(this.getParameterName()));
            buffer.append("</name>");
        }
        if (this.getPromptType().length() > 0) {
            buffer.append("<promptType xsi:type=\"bus:promptTypeEnum\">");
            buffer.append(this.getPromptType());
            buffer.append("</promptType>");
        }
        if (this.getDataTypeName().length() > 0) {
            buffer.append("<type xsi:type=\"bus:parameterDataTypeEnum\">");
            buffer.append(this.getDataTypeName());
            buffer.append("</type>");
        }
        if (this.getCaption().length() > 0) {
            buffer.append("<caption SOAP-ENC:arrayType=\"bus:multilingualString[1]\" xsi:type=\"SOAP-ENC:Array\">");
            buffer.append("<item xsi:type=\"bus:multilingualString\">");
            buffer.append("<value xsi:type=\"xsd:string\">");
            buffer.append(StringSubstitutionEngine.escapeString(this.getCaption()));
            buffer.append("</value>");
            if (this.getCaptionLocale() != null) {
                buffer.append("<locale xsi:type=\"xsd:string\">");
                buffer.append(this.getCaptionLocale());
                buffer.append("</locale>");
            }
            buffer.append("</item></caption>");
        }
        buffer.append(this.capabilities.asDOMString());
        if (!this.isResolved()) {
            this.appendDefaultValueString(buffer);
        } else {
            String valueItemsString = this.getParameterValueItems().asDOMString(VALUES_ELEMENT);
            buffer.append(valueItemsString);
        }
        if (!this.isDataSourceParameter()) {
            if (this.getModelItem().length() > 0) {
                buffer.append("<modelFilterItem xsi:type=\"xsd:string\">");
                buffer.append(StringSubstitutionEngine.escapeString(this.getModelItem()));
                buffer.append("</modelFilterItem>");
            } else if (this.getValueExpression().length() > 0) {
                buffer.append("<useValueExpression xsi:type=\"bus:metadataModelExpression\">");
                buffer.append(StringSubstitutionEngine.escapeString(this.getValueExpression()));
                buffer.append("</useValueExpression>");
            }
        }
        if (this.modulePath != null) {
            buffer.append("<modulePath xsi:type=\"xsd:string\">");
            buffer.append(StringSubstitutionEngine.escapeString(this.getModulePath()));
            buffer.append("</modulePath>");
        }
        if (this.modelPath != null) {
            buffer.append("<modelPath xsi:type=\"xsd:string\">");
            buffer.append(StringSubstitutionEngine.escapeString(this.getModelPath()));
            buffer.append("</modelPath>");
        }
        buffer.append(CLOSINGITEM);
    }

    public void appendItemJSON(JSONArray jItems, boolean resolvedParameter) {
        JSONObject jParam = new JSONObject();
        jItems.add((Object)jParam);
        if (this.isDataSourceParameter()) {
            jParam.put((Object)PARAMETER_TYPE, (Object)PARAMETER_DATASOURCE);
        } else if (resolvedParameter) {
            jParam.put((Object)PARAMETER_TYPE, (Object)PARAMETER_VALUE);
        } else {
            jParam.put((Object)PARAMETER_TYPE, (Object)PARAMETER_STR);
        }
        if (this.getParameterName().length() > 0) {
            jParam.put((Object)NAME_PROPERTY, (Object)this.getParameterName());
        }
        if (this.getPromptType().length() > 0) {
            jParam.put((Object)ATTRIBUTE_PROMPT_TYPE, (Object)this.getPromptType());
        }
        if (this.getDataTypeName().length() > 0) {
            jParam.put((Object)TYPE_PROPERTY, (Object)this.getDataTypeName());
        }
        if (this.getCaption().length() > 0) {
            JSONArray capItems = new JSONArray();
            jParam.put((Object)ATTRIBUTE_CAPTION, (Object)capItems);
            JSONObject capObj = new JSONObject();
            capItems.add((Object)capObj);
            capObj.put((Object)VALUE_ELEMENT, (Object)this.getCaption());
            if (this.getCaptionLocale() != null) {
                capObj.put((Object)LOCALE_ATTR, (Object)this.getCaptionLocale());
            }
        }
        if (this.capabilities != null && !this.capabilities.isEmpty()) {
            this.capabilities.appendJSON(jParam);
        }
        if (!this.isResolved()) {
            this.getDefaultValues().appendJSON(DEFAULT_VALUE, jParam);
        } else {
            this.getParameterValueItems().appendJSON(VALUES_ELEMENT, jParam);
        }
        if (!this.isDataSourceParameter()) {
            if (this.getModelItem().length() > 0) {
                jParam.put((Object)MODEL_FILTER_ITEM, (Object)this.getModelItem());
            } else if (this.getValueExpression().length() > 0) {
                jParam.put((Object)USE_VALUE_EXPRESSION, (Object)this.getValueExpression());
            }
        }
        if (this.modulePath != null) {
            jParam.put((Object)ATTRIBUTE_MODULE_PATH, (Object)this.getModulePath());
        }
        if (this.modelPath != null) {
            jParam.put((Object)ATTRIBUTE_MODEL_PATH, (Object)this.getModelPath());
        }
        if (this.invert) {
            jParam.put((Object)ATTRIBUTE_INVERT, (Object)this.invert);
        }
    }

    public Element createParameterElement(String parameterName) {
        Element parameterElement = DocumentHelper.createElement((String)ITEM_ELEMENT);
        parameterElement.addAttribute(XSI_TYPE_ATTRIBUTE, "bus:parameter");
        Element nameElement = parameterElement.addElement(NAME_PROPERTY);
        nameElement.addAttribute(XSI_TYPE_ATTRIBUTE, XSD_STRING_ATTRIBUTE_VALUE);
        nameElement.setText(parameterName);
        Element typeElement = parameterElement.addElement(TYPE_PROPERTY);
        typeElement.addAttribute(XSI_TYPE_ATTRIBUTE, "bus:parameterDataTypeEnum");
        typeElement.setText(this.getDataTypeName());
        this.capabilities.asDOMElement(parameterElement);
        Element modelFilterItemElement = parameterElement.addElement(MODEL_FILTER_ITEM);
        modelFilterItemElement.addAttribute(XSI_TYPE_ATTRIBUTE, XSD_STRING_ATTRIBUTE_VALUE);
        modelFilterItemElement.setText(this.getModelItem());
        return parameterElement;
    }

    public Element createParameterValueElement() {
        Element parameterValueElement = DocumentHelper.createElement((String)VALUE_ELEMENT);
        ParameterValues values = this.getParameterValueItems();
        if (!values.isEmpty()) {
            V5ParameterValueItem value = (V5ParameterValueItem)values.get(0);
            Element itemElem = parameterValueElement.addElement(ITEM_ELEMENT);
            if (values.isValueExplicitlyNotSupplied()) {
                itemElem.addAttribute("nil", "true");
            } else {
                Element useElem = itemElem.addElement(USE_ELEMENT);
                useElem.setText(value.getInternalValue());
            }
        }
        return parameterValueElement;
    }

    public void setParameterValueRequiredBeforePlanning(boolean aParameterValueRequired) {
        this.isParameterValueRequired |= aParameterValueRequired;
    }

    public boolean isParameterValueRequiredBeforePlanning() {
        return this.isParameterValueRequired;
    }

    public void setIsDMRParameter(boolean isDMRParameterUsed) {
        this.isDMRParameter |= isDMRParameterUsed;
    }

    public boolean isDMRParameter() {
        return this.isDMRParameter;
    }

    public void setIsUsedByScrollCursor(boolean value) {
        this.isUsedByScrollCursor = value;
    }

    public boolean isUsedByScrollCursor() {
        return this.isUsedByScrollCursor;
    }

    public boolean doResolveExternalName() {
        if (this.providerName == null) {
            return false;
        }
        if (!this.isLiteral()) {
            if (DataSourceTypeEnum.isEssbase(this.providerName)) {
                return true;
            }
            if (this.providerName.equals("PC") && !this.getLevels().isEmpty()) {
                return true;
            }
            if (this.providerName.equals("BW") && this.getDataType().isDate()) {
                return true;
            }
        } else if (this.getDataType() == TimestampType.TIMESTAMPTYPE && (DataSourceTypeEnum.isMicrosoft(this.providerName) || DataSourceTypeEnum.isEssbase(this.providerName))) {
            return true;
        }
        return false;
    }

    public boolean allowDateOnlyTimestampValue() {
        if (this.providerName == null) {
            return false;
        }
        return DataSourceTypeEnum.isEssbase(this.providerName);
    }

    public void setOrderIndex(Integer theOrderIndex) {
        if (theOrderIndex != null) {
            this.orderIndex = theOrderIndex;
        }
    }

    public int getOrderIndex() {
        return this.orderIndex;
    }

    public int getColumnNo() {
        return this.columnNo;
    }

    public void setErrorCode(UnresolvedParameterException.ParameterErrorCodeEnum code) {
        this.errorCode = code;
    }

    public UnresolvedParameterException.ParameterErrorCodeEnum getErrorCode() {
        return this.errorCode;
    }

    private void validateValueForLevels(V5MemberUniqueName munNode, V5BoundMemberUniqueName boundMun) {
        if (this.isMasterDetailLinkParameter() && this.isSameMasterDetailLinkLevel(munNode)) {
            return;
        }
        if (this.isModelPartReset) {
            this.isModelPartReset = false;
            return;
        }
        StringBuilder sbLevelNames = new StringBuilder(this.levels.get(0).getV5UniqueName());
        for (int idx = 1; idx < this.levels.size(); ++idx) {
            sbLevelNames.append(COMMA);
            sbLevelNames.append(this.levels.get(idx).getV5UniqueName());
        }
        if (this.isMasterDetailLinkParameter()) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidMasterDetailLinkValue, (Object)this.getQueryName(), (Object)sbLevelNames.toString(), (Object)munNode.getModel());
        }
        throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidPromptValue, (Object)this.getName(), (Object)sbLevelNames.toString(), (Object)munNode.getModel());
    }

    public void resetModel(V5MemberUniqueName munNode, V5BoundMemberUniqueName boundMun) {
        if (!this.getLevels().isEmpty() && !this.isModelPartReset) {
            this.isModelPartReset = this.resetModelPart(munNode, boundMun);
        }
    }

    private boolean resetModelPart(V5MemberUniqueName munNode, V5BoundMemberUniqueName boundMun) {
        String munName = munNode.getModel();
        if (boundMun != null) {
            munName = boundMun.getLevel().getV5UniqueName();
        }
        for (ILevel level : this.levels) {
            String levelName = level.getV5UniqueName();
            if (munName.compareTo(levelName) == 0) {
                return true;
            }
            if (level.isDMR()) continue;
            ILevel mfwLevel = level;
            if (!mfwLevel.isMFW()) {
                mfwLevel = (ILevel)munNode.getPlanningEnvironment().getMetadataConnection().bindMetadataReference(level.getV5UniqueName());
            }
            if (!mfwLevel.isMFW()) continue;
            String id = (String)mfwLevel.getProperty("ID");
            if (id != null && id.equals(munNode.getModel())) {
                munNode.setModel(mfwLevel.getV5UniqueName());
                return true;
            }
            String munWithoutNS = null;
            String levelNameWithoutNS = null;
            int index1 = munName.indexOf(DOT);
            int index2 = levelName.indexOf(DOT);
            if (index1 != -1) {
                munWithoutNS = munName.substring(index1 + 1, munName.length());
            }
            if (index2 != -1) {
                levelNameWithoutNS = levelName.substring(index2 + 1, levelName.length());
            }
            if (levelNameWithoutNS == null || !levelNameWithoutNS.equals(munWithoutNS)) continue;
            munNode.setModel(level.getV5UniqueName());
            return true;
        }
        return false;
    }

    public boolean isSameMasterDetailLinkLevel(IXQEQueryNode node) {
        PlanningEnvironment env;
        if (this.levels.isEmpty()) {
            return this.isSameMasterDetailLinkLevel;
        }
        this.isSameMasterDetailLinkLevel = this.isSameMasterDetailLinkLevel(((V5MemberUniqueName)node).getModel());
        if (!this.isSameMasterDetailLinkLevel && (env = (PlanningEnvironment)((V5MemberUniqueName)node).getPlanningEnvironment()).getMetadataConnection() != null) {
            V5NameBinding nameBinding = new V5NameBinding(env);
            IMetadata metaData = nameBinding.bindModelIdentifier(((V5MemberUniqueName)node).getModel(), false);
            this.isSameMasterDetailLinkLevel = this.isSameMasterDetailLinkLevel(metaData.getV5UniqueName());
        }
        return this.isSameMasterDetailLinkLevel;
    }

    public boolean isSameMasterDetailLinkLevel(String level) {
        List<String> parameterValues = this.getExternalValues(false);
        if (this.getCapabilities().isMultivalued() && parameterValues != null && parameterValues.size() != 1) {
            String paramLevel = this.levels.get(0).getV5UniqueName();
            return level.equals(paramLevel);
        }
        for (int i = 0; i < this.levels.size(); ++i) {
            if (!level.equals(this.levels.get(i).getV5UniqueName())) continue;
            return true;
        }
        return this.isSameMasterDetailLinkLevel;
    }

    public void validateValue(IXQEQueryNode value, V5BoundMemberUniqueName boundValue) {
        if (!this.getLevels().isEmpty() && !(value instanceof V5MemberUniqueName)) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidPromptValueForMember, this.getName());
        }
        if (!this.getLevels().isEmpty()) {
            this.validateValueForLevels((V5MemberUniqueName)value, boundValue);
        }
    }

    public boolean isExplicitValueRequired() {
        return this.explicitValueRequired;
    }

    public void setExplicitValueRequired(boolean explicitValueRequiredParam) {
        this.explicitValueRequired |= explicitValueRequiredParam;
    }

    public void setOriginalName(String theOrigName) {
        this.origName = theOrigName;
    }

    public final String getParameterName() {
        if (this.origName.length() > 0 && !this.origName.equals(this.name)) {
            return this.origName;
        }
        return this.name;
    }

    public boolean parameterReplacedByValue() {
        return this.parameterReplacedByValue;
    }

    public void setParameterReplacedByValue(boolean value) {
        this.parameterReplacedByValue = value;
    }

    public boolean validateXmlValuesWithDataType() {
        ParameterValues valueItems = this.getParameterValueItems();
        if (valueItems.isEmpty()) {
            return true;
        }
        ArrayList<ParameterValueItem> newValueItems = new ArrayList<ParameterValueItem>();
        for (int i = 0; i < valueItems.size(); ++i) {
            if (!(valueItems.get(i) instanceof V5ParameterValueItem)) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_Invalid_Parameter_Value, this.getName());
            }
            V5ParameterValueItem valueItem = (V5ParameterValueItem)valueItems.get(i);
            String userValue = valueItem.getInternalValue();
            if (userValue != null) {
                String udaValue = MacroPromptUtils.convertValidXMLConstToUDAValue(userValue, this.getDataType());
                if (udaValue == null) {
                    return false;
                }
                valueItem.setInternalValue(udaValue);
            }
            newValueItems.add(valueItem);
        }
        this.setParameterValueItems(newValueItems);
        return true;
    }

    public void setVariableInfo(PlanningEnvironment environment, IVariable variable) {
        this.setCaption(variable.getCaption());
        this.setIsDataSourceParameter(true);
        this.setDataType(variable.getDataType());
        this.setIsLiteral(false);
        this.setProviderHierarchyUniqueName(variable.getHierarchyUniqueName());
        boolean isMandatoryVariable = variable.getEntryType() == VariableEntryTypeEnum.MANDATORY;
        this.setExplicitValueRequired(isMandatoryVariable);
        this.getParameterValueItems().setExternalValues(environment);
    }

    @Override
    public void persist(XQEPersistContext ctx, String optionalName) {
        if (ctx.beginElement(this, optionalName, -1)) {
            this.persistAttributeProperties(ctx);
            this.persistElementProperties(ctx);
            ctx.endElement();
        }
    }

    public void persistAttributeProperties(XQEPersistContext ctx) {
        ctx.property(NAME_PROPERTY, this.name);
        ctx.property(ATTRIUTE_ORIG_NAME, this.origName);
        ctx.property(ATTRIBUTE_CAPTION, this.caption);
        ctx.property(ATTRIBUTE_CAPTION_LOCALE, this.captionLocale);
        ctx.property(ATTRIBUTE_MODEL_ITEM, this.modelItem);
        ctx.property(ATTRIBUTE_VALUE_EXPRESSION, this.valueExpression);
        ctx.property(ATTRIBUTE_PROMPT_TYPE, this.promptType);
        ctx.property(ATTRIBUTE_DATAITEM_REF, this.dataItemRef);
        ctx.property(ATTRIBUTE_MASTER_DETAIL_LINK_FLAG, this.masterDetailLinkFlag);
        ctx.property(ATTRIBUTE_IS_LITERAL, this.isLiteral);
        ctx.property(ATTRIBUTE_DATATYPE_NAME, this.dataTypeName);
        ctx.property(ATTRIBUTE_MODEL_SIZE, this.modelSize);
        ctx.property(ATTRIBUTE_IS_DATA_SOURCE_PARAMETER, this.isDataSourceParameter);
        ctx.property(ATTRIBUTE_PROVIDER_HIERARCHY_UNIQUE_NAME, this.providerHierarchyUniqueName);
        ctx.property(ATTRIBUTE_PROVIDER_NAME, this.providerName);
        ctx.property(ATTRIBUTE_QUERY_NAME, this.queryName);
        ctx.property(ATTRIBUTE_IS_PARAMETER_VALUE_REQUIRED, this.isParameterValueRequired);
        ctx.property(ATTRIBUTE_IS_SAME_MASTER_DETAIL_LINK_LEVEL, this.isSameMasterDetailLinkLevel);
        ctx.property(ATTRIBUTE_ORDER_INDEX, this.orderIndex);
        ctx.property(ATTRIBUTE_COLUMNNO, this.columnNo);
        ctx.property(ATTRIBUTE_ERROR_CODE, (Object)this.errorCode);
        ctx.property(ATTRIBUTE_EXPLICIT_VALUE_REQUIRED, this.explicitValueRequired);
        ctx.property(ATTRIBUTE_PARAMETER_REPLACED_BY_VALUE, this.parameterReplacedByValue);
        ctx.property(ATTRIBUTE_IS_SAP_VARIABLE_FIXED_VALUE, this.isSAPVariableFixedValue);
        ctx.property(ATTRIBUTE_MODULE_PATH, this.modulePath);
        ctx.property(ATTRIBUTE_MODEL_PATH, this.modelPath);
        ctx.property(ATTRIBUTE_INVERT, this.invert);
    }

    public void persistElementProperties(XQEPersistContext ctx) {
        if (this.capabilities != null) {
            ctx.elementProperty(ELEMENT_CAPABILITIES, this.capabilities);
        }
        if (this.levels != null) {
            ctx.elementProperty(ELEMENT_LEVELS, this.levels);
        }
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
        this.restoreAttributes(ctx, node);
        this.restoreChildren(ctx, node);
    }

    public void restoreAttributes(XQERestoreContext ctx, Element node) {
        int size = node.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = node.attribute(i);
            this.restoreAttributeProperty(ctx, att);
        }
    }

    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att) {
        String attName = att.getName();
        if (attName.equals(NAME_PROPERTY)) {
            Object val = ctx.attributeValue(att);
            this.name = (String)val;
        } else if (attName.equals(ATTRIUTE_ORIG_NAME)) {
            Object val = ctx.attributeValue(att);
            this.origName = (String)val;
        } else if (attName.equals(ATTRIBUTE_CAPTION)) {
            Object val = ctx.attributeValue(att);
            this.caption = (String)val;
        } else if (attName.equals(ATTRIBUTE_CAPTION_LOCALE)) {
            Object val = ctx.attributeValue(att);
            this.captionLocale = (Locale)val;
        } else if (attName.equals(ATTRIBUTE_MODEL_ITEM)) {
            Object val = ctx.attributeValue(att);
            this.modelItem = (String)val;
        } else if (attName.equals(ATTRIBUTE_VALUE_EXPRESSION)) {
            Object val = ctx.attributeValue(att);
            this.valueExpression = (String)val;
        } else if (attName.equals(ATTRIBUTE_PROMPT_TYPE)) {
            Object val = ctx.attributeValue(att);
            this.promptType = (String)val;
        } else if (attName.equals(ATTRIBUTE_DATAITEM_REF)) {
            Object val = ctx.attributeValue(att);
            this.dataItemRef = (String)val;
        } else if (attName.equals(ATTRIBUTE_MASTER_DETAIL_LINK_FLAG)) {
            Object val = ctx.attributeValue(att);
            this.masterDetailLinkFlag = (Boolean)val;
        } else if (attName.equals(ATTRIBUTE_IS_LITERAL)) {
            Object val = ctx.attributeValue(att);
            this.isLiteral = (Boolean)val;
        } else if (attName.equals(ATTRIBUTE_DATATYPE_NAME)) {
            Object val = ctx.attributeValue(att);
            this.dataTypeName = (String)val;
        } else if (attName.equals(ATTRIBUTE_MODEL_SIZE)) {
            Object val = ctx.attributeValue(att);
            this.modelSize = (Integer)val;
        } else if (attName.equals(ATTRIBUTE_IS_DATA_SOURCE_PARAMETER)) {
            Object val = ctx.attributeValue(att);
            this.isDataSourceParameter = (Boolean)val;
        } else if (attName.equals(ATTRIBUTE_PROVIDER_HIERARCHY_UNIQUE_NAME)) {
            Object val = ctx.attributeValue(att);
            this.providerHierarchyUniqueName = (String)val;
        } else if (attName.equals(ATTRIBUTE_PROVIDER_NAME)) {
            Object val = ctx.attributeValue(att);
            this.providerName = (String)val;
        } else if (attName.equals(ATTRIBUTE_QUERY_NAME)) {
            Object val = ctx.attributeValue(att);
            this.queryName = (String)val;
        } else if (attName.equals(ATTRIBUTE_IS_PARAMETER_VALUE_REQUIRED)) {
            Object val = ctx.attributeValue(att);
            this.isParameterValueRequired = (Boolean)val;
        } else if (attName.equals(ATTRIBUTE_IS_SAME_MASTER_DETAIL_LINK_LEVEL)) {
            Object val = ctx.attributeValue(att);
            this.isSameMasterDetailLinkLevel = (Boolean)val;
        } else if (attName.equals(ATTRIBUTE_ORDER_INDEX)) {
            Object val = ctx.attributeValue(att);
            this.orderIndex = (Integer)val;
        } else if (attName.equals(ATTRIBUTE_COLUMNNO)) {
            Object val = ctx.attributeValue(att);
            this.columnNo = (Integer)val;
        } else if (attName.equals(ATTRIBUTE_ERROR_CODE)) {
            Object val = ctx.attributeValue(att);
            this.errorCode = (UnresolvedParameterException.ParameterErrorCodeEnum)((Object)val);
        } else if (attName.equals(ATTRIBUTE_EXPLICIT_VALUE_REQUIRED)) {
            Object val = ctx.attributeValue(att);
            this.explicitValueRequired = (Boolean)val;
        } else if (attName.equals(ATTRIBUTE_PARAMETER_REPLACED_BY_VALUE)) {
            Object val = ctx.attributeValue(att);
            this.parameterReplacedByValue = (Boolean)val;
        } else if (attName.equals(ATTRIBUTE_IS_SAP_VARIABLE_FIXED_VALUE)) {
            Object val = ctx.attributeValue(att);
            this.isSAPVariableFixedValue = (Boolean)val;
        } else if (attName.equals(ATTRIBUTE_MODULE_PATH)) {
            Object val = ctx.attributeValue(att);
            this.modulePath = (String)val;
        } else if (attName.equals(ATTRIBUTE_MODEL_PATH)) {
            Object val = ctx.attributeValue(att);
            this.modelPath = (String)val;
        } else if (attName.equals(ATTRIBUTE_INVERT)) {
            Object val = ctx.attributeValue(att);
            this.invert = (Boolean)val;
        }
    }

    protected void restoreChildren(XQERestoreContext ctx, Element node) {
        List childList = node.elements();
        int nChildren = childList.size();
        for (int i = 0; i < nChildren; ++i) {
            Element child = (Element)childList.get(i);
            if (child.getNamespace().getURI().isEmpty()) continue;
            this.restoreElementProperty(ctx, child);
        }
    }

    protected void restoreElementProperty(XQERestoreContext ctx, Element node) {
        String pname = node.attributeValue("pname");
        if (pname.equals(ELEMENT_CAPABILITIES)) {
            Object val = ctx.elementValue(node);
            this.capabilities = (ParameterCapabilities)val;
        } else if (pname.equals(ELEMENT_LEVELS)) {
            Object val = ctx.elementValue(node);
            this.levels = (List)val;
        }
    }

    public void setNameVariable(boolean value) {
        this.nameVariable = value;
    }

    public boolean getNameVariable() {
        return this.nameVariable;
    }

    public String getModulePath() {
        return this.modulePath;
    }

    public void setModulePath(String path) {
        this.modulePath = path;
    }

    public String getModelPath() {
        return this.modelPath;
    }

    public void setModelPath(String path) {
        this.modelPath = path;
    }

    public boolean hasValueProvidedWithRequest() {
        return this.hasValueProvidedWithRequest;
    }

    public void setHasValueProvidedWithRequest(boolean value) {
        this.hasValueProvidedWithRequest = value;
    }

    public boolean isGlobalParameter() {
        return this.isGlobalParameter;
    }

    public void setIsGlobalParameter(boolean value) {
        this.isGlobalParameter = value;
    }

    public void setIsOnlyReferencedInQuery(boolean value) {
        this.isOnlyReferencedInQuery = value;
    }

    public void incrementQueryReferenceCount() {
        ++this.queryReferenceCount;
    }

    public void decrementQueryReferenceCount() {
        --this.queryReferenceCount;
    }

    public void setPromptHandlingNoFault() {
        this.promptHandlingNoFault = true;
    }

    public LOCATION getLocation() {
        if (this.paramLocation != null) {
            return this.paramLocation;
        }
        if (this.hasValueProvidedWithRequest) {
            return LOCATION.REQUEST;
        }
        if (this.isGlobalParameter) {
            return LOCATION.GLOBAL;
        }
        if (this.isDataSourceParameter) {
            return LOCATION.DATASOURCE;
        }
        return LOCATION.QUERY;
    }

    public void setLocation(LOCATION location) {
        this.paramLocation = location;
    }

    public static IDataType getParameterDataType(String dataType) {
        switch (dataType) {
            case "boolean": {
                return BooleanType.BOOLEANTYPE;
            }
            case "string": {
                return StringType.DEFAULTSTRINGTYPE;
            }
            case "integer": {
                return IntegerType.INTEGERTYPE;
            }
            case "decimal": {
                return DecimalType.DEFAULT_DECIMALTYPE;
            }
            case "datetime": {
                return TimestampType.TIMESTAMPTYPE;
            }
            case "time": {
                return TimeType.TIMETYPE;
            }
            case "date": {
                return DateType.DATETYPE;
            }
            case "interval": {
                return IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE;
            }
            case "memberUniqueName": {
                return MemberUniqueNameType.DEFAULTMEMBERUNIQUENAMETYPE;
            }
        }
        return StringType.DEFAULTSTRINGTYPE;
    }

    public void setInvert(boolean invertValue) {
        this.invert = invertValue;
    }

    public boolean getInvert() {
        return this.invert;
    }

    public static enum LOCATION {
        REQUEST("request"),
        GLOBAL("global"),
        MODULE("module"),
        DATASOURCE("datasource"),
        QUERY("query");

        private final String v;

        private LOCATION(String val) {
            this.v = val;
        }

        public String getValue() {
            return this.v;
        }

        public static LOCATION fromString(String in) {
            if (in != null) {
                for (LOCATION current : LOCATION.values()) {
                    if (!in.equals(current.v)) continue;
                    return current;
                }
            }
            return null;
        }
    }
}

