/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.parameters;

import com.cognos.developer.schemas.bibus._3.ParameterCapabilityEnum;
import com.cognos.xqe.ast.IXQEPersist;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class ParameterCapabilities
extends HashSet<ParameterCapabilityEnum>
implements IXQEPersist {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_IS_USED_IN_SINGLE_VALUE_CONTEXT = "isUsedInSingleValueContext";
    private static final String ATTRIBUTE_IS_USED_IN_MULTI_VALUE_CONTEXT = "isUsedInMultiValueContext";
    private static final String ATTRIBUTE_IS_REQUIRED = "isRequired";
    private static final String CAPABILITIES = "capabilities";
    private static final String CAPABILITY_ENUM = "bus:parameterCapabilityEnum";
    private static final String ARRAY_TYPE = "SOAP-ENC:arrayType";
    private static final String TYPE = "xsi:type";
    private static final String ITEM = "item";
    private boolean isUsedInSingleValueContext = false;
    private boolean isUsedInMultiValueContext = false;
    private boolean isRequired = false;

    public boolean isMultivalued() {
        return this.contains(ParameterCapabilityEnum.multivalued);
    }

    public void setMultivalued(boolean value) {
        if (!this.isUsedInSingleValueContext) {
            this.setCapability(ParameterCapabilityEnum.multivalued, value);
        }
        if (value) {
            this.isUsedInMultiValueContext = true;
        } else {
            this.isUsedInSingleValueContext = true;
        }
    }

    public boolean isUsedInSingleAndMultiValueContext() {
        return this.isUsedInSingleValueContext && this.isUsedInMultiValueContext;
    }

    public boolean isOptional() {
        return this.contains(ParameterCapabilityEnum.optional);
    }

    public void setOptional(boolean value) {
        if (!this.isRequired) {
            this.setCapability(ParameterCapabilityEnum.optional, value);
        }
        if (!value) {
            this.isRequired = true;
        }
    }

    public void setRangeSupport(ParameterCapabilityEnum rangeSupport) {
        boolean isDiscrete = this.contains(ParameterCapabilityEnum.discreteValue);
        boolean isBoundRange = this.contains(ParameterCapabilityEnum.boundRange);
        if (rangeSupport == ParameterCapabilityEnum.discreteValue) {
            this.setCapability(ParameterCapabilityEnum.discreteValue, true);
            this.setCapability(ParameterCapabilityEnum.boundRange, false);
            this.setCapability(ParameterCapabilityEnum.unboundedRange, false);
        } else if (rangeSupport == ParameterCapabilityEnum.boundRange && !isDiscrete) {
            this.setCapability(ParameterCapabilityEnum.boundRange, true);
            this.setCapability(ParameterCapabilityEnum.unboundedRange, false);
        } else if (rangeSupport == ParameterCapabilityEnum.unboundedRange && !isDiscrete && !isBoundRange) {
            this.setCapability(ParameterCapabilityEnum.unboundedRange, true);
        }
    }

    public boolean isDiscreteValue() {
        return this.contains(ParameterCapabilityEnum.discreteValue);
    }

    public boolean isBoundRange() {
        return this.contains(ParameterCapabilityEnum.boundRange);
    }

    public boolean isUnboundRange() {
        return this.contains(ParameterCapabilityEnum.unboundedRange);
    }

    public boolean isExcludeValues() {
        return this.contains(ParameterCapabilityEnum.excludeValues);
    }

    public void setExcludeValues(boolean value) {
        this.setCapability(ParameterCapabilityEnum.excludeValues, value);
    }

    public void setCapability(ParameterCapabilityEnum capability, boolean value) {
        if (value) {
            this.add(capability);
        } else {
            this.remove(capability);
        }
    }

    public String asDOMString() {
        StringBuilder capabilitiesString = new StringBuilder();
        if (this.size() > 0) {
            capabilitiesString.append("<capabilities SOAP-ENC:arrayType=" + this.getArrayTypeString());
            ParameterCapabilityEnum[] sortedSet = new ParameterCapabilityEnum[this.size()];
            Arrays.sort(this.toArray(sortedSet), new ParameterCapabilityEnumComparator());
            for (ParameterCapabilityEnum capability : sortedSet) {
                capabilitiesString.append("<item xsi:type=\"bus:parameterCapabilityEnum\">" + capability + "</item>");
            }
            capabilitiesString.append("</capabilities>");
        }
        return capabilitiesString.toString();
    }

    public Element asDOMElement(Element parent) {
        Element capabilitiesElement = null;
        if (this.size() > 0) {
            capabilitiesElement = parent.addElement(CAPABILITIES);
            capabilitiesElement.addAttribute(ARRAY_TYPE, this.getArrayTypeString());
            ParameterCapabilityEnum[] sortedSet = new ParameterCapabilityEnum[this.size()];
            Arrays.sort(this.toArray(sortedSet), new ParameterCapabilityEnumComparator());
            for (ParameterCapabilityEnum capability : sortedSet) {
                Element capabilityItem = capabilitiesElement.addElement(ITEM);
                capabilityItem.addAttribute(TYPE, CAPABILITY_ENUM);
                capabilityItem.setData((Object)capability);
            }
        }
        return capabilitiesElement;
    }

    private String getArrayTypeString() {
        return "\"bus:parameterCapabilityEnum[" + this.size() + "]\" xsi:type=\"SOAP-ENC:Array\">";
    }

    @Override
    public void persist(XQEPersistContext ctx, String optionalName) {
        if (ctx.beginElement(this, optionalName, -1)) {
            this.persistAttributeProperties(ctx);
            this.persistElementProperties(ctx);
            ctx.endElement();
        }
    }

    public void persistAttributeProperties(XQEPersistContext ctx) {
        ctx.property(ATTRIBUTE_IS_USED_IN_SINGLE_VALUE_CONTEXT, this.isUsedInSingleValueContext);
        ctx.property(ATTRIBUTE_IS_USED_IN_MULTI_VALUE_CONTEXT, this.isUsedInMultiValueContext);
        ctx.property(ATTRIBUTE_IS_REQUIRED, this.isRequired);
    }

    public void persistElementProperties(XQEPersistContext ctx) {
        for (ParameterCapabilityEnum value : this) {
            ctx.elementProperty(null, value.toString());
        }
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
        this.restoreAttributes(ctx, node);
        this.restoreChildren(ctx, node);
    }

    public void restoreAttributes(XQERestoreContext ctx, Element node) {
        int size = node.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = node.attribute(i);
            this.restoreAttributeProperty(ctx, att, node);
        }
    }

    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element node) {
        String attName = att.getName();
        if (attName.equals(ATTRIBUTE_IS_USED_IN_SINGLE_VALUE_CONTEXT)) {
            Object val = ctx.attributeValue(att);
            this.isUsedInSingleValueContext = (Boolean)val;
        } else if (attName.equals(ATTRIBUTE_IS_USED_IN_MULTI_VALUE_CONTEXT)) {
            Object val = ctx.attributeValue(att);
            this.isUsedInMultiValueContext = (Boolean)val;
        } else if (attName.equals(ATTRIBUTE_IS_REQUIRED)) {
            Object val = ctx.attributeValue(att);
            this.isRequired = (Boolean)val;
        }
    }

    protected void restoreChildren(XQERestoreContext ctx, Element node) {
        List childList = node.elements();
        int nChildren = childList.size();
        for (int i = 0; i < nChildren; ++i) {
            Element child = (Element)childList.get(i);
            if (child.getNamespace().getURI().isEmpty()) continue;
            this.restoreElementProperty(ctx, child, node);
        }
    }

    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        Object strValue = ctx.elementValue(node);
        if (strValue != null) {
            ParameterCapabilityEnum value = ParameterCapabilityEnum.fromString((String)((String)strValue));
            this.add(value);
        }
    }

    public void appendJSON(JSONObject owner) {
        JSONArray jItems = new JSONArray();
        owner.put((Object)CAPABILITIES, (Object)jItems);
        ParameterCapabilityEnum[] sortedSet = new ParameterCapabilityEnum[this.size()];
        Arrays.sort(this.toArray(sortedSet), new ParameterCapabilityEnumComparator());
        for (ParameterCapabilityEnum capability : sortedSet) {
            jItems.add((Object)capability.toString());
        }
    }

    public class ParameterCapabilityEnumComparator
    implements Comparator<ParameterCapabilityEnum> {
        @Override
        public int compare(ParameterCapabilityEnum first, ParameterCapabilityEnum second) {
            return first.getValue().compareTo(second.getValue());
        }
    }
}

