/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.query.parameters;

import com.cognos.xqe.ast.IXQEPersist;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.ParameterValues;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

public class RequestParameters
implements IXQEPersist {
    private static final String ELEMENT_PARAMETERS = "parameters";
    private static final String ELEMENT_DEFAULT_VALUES_MAP = "defaultValuesMap";
    private static final String ELEMENT_PARAMETER_VALUES_MAP = "parameterValuesMap";
    private static final String ELEMENT_MASTER_DETAIL_PARAMETER_VALUES_MAP = "masterDetailParameterValuesMap";
    private Parameters parameters = new Parameters();
    private Map<String, ParameterValues> defaultValuesMap = new HashMap<String, ParameterValues>();
    private Map<String, ParameterValues> parameterValuesMap = new HashMap<String, ParameterValues>();
    private Map<String, ParameterValues> masterdetailParameterValuesMap = new HashMap<String, ParameterValues>();

    public RequestParameters() {
    }

    public RequestParameters(RequestParameters source) {
        String parameterName;
        if (source == null) {
            return;
        }
        this.setParameters((Parameters)source.getParameters().clone());
        HashMap<String, ParameterValues> clonedDefaultValuesMap = new HashMap<String, ParameterValues>();
        HashMap<String, ParameterValues> clonedParametersValuesMap = new HashMap<String, ParameterValues>();
        for (Map.Entry<String, ParameterValues> entry : source.defaultValuesMap.entrySet()) {
            parameterName = entry.getKey();
            ParameterValues listOfDefaultValues = entry.getValue();
            ParameterValues clonedListOfDefaultValues = (ParameterValues)listOfDefaultValues.clone();
            clonedListOfDefaultValues.setAssociatedParameter(listOfDefaultValues.getAssociatedParameter());
            clonedDefaultValuesMap.put(parameterName, clonedListOfDefaultValues);
        }
        this.setDefaultParameterValueList(clonedDefaultValuesMap);
        for (Map.Entry<String, ParameterValues> entry : this.parameterValuesMap.entrySet()) {
            parameterName = entry.getKey();
            ParameterValues listOfValues = entry.getValue();
            ParameterValues clonedListOfValues = (ParameterValues)listOfValues.clone();
            clonedListOfValues.setAssociatedParameter(listOfValues.getAssociatedParameter());
            clonedParametersValuesMap.put(parameterName, clonedListOfValues);
        }
        this.setParametersValueList(clonedParametersValuesMap);
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public void setParameters(Parameters theParameters) {
        this.parameters = theParameters;
    }

    public boolean hasParameters() {
        boolean hasParameter = false;
        if (!this.parameters.isEmpty()) {
            hasParameter = true;
        }
        return hasParameter;
    }

    private void setDefaultParameterValueList(Map<String, ParameterValues> defaultValueList) {
        this.defaultValuesMap = defaultValueList;
    }

    private void setParametersValueList(Map<String, ParameterValues> valueList) {
        this.parameterValuesMap = valueList;
    }

    public Map<String, ParameterValues> getParametersValueList() {
        return this.parameterValuesMap;
    }

    public ParameterValues getParameterValueItems(Parameter parameter) {
        ParameterValues values = this.getParameterValues(parameter);
        if (null == values) {
            values = new ParameterValues(parameter);
            this.setParameterValues(parameter, values);
        } else {
            Parameter associatedParameter = values.getAssociatedParameter();
            if (associatedParameter.getDataType() == null && parameter.getDataType() != null) {
                associatedParameter.setDataType(parameter.getDataType());
                associatedParameter.setProviderName(parameter.getProviderName());
                associatedParameter.setIsLiteral(parameter.isLiteral());
            }
            if (!parameter.isLiteral() && parameter != associatedParameter && parameter.getDataType().equals(associatedParameter.getDataType()) && !parameter.getModelItem().isEmpty() && !parameter.getModelItem().equals(associatedParameter.getModelItem())) {
                int aSeverity = 1;
                ArrayList<IXQEQueryNode> messageContext = new ArrayList<IXQEQueryNode>();
                RequestEnvironment reqEnv = (RequestEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment();
                XQEMessage message = new XQEMessage(XQEMessageKeys.WRN_MultipleQueriesPromptsWithSameName, parameter.getName(), associatedParameter.getQueryName(), associatedParameter.getModelItem(), parameter.getQueryName(), parameter.getModelItem(), messageContext);
                reqEnv.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, message));
                values.replaceAssociatedParameter(parameter);
            }
            if (associatedParameter.isGlobalParameter() && associatedParameter != parameter) {
                values.replaceAssociatedParameter(parameter);
            }
        }
        return values;
    }

    private ParameterValues getParameterValues(Parameter parameter) {
        ParameterValues values = parameter.isMasterDetailLinkParameter() ? this.masterdetailParameterValuesMap.get(parameter.getParameterName()) : this.parameterValuesMap.get(parameter.getParameterName());
        return values;
    }

    public void removeParameterValues(Parameter parameter) {
        if (parameter.isMasterDetailLinkParameter()) {
            this.masterdetailParameterValuesMap.remove(parameter.getName());
        } else {
            this.parameterValuesMap.remove(parameter.getName());
        }
    }

    private void setParameterValues(Parameter parameter, ParameterValues values) {
        if (parameter.isMasterDetailLinkParameter()) {
            this.masterdetailParameterValuesMap.put(parameter.getName(), values);
        } else {
            this.parameterValuesMap.put(parameter.getName(), values);
        }
    }

    public ParameterValues getParameterDefaultValues(Parameter parameter) {
        ParameterValues defaultValues = this.defaultValuesMap.get(parameter.getName());
        if (null == defaultValues) {
            defaultValues = new ParameterValues(parameter);
            this.defaultValuesMap.put(parameter.getName(), defaultValues);
        }
        return defaultValues;
    }

    public void mergeCachedParameters(Parameters cachedParameters, RequestEnvironment reqEnv) {
        for (Parameter cachedParameter : cachedParameters.values()) {
            String name = cachedParameter.getName();
            this.parameters.addParameter(name, cachedParameter);
            ParameterValues currentValues = this.getParameterValues(cachedParameter);
            if (currentValues != null) {
                currentValues.replaceAssociatedParameter(cachedParameter);
            }
            cachedParameter.bindToRequest(reqEnv);
        }
    }

    @Override
    public void persist(XQEPersistContext ctx, String optionalName) {
        if (ctx.beginElement(this, optionalName, -1)) {
            this.persistElementProperties(ctx);
            ctx.endElement();
        }
    }

    public void persistElementProperties(XQEPersistContext ctx) {
        if (this.parameters != null) {
            ctx.elementProperty(ELEMENT_PARAMETERS, this.parameters);
        }
        if (this.defaultValuesMap != null) {
            ctx.elementProperty(ELEMENT_DEFAULT_VALUES_MAP, this.defaultValuesMap);
        }
        if (this.parameterValuesMap != null) {
            ctx.elementProperty(ELEMENT_PARAMETER_VALUES_MAP, this.parameterValuesMap);
        }
        if (this.masterdetailParameterValuesMap != null) {
            ctx.elementProperty(ELEMENT_MASTER_DETAIL_PARAMETER_VALUES_MAP, this.masterdetailParameterValuesMap);
        }
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
        this.restoreChildren(ctx, node);
    }

    protected void restoreChildren(XQERestoreContext ctx, Element node) {
        List childList = node.elements();
        int nChildren = childList.size();
        for (int i = 0; i < nChildren; ++i) {
            Element child = (Element)childList.get(i);
            if (child.getNamespace().getURI().isEmpty()) continue;
            this.restoreElementProperty(ctx, child);
        }
    }

    protected void restoreElementProperty(XQERestoreContext ctx, Element node) {
        String pname = node.attributeValue("pname");
        if (pname.equals(ELEMENT_PARAMETERS)) {
            Object val = ctx.elementValue(node);
            this.parameters = (Parameters)val;
        } else if (pname.equals(ELEMENT_DEFAULT_VALUES_MAP)) {
            Object val = ctx.elementValue(node);
            this.defaultValuesMap = (Map)val;
        } else if (pname.equals(ELEMENT_PARAMETER_VALUES_MAP)) {
            Object val = ctx.elementValue(node);
            this.parameterValuesMap = (Map)val;
        } else if (pname.equals(ELEMENT_MASTER_DETAIL_PARAMETER_VALUES_MAP)) {
            Object val = ctx.elementValue(node);
            this.masterdetailParameterValuesMap = (Map)val;
        }
    }
}

