/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets;

import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.resultset.interfaces.IContext;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.rsapi.RSAPIRowset;
import com.cognos.xqe.util.xml.XMLWriter;
import com.ibm.icu.text.Collator;

public abstract class ContextBase
implements IContext {
    public static final String NAME_DELIMITER = "'";
    public static final String NAME_SEPARATOR = "\\";
    private RSAPIRowset mRowset;
    private int mDataItemIndex;
    private int mEdgeOrdinal;
    private ContextMember mContextMember;

    @Override
    public void setRowset(RSAPIRowset rowset) {
        this.mRowset = rowset;
    }

    @Override
    public void setDataItemIndex(int index) {
        this.mDataItemIndex = index;
    }

    @Override
    public void setEdgeOrdinal(int edgeOrdinal) {
        this.mEdgeOrdinal = edgeOrdinal;
    }

    @Override
    public RSAPIRowset getRowset() {
        return this.mRowset;
    }

    @Override
    public int getDataItemIndex() {
        return this.mDataItemIndex;
    }

    @Override
    public int getEdgeOrdinal() {
        return this.mEdgeOrdinal;
    }

    @Override
    public void setContextMember(ContextMember context) {
        this.mContextMember = context;
    }

    @Override
    public ContextMember getContextMember() {
        return this.mContextMember;
    }

    protected void copy(ContextBase base) {
        if (base.getContextMember() != null) {
            this.setContextMember((ContextMember)base.getContextMember().copy());
        } else {
            this.setContextMember(null);
        }
        this.setDataItemIndex(base.getDataItemIndex());
        this.setEdgeOrdinal(base.getEdgeOrdinal());
        this.setRowset(base.getRowset());
    }

    public abstract boolean contextIsAMember();

    public abstract boolean contextIsAValue();

    public abstract boolean isSummary();

    public abstract boolean isQueryCalculation();

    protected abstract String getContextTypeName();

    protected void dumpAttributes(XMLWriter xmlWriter) {
        int rowsetId = -1;
        if (this.getRowset() != null) {
            rowsetId = this.getRowset().getRowsetId();
        }
        xmlWriter.attribute("rowsetId", rowsetId);
        xmlWriter.attribute("dataItemIndex", this.getDataItemIndex());
    }

    protected void dumpNestedObjects(XMLWriter xmlWriter) {
        ContextMember context = this.getContextMember();
        if (context != null) {
            context.toXML(xmlWriter);
        }
    }

    public void toXML(XMLWriter xmlWriter) {
        xmlWriter.beginElement(this.getContextTypeName(), -1);
        this.dumpAttributes(xmlWriter);
        this.dumpNestedObjects(xmlWriter);
        xmlWriter.endElement();
    }

    public Object toJSON() {
        throw new UnsupportedOperationException();
    }

    public abstract boolean isNull();

    public boolean isNullContext() {
        return this.mRowset == null;
    }

    public void assignContextFromMember(ContextMember contextMember) {
        this.setContextMember((ContextMember)contextMember.copy());
        this.setDataItemIndex(contextMember.getDataItemIndex());
        this.setEdgeOrdinal(contextMember.getEdgeOrdinal());
        this.setRowset(contextMember.getRowset());
    }

    public int fastHash() {
        return this.hashCode();
    }

    public Object hashKey() {
        return this;
    }

    public Object hashKey(Collator collator) {
        return this.hashKey();
    }

    public int sizeOf() {
        return ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.DEFAULT);
    }

    public void nestedObjectsToString(StringBuilder strBuffer) {
        ContextMember context = this.getContextMember();
        if (context != null) {
            if (strBuffer.length() > 0) {
                strBuffer.append(NAME_SEPARATOR);
            }
            strBuffer.append(NAME_DELIMITER);
            strBuffer.append(context.toString());
            strBuffer.append(NAME_DELIMITER);
        }
    }

    public String memberAndContextToString(StringBuilder strBuffer) {
        this.nestedObjectsToString(strBuffer);
        if (strBuffer.length() > 0) {
            strBuffer.append(NAME_SEPARATOR);
        }
        strBuffer.append(NAME_DELIMITER);
        strBuffer.append(this.toString());
        strBuffer.append(NAME_DELIMITER);
        String contextStr = strBuffer.toString();
        return contextStr;
    }
}

