/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.MemberType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IEncodable;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IAggregateRule;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IMultiRequestHandle;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.RollupTypeEnum;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.resultsets.ContextBase;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.resultsets.MemberProxy;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIRowset;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.edgemapping.EdgeMappingUtils;
import com.cognos.xqe.runtree.olap.mdx.data.cache.CachedCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.Member;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.MetadataCacheKey;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCalculatedMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPRelativeTimeMember;
import com.cognos.xqe.transformation.olap.util.CalcMemberReferencePrefixes;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import com.cognos.xqe.util.xml.XMLWriter;
import com.ibm.icu.text.Collator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ContextMember
extends ContextBase
implements IMember,
IEncodable {
    public static final String CUBENAME_KEY = "cube";
    static final long serialVersionUID = 0L;
    private IMember member;
    private String mV5CalculatedMemberName;
    private String mV5CalculatedMemberCaption;
    private boolean summary = false;
    private boolean queryCalculation = false;
    private boolean calculatedMember = false;
    private boolean isFillerMember = false;
    public static final int NOT_A_CROSSTAB_SPACER = -1;
    public static final int NO_CELLVALUE_CROSSTAB_SPACER = 0;
    public static final int CELLVALUE_CROSSTAB_SPACER = 1;
    private int isCrosstabSpacer = -1;
    private static final String EMPTY_STRING = "";
    private List<Integer> mAdditionalDataItemIndices;
    private HashMap<Integer, ContextValue> mGroupBodyMeasureValues;
    private int ruleId = -1;
    private int olapEdgeMappingColumnId = -1;
    private String customPropertyName = null;
    private String cubeNameFromDataSourceProperties = null;

    private IMember getROLAPCalculatedMember(String uniqueName) {
        IROLAPHierarchy hierarchy = (IROLAPHierarchy)this.getHierarchy();
        Member originalCalcMem = null;
        if (hierarchy.isMeasure() && hierarchy instanceof ROLAPHierarchy) {
            List<ROLAPCalculatedMeasure> calcMeasures = hierarchy.getROLAPCalculatedMeasures();
            for (ROLAPCalculatedMeasure calcMeasure : calcMeasures) {
                if (!uniqueName.equals(calcMeasure.getUniqueName())) continue;
                originalCalcMem = calcMeasure;
                break;
            }
        } else {
            List<ROLAPCalculatedMember> calcMembers = hierarchy.getROLAPCalculatedMembers(this.getCubeNameFromDataSourceProperties());
            for (ROLAPCalculatedMember calMember : calcMembers) {
                if (!uniqueName.equals(calMember.getUniqueName())) continue;
                originalCalcMem = calMember;
                break;
            }
        }
        return originalCalcMem;
    }

    public String getCalculatedMemberName() {
        return this.mV5CalculatedMemberName;
    }

    public void setCalculatedMemberName(String name) {
        this.mV5CalculatedMemberName = name;
    }

    public String getCalculatedMemberCaption() {
        return this.mV5CalculatedMemberCaption;
    }

    public void setCalculatedMemberCaption(String caption) {
        this.mV5CalculatedMemberCaption = caption;
    }

    @Override
    public String getName() {
        if (this.mV5CalculatedMemberName != null) {
            return this.mV5CalculatedMemberName;
        }
        if (this.member == null) {
            return null;
        }
        return this.member.getName();
    }

    @Override
    public int compareTo(Object pObject) {
        if (this.member == null) {
            if (pObject == null) {
                return 0;
            }
            return 1;
        }
        if (pObject instanceof ContextMember) {
            return this.member.compareTo(((ContextMember)pObject).getMember());
        }
        return this.member.compareTo(pObject);
    }

    @Override
    public boolean isPrimitive() {
        return this.member != null && this.member.isPrimitive();
    }

    @Override
    public boolean isMetadata() {
        return true;
    }

    @Override
    public boolean isResultSet() {
        return this.member != null && this.member.isMetadata();
    }

    @Override
    public IDataType getDataType() {
        return MemberType.MEMBERTYPE;
    }

    @Override
    public MetadataType getObjectType() {
        return MetadataType.MEMBER;
    }

    @Override
    public boolean isCalculatedMember() {
        return this.calculatedMember;
    }

    @Override
    public boolean isExtendedCalculatedMember() {
        IDimension dim = this.getDimension();
        if (dim instanceof IROLAPDimension && this.member != null && this.member instanceof CalculatedMember) {
            if (this.member.isExtendedCalculatedMember()) {
                return true;
            }
            IMember originalCalcMem = ((CalculatedMember)this.member).getOriginalCalculatedMember();
            if (originalCalcMem instanceof ROLAPRelativeTimeMember) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isExtendedCalculatedMemberTypeChildRef() {
        return false;
    }

    @Override
    public boolean isExtendedCalculatedMemberWithFormula() {
        IDimension dim = this.getDimension();
        if (dim instanceof IROLAPDimension && this.member != null && this.member instanceof CalculatedMember) {
            if (this.member.isExtendedCalculatedMemberWithFormula()) {
                return true;
            }
            IMember originalCalcMem = ((CalculatedMember)this.member).getOriginalCalculatedMember();
            if (originalCalcMem instanceof ROLAPRelativeTimeMember) {
                return ((ROLAPRelativeTimeMember)originalCalcMem).isExtendedCalculatedMemberWithFormula();
            }
        }
        return false;
    }

    @Override
    public boolean isProviderDefaultMember() {
        return false;
    }

    @Override
    public IMember getDataMember() {
        return this;
    }

    public void setCalculatedMember(boolean aCalculatedMember) {
        this.calculatedMember = aCalculatedMember;
    }

    @Override
    public Set<String> getAvailableProperties() {
        if (this.member == null) {
            return new HashSet<String>();
        }
        return this.member.getAvailableProperties();
    }

    @Override
    public Object getProperty(String propertyName) {
        if (this.member == null) {
            return null;
        }
        return this.member.getProperty(propertyName);
    }

    @Override
    public MetadataConnection getConnection() {
        if (this.member == null) {
            return null;
        }
        return this.member.getConnection();
    }

    @Override
    public IMetadata getParentObject() {
        if (this.member == null) {
            return null;
        }
        return this.member.getParentObject();
    }

    @Override
    public List<IMetadata> getChildMetadataObjects() {
        if (this.member == null) {
            return new ArrayList<IMetadata>();
        }
        return this.member.getChildMetadataObjects();
    }

    @Override
    public String getUniqueName() {
        if (this.mV5CalculatedMemberName != null) {
            return this.mV5CalculatedMemberName;
        }
        if (this.member == null) {
            return null;
        }
        return this.member.getUniqueName();
    }

    @Override
    public String getParentUniqueName() {
        if (this.member == null) {
            return null;
        }
        return this.member.getParentUniqueName();
    }

    @Override
    public IMember getParent() {
        if (this.member == null) {
            return null;
        }
        return this.member.getParent();
    }

    @Override
    public ILevel getLevel() {
        if (this.member == null) {
            return null;
        }
        return this.member.getLevel();
    }

    public String getOriginalMemberCaption() {
        IMember originalCalcMem;
        String caption = null;
        if (this.isROLAP() && this.getOriginalUniqueName() != null && (originalCalcMem = this.getROLAPCalculatedMember(this.getOriginalUniqueName())) != null) {
            caption = originalCalcMem.getCaption();
        }
        if (caption == null) {
            caption = this.member != null ? this.member.getCaption() : this.getCaption();
        }
        return caption;
    }

    @Override
    public String getCaption() {
        if (this.mV5CalculatedMemberCaption != null) {
            if (this.mV5CalculatedMemberCaption.equals(EMPTY_STRING)) {
                return null;
            }
            return this.mV5CalculatedMemberCaption;
        }
        if (this.mV5CalculatedMemberName != null) {
            if (this.mV5CalculatedMemberName.equals(EMPTY_STRING)) {
                return null;
            }
            return this.mV5CalculatedMemberName;
        }
        Value v = null;
        if (this.member != null) {
            v = this.member.getCaptionValue();
        }
        if (v == null || !v.isOK()) {
            return null;
        }
        return FormatService.getInstance().formatValue(v, v.getFormatId());
    }

    @Override
    public Value getCaptionValue() {
        if (this.mV5CalculatedMemberCaption != null) {
            StringValue v = DataValueFactory.createStringValue();
            if (this.mV5CalculatedMemberCaption.equals(EMPTY_STRING)) {
                ((Value)v).setNull();
            } else {
                ((Value)v).set(this.mV5CalculatedMemberCaption);
            }
            return v;
        }
        if (this.mV5CalculatedMemberName != null) {
            StringValue v = DataValueFactory.createStringValue();
            if (this.mV5CalculatedMemberName.equals(EMPTY_STRING)) {
                ((Value)v).setNull();
            } else {
                ((Value)v).set(this.mV5CalculatedMemberName);
            }
            return v;
        }
        if (this.member == null) {
            return null;
        }
        return this.member.getCaptionValue();
    }

    @Override
    public List<IMember> getChildren() {
        if (this.member == null) {
            return new ArrayList<IMember>();
        }
        return this.member.getChildren();
    }

    @Override
    public int getChildrenCardinality() {
        if (this.member == null) {
            return -1;
        }
        return this.member.getChildrenCardinality();
    }

    @Override
    public boolean isMeasure() {
        return this.member != null && this.member.isMeasure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDataBaseCalculation() {
        if (this.member == null) {
            return false;
        }
        boolean isDataBaseCalculation = false;
        boolean needToRemoveCubeName = false;
        if (this.member.getDimension() != null && this.member.getDimension().isShareable()) {
            String cubeName = this.getCubeNameFromDataSourceProperties();
            needToRemoveCubeName = ROLAPContext.setCurrentCubeName(cubeName);
        }
        try {
            if (!this.isQueryCalculation() && this.member.getType() == MemberTypeEnum.GLOBAL_CALCULATION && !this.member.isMeasure()) {
                isDataBaseCalculation = true;
                if (this.isExtendedCalculatedMember() && !this.isExtendedCalculatedMemberWithFormula()) {
                    isDataBaseCalculation = false;
                }
            } else {
                isDataBaseCalculation = !this.isQueryCalculation() && this.member.getType() == MemberTypeEnum.CALCULATED && !this.member.isMeasure() && !this.isCalculatedMember() && !CalcMemberReferencePrefixes.isXQECalculation(this.member);
            }
        }
        finally {
            ROLAPContext.removeCurrentCubeName(needToRemoveCubeName);
        }
        return isDataBaseCalculation;
    }

    public void setMember(IMember aMember) {
        this.member = aMember;
    }

    public IMember getMember() {
        return this.member;
    }

    @Override
    public int getChildIndex(IMember child) {
        if (this.member == null) {
            return -1;
        }
        return this.member.getChildIndex(child);
    }

    @Override
    public IDimension getDimension() {
        if (this.member == null) {
            return null;
        }
        return this.member.getDimension();
    }

    @Override
    public IHierarchy getHierarchy() {
        if (this.member == null) {
            return null;
        }
        return this.member.getHierarchy();
    }

    @Override
    @Deprecated
    public Object getBusinessKey() {
        if (this.member == null) {
            return null;
        }
        return this.member.getBusinessKey();
    }

    @Override
    public Value getBusinessKeyValue() {
        if (this.member == null) {
            return null;
        }
        return this.member.getBusinessKeyValue();
    }

    @Override
    public IMember[] getSiblings(boolean includeSelf) {
        if (this.member == null) {
            return new IMember[0];
        }
        return this.member.getSiblings(includeSelf);
    }

    @Override
    public IMember[] getChildMembers() {
        if (this.member == null) {
            return new IMember[0];
        }
        return this.member.getChildMembers();
    }

    @Override
    public IMember getChildMember(String memberName) {
        if (this.member == null) {
            return null;
        }
        return this.member.getChildMember(memberName);
    }

    @Override
    public boolean isContextMember() {
        return true;
    }

    @Override
    protected void dumpAttributes(XMLWriter xmlWriter) {
        super.dumpAttributes(xmlWriter);
        xmlWriter.attribute("queryCalculation", this.isQueryCalculation());
        if (this.isCalculatedMember()) {
            xmlWriter.attribute("calculatedMember", this.isCalculatedMember());
        }
        if (this.isQueryCalculation() || this.isSummary()) {
            xmlWriter.attribute("summary", this.isSummary());
        }
        if (this.mV5CalculatedMemberName != null) {
            xmlWriter.attribute("V5CalculatedMemberName", this.mV5CalculatedMemberName);
            xmlWriter.attribute("V5CalculatedMemberCaption", this.mV5CalculatedMemberCaption);
        }
        if (this.mAdditionalDataItemIndices != null && !this.mAdditionalDataItemIndices.isEmpty()) {
            xmlWriter.attribute("AdditionalDataItemIndices", this.mAdditionalDataItemIndices.toString());
        }
        if (this.isCrosstabSpacer() != -1) {
            if (this.isCrosstabSpacer() == 0) {
                xmlWriter.attribute("spacer", "noCellValue");
            } else {
                xmlWriter.attribute("spacer", "withCellValue");
            }
        }
    }

    @Override
    protected void dumpNestedObjects(XMLWriter xmlWriter) {
        super.dumpNestedObjects(xmlWriter);
        if (this.member != null) {
            this.member.toXML(xmlWriter);
        }
        if (this.getGroupBodyMeasures() != null) {
            for (ContextValue value : this.getGroupBodyMeasures()) {
                value.toXML(xmlWriter);
            }
        }
    }

    @Override
    protected String getContextTypeName() {
        return "ContextMember";
    }

    @Override
    public Object copy() {
        ContextMember newMember = new ContextMember();
        newMember.copyFrom(this);
        return newMember;
    }

    @Override
    public void copyFrom(IValue dValue) {
        if (!(dValue instanceof ContextMember)) {
            if (dValue instanceof IMember) {
                IMember aMember = (IMember)dValue;
                this.setMember(aMember);
            } else {
                this.setMember(null);
            }
            this.setContextMember(null);
            this.setDataItemIndex(-1);
            this.setRowset(null);
            return;
        }
        ContextMember sourceMember = null;
        try {
            sourceMember = (ContextMember)dValue;
        }
        catch (ClassCastException cce) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, (Throwable)cce, dValue.getDataType().getTypeName(), dValue.toString(), this.getDataType().getTypeName());
        }
        super.copy(sourceMember);
        this.setMember(sourceMember.getMember());
        this.setCalculatedMemberCaption(sourceMember.mV5CalculatedMemberCaption);
        this.setCalculatedMemberName(sourceMember.mV5CalculatedMemberName);
        this.setQueryCalculation(sourceMember.isQueryCalculation());
        this.setSummary(sourceMember.isSummary());
        this.setCalculatedMember(sourceMember.isCalculatedMember());
        this.setAdditionalDataItemIndices(sourceMember.getAdditionalDataItemIndices());
        this.copyGroupBodyMeasures(sourceMember);
        this.setRuleId(sourceMember.getRuleId());
        this.setOlapEdgeMappingColumnId(sourceMember.getOlapEdgeMappingColumnId());
        this.setFillerMember(sourceMember.isFillerMember());
        this.setCustomPropertyName(sourceMember.customPropertyName);
        this.setIsCrosstabSpacer(sourceMember.isCrosstabSpacer);
    }

    public void setCustomPropertyName(String val) {
        this.customPropertyName = val;
    }

    @Override
    public boolean contextIsAMember() {
        return true;
    }

    @Override
    public boolean contextIsAValue() {
        return false;
    }

    public boolean isFillerMember() {
        return this.isFillerMember;
    }

    public void setFillerMember(boolean fillerMemberFlag) {
        this.isFillerMember = fillerMemberFlag;
    }

    @Override
    public boolean isSummary() {
        return this.summary;
    }

    @Override
    public boolean isQueryCalculation() {
        return this.queryCalculation;
    }

    public void setSummary(boolean summaryValue) {
        this.summary = summaryValue;
    }

    public void setQueryCalculation(boolean queryCalculationValue) {
        this.queryCalculation = queryCalculationValue;
    }

    public boolean sameAs(ContextMember aContextMember) {
        if (this == aContextMember) {
            return true;
        }
        if (this.equals(aContextMember)) {
            ContextMember otherContextMember;
            ContextMember thisContextMember = this.getContextMember();
            if (thisContextMember == (otherContextMember = aContextMember.getContextMember())) {
                return true;
            }
            if (thisContextMember == null || otherContextMember == null) {
                return false;
            }
            return thisContextMember.sameAs(otherContextMember);
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ContextMember)) {
            return false;
        }
        ContextMember contextMember = (ContextMember)obj;
        RSAPIRowset rowSet = this.getRowset();
        boolean membersEqual = false;
        if (this.member != null) {
            membersEqual = contextMember.getMember().getUniqueName().equals(this.member.getUniqueName());
        }
        return membersEqual && contextMember.getRowset() != null && rowSet != null && contextMember.getRowset().getRowsetId() == rowSet.getRowsetId() && contextMember.getDataItemIndex() == this.getDataItemIndex();
    }

    public int hashCode() {
        RSAPIRowset rowSet = this.getRowset();
        int memberHashCode = 0;
        if (this.member != null) {
            memberHashCode = this.member.hashCode();
        }
        if (rowSet == null) {
            return memberHashCode;
        }
        return memberHashCode + rowSet.getRowsetId() + this.getDataItemIndex();
    }

    public String toString() {
        if (this.member == null) {
            return EMPTY_STRING;
        }
        return this.member.toString();
    }

    @Override
    public AggregateTypeEnum getRegularAggregate() {
        if (this.member == null) {
            return AggregateTypeEnum.UNKNOWN;
        }
        return this.member.getRegularAggregate();
    }

    @Override
    public AggregateTypeEnum getSemiAggregate() {
        if (this.member == null) {
            return AggregateTypeEnum.UNKNOWN;
        }
        return this.member.getSemiAggregate();
    }

    @Override
    public IAggregateRule[] getAggregateRules() {
        if (this.member == null) {
            return new IAggregateRule[0];
        }
        return this.member.getAggregateRules();
    }

    @Override
    public boolean isNull() {
        return this.member != null && this.member.isNull();
    }

    @Override
    public void setNull() {
    }

    public String getCognosUniqueNameNormalized() {
        String cognosUniqueName = null;
        if (this.mV5CalculatedMemberName == null) {
            String uniqueName;
            if (!this.calculatedMember && this.member != null && (uniqueName = this.member.getUniqueName()) != null) {
                cognosUniqueName = UniqueNameGenerator.createMemberV5UniqueName(this.member.getLevel(), uniqueName);
            }
        } else if (!this.mV5CalculatedMemberName.equals(EMPTY_STRING)) {
            cognosUniqueName = this.mV5CalculatedMemberName;
        }
        return cognosUniqueName;
    }

    @Override
    public String getParentObjectUniqueName() {
        if (this.member == null || this.member.getObjectType() != MetadataType.MEMBER && !this.member.isCalculatedMember()) {
            return null;
        }
        if (this.member.isRelational()) {
            IMember parent = this.member.getParent();
            if (parent == null) {
                return null;
            }
            return parent.getV5UniqueName();
        }
        ILevel level = this.member.getLevel();
        if (null == level || level.isRootLevel()) {
            return null;
        }
        IHierarchy hierarchy = this.member.getHierarchy();
        if (hierarchy.isRagged()) {
            IntegerValue parentLevelNumber = DataValueFactory.createIntegerValue();
            parentLevelNumber.set(this.member.getParentLevelNumber());
            level = level.getHierarchy().getLevel(parentLevelNumber.getInteger());
        } else {
            if (this.isMeasure() && hierarchy.isAutoGenerated()) {
                return null;
            }
            level = this.member.getLevel().getPreviousLevel();
        }
        if (null == level) {
            return null;
        }
        if (this.isOnSharedDimension()) {
            return UniqueNameGenerator.createMemberV5UniqueName(this.getCubeNameFromDataSourceProperties(), level, this.member.getParentUniqueName());
        }
        return UniqueNameGenerator.createMemberV5UniqueName(level, this.member.getParentUniqueName());
    }

    @Override
    public Object hashKey() {
        StringValue key = DataValueFactory.createStringValue();
        if (this.member != null) {
            key.set(this.member.getCaptionValue().getString());
        } else {
            key.setNull();
        }
        return key;
    }

    @Override
    public Object hashKey(Collator collator) {
        StringValue key = DataValueFactory.createStringValue(collator);
        if (this.member != null) {
            key.set(this.member.getCaptionValue().getString());
        } else {
            key.setNull();
        }
        return key;
    }

    public boolean isQueryItem() {
        return false;
    }

    @Override
    public boolean hasChildMetadataObjects() {
        if (this.member == null) {
            return false;
        }
        return this.member.hasChildMetadataObjects();
    }

    public static void nestMembers(ContextMember member1, ContextMember member2) {
        ContextMember rootContextMember = member2;
        while (rootContextMember.getContextMember() != null) {
            if ((rootContextMember = rootContextMember.getContextMember()) != member1) continue;
            return;
        }
        rootContextMember.setContextMember(member1);
    }

    public void setAdditionalDataItemIndices(List<Integer> indices) {
        this.mAdditionalDataItemIndices = indices;
    }

    public List<Integer> getAdditionalDataItemIndices() {
        return this.mAdditionalDataItemIndices;
    }

    public void addValueOfGroupBodyMeasure(ContextValue value) {
        if (this.mGroupBodyMeasureValues == null) {
            this.mGroupBodyMeasureValues = new HashMap();
        }
        this.mGroupBodyMeasureValues.put(value.getDataItemIndex(), value);
    }

    public void copyGroupBodyMeasures(ContextMember sourceMember) {
        if (sourceMember.getGroupBodyMeasures() != null) {
            for (ContextValue value : sourceMember.getGroupBodyMeasures()) {
                this.addValueOfGroupBodyMeasure((ContextValue)value.copy());
            }
        } else {
            this.mGroupBodyMeasureValues = null;
        }
    }

    public Collection<ContextValue> getGroupBodyMeasures() {
        if (this.mGroupBodyMeasureValues == null) {
            return null;
        }
        return this.mGroupBodyMeasureValues.values();
    }

    public boolean hasGroupBodyMeasures() {
        return this.mGroupBodyMeasureValues != null && this.mGroupBodyMeasureValues.size() > 0;
    }

    @Override
    public String getDescription() {
        String descript = null;
        if (this.member != null) {
            descript = this.member.getDescription();
        }
        return descript;
    }

    @Override
    public String getScreenTip() {
        String tip = null;
        if (this.member != null) {
            tip = this.member.getScreenTip();
        }
        return tip;
    }

    @Override
    public String getUniqueID() {
        if (this.member == null) {
            return null;
        }
        return this.member.getUniqueID();
    }

    public void setCaption(String sCaption) {
    }

    @Override
    public int getNumberOfParents() {
        if (this.member == null) {
            return 0;
        }
        return this.member.getNumberOfParents();
    }

    @Override
    public MemberTypeEnum getType() {
        if (this.member == null) {
            return MemberTypeEnum.UNKNOWN;
        }
        return this.member.getType();
    }

    @Override
    public RollupTypeEnum getRollupType() {
        if (this.member == null) {
            return RollupTypeEnum.ROLLUP;
        }
        RollupTypeEnum rollupType = this.member.getRollupType();
        if (rollupType == null) {
            rollupType = RollupTypeEnum.ROLLUP;
        }
        return rollupType;
    }

    @Override
    public boolean isSuppressed() {
        return this.member != null && this.member.isSuppressed();
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getV5UniqueName() {
        String v5UniqueName = null;
        if (this.mV5CalculatedMemberName == null) {
            if (!this.calculatedMember) {
                if (this.isOnSharedDimension()) {
                    v5UniqueName = this.getSharedV5UniqueName(this.getCubeNameFromDataSourceProperties());
                } else if (this.member != null) {
                    v5UniqueName = this.member.getV5UniqueName();
                }
            }
        } else if (!this.mV5CalculatedMemberName.equals(EMPTY_STRING)) {
            v5UniqueName = this.mV5CalculatedMemberName;
        }
        return v5UniqueName;
    }

    private String getSharedV5UniqueName(String cubeName) {
        if (this.member == null) {
            return null;
        }
        if (this.member.isContextMember()) {
            return ((ContextMember)this.member).getSharedV5UniqueName(cubeName);
        }
        if (this.member.getType() == MemberTypeEnum.CALCULATED || this.member.getType() == MemberTypeEnum.GLOBAL_CALCULATION || this.member.getType() == MemberTypeEnum.QUERY_CALCULATION) {
            return ((CalculatedMember)this.member).getV5UniqueName(cubeName);
        }
        return ((IROLAPMember)this.member).getV5UniqueName(cubeName);
    }

    public String getOriginalUniqueName() {
        IMember mem = this.getMember();
        String uniqueName = null;
        if (mem != null && mem instanceof CachedCalculatedMember) {
            uniqueName = ((CachedCalculatedMember)mem).getOriginalUniqueName();
        }
        return uniqueName;
    }

    @Override
    public String getID() {
        return this.getV5UniqueName();
    }

    @Override
    public int getParentLevelNumber() {
        if (this.member == null) {
            return -1;
        }
        return this.member.getParentLevelNumber();
    }

    public ContextMember getMemberWithRowsetContext(RSAPIRowset rowset) {
        if (this.getRowset() == rowset) {
            return this;
        }
        if (this.getContextMember() != null) {
            return this.getContextMember().getMemberWithRowsetContext(rowset);
        }
        return null;
    }

    @Override
    public void release() {
    }

    @Override
    public boolean isRelational() {
        return this.member != null && this.member.isRelational();
    }

    public int getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(int aRuleId) {
        this.ruleId = aRuleId;
    }

    public int getOlapEdgeMappingColumnId() {
        return this.olapEdgeMappingColumnId;
    }

    public void setOlapEdgeMappingColumnId(int anId) {
        this.olapEdgeMappingColumnId = anId;
    }

    public String getOlapEdgeMappingColumnIdsAsString() {
        List<Integer> ids = this.getOlapEdgeMappingColumnIds();
        return EdgeMappingUtils.integerListToString(ids);
    }

    public List<Integer> getOlapEdgeMappingColumnIds() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (ContextMember aContextMember = this; aContextMember != null; aContextMember = aContextMember.getContextMember()) {
            ids.add(XQEIntegerPool.getInteger(aContextMember.getOlapEdgeMappingColumnId()));
        }
        return ids;
    }

    @Override
    public void decode(XDataContext context, DataInput iStream) throws IOException {
        boolean isNull = iStream.readBoolean();
        if (!isNull) {
            long memberKey = iStream.readLong();
            int levelIndex = iStream.readInt();
            MemberProxy memberProxy = new MemberProxy(context, memberKey, levelIndex);
            this.setMember(memberProxy);
        } else {
            this.setMember(null);
        }
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream) throws IOException {
        oStream.writeBoolean(this.isNull());
        if (this.member != null) {
            MetadataCacheKey memKey = context.cacheMember(this.member, this.customPropertyName);
            int index = context.cacheLevel(this.member.getLevel());
            oStream.writeLong(memKey.getKeyValue());
            oStream.writeInt(index);
        }
    }

    @Override
    public boolean isDMR() {
        return false;
    }

    @Override
    public boolean isMFW() {
        return false;
    }

    public boolean isROLAP() {
        return this.getDimension() instanceof IROLAPDimension;
    }

    public IMember getBaseMember() {
        if (this.member == null || !(this.member instanceof ContextMember)) {
            return this.member;
        }
        return ((ContextMember)this.member).getBaseMember();
    }

    public String getExtendedCalculatedMemberCaption() {
        IMember originalCalcMem;
        String caption = null;
        IDimension dim = this.getDimension();
        if (dim instanceof IROLAPDimension && this.member != null && this.member instanceof CalculatedMember && (originalCalcMem = ((CalculatedMember)this.member).getOriginalCalculatedMember()) != null) {
            caption = originalCalcMem.getCaption();
        }
        if (caption == null) {
            caption = this.member != null ? this.member.getCaption() : this.getCaption();
        }
        return caption;
    }

    public int isCrosstabSpacer() {
        return this.isCrosstabSpacer;
    }

    public void setIsCrosstabSpacer(int value) {
        this.isCrosstabSpacer = value;
    }

    public String getCubeNameFromDataSourceProperties() {
        if (this.cubeNameFromDataSourceProperties == null) {
            RSAPIDataset dataSet;
            this.cubeNameFromDataSourceProperties = ROLAPContext.getCurrentCubeName();
            if (this.cubeNameFromDataSourceProperties == null && this.getRowset() != null && (dataSet = this.getRowset().getEdge().getDataset()) != null && dataSet.getPlanningEnvironment() != null) {
                this.cubeNameFromDataSourceProperties = ROLAPContext.getCMDataSourceName(dataSet.getPlanningEnvironment());
            }
        }
        if (this.cubeNameFromDataSourceProperties != null) {
            return this.cubeNameFromDataSourceProperties;
        }
        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Cannot determine which cube");
    }

    public boolean isOnSharedDimension() {
        return this.member != null && this.member.getDimension() != null && this.member.getDimension().isShareable();
    }

    @Override
    public IMetadata getParentObjectSkipFolders() {
        return null;
    }

    @Override
    public String getV5MUN() {
        return null;
    }

    @Override
    public boolean isAccessible() {
        return false;
    }

    @Override
    public void setParentMetadataObject(IMetadata parent) {
    }

    @Override
    public IMultiRequestHandle[] getHandles() {
        return null;
    }

    @Override
    public List<IMetadata> getDescendantMetadataObjectsSkipFolders() {
        return null;
    }

    public boolean isROLAPCalculatedMember() {
        return this.isROLAP() && this.member instanceof CalculatedMember && !this.member.isMeasure() && this.member.getLevel() != null && (this.member.getType() == MemberTypeEnum.GLOBAL_CALCULATION || this.member.getType() == MemberTypeEnum.QUERY_CALCULATION);
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isVisible(boolean inShortcut) {
        return false;
    }
}

