/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets;

import com.cognos.xqe.data.types.BusinessKeyType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.runtree.v5.edgeupdate.XEdgeUpdateSpec;
import java.util.HashMap;
import java.util.Map;

public final class ContextMemberWrapper
extends ContextMember {
    private Value mChangedBusinessKey;
    private Map<String, Object> mChangedCustomProperties = null;
    private String mChangedMemberCaption;
    private String mChangedMemberDescription;
    private String mChangedV5UniqueName;
    private String mChangedParentObjectUniqueName;
    private static final String EMPTY_STRING = "";

    public ContextMemberWrapper(ContextMember cMember) {
        this.copyFrom(cMember);
    }

    public ContextMemberWrapper() {
    }

    @Override
    public Value getBusinessKeyValue() {
        if (this.mChangedBusinessKey != null) {
            return this.mChangedBusinessKey;
        }
        return super.getBusinessKeyValue();
    }

    @Override
    public String getCaption() {
        if (this.mChangedMemberCaption != null) {
            if (this.mChangedMemberCaption.equals(EMPTY_STRING)) {
                return null;
            }
            return this.mChangedMemberCaption;
        }
        return super.getCaption();
    }

    @Override
    public Value getCaptionValue() {
        if (this.mChangedMemberCaption != null) {
            StringValue v = DataValueFactory.createStringValue();
            if (this.mChangedMemberCaption.equals(EMPTY_STRING)) {
                ((Value)v).setNull();
            } else {
                ((Value)v).set(this.mChangedMemberCaption);
            }
            return v;
        }
        return super.getCaptionValue();
    }

    @Override
    public String getDescription() {
        if (this.mChangedMemberDescription != null) {
            if (this.mChangedMemberDescription.equals(EMPTY_STRING)) {
                return null;
            }
            return this.mChangedMemberDescription;
        }
        return super.getDescription();
    }

    @Override
    public String getExtendedCalculatedMemberCaption() {
        if (this.mChangedMemberCaption != null) {
            if (this.mChangedMemberCaption.equals(EMPTY_STRING)) {
                return null;
            }
            return this.mChangedMemberCaption;
        }
        return super.getExtendedCalculatedMemberCaption();
    }

    @Override
    public String getOriginalMemberCaption() {
        if (this.mChangedMemberCaption != null) {
            if (this.mChangedMemberCaption.equals(EMPTY_STRING)) {
                return null;
            }
            return this.mChangedMemberCaption;
        }
        return super.getOriginalMemberCaption();
    }

    @Override
    public String getParentObjectUniqueName() {
        if (this.mChangedParentObjectUniqueName != null) {
            if (this.mChangedParentObjectUniqueName.equals(EMPTY_STRING)) {
                return null;
            }
            return this.mChangedParentObjectUniqueName;
        }
        return super.getParentObjectUniqueName();
    }

    @Override
    public Object getProperty(String propertyName) {
        if (this.mChangedCustomProperties != null && this.mChangedCustomProperties.containsKey(propertyName)) {
            return this.mChangedCustomProperties.get(propertyName);
        }
        return super.getProperty(propertyName);
    }

    @Override
    public String getV5UniqueName() {
        if (this.mChangedV5UniqueName != null) {
            if (this.mChangedV5UniqueName.equals(EMPTY_STRING)) {
                return null;
            }
            return this.mChangedV5UniqueName;
        }
        return super.getV5UniqueName();
    }

    private void changeBusinessKeyValue(Value value) {
        this.mChangedBusinessKey = value;
    }

    public void changeCaption(String caption) {
        if (caption == null) {
            caption = EMPTY_STRING;
        }
        this.mChangedMemberCaption = caption;
    }

    public void changeCustomProperty(String propertyName, Object newPropertyValue) {
        Object oldPropertyValue;
        if (this.mChangedCustomProperties == null) {
            this.mChangedCustomProperties = new HashMap<String, Object>();
        }
        if (newPropertyValue == null && (oldPropertyValue = super.getProperty(propertyName)) instanceof Value) {
            newPropertyValue = ((Value)oldPropertyValue).getDataType().createValue();
        }
        this.mChangedCustomProperties.put(propertyName, newPropertyValue);
    }

    private void changeMemberDescription(String description) {
        if (description == null) {
            description = EMPTY_STRING;
        }
        this.mChangedMemberDescription = description;
    }

    private void changeParentObjectUniqueName(String parentUniqueName) {
        if (parentUniqueName == null) {
            parentUniqueName = EMPTY_STRING;
        }
        this.mChangedParentObjectUniqueName = parentUniqueName;
    }

    private void changeV5UniqueName(String uniqueName) {
        if (uniqueName == null) {
            uniqueName = EMPTY_STRING;
        }
        this.mChangedV5UniqueName = uniqueName;
    }

    public void updateV5Row(XEdgeUpdateSpec updateSpec) {
        block0 : switch (updateSpec.getUpdateType()) {
            case VALUE: {
                this.changeCaption(((Value)updateSpec.getNewValueOrState()).getString());
                break;
            }
            case PROPERTY_VALUE: {
                String propertyName = updateSpec.getPropertyName();
                Value newValue = (Value)updateSpec.getNewValueOrState();
                if (propertyName.equals("_memberCaption")) {
                    this.changeCaption(newValue.getString());
                    break;
                }
                if (propertyName.equals("_memberUniqueName")) {
                    this.changeV5UniqueName(newValue.getString());
                    break;
                }
                if (propertyName.equals("_businessKey")) {
                    this.changeBusinessKeyValue(newValue);
                    break;
                }
                if (propertyName.equals("_memberDescription")) {
                    this.changeMemberDescription(newValue.getString());
                    break;
                }
                if (propertyName.equals("_parentUniqueName")) {
                    this.changeParentObjectUniqueName(newValue.getString());
                    break;
                }
                this.changeCustomProperty(propertyName, newValue);
                break;
            }
            case VALUE_STATE: {
                ValueState newState = (ValueState)((Object)updateSpec.getNewValueOrState());
                switch (newState) {
                    case OK: {
                        break block0;
                    }
                    case NULL: {
                        this.changeCaption(null);
                        break block0;
                    }
                }
                throw new IllegalStateException();
            }
            case PROPERTY_VALUE_STATE: {
                String propertyName = updateSpec.getPropertyName();
                ValueState newState = (ValueState)((Object)updateSpec.getNewValueOrState());
                switch (newState) {
                    case OK: {
                        break block0;
                    }
                    case NULL: {
                        if (propertyName.equals("_businessKey")) {
                            Value businessKey = (Value)BusinessKeyType.DEFAULTBUSINESSKEYTYPE.createValue();
                            businessKey.setNull();
                            this.changeBusinessKeyValue(businessKey);
                            break block0;
                        }
                        if (propertyName.equals("_memberCaption")) {
                            this.changeCaption(null);
                            break block0;
                        }
                        if (propertyName.equals("_memberDescription")) {
                            this.changeMemberDescription(null);
                            break block0;
                        }
                        if (propertyName.equals("_memberUniqueName")) {
                            this.changeV5UniqueName(null);
                            break block0;
                        }
                        if (propertyName.equals("_parentUniqueName")) {
                            this.changeParentObjectUniqueName(null);
                            break block0;
                        }
                        this.changeCustomProperty(propertyName, null);
                        break block0;
                    }
                }
                throw new IllegalStateException();
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public Object copy() {
        ContextMemberWrapper newMember = new ContextMemberWrapper();
        newMember.copyFrom(this);
        return newMember;
    }

    @Override
    public void copyFrom(IValue dValue) {
        if (dValue instanceof ContextMemberWrapper) {
            ContextMemberWrapper sourceWrapper = (ContextMemberWrapper)dValue;
            this.mChangedBusinessKey = sourceWrapper.mChangedBusinessKey;
            if (sourceWrapper.mChangedCustomProperties != null) {
                this.mChangedCustomProperties = new HashMap<String, Object>(sourceWrapper.mChangedCustomProperties);
            }
            this.mChangedMemberCaption = sourceWrapper.mChangedMemberCaption;
            this.mChangedMemberDescription = sourceWrapper.mChangedMemberDescription;
            this.mChangedParentObjectUniqueName = sourceWrapper.mChangedParentObjectUniqueName;
            this.mChangedV5UniqueName = sourceWrapper.mChangedV5UniqueName;
        }
        super.copyFrom(dValue);
    }

    public String getChangedMemberCaption() {
        return this.mChangedMemberCaption;
    }
}

