/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets.caching;

import com.cognos.xqe.cache.ICaching;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.caching.CachedResultSetManager;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.util.resource.ReleasableResourceTracker;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class CachedResultSet
extends XResultSetBase
implements ITabularResultSet,
ICaching {
    protected static final String FLINT_INFO_RETURNING_THE_POOLED_CONNECTION = "FlintResultSet: %s - Returning the Flint Pooled Connection (%s).\nTotal Time Flint Pooled Connection was borrowed: %.3f secs.";
    protected final int id;
    protected String key;
    protected ITabularResultSet inputResultSet;
    protected final AtomicInteger refCount = new AtomicInteger(1);
    protected boolean canceled = false;
    protected int maxMemory;
    protected long timeLastUsed;
    protected long timeCreated;
    protected CachedResultSetManager.IPooledConnectionDelegator resultSetPooledConnectionDelegator;

    public CachedResultSet(XDataContext context, ITabularResultSet iResultSet, CachedResultSetManager.IPooledConnectionDelegator iResultSetPooledConnectionDelegator, ReleasableResourceTracker tracker, int cachedResultSetId, String theKey) {
        super(context, iResultSet.getTabularRowsetInfo(), context.getNodeId(), tracker);
        this.key = theKey;
        this.inputResultSet = iResultSet;
        this.resultSetPooledConnectionDelegator = iResultSetPooledConnectionDelegator;
        this.id = cachedResultSetId;
        this.setTimeCreated(System.currentTimeMillis());
        this.setTimeLastUsed(this.getTimeCreated());
    }

    public CachedResultSet(XDataContext context, ITabularResultSet iResultSet, CachedResultSetManager.IPooledConnectionDelegator iResultSetPooledConnectionDelegator, ReleasableResourceTracker tracker, int cachedResultSetId, String theKey, int theMaxMemory) {
        this(context, iResultSet, iResultSetPooledConnectionDelegator, tracker, cachedResultSetId, theKey);
        this.maxMemory = theMaxMemory;
    }

    public int getId() {
        return this.id;
    }

    public void incrementReferenceCount() {
        this.refCount.incrementAndGet();
    }

    public void decrementReferenceCount() {
        if (0 == this.refCount.decrementAndGet()) {
            this.freeResources();
        }
    }

    public int getReferenceCount() {
        return this.refCount.get();
    }

    public void setTimeLastUsed(long theTimeLastUsed) {
        this.timeLastUsed = theTimeLastUsed;
    }

    public long getTimeLastUsed() {
        return this.timeLastUsed;
    }

    public void setTimeCreated(long theTimeCreated) {
        this.timeCreated = theTimeCreated;
    }

    public long getTimeCreated() {
        return this.timeCreated;
    }

    @Override
    public boolean isCaching() {
        return true;
    }

    public synchronized boolean isCanceledJDBCTabularResultSet() {
        return false;
    }

    private void freeResources() {
        super.release();
    }
}

