/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets.caching;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.caching.ForwardOnlyTabularCache;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatchUtil;
import com.cognos.xqe.util.io.BufferedDataInputStream;
import com.cognos.xqe.util.io.BufferedDataOutputStream;
import com.cognos.xqe.util.io.TempFileUtil;
import com.cognos.xqe.util.primitive.ArrayListLong;
import com.cognos.xqe.util.primitive.LongArrayList;
import java.io.IOException;
import java.util.ArrayList;

public class ForwardOnlyColumnarCache
extends ForwardOnlyTabularCache {
    private ArrayList<XVectorRowBatch> memoryBatchCache = new ArrayList();
    private ArrayListLong batchRowCounts = new ArrayListLong();
    private LongArrayList batchFileOffsets = new LongArrayList(5000);
    private int cachedBatchCount = 0;
    private static final int INITIAL_CAPACITY = 5000;
    private XVectorRowBatch rowBatch;

    public ForwardOnlyColumnarCache(XDataContext context, ITabularResultSet resultSet, int id, int maxMemory) {
        super(context, resultSet, id, maxMemory);
        this.rowBatch = XVectorRowBatchUtil.createRowBatch(this.rowsetInfo, context.getLocalCollator());
    }

    @Override
    public synchronized ITabularIterator getTabularIterator(XDataContext context) {
        return this.getTabularIterator(context, null);
    }

    @Override
    public synchronized ITabularIterator getTabularIterator(XDataContext context, XVectorContext vContext) {
        ColumnarCacheReadIterator result = null == this.tableIterator ? new CompleteColumnarCacheIterator(this, context, vContext) : new ColumnarCacheIterator(context, vContext);
        return result;
    }

    @Override
    public synchronized boolean isCompleted() {
        return this.tableIterator == null;
    }

    private final class ColumnarCacheIterator
    extends ColumnarCacheReadIterator {
        private ColumnarCacheIterator(XDataContext xDataContext, XVectorContext vContext) {
            super(ForwardOnlyColumnarCache.this, xDataContext, vContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void windupInputStreamAndDecodeBatch() throws IOException {
            BufferedDataInputStream inputStream = this.getOrCreateInputStream();
            ForwardOnlyColumnarCache forwardOnlyColumnarCache = ForwardOnlyColumnarCache.this;
            synchronized (forwardOnlyColumnarCache) {
                if (this.currentBatchIndex - ForwardOnlyColumnarCache.this.memoryBatchCache.size() > 0 && this.lastBatchIndexFromStream + 1L < (long)this.currentBatchIndex) {
                    long size = ForwardOnlyColumnarCache.this.batchFileOffsets.get(this.currentBatchIndex - ForwardOnlyColumnarCache.this.memoryBatchCache.size());
                    if (this.lastBatchIndexFromStream >= 0L) {
                        size -= ForwardOnlyColumnarCache.this.batchFileOffsets.get((int)this.lastBatchIndexFromStream - ForwardOnlyColumnarCache.this.memoryBatchCache.size());
                    }
                    inputStream.skip(size);
                }
                if (ForwardOnlyColumnarCache.this.outputStream != null) {
                    ForwardOnlyColumnarCache.this.outputStream.flush();
                }
            }
            this.decodeBatch();
            this.lastBatchIndexFromStream = this.currentBatchIndex;
        }

        @Override
        public Object nextBatch() {
            XVectorRowBatch result = this.batch;
            result.reset(true);
            ++this.currentBatchIndex;
            try {
                if (this.currentBatchIndex >= ForwardOnlyColumnarCache.this.cachedBatchCount) {
                    XVectorRowBatch input;
                    if (ForwardOnlyColumnarCache.this.tableIterator == null) {
                        if (ForwardOnlyColumnarCache.this.getCancelReason() != null) {
                            throw ForwardOnlyColumnarCache.this.getCancelReason();
                        }
                        this.batch.eod = true;
                        return this.batch;
                    }
                    try {
                        input = (XVectorRowBatch)ForwardOnlyColumnarCache.this.tableIterator.nextBatch();
                    }
                    catch (XQERuntimeException e) {
                        ForwardOnlyColumnarCache.this.setCancelReason(e);
                        ForwardOnlyColumnarCache.this.release();
                        throw e;
                    }
                    result = input;
                    XVectorRowBatch resultCopy = result.copy();
                    if (ForwardOnlyColumnarCache.this.memoryRemaining > 0L && ForwardOnlyColumnarCache.this.memoryRemaining - (long)result.sizeOf() > 0L) {
                        ForwardOnlyColumnarCache.this.memoryBatchCache.add(result.copy());
                        ForwardOnlyColumnarCache.this.memoryRemaining -= (long)result.sizeOf();
                    } else {
                        ForwardOnlyColumnarCache.this.memoryRemaining = 0L;
                        this.openOutputStream();
                        ForwardOnlyColumnarCache.this.batchFileOffsets.add(ForwardOnlyColumnarCache.this.outputStream.size());
                        result.encode(this.context, ForwardOnlyColumnarCache.this.outputStream);
                    }
                    if (ForwardOnlyColumnarCache.this.cachedBatchCount == 0) {
                        ForwardOnlyColumnarCache.this.batchRowCounts.add(result.size);
                    } else {
                        long offset = ForwardOnlyColumnarCache.this.batchRowCounts.get(ForwardOnlyColumnarCache.this.cachedBatchCount - 1) + (long)result.size;
                        ForwardOnlyColumnarCache.this.batchRowCounts.add(offset);
                    }
                    ForwardOnlyColumnarCache.this.cachedBatchCount++;
                    if (input.eod) {
                        if (ForwardOnlyTabularCache.infoLogger.isOn()) {
                            ForwardOnlyTabularCache.infoLogger.log(String.format("Completed data retrieval from underlying data source for cached result set [id=%1$d, cachedRowCount=%2$d].", ForwardOnlyColumnarCache.this.requestId, ForwardOnlyColumnarCache.this.cachedBatchCount));
                        }
                        ForwardOnlyColumnarCache.this.releaseInputIteratorAndOutputStream();
                    }
                    if (ForwardOnlyColumnarCache.this.logDsAccess) {
                        if (ForwardOnlyTabularCache.infoLogger.isOn()) {
                            ForwardOnlyTabularCache.infoLogger.log(String.format("Retrieving data from underlying data source for cached result set [id=%1$d].", ForwardOnlyColumnarCache.this.requestId));
                        }
                        ForwardOnlyColumnarCache.this.logDsAccess = false;
                    }
                    return resultCopy;
                }
                if (this.currentBatchIndex < ForwardOnlyColumnarCache.this.memoryBatchCache.size()) {
                    result = (XVectorRowBatch)ForwardOnlyColumnarCache.this.memoryBatchCache.get(this.currentBatchIndex);
                } else {
                    this.windupInputStreamAndDecodeBatch();
                    result = this.forwardOnlyColumnarCache.rowBatch;
                }
            }
            catch (IOException e) {
                throw new XQERuntimeException(e);
            }
            return this.batch.shallowCopyFrom(result);
        }

        private void openOutputStream() {
            if (ForwardOnlyColumnarCache.this.outputStream == null) {
                try {
                    ForwardOnlyColumnarCache.this.tempFile = TempFileUtil.createTempFile(this.getClass().getSimpleName(), ".cache");
                    ForwardOnlyColumnarCache.this.outputStream = new BufferedDataOutputStream(ForwardOnlyColumnarCache.this.tempFile, 1, ForwardOnlyColumnarCache.this.requestId);
                }
                catch (Exception e) {
                    this.release();
                    throw new XQERuntimeException(e);
                }
            }
        }

        @Override
        public long positionOnRow(long iDetailRowNumber, boolean top) {
            long detailRowNumber = -1L;
            if (top) {
                if (iDetailRowNumber < 0L) {
                    iDetailRowNumber = 0L;
                }
                detailRowNumber = iDetailRowNumber;
                if (ForwardOnlyColumnarCache.this.batchRowCounts.isEmpty()) {
                    this.nextBatch();
                }
                while (ForwardOnlyColumnarCache.this.batchRowCounts.get(ForwardOnlyColumnarCache.this.batchRowCounts.size() - 1) < detailRowNumber + 1L && ForwardOnlyColumnarCache.this.tableIterator != null) {
                    this.nextBatch();
                }
                detailRowNumber = Math.min(ForwardOnlyColumnarCache.this.batchRowCounts.get(ForwardOnlyColumnarCache.this.batchRowCounts.size() - 1) - 1L, detailRowNumber);
            } else {
                while (ForwardOnlyColumnarCache.this.tableIterator != null) {
                    this.nextBatch();
                }
                detailRowNumber = Math.max(0L, ForwardOnlyColumnarCache.this.batchRowCounts.get(ForwardOnlyColumnarCache.this.batchRowCounts.size() - 1) - iDetailRowNumber);
            }
            if (ForwardOnlyColumnarCache.this.batchRowCounts.size() == 1 && ForwardOnlyColumnarCache.this.batchRowCounts.get(0) == 0L) {
                return -1L;
            }
            this.currentIndex = detailRowNumber - 1L;
            int batchIndex = this.getBatchIndex(ForwardOnlyColumnarCache.this.batchRowCounts, detailRowNumber);
            if (batchIndex == -1) {
                return -1L;
            }
            if (this.currentBatchIndex != batchIndex) {
                this.currentBatchIndex = batchIndex;
                if (batchIndex < ForwardOnlyColumnarCache.this.memoryBatchCache.size()) {
                    this.batch.shallowCopyFrom((XVectorRowBatch)this.forwardOnlyColumnarCache.memoryBatchCache.get(batchIndex));
                } else {
                    long byteOffset = this.forwardOnlyColumnarCache.batchFileOffsets.get(batchIndex - ForwardOnlyColumnarCache.this.memoryBatchCache.size());
                    try {
                        BufferedDataInputStream inputStream = this.getOrCreateInputStream();
                        inputStream.seek(byteOffset);
                        this.decodeBatch();
                        this.batch.shallowCopyFrom(this.forwardOnlyColumnarCache.rowBatch);
                        this.lastBatchIndexFromStream = batchIndex;
                    }
                    catch (IOException e) {
                        throw new XQERuntimeException(e);
                    }
                }
            }
            if (batchIndex > 0) {
                this.currentIndex -= ForwardOnlyColumnarCache.this.batchRowCounts.get(batchIndex - 1);
            }
            return detailRowNumber;
        }
    }

    private static final class CompleteColumnarCacheIterator
    extends ColumnarCacheReadIterator {
        private static final String USING_CACHED_DATA = "Using data from cached result set [id=%1$d, cachedRowCount=%2$d].";

        private CompleteColumnarCacheIterator(ForwardOnlyColumnarCache iForwardOnlyTabularCache, XDataContext xDataContext, XVectorContext vContext) {
            super(iForwardOnlyTabularCache, xDataContext, vContext);
            if (ForwardOnlyTabularCache.infoLogger.isOn()) {
                ForwardOnlyTabularCache.infoLogger.log(String.format(USING_CACHED_DATA, iForwardOnlyTabularCache.requestId, iForwardOnlyTabularCache.cachedBatchCount));
            }
        }

        @Override
        public Object nextBatch() {
            XVectorRowBatch tmpBatch;
            ++this.currentBatchIndex;
            this.batch.reset(true);
            if (this.currentBatchIndex < this.forwardOnlyColumnarCache.memoryBatchCache.size()) {
                tmpBatch = (XVectorRowBatch)this.forwardOnlyColumnarCache.memoryBatchCache.get(this.currentBatchIndex);
            } else {
                try {
                    if (this.currentBatchIndex >= this.forwardOnlyColumnarCache.cachedBatchCount) {
                        this.batch.eod = true;
                        return this.batch;
                    }
                    tmpBatch = this.decodeBatch();
                }
                catch (IOException e) {
                    throw new XQERuntimeException(e);
                }
            }
            return this.batch.shallowCopyFrom(tmpBatch);
        }

        @Override
        public long positionOnRow(long iDetailRowNumber, boolean top) {
            long detailRowNumber;
            ArrayListLong batchOffsets = this.forwardOnlyColumnarCache.batchRowCounts;
            if (this.forwardOnlyColumnarCache.cachedBatchCount == 0) {
                return -1L;
            }
            if (top) {
                if (iDetailRowNumber < 0L) {
                    iDetailRowNumber = 0L;
                }
                detailRowNumber = Math.min(batchOffsets.get(batchOffsets.size() - 1) - 1L, iDetailRowNumber);
            } else {
                detailRowNumber = Math.max(0L, batchOffsets.get(batchOffsets.size() - 1) - iDetailRowNumber);
            }
            this.currentIndex = detailRowNumber - 1L;
            int batchIndex = this.getBatchIndex(batchOffsets, this.currentIndex);
            if (batchIndex == -1) {
                return -1L;
            }
            this.currentBatchIndex = batchIndex;
            if (batchIndex < this.forwardOnlyColumnarCache.memoryBatchCache.size()) {
                this.batch.shallowCopyFrom((XVectorRowBatch)this.forwardOnlyColumnarCache.memoryBatchCache.get(batchIndex));
            } else {
                long byteOffset = this.forwardOnlyColumnarCache.batchFileOffsets.get(batchIndex - this.forwardOnlyColumnarCache.memoryBatchCache.size());
                try {
                    BufferedDataInputStream inputStream = this.getOrCreateInputStream();
                    inputStream.seek(byteOffset);
                    this.decodeBatch();
                    this.batch.shallowCopyFrom(this.forwardOnlyColumnarCache.rowBatch);
                    this.lastBatchIndexFromStream = batchIndex;
                }
                catch (IOException e) {
                    throw new XQERuntimeException(e);
                }
            }
            if (batchIndex > 0) {
                this.currentIndex -= batchOffsets.get(batchIndex - 1);
            }
            return detailRowNumber;
        }
    }

    private static abstract class ColumnarCacheReadIterator
    extends XTabularIterator {
        protected ForwardOnlyColumnarCache forwardOnlyColumnarCache;
        protected long lastBatchIndexFromStream = -1L;
        protected int currentBatchIndex = -1;
        private BufferedDataInputStream inputStream = null;
        protected XVectorRowBatch batch;
        private IRow row;

        protected ColumnarCacheReadIterator(ForwardOnlyColumnarCache iForwardOnlyTabularCache, XDataContext xDataContext, XVectorContext vContext) {
            super(xDataContext, xDataContext.getNodeId());
            this.forwardOnlyColumnarCache = iForwardOnlyTabularCache;
            this.batch = XVectorRowBatchUtil.createRowBatch(vContext, this.forwardOnlyColumnarCache.rowsetInfo, this.context.getLocalCollator(), true);
        }

        @Override
        public Object nextImpl() {
            if (this.context.isCanceled()) {
                throw new OperationCanceledException(this.context.getCancelSource());
            }
            if (this.row == null) {
                this.row = DataValueFactory.createRowValue(this.context.getLocalCollator(), this.forwardOnlyColumnarCache.rowsetInfo);
            }
            ++this.currentIndex;
            if (this.currentIndex == (long)this.batch.size) {
                this.batch = (XVectorRowBatch)this.nextBatch();
                this.currentIndex = 0L;
            }
            if (this.batch.eod) {
                return null;
            }
            int srcIndex = (int)this.currentIndex;
            if (this.batch.selectedInUse) {
                srcIndex = this.batch.selected[srcIndex];
            }
            int nColumns = this.forwardOnlyColumnarCache.rowsetInfo.getNumColumns();
            for (int j = 0; j < nColumns; ++j) {
                ColumnVector vector = this.batch.columns[j];
                int vectorIndex = srcIndex;
                if (vector.isRepeating) {
                    vectorIndex = 0;
                }
                vector.getValue(vectorIndex, (Value)this.row.getColumn(j));
            }
            return this.row;
        }

        protected final BufferedDataInputStream getOrCreateInputStream() throws IOException {
            if (null == this.inputStream) {
                this.inputStream = new BufferedDataInputStream(this.forwardOnlyColumnarCache.tempFile);
            }
            return this.inputStream;
        }

        protected final XVectorRowBatch decodeBatch() throws IOException {
            try {
                this.forwardOnlyColumnarCache.rowBatch.decode(this.context, this.getOrCreateInputStream());
            }
            catch (RuntimeException re) {
                String message = "Decoding failed (file=" + this.forwardOnlyColumnarCache.tempFile.getName() + ")" + " (currentIndex=" + this.currentIndex + ")" + " (nRows=" + this.nRows + ")";
                mErrorLogger.log(message, (Throwable)re);
                throw new XQERuntimeException(re);
            }
            return this.forwardOnlyColumnarCache.rowBatch;
        }

        @Override
        public void release() {
            try {
                if (this.inputStream != null) {
                    this.inputStream.close();
                    this.inputStream = null;
                }
            }
            catch (IOException e) {
                throw new XQERuntimeException(e);
            }
            finally {
                this.inputStream = null;
                this.forwardOnlyColumnarCache = null;
                super.release();
            }
        }

        protected int getBatchIndex(ArrayListLong batchOffsets, long currentRowIndex) {
            for (int i = 0; i < batchOffsets.size(); ++i) {
                if (currentRowIndex >= batchOffsets.get(i)) continue;
                return i;
            }
            return -1;
        }
    }
}

