/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets.caching;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.ResultSetValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatchUtil;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.io.BufferedDataInputStream;
import com.cognos.xqe.util.io.BufferedDataOutputStream;
import com.cognos.xqe.util.io.TempFileUtil;
import com.cognos.xqe.util.primitive.LongArrayList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class ForwardOnlyTabularCache {
    private ArrayList<IRow> memoryCache = new ArrayList();
    protected long memoryRemaining;
    protected static final int PAGE_SIZE = 0x100000;
    protected ITabularIterator tableIterator;
    protected IRowsetInfo rowsetInfo;
    private long cachedRowCount = 0L;
    protected File tempFile;
    protected BufferedDataOutputStream outputStream;
    protected final int requestId;
    protected static final int INITIAL_CAPACITY = 5000;
    protected LongArrayList rowOffsets = new LongArrayList(5000);
    protected static XQELogger infoLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "CacheManager", LogLevel.INFO);
    protected static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    protected static final String STARTING_DATA_RETRIEVAL = "Retrieving data from underlying data source for cached result set [id=%1$d].";
    protected static final String COMPLETED_DATA_RETRIEVAL = "Completed data retrieval from underlying data source for cached result set [id=%1$d, cachedRowCount=%2$d].";
    protected static final String CLOSING_PARENTHESIS = ")";
    protected boolean logDsAccess = true;
    protected int nPages;
    protected XQERuntimeException cancelReason = null;
    DataReadBackgroundThread threadBackGroundLoading = null;
    ITabularResultSet inputResultSet = null;

    public ForwardOnlyTabularCache(XDataContext context, ITabularResultSet resultSet, int id, int maxMemory) {
        this.nPages = maxMemory;
        this.memoryRemaining = this.nPages * 0x100000;
        this.requestId = id;
        this.rowsetInfo = resultSet.getTabularRowsetInfo();
        this.tableIterator = resultSet.getTabularIterator();
        this.inputResultSet = resultSet;
    }

    public synchronized ITabularIterator getTabularIterator(XDataContext context) {
        return this.getTabularIterator(context, null);
    }

    public synchronized ITabularIterator getTabularIterator(XDataContext context, XVectorContext vContext) {
        TabularCacheReadIterator result = null == this.tableIterator ? new CompleteTabularCacheIterator(this, context, vContext) : new TabularCacheIterator(context, vContext);
        return result;
    }

    public IRowsetInfo getTabularRowsetInfo() {
        return this.rowsetInfo;
    }

    public synchronized boolean isCompleted() {
        return this.tableIterator == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseInputIteratorAndOutputStream() throws IOException {
        ForwardOnlyTabularCache forwardOnlyTabularCache = this;
        synchronized (forwardOnlyTabularCache) {
            block20: {
                try {
                    if (this.tableIterator != null) {
                        try {
                            this.tableIterator.release();
                        }
                        finally {
                            this.tableIterator = null;
                        }
                    }
                    if (this.inputResultSet == null) break block20;
                    try {
                        this.inputResultSet.release();
                    }
                    finally {
                        this.inputResultSet = null;
                    }
                }
                finally {
                    if (this.outputStream != null) {
                        try {
                            this.outputStream.flush();
                            this.outputStream.close();
                        }
                        finally {
                            this.outputStream = null;
                        }
                    }
                }
            }
        }
    }

    public void release() {
        try {
            try {
                this.releaseInputIteratorAndOutputStream();
            }
            finally {
                if (this.tempFile != null) {
                    TempFileUtil.deleteTempFile(this.tempFile);
                }
            }
        }
        catch (IOException e) {
            mErrorLogger.log(e);
        }
        finally {
            this.rowsetInfo = null;
            this.tempFile = null;
        }
    }

    public void setCancelReason(XQERuntimeException theCancelReason) {
        this.cancelReason = theCancelReason;
    }

    public XQERuntimeException getCancelReason() {
        return this.cancelReason;
    }

    public boolean isCanceled() {
        return this.inputResultSet instanceof ResultSetValue && ((ResultSetValue)((Object)this.inputResultSet)).getDataContext().isCanceled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadInBackground() {
        ForwardOnlyTabularCache forwardOnlyTabularCache = this;
        synchronized (forwardOnlyTabularCache) {
            if (this.tableIterator == null) {
                return 1;
            }
            if (this.threadBackGroundLoading != null) {
                return 2;
            }
            IExecutionEnvironment execEnv = ExecutionEnvironmentContext.getExecutionEnvironment();
            XDataContext context = execEnv.getDataContext();
            TabularCacheIterator tabIter = (TabularCacheIterator)this.getTabularIterator(context, null);
            this.threadBackGroundLoading = new DataReadBackgroundThread(tabIter, context);
            this.threadBackGroundLoading.setPriority(1);
            this.threadBackGroundLoading.start();
            return 0;
        }
    }

    private final class TabularCacheIterator
    extends TabularCacheReadIterator {
        long lastRowIndexFromStream;

        private TabularCacheIterator(XDataContext xDataContext, XVectorContext vContext) {
            super(ForwardOnlyTabularCache.this, xDataContext, vContext);
            this.lastRowIndexFromStream = -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void windupInputStreamAndDecodeRow() throws IOException {
            BufferedDataInputStream inputStream = this.getOrCreateInputStream();
            ForwardOnlyTabularCache forwardOnlyTabularCache = ForwardOnlyTabularCache.this;
            synchronized (forwardOnlyTabularCache) {
                if (this.currentIndex - (long)ForwardOnlyTabularCache.this.memoryCache.size() > 0L && this.lastRowIndexFromStream + 1L < this.currentIndex) {
                    long size = ForwardOnlyTabularCache.this.rowOffsets.get((int)this.currentIndex - ForwardOnlyTabularCache.this.memoryCache.size() - 1);
                    if (this.lastRowIndexFromStream >= 0L) {
                        size -= ForwardOnlyTabularCache.this.rowOffsets.get((int)this.lastRowIndexFromStream - ForwardOnlyTabularCache.this.memoryCache.size());
                    }
                    inputStream.skip(size);
                }
                if (ForwardOnlyTabularCache.this.outputStream != null) {
                    ForwardOnlyTabularCache.this.outputStream.flush();
                }
            }
            this.decodeRow();
            this.lastRowIndexFromStream = this.currentIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object nextImpl() {
            IRow result = this.row;
            ++this.currentIndex;
            ForwardOnlyTabularCache forwardOnlyTabularCache = ForwardOnlyTabularCache.this;
            synchronized (forwardOnlyTabularCache) {
                block19: {
                    try {
                        if (this.currentIndex >= ForwardOnlyTabularCache.this.cachedRowCount) {
                            IRow input;
                            if (ForwardOnlyTabularCache.this.tableIterator == null) {
                                if (ForwardOnlyTabularCache.this.getCancelReason() != null) {
                                    throw ForwardOnlyTabularCache.this.getCancelReason();
                                }
                                return null;
                            }
                            try {
                                input = (IRow)ForwardOnlyTabularCache.this.tableIterator.next();
                            }
                            catch (XQERuntimeException e) {
                                ForwardOnlyTabularCache.this.setCancelReason(e);
                                ForwardOnlyTabularCache.this.release();
                                throw e;
                            }
                            if (input == null) {
                                if (infoLogger.isOn()) {
                                    infoLogger.log(String.format(ForwardOnlyTabularCache.COMPLETED_DATA_RETRIEVAL, ForwardOnlyTabularCache.this.requestId, ForwardOnlyTabularCache.this.cachedRowCount));
                                }
                                ForwardOnlyTabularCache.this.releaseInputIteratorAndOutputStream();
                                return null;
                            }
                            result = (IRow)input.copy();
                            if (ForwardOnlyTabularCache.this.memoryRemaining > 0L && ForwardOnlyTabularCache.this.memoryRemaining - (long)result.sizeOf() > 0L) {
                                ForwardOnlyTabularCache.this.memoryCache.add((int)ForwardOnlyTabularCache.this.cachedRowCount++, result);
                                ForwardOnlyTabularCache.this.memoryRemaining -= (long)result.sizeOf();
                            } else {
                                ForwardOnlyTabularCache.this.memoryRemaining = 0L;
                                this.openOutputStream();
                                result.encode(this.context, ForwardOnlyTabularCache.this.outputStream);
                                ForwardOnlyTabularCache.this.rowOffsets.add(ForwardOnlyTabularCache.this.outputStream.size());
                                ForwardOnlyTabularCache.this.cachedRowCount++;
                            }
                            this.incrementNRow();
                            if (ForwardOnlyTabularCache.this.logDsAccess) {
                                if (infoLogger.isOn()) {
                                    infoLogger.log(String.format(ForwardOnlyTabularCache.STARTING_DATA_RETRIEVAL, ForwardOnlyTabularCache.this.requestId));
                                }
                                ForwardOnlyTabularCache.this.logDsAccess = false;
                            }
                            break block19;
                        }
                        if (this.currentIndex < (long)ForwardOnlyTabularCache.this.memoryCache.size()) {
                            result = (IRow)((IRow)ForwardOnlyTabularCache.this.memoryCache.get((int)this.currentIndex)).copy();
                            IValue[] values = result.getColumns();
                            for (int i = 0; i < values.length; ++i) {
                                if (!(values[i] instanceof TextValue)) continue;
                                ((TextValue)values[i]).setCollator(this.context.getLocalCollator());
                            }
                        } else {
                            this.windupInputStreamAndDecodeRow();
                            result = this.row;
                        }
                        this.incrementNRow();
                    }
                    catch (IOException e) {
                        throw new XQERuntimeException(e);
                    }
                }
            }
            return result;
        }

        private void openOutputStream() {
            if (ForwardOnlyTabularCache.this.outputStream == null) {
                try {
                    ForwardOnlyTabularCache.this.tempFile = TempFileUtil.createTempFile(this.getClass().getSimpleName(), ".cache");
                    ForwardOnlyTabularCache.this.outputStream = new BufferedDataOutputStream(ForwardOnlyTabularCache.this.tempFile, 1, ForwardOnlyTabularCache.this.requestId);
                }
                catch (IOException e) {
                    this.release();
                    throw new XQERuntimeException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long positionOnRow(long iDetailRowNumber, boolean top) {
            ForwardOnlyTabularCache forwardOnlyTabularCache;
            long detailRowNumber = -1L;
            if (top) {
                if (iDetailRowNumber < 0L) {
                    iDetailRowNumber = 0L;
                }
                detailRowNumber = iDetailRowNumber;
                forwardOnlyTabularCache = ForwardOnlyTabularCache.this;
                synchronized (forwardOnlyTabularCache) {
                    while (ForwardOnlyTabularCache.this.cachedRowCount < detailRowNumber + 1L && ForwardOnlyTabularCache.this.tableIterator != null) {
                        this.nextImpl();
                    }
                    detailRowNumber = Math.min(ForwardOnlyTabularCache.this.cachedRowCount - 1L, detailRowNumber);
                }
            }
            forwardOnlyTabularCache = ForwardOnlyTabularCache.this;
            synchronized (forwardOnlyTabularCache) {
                while (ForwardOnlyTabularCache.this.tableIterator != null) {
                    this.nextImpl();
                }
                detailRowNumber = Math.max(0L, ForwardOnlyTabularCache.this.cachedRowCount - iDetailRowNumber);
            }
            if (ForwardOnlyTabularCache.this.cachedRowCount == 0L) {
                return -1L;
            }
            this.currentIndex = detailRowNumber - 1L;
            if (detailRowNumber < (long)this.forwardOnlyTabularCache.memoryCache.size()) {
                return detailRowNumber;
            }
            long byteOffset = 0L;
            if (detailRowNumber - (long)this.forwardOnlyTabularCache.memoryCache.size() > 0L) {
                byteOffset = this.forwardOnlyTabularCache.rowOffsets.get((int)detailRowNumber - this.forwardOnlyTabularCache.memoryCache.size() - 1);
            }
            try {
                BufferedDataInputStream inputStream = this.getOrCreateInputStream();
                inputStream.seek(byteOffset);
                this.lastRowIndexFromStream = this.currentIndex;
            }
            catch (IOException e) {
                throw new XQERuntimeException(e);
            }
            return detailRowNumber;
        }
    }

    private static final class CompleteTabularCacheIterator
    extends TabularCacheReadIterator {
        private static final String USING_CACHED_DATA = "Using data from cached result set [id=%1$d, cachedRowCount=%2$d].";

        private CompleteTabularCacheIterator(ForwardOnlyTabularCache iForwardOnlyTabularCache, XDataContext xDataContext, XVectorContext vContext) {
            super(iForwardOnlyTabularCache, xDataContext, vContext);
            if (infoLogger.isOn()) {
                infoLogger.log(String.format(USING_CACHED_DATA, iForwardOnlyTabularCache.requestId, iForwardOnlyTabularCache.cachedRowCount));
            }
        }

        @Override
        public Object nextImpl() {
            ++this.currentIndex;
            if (this.currentIndex < (long)this.forwardOnlyTabularCache.memoryCache.size()) {
                this.incrementNRow();
                IRow row = (IRow)((IRow)this.forwardOnlyTabularCache.memoryCache.get((int)this.currentIndex)).copy();
                IValue[] values = row.getColumns();
                for (int i = 0; i < values.length; ++i) {
                    if (!(values[i] instanceof TextValue)) continue;
                    ((TextValue)values[i]).setCollator(this.context.getLocalCollator());
                }
                return row;
            }
            try {
                if (this.currentIndex >= this.forwardOnlyTabularCache.cachedRowCount) {
                    return null;
                }
                this.decodeRow();
                this.incrementNRow();
            }
            catch (IOException e) {
                throw new XQERuntimeException(e);
            }
            return this.row;
        }

        @Override
        public long positionOnRow(long iDetailRowNumber, boolean top) {
            long detailRowNumber;
            if (this.forwardOnlyTabularCache.cachedRowCount == 0L) {
                return -1L;
            }
            if (top) {
                if (iDetailRowNumber < 0L) {
                    iDetailRowNumber = 0L;
                }
                detailRowNumber = Math.min(this.forwardOnlyTabularCache.cachedRowCount - 1L, iDetailRowNumber);
            } else {
                detailRowNumber = Math.max(0L, this.forwardOnlyTabularCache.cachedRowCount - iDetailRowNumber);
            }
            this.currentIndex = detailRowNumber - 1L;
            if (detailRowNumber < (long)this.forwardOnlyTabularCache.memoryCache.size()) {
                return detailRowNumber;
            }
            long byteOffset = 0L;
            if (detailRowNumber - (long)this.forwardOnlyTabularCache.memoryCache.size() > 0L) {
                byteOffset = this.forwardOnlyTabularCache.rowOffsets.get((int)detailRowNumber - this.forwardOnlyTabularCache.memoryCache.size() - 1);
            }
            try {
                BufferedDataInputStream inputStream = this.getOrCreateInputStream();
                inputStream.seek(byteOffset);
            }
            catch (IOException e) {
                throw new XQERuntimeException(e);
            }
            return detailRowNumber;
        }
    }

    private final class DataReadBackgroundThread
    extends Thread {
        TabularCacheIterator tabIter;
        XDataContext context;

        DataReadBackgroundThread(TabularCacheIterator theTabIter, XDataContext theContext) {
            this.tabIter = theTabIter;
            this.context = theContext;
            this.context.incrementRefCount();
        }

        @Override
        public void run() {
            ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(this.context.getEnvironment());
            try {
                while (this.tabIter.nextImpl() != null) {
                }
            }
            finally {
                executionEnvironmentContext.exit();
                this.context.decrementRefCount();
            }
        }
    }

    private static abstract class TabularCacheReadIterator
    extends XTabularIterator {
        protected ForwardOnlyTabularCache forwardOnlyTabularCache;
        protected IRow row;
        protected XVectorRowBatch batch;
        private BufferedDataInputStream inputStream = null;
        private int nColumns;

        protected TabularCacheReadIterator(ForwardOnlyTabularCache iForwardOnlyTabularCache, XDataContext xDataContext, XVectorContext vContext) {
            super(xDataContext, xDataContext.getNodeId());
            this.forwardOnlyTabularCache = iForwardOnlyTabularCache;
            this.nColumns = this.forwardOnlyTabularCache.rowsetInfo.getNumColumns();
            this.row = DataValueFactory.createRowValue(this.context.getLocalCollator(), this.forwardOnlyTabularCache.rowsetInfo);
            if (vContext != null) {
                this.batch = XVectorRowBatchUtil.createRowBatch(vContext, this.forwardOnlyTabularCache.rowsetInfo, this.context.getLocalCollator());
            }
        }

        protected final void incrementNRow() {
            this.nRows = this.nRows < Integer.MAX_VALUE ? ++this.nRows : -1;
        }

        protected final BufferedDataInputStream getOrCreateInputStream() throws IOException {
            if (null == this.inputStream) {
                this.inputStream = new BufferedDataInputStream(this.forwardOnlyTabularCache.tempFile);
            }
            return this.inputStream;
        }

        protected final void decodeRow() throws IOException {
            try {
                this.row.decode(this.context, this.getOrCreateInputStream());
            }
            catch (RuntimeException re) {
                String message = "Decoding failed (file=" + this.forwardOnlyTabularCache.tempFile.getName() + ForwardOnlyTabularCache.CLOSING_PARENTHESIS + " (currentIndex=" + this.currentIndex + ForwardOnlyTabularCache.CLOSING_PARENTHESIS + " (nRows=" + this.nRows + ForwardOnlyTabularCache.CLOSING_PARENTHESIS;
                mErrorLogger.log(message, (Throwable)re);
                throw new XQERuntimeException(re);
            }
        }

        @Override
        public Object nextBatch() {
            IRow result;
            this.batch.reset();
            ColumnVector[] columns = this.batch.columns;
            int size = 0;
            for (int i = 0; i < this.batch.maxBatchSize && (result = (IRow)this.nextImpl()) != null; ++i) {
                for (int j = 0; j < this.nColumns; ++j) {
                    columns[j].assign(i, result.getColumn(j));
                }
                ++size;
            }
            this.batch.size = size;
            if (size == 0) {
                this.batch.eod = true;
            } else {
                this.batch.complete(size);
            }
            return this.batch;
        }

        @Override
        public void release() {
            try {
                if (this.inputStream != null) {
                    this.inputStream.close();
                    this.inputStream = null;
                }
            }
            catch (IOException e) {
                throw new XQERuntimeException(e);
            }
            finally {
                this.row = null;
                this.inputStream = null;
                this.forwardOnlyTabularCache = null;
                super.release();
            }
        }
    }
}

