/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets.md;

import com.cognos.xqe.resultsets.md.CacheUsageHints;
import com.cognos.xqe.util.LinkedStack;
import java.util.BitSet;

public class CacheHints
extends CacheUsageHints {
    private boolean cacheAlways = false;
    private boolean cacheCellsAlways = false;
    private CacheUsageHints cacheUsageHints = null;

    public CacheHints(boolean cells) {
        super(cells);
    }

    public CacheHints(BitSet axes, boolean cells) {
        super(axes, cells);
    }

    public CacheHints(BitSet axes, boolean cells, boolean alwaysCacheCells) {
        super(axes, cells);
        this.cacheCellsAlways = alwaysCacheCells;
    }

    public static CacheHints cacheOneAxisNoCells(int axis) {
        if (axis < 0) {
            throw new IllegalArgumentException();
        }
        BitSet bitSet = new BitSet();
        bitSet.set(axis);
        return new CacheHints(bitSet, false);
    }

    public static CacheHints cacheCellsOnly() {
        return new CacheHints(null, true);
    }

    public static CacheHints cacheCellsAlways() {
        return new CacheHints(null, true, true);
    }

    public static CacheHints cacheAll() {
        CacheHints hints = new CacheHints(true);
        hints.setCacheAlways(true);
        return hints;
    }

    public static CacheHints cacheNone() {
        return new CacheHints(null, false);
    }

    public static boolean isAxisCached(LinkedStack<CacheHints> hints, int axis) {
        if (axis < 0) {
            throw new IllegalArgumentException();
        }
        for (CacheHints hint : hints) {
            if (hint.isUseAxis(axis)) {
                return false;
            }
            if (!hint.isAxisCached(axis)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCellsCached(LinkedStack<CacheHints> hints) {
        for (CacheHints hint : hints) {
            if (hint.isUseCells()) {
                return false;
            }
            if (!hint.cacheCells) continue;
            return true;
        }
        return false;
    }

    public void optimizeCache(LinkedStack<CacheHints> hints, int numAxes) {
        if (this.cacheAlways) {
            return;
        }
        for (int i = 0; i < numAxes; ++i) {
            if (!CacheHints.isAxisCached(hints, i)) continue;
            if (this.cacheAllAxes) {
                this.cacheAllAxes = false;
                this.axesToCache = new BitSet();
                this.axesToCache.set(0, numAxes);
            }
            if (this.axesToCache == null) continue;
            this.axesToCache.clear(i);
        }
        if (this.cacheCellsAlways) {
            this.cacheCells = true;
        } else if (CacheHints.isCellsCached(hints)) {
            this.cacheCells = false;
        }
    }

    public void setCacheAlways(boolean always) {
        this.cacheAlways = always;
    }

    public void setUseAxis(int axis) {
        if (this.isUseAxis(axis)) {
            return;
        }
        BitSet axes = null;
        if (this.cacheUsageHints == null) {
            axes = new BitSet();
            this.cacheUsageHints = new CacheUsageHints(axes, false);
        } else {
            axes = this.cacheUsageHints.axesToCache;
        }
        axes.set(axis);
    }

    public boolean isUseAxis(int axis) {
        if (this.cacheUsageHints == null) {
            return false;
        }
        return this.cacheUsageHints.isAxisCached(axis);
    }

    public boolean isUseCells() {
        if (this.cacheUsageHints == null) {
            return false;
        }
        return this.cacheUsageHints.isCacheCells();
    }
}

