/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets.md;

import com.cognos.xqe.data.providers.ProviderCellBase;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.ValueMethodNotImplementedException;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.util.xml.XMLWriter;
import com.ibm.icu.text.Collator;
import java.util.HashMap;

public class Cell
extends ProviderCellBase {
    public Cell() {
    }

    public Cell(long pOrdinal, IValue pValue) {
        this.ordinal = pOrdinal;
        this.value = pValue;
    }

    public Cell(long pOrdinal, double pValue) {
        this.ordinal = pOrdinal;
        DoubleValue d = DataValueFactory.createDoubleValue();
        d.set(pValue);
        this.value = d;
    }

    @Override
    public int compareTo(Object o) {
        if (this.getOrdinal() == ((Cell)o).getOrdinal()) {
            return 0;
        }
        if (this.getOrdinal() < ((Cell)o).getOrdinal()) {
            return -1;
        }
        return 1;
    }

    @Override
    public void toXML(XMLWriter xmlWriter) {
        xmlWriter.beginElement("Cell", -1);
        xmlWriter.attribute("CellOrdinal", this.ordinal);
        this.value.toXML(xmlWriter);
        xmlWriter.endElement();
    }

    @Override
    public Object copy() {
        Cell result = new Cell();
        result.copyFrom(this);
        return result;
    }

    @Override
    public void copyFrom(IValue dValue) throws ValueMethodNotImplementedException {
        ICell anotherCell = (ICell)dValue;
        this.setOrdinal(anotherCell.getOrdinal());
        this.setValue(anotherCell.getValue());
        this.cellProperties = anotherCell.getCellProperties() != null ? (HashMap)anotherCell.getCellProperties().clone() : null;
    }

    @Override
    public int fastHash() {
        return this.hashCode();
    }

    @Override
    public Object hashKey() {
        return this;
    }

    @Override
    public Object hashKey(Collator collator) {
        return this.hashKey();
    }

    @Override
    public int sizeOf() {
        int size = ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.OBJECTSIZE) + ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.PRIMITIVELONG);
        if (null != this.value) {
            size += this.value.sizeOf();
        }
        return size;
    }

    public String toString() {
        StringBuilder strBldr = new StringBuilder("Ordinal: ");
        strBldr.append(this.ordinal);
        strBldr.append(" ");
        strBldr.append(this.value);
        return strBldr.toString();
    }
}

