/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets.md;

import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.IIterator;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.md.Set;
import com.cognos.xqe.resultsets.md.SetBase;
import com.cognos.xqe.resultsets.md.Tuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.collections.set.ListOrderedSet;

public class CrossJoinedSet
extends SetBase {
    private static final long serialVersionUID = 1L;
    private SetBase[] sets;
    private HashMap<ITuple, long[]> tupleToIndexes;
    private int width;

    public CrossJoinedSet(ISet[] aSets) {
        ArrayList<ISet> al = new ArrayList<ISet>();
        for (int i = 0; i < aSets.length; ++i) {
            if (aSets[i] instanceof CrossJoinedSet) {
                Set[] sets2 = ((CrossJoinedSet)aSets[i]).getSets();
                for (int j = 0; j < sets2.length; ++j) {
                    if (sets2[j].isEmpty()) continue;
                    al.add(sets2[j]);
                }
                continue;
            }
            if (aSets[i].isEmpty()) continue;
            al.add(aSets[i]);
        }
        if (al.size() == 0) {
            al.add(new Set());
        }
        HashSet<IDimension> seenDimensions = new HashSet<IDimension>();
        this.sets = al.toArray(new Set[0]);
        if (this.size() > 0L) {
            for (int i = 0; i < this.sets.length; ++i) {
                SetBase s = this.sets[i];
                IDimension[] dims = s.getDimensions();
                this.width += dims.length;
                for (int j = 0; j < dims.length; ++j) {
                    if (seenDimensions.contains(dims[j])) {
                        throw new RuntimeException("Error creating CrossJoinedSet. Dimension " + dims[j] + " encountered more than once.");
                    }
                    seenDimensions.add(dims[j]);
                }
            }
        }
    }

    public Set[] getSets() {
        return (Set[])this.sets.clone();
    }

    public long[] getOrdinals(Tuple tuple) {
        long[] result = new long[]{0L};
        if (this.size() > 0L) {
            if (this.tupleToIndexes == null) {
                this.populateTupleToIndex();
            }
            long mult = 1L;
            for (int i = this.sets.length - 1; i >= 0; --i) {
                SetBase s = this.sets[i];
                IDimension[] dims = s.getDimensions();
                IMember[] mems = new IMember[dims.length];
                for (int j = 0; j < mems.length; ++j) {
                    mems[j] = tuple.getMember(dims[j]);
                }
                Tuple subTuple = new Tuple(mems);
                if (!this.tupleToIndexes.containsKey(subTuple)) {
                    return new long[0];
                }
                long[] indexes = this.tupleToIndexes.get(subTuple);
                if (indexes.length == 1) {
                    for (int j = 0; j < result.length; ++j) {
                        result[j] = result[j] + mult * indexes[0];
                    }
                } else {
                    long[] newIndexes = new long[result.length * indexes.length];
                    for (int j = 0; j < indexes.length; ++j) {
                        System.arraycopy(result, 0, newIndexes, j * result.length, result.length);
                        for (int k = 0; k < result.length; ++k) {
                            newIndexes[j * result.length + k] = newIndexes[j * result.length + k] + mult * indexes[j];
                        }
                    }
                    result = newIndexes;
                }
                mult *= s.size();
            }
        }
        return result;
    }

    @Override
    public ITuple getTuple(long index) {
        long n = this.size();
        IMember[] mems = new IMember[this.width];
        int count = 0;
        for (int i = 0; i < this.sets.length; ++i) {
            long tupIndex = index / (n /= this.sets[i].size());
            ITuple tuple = this.sets[i].getTuple(tupIndex);
            index -= tupIndex * n;
            for (int j = 0; j < tuple.size(); ++j) {
                mems[count++] = tuple.getMember(j);
            }
        }
        Tuple result = null;
        result = new Tuple(mems, false);
        return result;
    }

    private void populateTupleToIndex() {
        this.tupleToIndexes = new HashMap();
        for (int i = 0; i < this.sets.length; ++i) {
            SetBase set = this.sets[i];
            int count = 0;
            IIterator it = set.iterator();
            Object o = it.next();
            while (o != null) {
                long[] indexes = this.tupleToIndexes.get(o);
                if (indexes == null) {
                    indexes = new long[]{count++};
                } else {
                    long[] newIndexes = new long[indexes.length + 1];
                    System.arraycopy(indexes, 0, newIndexes, 0, indexes.length);
                    newIndexes[indexes.length] = count++;
                    indexes = newIndexes;
                }
                this.tupleToIndexes.put((ITuple)((ITuple)o).copy(), indexes);
                o = it.next();
            }
        }
    }

    @Override
    public ISet removeDimension(IDimension d, boolean retainDuplicates) {
        ArrayList<SetBase> al = new ArrayList<SetBase>();
        for (int i = 0; i < this.sets.length; ++i) {
            SetBase s = this.sets[i];
            if (s.contains(d)) {
                this.tupleToIndexes = null;
                if (s.getTuple(0L).size() <= 1) continue;
                ListOrderedSet tuples = new ListOrderedSet();
                if (!retainDuplicates) {
                    tuples = ListOrderedSet.decorate((java.util.Set)tuples);
                }
                int j = 0;
                while ((long)j < s.size()) {
                    ITuple tup = s.getTuple(j);
                    tup = tup.remove(d);
                    tuples.add((Object)tup);
                    ++j;
                }
                al.add(new Set((Tuple[])tuples.toArray((Object[])new Tuple[0])));
                continue;
            }
            if (s.isEmpty()) continue;
            al.add(s);
        }
        return new CrossJoinedSet(al.toArray(new Set[0]));
    }

    @Override
    public ISet removeHierarchy(IHierarchy h, boolean retainDuplicates) {
        ArrayList<SetBase> al = new ArrayList<SetBase>();
        for (int i = 0; i < this.sets.length; ++i) {
            SetBase s = this.sets[i];
            if (s.contains(h)) {
                this.tupleToIndexes = null;
                if (s.getTuple(0L).size() <= 1) continue;
                ListOrderedSet tuples = new ListOrderedSet();
                if (!retainDuplicates) {
                    tuples = ListOrderedSet.decorate((java.util.Set)tuples);
                }
                int j = 0;
                while ((long)j < s.size()) {
                    ITuple tup = s.getTuple(j);
                    tup = tup.remove(h);
                    tuples.add((Object)tup);
                    ++j;
                }
                al.add(new Set((Tuple[])tuples.toArray((Object[])new Tuple[0])));
                continue;
            }
            if (s.isEmpty()) continue;
            al.add(s);
        }
        return new CrossJoinedSet(al.toArray(new Set[0]));
    }

    @Override
    public long size() {
        long result = 0L;
        if (this.sets.length > 0) {
            result = this.sets[0].size();
        }
        for (int i = 1; i < this.sets.length; ++i) {
            result *= this.sets[i].size();
        }
        return result;
    }

    @Override
    public CrossJoinedSet copy() {
        return new CrossJoinedSet(this.getSets());
    }
}

