/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets.md;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.olap.MDXQueryArguments;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.NumericType;
import com.cognos.xqe.data.types.StringType;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.ResultSetValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.format.string.IFormatInfo;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.provider.Member;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.HResultSetException;
import com.cognos.xqe.resultsets.md.CacheHints;
import com.cognos.xqe.resultsets.md.Cell;
import com.cognos.xqe.resultsets.md.Tuple;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.XScrollableCellIterator;
import com.cognos.xqe.runtree.XScrollableIterator;
import com.cognos.xqe.runtree.exception.XRuntimeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.BigArray;
import com.cognos.xqe.util.FileHandler;
import com.cognos.xqe.util.LinkedStack;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import com.cognos.xqe.util.pool.XQESAXReaderPool;
import com.cognos.xqe.util.xml.XMLWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class CubeCache
extends ResultSetValue
implements ICubeResultSet {
    private static final int NUMBER_5 = 5;
    private static final String CELLS = "cells";
    private static final String U_NAME = "UName";
    private static final String TUPLE_AXIS = "TupleAxis";
    private static final String CACHED_TUPLES = "cachedTuples";
    private static final String SLICER = "slicer";
    private static final String NUM_AXES = "NumAxes";
    private static final String NUM_TABULAR_MEASURES = "NumTabularMeasures";
    static final long serialVersionUID = 1L;
    private ICubeResultSet sourceResultSet;
    private XIterator[] axisIterators;
    private XCellIterator providerCellIterator;
    private List<ITuple>[] cachedTuples;
    IDimension[][] cachedDimensions;
    boolean allLoaded;
    int cachedNumAxes;
    int cachedNumTabularMeasures;
    ITuple cachedSlicer;
    private BigArray cellsMap = new BigArray();
    private List<ICell> cellsList = new ArrayList<ICell>();
    private CacheHints cacheHints;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    private static final ICell NULL_CELL_PLACE_HOLDER = new Cell(-1L, DoubleValue.NULL_VALUE);
    private static final String CONFIG_MOCKLOGGING_ENABLED = "queryExecution.logCachedResultSet[@enabled]";
    private static final boolean DEFAULT_MOCKLOGGING_ENABLED = false;

    public CubeCache(XDataContext xDataContext, ICubeResultSet source, Integer theNodeId, CacheHints hints) {
        super(xDataContext, theNodeId, xDataContext.getEnvironment().getMultiRequestContext().getResourceTracker());
        try {
            this.allLoaded = false;
            this.cacheHints = hints;
            this.sourceResultSet = source;
            this.cachedNumAxes = 0;
            this.cachedNumTabularMeasures = 0;
            this.cachedSlicer = null;
            int numAxes = this.sourceResultSet.getNumAxes();
            this.axisIterators = new XIterator[numAxes];
            this.cachedTuples = new List[numAxes];
            for (int i = 0; i < numAxes; ++i) {
                if (!this.cacheHints.isAxisCached(i)) continue;
                this.axisIterators[i] = this.sourceResultSet.getAxisIterator(i);
                this.cachedTuples[i] = new ArrayList<ITuple>();
            }
        }
        catch (RuntimeException e) {
            this.release();
            throw e;
        }
    }

    public CubeCache(XDataContext xDataContext, Integer theNodeId, CacheHints hints) {
        super(xDataContext, theNodeId, xDataContext.getEnvironment().getMultiRequestContext().getResourceTracker());
        this.allLoaded = false;
        this.cacheHints = hints;
        this.sourceResultSet = null;
        this.cachedNumAxes = 0;
        this.cachedNumTabularMeasures = 0;
        this.cachedSlicer = null;
    }

    public void initializeFromFile(RequestEnvironment requestEnvironment, XDataContext xDataContext, String source, MDXQueryArguments theQueryArgument) {
        boolean bLoggingEnabled = CubeCache.getMockLoggingEnabled((ExecutionEnvironment)requestEnvironment.getExecutionEnvironment());
        String newfilename = CubeCache.getCacheFileNameWithIndex(requestEnvironment, source);
        try {
            int j;
            Document cachedDocument = null;
            SAXReader xmlReader = XQESAXReaderPool.getInstance().borrowReader();
            try {
                FileInputStream is = new FileInputStream(newfilename);
                cachedDocument = xmlReader.read((InputStream)is);
            }
            catch (RuntimeException e) {
                this.release();
                throw e;
            }
            catch (Exception e) {
                throw XQERuntimeException.wrap(e);
            }
            finally {
                if (xmlReader != null) {
                    if (cachedDocument == null) {
                        XQESAXReaderPool.getInstance().invalidateReader(xmlReader);
                    } else {
                        XQESAXReaderPool.getInstance().returnReader(xmlReader);
                    }
                }
            }
            if (cachedDocument == null || cachedDocument.getRootElement() == null) {
                XQEDebugLog.err.println("Cannot find root element.");
                throw new XQERuntimeException();
            }
            Element rootElement = cachedDocument.getRootElement();
            String sAttribValue = rootElement.attributeValue(NUM_TABULAR_MEASURES);
            this.cachedNumTabularMeasures = Integer.parseInt(sAttribValue);
            sAttribValue = rootElement.attributeValue(NUM_AXES);
            this.cachedNumAxes = Integer.parseInt(sAttribValue);
            this.cachedDimensions = new IDimension[this.cachedNumAxes][];
            for (int i = 0; i < theQueryArgument.getNumberOfAxes(); ++i) {
                MDXQueryArguments.MDXAxisInfo axisInfo = theQueryArgument.getMDXAxisInfo(i);
                this.cachedDimensions[i] = new IDimension[axisInfo.getNumberOfHierarchies()];
                for (int j2 = 0; j2 < axisInfo.getNumberOfHierarchies(); ++j2) {
                    this.cachedDimensions[i][j2] = axisInfo.getMDXHierarchyInfo(j2).getHierarchy().getDimension();
                    if (!bLoggingEnabled) continue;
                    XQEDebugLog.out.println("Loaded dimension=" + this.cachedDimensions[i][j2].getUniqueName());
                }
            }
            Element eSlicer = rootElement.element(SLICER);
            if (null != eSlicer) {
                XQEDebugLog.err.println("Found Slicer -- not implemented yet");
                throw new XQERuntimeException();
            }
            this.cachedTuples = new List[this.cachedNumAxes];
            Element tuples = rootElement.element(CACHED_TUPLES);
            if (null != tuples) {
                for (int i = 0; i < this.cachedNumAxes; ++i) {
                    List lTupleAxis = tuples.elements(TUPLE_AXIS);
                    for (j = 0; j < lTupleAxis.size(); ++j) {
                        Element eTupleAxis = (Element)lTupleAxis.get(j);
                        String id = eTupleAxis.attributeValue("id");
                        int nid = Integer.parseInt(id);
                        if (nid != i) continue;
                        List lTuples = eTupleAxis.elements("Tuple");
                        this.cachedTuples[i] = new ArrayList<ITuple>();
                        for (int k = 0; k < lTuples.size(); ++k) {
                            Element eTuple = (Element)lTuples.get(k);
                            List lMembers = eTuple.elements("Member");
                            IMember[] memList = new IMember[lMembers.size()];
                            for (int m = 0; m < lMembers.size(); ++m) {
                                Element eMember = (Element)lMembers.get(m);
                                String sHier = eMember.attributeValue("Hierarchy");
                                Element eAttrib = eMember.element(U_NAME);
                                String mun = eAttrib.getText();
                                eAttrib = eMember.element("LName");
                                String lun = eAttrib.getText();
                                MDXQueryArguments.MDXAxisInfo axisInfo = theQueryArgument.getMDXAxisInfo(j);
                                IHierarchy hier = null;
                                IDimension dim = null;
                                List<ILevel> levelInfos = null;
                                boolean bFoundHier = false;
                                if (axisInfo != null) {
                                    List<MDXQueryArguments.MDXHierarchyInfo> mdxHiers = axisInfo.getProjectedHierarchies();
                                    for (int n = 0; n < mdxHiers.size(); ++n) {
                                        if (mdxHiers.get(n).getHierarchy().getUniqueName().compareTo(sHier) != 0) continue;
                                        hier = mdxHiers.get(n).getHierarchy();
                                        levelInfos = mdxHiers.get(n).getProjectedLevels();
                                        dim = hier.getDimension();
                                        bFoundHier = true;
                                        break;
                                    }
                                }
                                if (!bFoundHier) {
                                    XQEDebugLog.err.println("Cannot find hierarchy:" + sHier);
                                    throw new XQERuntimeException();
                                }
                                ILevel lvl = null;
                                boolean bFoundLevel = false;
                                if (levelInfos != null) {
                                    for (int p = 0; p < levelInfos.size(); ++p) {
                                        lvl = (ILevel)levelInfos.get(p);
                                        if (lvl.getUniqueName().compareTo(lun) != 0) continue;
                                        bFoundLevel = true;
                                        break;
                                    }
                                }
                                if (!bFoundLevel) {
                                    XQEDebugLog.err.println("Cannot find level:" + lun);
                                    throw new XQERuntimeException();
                                }
                                Member currentMember = new Member();
                                currentMember.setUniqueName(mun);
                                currentMember.setConnection(theQueryArgument.getCube().getConnection());
                                currentMember.setInitialised();
                                eAttrib = eMember.element("Caption");
                                String caption = eAttrib.getText();
                                currentMember.setName(caption);
                                currentMember.setCaption(caption);
                                eAttrib = eMember.element("PUN");
                                if (eAttrib != null) {
                                    String pun = eAttrib.getText();
                                    currentMember.setParentUniqueName(pun);
                                }
                                currentMember.setLevel(lvl);
                                HashMap<String, Object> properties = new HashMap<String, Object>();
                                List lDynProps = eMember.elements("DynamicProperty");
                                for (int p = 0; p < lDynProps.size(); ++p) {
                                    Element eProp = (Element)lDynProps.get(p);
                                    String sUName = eProp.attributeValue(U_NAME);
                                    String sValue = eProp.getText();
                                    if (bLoggingEnabled) {
                                        XQEDebugLog.out.println("  Dynamic Property=" + sUName + ",value=" + sValue);
                                    }
                                    StringType dataType = DataTypeFactory.getStringType();
                                    Value aValue = (Value)dataType.createValue();
                                    aValue.set(sValue);
                                    properties.put(sUName, aValue);
                                }
                                currentMember.setDynamicProperties(properties);
                                memList[m] = currentMember;
                            }
                            Tuple tup = new Tuple(memList);
                            this.cachedTuples[i].add(tup);
                            if (!bLoggingEnabled) continue;
                            XQEDebugLog.out.println("Loaded tuple=" + tup.toString());
                        }
                    }
                }
            }
            Element eCells = rootElement.element(CELLS);
            List lCellList = eCells.elements("Cell");
            for (j = 0; j < lCellList.size(); ++j) {
                Integer iValue;
                Element eCell = (Element)lCellList.get(j);
                String sOrdinal = eCell.attributeValue("CellOrdinal");
                int ord = Integer.parseInt(sOrdinal);
                Element eValue = eCell.element("Value");
                String sDatatype = eValue.attributeValue("dataType");
                String sValue = eValue.getText();
                NumericType dataType = null;
                Value aValue = null;
                if (bLoggingEnabled) {
                    XQEDebugLog.out.println("datatype=" + sDatatype);
                }
                if (sDatatype.equals("integer")) {
                    iValue = Integer.parseInt(sValue);
                    if (bLoggingEnabled) {
                        XQEDebugLog.out.println("Loaded cell, integer value=" + iValue);
                    }
                    dataType = DataTypeFactory.getIntegerType();
                    aValue = (Value)dataType.createValue();
                    aValue.set(iValue);
                } else if (sDatatype.equals("long")) {
                    iValue = Integer.parseInt(sValue);
                    if (bLoggingEnabled) {
                        XQEDebugLog.out.println("Loaded cell, long value=" + iValue);
                    }
                    dataType = DataTypeFactory.getLongType();
                    aValue = (Value)dataType.createValue();
                    aValue.set(iValue);
                } else if (sDatatype.startsWith("long(")) {
                    int idx = sDatatype.indexOf(44);
                    String sPrec = sDatatype.substring(5, idx);
                    int iPrec = Integer.parseInt(sPrec);
                    int idxBracket = sDatatype.indexOf(41);
                    String sScale = sDatatype.substring(idx + 1, idxBracket);
                    int iScale = Integer.parseInt(sScale);
                    Double dValue = Double.parseDouble(sValue);
                    if (bLoggingEnabled) {
                        XQEDebugLog.out.println("Loaded cell, decimal (" + iPrec + "," + iScale + "), value=" + dValue);
                    }
                    dataType = DataTypeFactory.getDecimalType(iPrec, iScale);
                    aValue = (Value)dataType.createValue();
                    aValue.set(dValue);
                } else {
                    Double dValue = Double.parseDouble(sValue);
                    if (bLoggingEnabled) {
                        XQEDebugLog.out.println("Loaded cell, double value=" + dValue);
                    }
                    dataType = DataTypeFactory.getDoubleType();
                    aValue = (Value)dataType.createValue();
                    aValue.set(dValue);
                }
                String sFormatType = eCell.attributeValue("formatType");
                String sFormatString = eCell.attributeValue("formatString");
                String sFormatLocale = eCell.attributeValue("formatLocale");
                String sLanguage = eCell.attributeValue("language");
                int nLanguage = 0;
                if (sLanguage != null) {
                    nLanguage = Integer.parseInt(sLanguage);
                }
                if (sFormatString == null || sFormatString.equals("")) {
                    aValue.setFormatId(FormatId.EMPTY_FORMAT_FID);
                } else if (sFormatType.equals("MSAS")) {
                    String unknownCurr = "*";
                    boolean includeCurrencyUnit = true;
                    IFormatInfo info = null;
                    try {
                        Class<?> providerClass = Class.forName("com.cognos.xqe.data.olap.common.MSASCommonFormatInfo");
                        Class<?> enumClass = Class.forName("com.cognos.xqe.data.olap.common.MSASTypeGroupEnum");
                        Constructor<?> cTor = providerClass.getConstructor(enumClass, Boolean.TYPE, String.class, String.class, Integer.TYPE);
                        Method getType = enumClass.getMethod("getTypeGroup", Integer.TYPE);
                        Object obj = getType.invoke(null, 5);
                        info = (IFormatInfo)cTor.newInstance(obj, includeCurrencyUnit, unknownCurr, sFormatString, nLanguage);
                    }
                    catch (Exception ex) {
                        throw XQERuntimeException.wrap(ex);
                    }
                    sFormatLocale = sFormatLocale.replace('_', '-');
                    Locale formatLocale = new Locale(sFormatLocale);
                    FormatId id = FormatService.getInstance().registerMSASFormat(info, formatLocale);
                    aValue.setFormatId(id);
                }
                Cell myCell = new Cell((long)ord, aValue);
                this.cellsList.add(myCell);
                long cellOrdinal = myCell.getOrdinal();
                this.cellsMap.put(ord, myCell);
            }
        }
        catch (RuntimeException e) {
            this.release();
            throw e;
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(e);
        }
        this.allLoaded = true;
    }

    public static boolean getMockLoggingEnabled(ExecutionEnvironment environment) {
        return environment.getMultiRequestContext().fetchBooleanConfiguration(CONFIG_MOCKLOGGING_ENABLED, false);
    }

    @Override
    public XIterator getAxisIterator(int axisNumber) {
        if (axisNumber < 0 || this.allLoaded && axisNumber >= this.cachedNumAxes || !this.allLoaded && axisNumber >= this.axisIterators.length) {
            throw new HResultSetException(XQEMessageKeys.EXE_InvalidAxisNumber, XQEIntegerPool.getInteger(axisNumber).toString());
        }
        if (this.cacheHints.isAxisCached(axisNumber)) {
            return new EdgeIterator(this.getDataContext(), axisNumber, this.nodeId);
        }
        if (null != this.sourceResultSet) {
            return this.sourceResultSet.getAxisIterator(axisNumber);
        }
        return null;
    }

    @Override
    public long getAxisSize(int axisNumber) {
        if (!this.cacheHints.isAxisCached(axisNumber)) {
            if (null != this.sourceResultSet) {
                return this.sourceResultSet.getAxisSize(axisNumber);
            }
            return 0L;
        }
        if (this.allLoaded) {
            return this.cachedTuples[axisNumber].size();
        }
        return this.fetchAllTuples(axisNumber);
    }

    @Override
    public XCellIterator getCellIterator() {
        if (this.cacheHints.isCacheCells()) {
            return new CellIterator(this.nodeId);
        }
        if (null != this.sourceResultSet) {
            return this.sourceResultSet.getCellIterator();
        }
        return null;
    }

    @Override
    public IDimension[] getDimensions(int axisNumber) {
        if (null != this.sourceResultSet) {
            if (null == this.cachedDimensions) {
                this.cachedDimensions = new IDimension[this.getNumAxes()][];
            }
            this.cachedDimensions[axisNumber] = this.sourceResultSet.getDimensions(axisNumber);
        }
        return this.cachedDimensions[axisNumber];
    }

    @Override
    public int getNumAxes() {
        if (null != this.sourceResultSet) {
            this.cachedNumAxes = this.sourceResultSet.getNumAxes();
        }
        return this.cachedNumAxes;
    }

    @Override
    public XScrollableIterator getScrollableAxisIterator(int axisNumber) {
        if (this.cacheHints.isAxisCached(axisNumber)) {
            return new EdgeIterator(this.getDataContext(), axisNumber, this.nodeId);
        }
        if (null != this.sourceResultSet) {
            return this.sourceResultSet.getScrollableAxisIterator(axisNumber);
        }
        return null;
    }

    @Override
    public XScrollableCellIterator getScrollableCellIterator() {
        if (null != this.sourceResultSet) {
            if (this.cacheHints.isCacheCells()) {
                XScrollableCellIterator sourceIterator;
                try {
                    sourceIterator = this.sourceResultSet.getScrollableCellIterator();
                }
                catch (UnsupportedOperationException e) {
                    return new CellIterator(this.nodeId);
                }
                return new SimpleScrollableIterator(this.nodeId, sourceIterator);
            }
            return this.sourceResultSet.getScrollableCellIterator();
        }
        return new CellIterator(this.nodeId);
    }

    @Override
    public ITuple getSlicer() {
        if (null != this.sourceResultSet) {
            this.cachedSlicer = this.sourceResultSet.getSlicer();
        }
        return this.cachedSlicer;
    }

    private ICell fetchByOrdinal(long ordinal) {
        ICell lastCellInList;
        ICell aCell = (ICell)this.cellsMap.get(ordinal);
        if (aCell != null) {
            return aCell;
        }
        if (!this.cellsList.isEmpty() && (lastCellInList = this.cellsList.get(this.cellsList.size() - 1)).getOrdinal() > ordinal) {
            return null;
        }
        if (null == this.sourceResultSet) {
            return null;
        }
        if (this.providerCellIterator == null) {
            this.providerCellIterator = this.sourceResultSet.getCellIterator();
        }
        aCell = this.providerCellIterator.next();
        while (aCell != null) {
            if (aCell.getOrdinal() <= -1L) {
                aCell = this.providerCellIterator.next();
                continue;
            }
            this.cellsList.add(aCell);
            long cellOrdinal = aCell.getOrdinal();
            this.cellsMap.put(cellOrdinal, aCell);
            if (cellOrdinal > ordinal) {
                return null;
            }
            if (cellOrdinal == ordinal) {
                return aCell;
            }
            aCell = this.providerCellIterator.next();
        }
        return null;
    }

    private long fetchAllTuples(int ordinal) {
        if (ordinal < 0 || ordinal >= this.axisIterators.length) {
            throw new HResultSetException(XQEMessageKeys.EXE_InvalidAxisNumber, XQEIntegerPool.getInteger(ordinal).toString());
        }
        XIterator iterator = this.axisIterators[ordinal];
        if (iterator != null) {
            ITuple aTuple = (ITuple)iterator.next();
            while (aTuple != null) {
                this.cachedTuples[ordinal].add(aTuple);
                aTuple = (ITuple)iterator.next();
            }
            iterator.release();
            this.axisIterators[ordinal] = null;
        }
        return this.cachedTuples[ordinal].size();
    }

    @Override
    public int getNumTabularMeasures() {
        if (null != this.sourceResultSet) {
            this.cachedNumTabularMeasures = this.sourceResultSet.getNumTabularMeasures();
        }
        return this.cachedNumTabularMeasures;
    }

    @Override
    public int getNumDataItemForSummary(int rowsetId) {
        if (null != this.sourceResultSet) {
            return this.sourceResultSet.getNumDataItemForSummary(rowsetId);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseImpl() {
        int i;
        if (this.axisIterators != null) {
            for (i = 0; i < this.axisIterators.length; ++i) {
                if (this.axisIterators[i] == null) continue;
                try {
                    this.axisIterators[i].release();
                    continue;
                }
                catch (Exception ex) {
                    mErrorLogger.log(ex);
                    continue;
                }
                finally {
                    this.axisIterators[i] = null;
                }
            }
            this.axisIterators = null;
        }
        if (this.cachedTuples != null) {
            for (i = 0; i < this.cachedTuples.length; ++i) {
                if (null == this.cachedTuples[i]) continue;
                this.cachedTuples[i].clear();
                this.cachedTuples[i] = null;
            }
            this.cachedTuples = null;
        }
        if (this.cellsList != null) {
            this.cellsList.clear();
            this.cellsList = null;
        }
        this.cellsMap = null;
        if (this.providerCellIterator != null) {
            try {
                this.providerCellIterator.release();
            }
            catch (Exception ex) {
                mErrorLogger.log(ex);
            }
            finally {
                this.providerCellIterator = null;
            }
        }
        this.cachedSlicer = null;
        this.sourceResultSet = null;
    }

    @Override
    public boolean isCaching() {
        return true;
    }

    @Override
    public void optimizeCache(LinkedStack<CacheHints> hints) {
        this.cacheHints.optimizeCache(hints, this.getNumAxes());
    }

    @Override
    public void toXML(XMLWriter xmlWriter) {
        int i;
        xmlWriter.beginElement("CubeCacheResultSet", -1);
        xmlWriter.attribute("serialVersionUID", 1L);
        xmlWriter.attribute(NUM_TABULAR_MEASURES, this.getNumTabularMeasures());
        int numAxes = this.getNumAxes();
        xmlWriter.attribute(NUM_AXES, numAxes);
        xmlWriter.beginElement("dimensions", -1);
        for (i = 0; i < numAxes; ++i) {
            xmlWriter.beginElement("Axis", i);
            IDimension[] dimArray = this.getDimensions(i);
            int dimLength = dimArray.length;
            for (int j = 0; j < dimLength; ++j) {
                xmlWriter.beginElement("Dimension", j);
                IDimension currDim = dimArray[j];
                xmlWriter.attribute("uname", currDim.getUniqueName());
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
            this.fetchAllTuples(i);
        }
        xmlWriter.endElement();
        if (null != this.cachedSlicer) {
            xmlWriter.beginElement(SLICER, -1);
            this.cachedSlicer.toXML(xmlWriter);
            xmlWriter.endElement();
        }
        if (this.cachedTuples != null) {
            xmlWriter.beginElement(CACHED_TUPLES, -1);
            for (i = 0; i < this.cachedTuples.length; ++i) {
                if (null == this.cachedTuples[i]) continue;
                xmlWriter.beginElement(TUPLE_AXIS, i);
                List<ITuple> currTupleList = this.cachedTuples[i];
                for (int j = 0; j < currTupleList.size(); ++j) {
                    ITuple currTuple = currTupleList.get(j);
                    currTuple.toXML(xmlWriter);
                }
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
        }
        XCellIterator iter = this.getCellIterator();
        xmlWriter.beginElement(CELLS, -1);
        while (iter.hasNext()) {
            ICell curr = iter.next();
            curr.toXML(xmlWriter);
        }
        iter.release();
        xmlWriter.endElement();
        xmlWriter.endElement();
    }

    public static void saveResultToFile(RequestEnvironment requestEnvironment, XDataContext xDataContext, ICubeResultSet result, String sFileName) throws Error {
        Error err;
        XQERuntimeException exception;
        XRuntimeException xRuntimeException;
        block11: {
            String newfilename = CubeCache.getCacheFileNameWithIndex(requestEnvironment, sFileName);
            CubeCache newCache = new CubeCache(xDataContext, result, 1, CacheHints.cacheAll());
            XMLWriter xmlWriter = null;
            Writer writer = null;
            xRuntimeException = null;
            exception = null;
            err = null;
            try {
                FileHandler.deleteFile(newfilename);
                File outputFile = new File(newfilename);
                FileHandler.createOutputFolders(newfilename);
                outputFile.createNewFile();
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8"));
                xmlWriter = new XMLWriter();
                xmlWriter.setRoundDoubleDecimalPlaces(2);
                xmlWriter.addStream(writer);
                newCache.toXML(xmlWriter);
                xmlWriter.flush();
            }
            catch (XRuntimeException e) {
                xRuntimeException = e;
            }
            catch (Exception e) {
                XQEDebugLog.err.printStackTrace(e);
                exception = new XQERuntimeException();
            }
            catch (Error e) {
                XQEDebugLog.err.printStackTrace(e);
                err = e;
            }
            newCache.release();
            if (xmlWriter != null) {
                xmlWriter.flush();
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    XQEDebugLog.err.printStackTrace(e);
                    if (xRuntimeException != null || exception != null || err != null) break block11;
                    exception = new XQERuntimeException();
                }
            }
        }
        if (xRuntimeException != null) {
            throw xRuntimeException;
        }
        if (exception != null) {
            throw exception;
        }
        if (err != null) {
            throw err;
        }
    }

    private static String getCacheFileNameWithIndex(RequestEnvironment requestEnvironment, String sFileName) {
        int currIdx = requestEnvironment.getNLastSavedQuery();
        requestEnvironment.setNLastSavedQuery(++currIdx);
        StringBuilder path = new StringBuilder(sFileName);
        path.append("_");
        path.append(currIdx);
        path.append(".xml");
        String newfilename = path.toString();
        if (CubeCache.getMockLoggingEnabled((ExecutionEnvironment)requestEnvironment.getExecutionEnvironment())) {
            XQEDebugLog.out.println("ResultSet filename: " + newfilename);
        }
        return newfilename;
    }

    public final class CellIterator
    extends XScrollableCellIterator {
        private int currentCellListPosition;

        private CellIterator(Integer id) {
            super(CubeCache.this.getDataContext(), id);
            this.currentCellListPosition = 0;
        }

        @Override
        public boolean absolute(long index) {
            if (index < 0L) {
                return false;
            }
            this.currentOrdinal = index;
            return true;
        }

        @Override
        public ICell current() {
            if (this.currentOrdinal < 0L) {
                return null;
            }
            ICell cachedCell = (ICell)CubeCache.this.cellsMap.get(this.currentOrdinal);
            if (cachedCell == null) {
                return null;
            }
            return cachedCell;
        }

        @Override
        public boolean hasPrevious() {
            ICell firstCellInList;
            if (this.currentOrdinal <= 0L) {
                return false;
            }
            return !CubeCache.this.cellsList.isEmpty() && (firstCellInList = (ICell)CubeCache.this.cellsList.get(0)).getOrdinal() < this.currentOrdinal;
        }

        @Override
        public ICell previous() {
            ICell firstCellInList;
            if (!this.hasPrevious()) {
                return null;
            }
            --this.currentOrdinal;
            ICell cell = this.current();
            if (cell != null) {
                return cell;
            }
            if (!CubeCache.this.cellsList.isEmpty() && (firstCellInList = (ICell)CubeCache.this.cellsList.get(0)).getOrdinal() < this.currentOrdinal) {
                cell = this.getNextCachedCellFromList(false);
                this.currentOrdinal = cell.getOrdinal();
                return cell;
            }
            return null;
        }

        @Override
        public boolean reset() {
            this.currentOrdinal = -1L;
            this.currentCellListPosition = 0;
            return true;
        }

        @Override
        public boolean hasNext() {
            ICell lastCellInList;
            if (CubeCache.this.cellsMap.get(this.currentOrdinal + 1L) != null) {
                return true;
            }
            if (!CubeCache.this.cellsList.isEmpty() && (lastCellInList = (ICell)CubeCache.this.cellsList.get(CubeCache.this.cellsList.size() - 1)).getOrdinal() > this.currentOrdinal + 1L) {
                return true;
            }
            if (CubeCache.this.providerCellIterator == null) {
                CubeCache.this.providerCellIterator = CubeCache.this.sourceResultSet.getCellIterator();
            }
            return CubeCache.this.providerCellIterator.hasNext();
        }

        private ICell getNextCachedCellFromList(boolean next) {
            ICell previousCell = null;
            if (this.currentOrdinal == -1L) {
                return (ICell)CubeCache.this.cellsList.get(0);
            }
            ICell aCell = (ICell)CubeCache.this.cellsList.get(this.currentCellListPosition);
            do {
                this.currentCellListPosition = next ? (aCell.getOrdinal() <= this.currentOrdinal ? ++this.currentCellListPosition : --this.currentCellListPosition) : (aCell.getOrdinal() >= this.currentOrdinal ? --this.currentCellListPosition : ++this.currentCellListPosition);
                if (this.currentCellListPosition <= -1 || this.currentCellListPosition >= CubeCache.this.cellsList.size()) {
                    throw new IllegalStateException();
                }
                previousCell = aCell;
                aCell = (ICell)CubeCache.this.cellsList.get(this.currentCellListPosition);
            } while (!(next ? previousCell.getOrdinal() <= this.currentOrdinal && aCell.getOrdinal() > this.currentOrdinal : previousCell.getOrdinal() >= this.currentOrdinal && aCell.getOrdinal() < this.currentOrdinal));
            return aCell;
        }

        @Override
        public ICell nextImpl() {
            ICell lastCachedCell;
            ICell cachedCell = (ICell)CubeCache.this.cellsMap.get(this.currentOrdinal + 1L);
            if (cachedCell != null) {
                ++this.currentOrdinal;
                return cachedCell;
            }
            if (!CubeCache.this.cellsList.isEmpty() && this.currentOrdinal + 1L < (lastCachedCell = (ICell)CubeCache.this.cellsList.get(CubeCache.this.cellsList.size() - 1)).getOrdinal()) {
                cachedCell = this.getNextCachedCellFromList(true);
                this.currentOrdinal = cachedCell.getOrdinal();
                return cachedCell;
            }
            if (CubeCache.this.providerCellIterator == null) {
                CubeCache.this.providerCellIterator = CubeCache.this.sourceResultSet.getCellIterator();
            }
            ICell aCell = null;
            do {
                if ((aCell = CubeCache.this.providerCellIterator.next()) != null) continue;
                return null;
            } while (aCell.getOrdinal() <= -1L);
            this.currentOrdinal = aCell.getOrdinal();
            if (!CubeCache.this.cacheHints.isCacheCells()) {
                return aCell;
            }
            CubeCache.this.cellsList.add(aCell);
            this.currentCellListPosition = CubeCache.this.cellsList.size() - 1;
            CubeCache.this.cellsMap.put(aCell.getOrdinal(), aCell);
            return aCell;
        }

        @Override
        public ICell byOrdinal(long ordinal) {
            ICell cachedCell = CubeCache.this.fetchByOrdinal(ordinal);
            if (cachedCell == null) {
                return null;
            }
            return cachedCell;
        }

        @Override
        public void release() {
        }

        @Override
        public boolean hasPipelineIterator() {
            if (CubeCache.this.providerCellIterator == null) {
                CubeCache.this.providerCellIterator = CubeCache.this.sourceResultSet.getCellIterator();
            }
            return CubeCache.this.providerCellIterator.hasPipelineIterator();
        }
    }

    private final class SimpleScrollableIterator
    extends XScrollableCellIterator {
        private XScrollableCellIterator sourceScrollableCellIterator;

        private SimpleScrollableIterator(Integer id, XScrollableCellIterator sourceIterator) {
            super(CubeCache.this.getDataContext(), id);
            this.sourceScrollableCellIterator = sourceIterator;
        }

        @Override
        public boolean absolute(long index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ICell current() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasPrevious() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ICell previous() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean reset() {
            return true;
        }

        @Override
        public boolean hasNext() {
            return this.sourceScrollableCellIterator.hasNext();
        }

        @Override
        public ICell nextImpl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ICell byOrdinal(long ordinal) {
            if (ordinal < 0L) {
                return null;
            }
            ICell aCell = (ICell)CubeCache.this.cellsMap.get(ordinal);
            if (aCell == NULL_CELL_PLACE_HOLDER) {
                return null;
            }
            if (aCell != null) {
                return aCell;
            }
            aCell = this.sourceScrollableCellIterator.byOrdinal(ordinal);
            if (aCell == null) {
                CubeCache.this.cellsMap.put(ordinal, NULL_CELL_PLACE_HOLDER);
                return null;
            }
            long cellOrdinal = aCell.getOrdinal();
            CubeCache.this.cellsMap.put(cellOrdinal, aCell);
            return aCell;
        }

        @Override
        public void release() {
            this.sourceScrollableCellIterator.release();
        }

        @Override
        public boolean hasPipelineIterator() {
            return this.sourceScrollableCellIterator.hasPipelineIterator();
        }
    }

    private final class EdgeIterator
    extends XScrollableIterator {
        private final int edgeOrdinal;
        private long iteratorPosition;
        private String requestID;
        private long claimedMemory;

        private EdgeIterator(XDataContext xDataContext, int ordinal, Integer theNodeId) {
            super(xDataContext, theNodeId);
            this.iteratorPosition = -1L;
            this.edgeOrdinal = ordinal;
            RequestEnvironment reqEnv = (RequestEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment();
            this.requestID = reqEnv.getRequestID();
        }

        @Override
        public boolean absolute(long index) {
            if (index < 0L) {
                return false;
            }
            if (index < (long)CubeCache.this.cachedTuples[this.edgeOrdinal].size()) {
                this.iteratorPosition = index;
                return true;
            }
            return false;
        }

        @Override
        public Object current() {
            if (this.iteratorPosition < 0L) {
                return null;
            }
            List tuplesList = CubeCache.this.cachedTuples[this.edgeOrdinal];
            if (tuplesList.isEmpty()) {
                return null;
            }
            return tuplesList.get((int)this.iteratorPosition);
        }

        @Override
        public boolean hasPrevious() {
            return this.iteratorPosition > 0L;
        }

        @Override
        public Object previous() {
            if (!this.hasPrevious()) {
                return null;
            }
            --this.iteratorPosition;
            return this.current();
        }

        @Override
        public void reset() {
            this.iteratorPosition = -1L;
        }

        @Override
        public long getIndex() {
            return this.iteratorPosition;
        }

        @Override
        public Object nextImpl() {
            if (this.iteratorPosition + 1L < (long)CubeCache.this.cachedTuples[this.edgeOrdinal].size()) {
                ++this.iteratorPosition;
                return CubeCache.this.cachedTuples[this.edgeOrdinal].get((int)this.iteratorPosition);
            }
            if (CubeCache.this.axisIterators == null || CubeCache.this.axisIterators[this.edgeOrdinal] == null) {
                return null;
            }
            ITuple aTuple = (ITuple)CubeCache.this.axisIterators[this.edgeOrdinal].next();
            if (aTuple == null) {
                CubeCache.this.axisIterators[this.edgeOrdinal].release();
                ((CubeCache)CubeCache.this).axisIterators[this.edgeOrdinal] = null;
                return null;
            }
            ++this.iteratorPosition;
            if (!CubeCache.this.cacheHints.isAxisCached(this.edgeOrdinal)) {
                return aTuple;
            }
            CubeCache.this.cachedTuples[this.edgeOrdinal].add(aTuple);
            return aTuple;
        }

        @Override
        public void release() {
            super.release();
        }
    }
}

