/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets.md;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.types.ContextValueType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.IIterator;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.ContextBase;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.resultsets.HResultSetException;
import com.cognos.xqe.resultsets.md.CacheHints;
import com.cognos.xqe.resultsets.md.CubeCache;
import com.cognos.xqe.resultsets.md.TabularAxisIterator;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.resultsets.tabular.DimensionColumnInfo;
import com.cognos.xqe.resultsets.tabular.MeasureColumnInfo;
import com.cognos.xqe.resultsets.tabular.RowsetInfo;
import com.cognos.xqe.resultsets.util.CubeResultSetWriter;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.runtree.ScrollableIterator;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XScrollableCellIterator;
import com.cognos.xqe.runtree.XScrollableIterator;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.olap.decoration.EdgeOrdinalMapping;
import com.cognos.xqe.runtree.olap.decoration.OLAPDecorationAxisIterator;
import com.cognos.xqe.runtree.v5.V5OnHybridEdgeIterator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.LinkedStack;
import com.cognos.xqe.util.xml.XMLWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CubeHybridResultSet
extends XResultSetBase
implements IHybridResultSet {
    private static final String ELEMENT_OLAPINFO = "OlapInfo";
    private static final String ELEMENT_CUBEINFO = "CubeInfo";
    private static final String ELEMENT_CUBE = "Cube";
    private static final String ELEMENT_CUBENAME = "CubeName";
    private static final String ELEMENT_AXESINFO = "AxesInfo";
    private static final String ELEMENT_AXISINFO = "AxisInfo";
    private static final String ELEMENT_HIERARCHYINFO = "HierarchyInfo";
    private static final String ELEMENT_CELLINFO = "CellInfo";
    private static final String ELEMENT_VALUE = "Value";
    private static final String ELEMENT_AXES = "Axes";
    private static final String ELEMENT_AXIS = "Axis";
    private static final String ATTRIBUTE_SLICERAXIS = "SlicerAxis";
    private static final String ELEMENT_TUPLES = "Tuples";
    private static final String ELEMENT_CELLDATA = "CellData";
    private static final String ELEMENT_UNAME = "UName";
    private static final String ELEMENT_CAPTION = "Caption";
    private static final String ELEMENT_LNAME = "LName";
    private static final String ELEMENT_LNUM = "LNum";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_UNIQUE_NAME = "uniqueName";
    static final long serialVersionUID = 1L;
    private ICubeResultSet dimensionalResult;
    private ICubeResultSet originalDimensionalResult;
    private CubeCache cache = null;
    private RowsetInfo rowSetInfo = null;
    private CacheHints cacheHints;
    private long[] v5EdgeSizes;
    private long tabularRowsSize = -1L;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    private void buildCache() {
        if (this.cache != null) {
            return;
        }
        LinkedStack<CacheHints> stack = new LinkedStack<CacheHints>();
        stack.push(this.cacheHints);
        this.cache = new CubeCache(this.getDataContext(), this.originalDimensionalResult, this.nodeId, this.cacheHints);
        this.originalDimensionalResult.optimizeCache(stack);
        this.dimensionalResult = this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRowsetInfo getTabularRowsetInfo() {
        if (this.rowSetInfo != null) {
            return this.rowSetInfo;
        }
        RowsetInfo columnInfoCollection = new RowsetInfo();
        MDTabularIterator tabIterator = new MDTabularIterator(this.getDataContext(), this.nodeId);
        IRow aRow = null;
        try {
            while ((aRow = (IRow)tabIterator.next()) != null && aRow.isSummary()) {
            }
        }
        finally {
            tabIterator.release();
        }
        if (aRow != null) {
            IValue[] values = aRow.getColumns();
            for (int i = 0; i < values.length; ++i) {
                ContextBase contextItem = (ContextBase)((Object)values[i]);
                if (contextItem.contextIsAMember()) {
                    IMember aMember = (IMember)((Object)contextItem);
                    columnInfoCollection.addColumnInfo(new DimensionColumnInfo(aMember.getDimension()));
                    continue;
                }
                ContextValue aValue = (ContextValue)contextItem;
                ContextValueType contextValueType = DataTypeFactory.getContextValueType(aValue.getValue().getDataType());
                columnInfoCollection.addColumnInfo(new MeasureColumnInfo(aValue.getContextMember(), (IDataType)contextValueType));
            }
        }
        this.rowSetInfo = columnInfoCollection;
        return this.rowSetInfo;
    }

    public CubeHybridResultSet(XDataContext xDataContext, ICubeResultSet olapResult, Integer theNodeId, CacheHints hints) {
        super(xDataContext, theNodeId);
        this.dimensionalResult = olapResult;
        this.originalDimensionalResult = olapResult;
        this.cacheHints = hints;
        this.v5EdgeSizes = new long[this.dimensionalResult.getNumAxes()];
        for (int i = 0; i < this.v5EdgeSizes.length; ++i) {
            this.v5EdgeSizes[i] = -1L;
        }
    }

    @Override
    public int getNumAxes() {
        return this.dimensionalResult.getNumAxes();
    }

    @Override
    public XIterator getAxisIterator(int axisNumber) {
        if (this.cacheHints.isAxisCached(axisNumber)) {
            return this.getScrollableAxisIterator(axisNumber);
        }
        return this.dimensionalResult.getAxisIterator(axisNumber);
    }

    @Override
    public XScrollableIterator getScrollableAxisIterator(int axisNumber) {
        this.buildCache();
        if (!this.cacheHints.isAxisCached(axisNumber)) {
            return this.originalDimensionalResult.getScrollableAxisIterator(axisNumber);
        }
        return this.cache.getScrollableAxisIterator(axisNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getV5EdgeSize(RSAPIEdge edge) {
        int axisNumber = edge.getHybridResultSetEdgePosition();
        if (axisNumber >= 0) {
            boolean isCrosstab = edge.getDataset().isCrossTabReport();
            if (isCrosstab) {
                if (this.v5EdgeSizes[axisNumber] == -1L) {
                    this.v5EdgeSizes[axisNumber] = this.getAxisSize(axisNumber);
                }
                return this.v5EdgeSizes[axisNumber];
            }
            if (this.tabularRowsSize == -1L) {
                this.tabularRowsSize = 0L;
                ITabularIterator iterator = this.getTabularIterator();
                try {
                    Object o = iterator.next();
                    while (o != null) {
                        ++this.tabularRowsSize;
                        o = iterator.next();
                    }
                }
                finally {
                    iterator.release();
                }
            }
            return this.tabularRowsSize;
        }
        return 0L;
    }

    @Override
    public IScrollableIterator getScrollableV5EdgeIterator(RSAPIEdge edge) {
        return new ScrollableIterator(this.getDataContext(), this.getV5EdgeIterator(edge), this.nodeId, edge);
    }

    @Override
    public XIterator getV5EdgeIterator(RSAPIEdge edge) {
        IIterator iterator = null;
        boolean isCrosstab = edge.getDataset().isCrossTabReport();
        if (isCrosstab) {
            int edgeInx = edge.getHybridResultSetEdgePosition();
            if (edgeInx != -1) {
                iterator = new TabularAxisIterator(this.getAxisIterator(edgeInx), this.nodeId);
            }
        } else {
            iterator = this.getTabularIterator();
        }
        return new V5OnHybridEdgeIterator(this.getDataContext(), this.nodeId, edge, iterator);
    }

    @Override
    public XCellIterator getV5CellIterator() {
        return this.getCellIterator();
    }

    @Override
    public XScrollableCellIterator getScrollableV5CellIterator() {
        return this.getScrollableCellIterator();
    }

    @Override
    public ITuple getSlicer() {
        return this.dimensionalResult.getSlicer();
    }

    @Override
    public XCellIterator getCellIterator() {
        return this.dimensionalResult.getCellIterator();
    }

    @Override
    public XScrollableCellIterator getScrollableCellIterator() {
        this.buildCache();
        return this.cache.getScrollableCellIterator();
    }

    @Override
    public IScrollableIterator getScrollableTabularIterator() {
        return new ScrollableIterator(this.getDataContext(), this.getTabularIterator(), this.nodeId);
    }

    @Override
    public ITabularIterator getTabularIterator() {
        return new MDTabularIterator(this.getDataContext(), this.nodeId);
    }

    @Override
    public long getRowCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isTabular() {
        return false;
    }

    @Override
    public int compareTo(Object o) {
        return -1;
    }

    private String generateUniqueName(String part1, String part2) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(part1);
        buffer.append(".[");
        buffer.append(part2);
        buffer.append("]");
        return buffer.toString();
    }

    private void dumpHierarchyInfo(XMLWriter xmlWriter, IHierarchy[] hierarchies) {
        if (hierarchies == null) {
            return;
        }
        for (int j = 0; j < hierarchies.length; ++j) {
            String hName = hierarchies[j].getUniqueName();
            xmlWriter.beginElement(ELEMENT_HIERARCHYINFO, -1);
            xmlWriter.attribute(ATTRIBUTE_NAME, hName);
            xmlWriter.beginElement(ELEMENT_UNAME, -1);
            xmlWriter.attribute(ATTRIBUTE_NAME, this.generateUniqueName(hName, "MEMBER_UNIQUE_NAME"));
            xmlWriter.endElement();
            xmlWriter.beginElement(ELEMENT_CAPTION, -1);
            xmlWriter.attribute(ATTRIBUTE_NAME, this.generateUniqueName(hName, "MEMBER_CAPTION"));
            xmlWriter.endElement();
            xmlWriter.beginElement(ELEMENT_LNAME, -1);
            xmlWriter.attribute(ATTRIBUTE_NAME, this.generateUniqueName(hName, "LEVEL_UNIQUE_NAME"));
            xmlWriter.endElement();
            xmlWriter.beginElement(ELEMENT_LNUM, -1);
            xmlWriter.attribute(ATTRIBUTE_NAME, this.generateUniqueName(hName, "LEVEL_NUMBER"));
            xmlWriter.endElement();
            xmlWriter.endElement();
        }
    }

    @Override
    public void toXML(XMLWriter xmlWriter) {
        this.toXML(xmlWriter, true);
    }

    public void toXML(XMLWriter xmlWriter, boolean showOlapInfo) {
        CubeResultSetWriter cubeWriter = new CubeResultSetWriter(this.dimensionalResult, xmlWriter);
        cubeWriter.toXML(showOlapInfo);
    }

    private void addAncestorsLevels(Set<ILevel> set, ILevel level) {
        for (ILevel current = level; current != null; current = current.getPreviousLevel()) {
            set.add(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<IDimension, Map<IHierarchy, Set<ILevel>>> getMetadataInResult(boolean includeAncestorLevels) {
        HashMap<IDimension, Map<IHierarchy, Set<ILevel>>> dimsToHierarchies = new HashMap<IDimension, Map<IHierarchy, Set<ILevel>>>();
        int numAxes = this.dimensionalResult.getNumAxes();
        for (int i = 0; i < numAxes; ++i) {
            XIterator anIterator = this.dimensionalResult.getAxisIterator(i);
            try {
                ITuple aTuple = (ITuple)anIterator.next();
                while (aTuple != null) {
                    IMember[] members = aTuple.getMembers();
                    int memberCount = members.length;
                    for (int k = 0; k < memberCount; ++k) {
                        HashSet<ILevel> levels;
                        ILevel level = members[k].getLevel();
                        IHierarchy hierarchy = level.getHierarchy();
                        IDimension dimension = hierarchy.getDimension();
                        HashMap<IHierarchy, HashSet<ILevel>> hierarchiesToLevels = (HashMap<IHierarchy, HashSet<ILevel>>)dimsToHierarchies.get(dimension);
                        if (hierarchiesToLevels == null) {
                            hierarchiesToLevels = new HashMap<IHierarchy, HashSet<ILevel>>();
                            dimsToHierarchies.put(dimension, hierarchiesToLevels);
                        }
                        if ((levels = (HashSet<ILevel>)hierarchiesToLevels.get(hierarchy)) == null) {
                            levels = new HashSet<ILevel>();
                            hierarchiesToLevels.put(hierarchy, levels);
                        }
                        if (includeAncestorLevels) {
                            this.addAncestorsLevels(levels, level);
                            continue;
                        }
                        levels.add(level);
                    }
                    aTuple = (ITuple)anIterator.next();
                }
                continue;
            }
            finally {
                anIterator.release();
            }
        }
        ITuple slicer = this.dimensionalResult.getSlicer();
        if (slicer != null) {
            IMember[] members = slicer.getMembers();
            int memberCount = members.length;
            for (int k = 0; k < memberCount; ++k) {
                HashSet<ILevel> levels;
                ILevel level = members[k].getLevel();
                IHierarchy hierarchy = level.getHierarchy();
                IDimension dimension = hierarchy.getDimension();
                HashMap<IHierarchy, HashSet<ILevel>> hierarchiesToLevels = (HashMap<IHierarchy, HashSet<ILevel>>)dimsToHierarchies.get(dimension);
                if (hierarchiesToLevels == null) {
                    hierarchiesToLevels = new HashMap<IHierarchy, HashSet<ILevel>>();
                    dimsToHierarchies.put(dimension, hierarchiesToLevels);
                }
                if ((levels = (HashSet<ILevel>)hierarchiesToLevels.get(hierarchy)) == null) {
                    levels = new HashSet<ILevel>();
                    hierarchiesToLevels.put(hierarchy, levels);
                }
                if (includeAncestorLevels) {
                    this.addAncestorsLevels(levels, level);
                    continue;
                }
                levels.add(level);
            }
        }
        return dimsToHierarchies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IHierarchy[] getHierarchies(int axisNumber) {
        ITuple aTuple;
        if (axisNumber >= this.dimensionalResult.getNumAxes()) {
            return null;
        }
        XIterator anIterator = this.dimensionalResult.getAxisIterator(axisNumber);
        try {
            aTuple = (ITuple)anIterator.next();
        }
        finally {
            anIterator.release();
        }
        if (aTuple != null) {
            return aTuple.getHierarchies();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDimension[] getDimensions(int axisNumber) {
        ITuple aTuple;
        if (axisNumber >= this.dimensionalResult.getNumAxes()) {
            return null;
        }
        XIterator anIterator = this.dimensionalResult.getAxisIterator(axisNumber);
        try {
            aTuple = (ITuple)anIterator.next();
        }
        finally {
            anIterator.release();
        }
        if (aTuple != null) {
            return aTuple.getDimensions();
        }
        return null;
    }

    @Override
    public long getAxisSize(int axisNumber) {
        this.buildCache();
        return this.cache.getAxisSize(axisNumber);
    }

    @Override
    public int getNumTabularMeasures() {
        return this.dimensionalResult.getNumTabularMeasures();
    }

    @Override
    public int getNumDataItemForSummary(int rowsetId) {
        return this.dimensionalResult.getNumDataItemForSummary(rowsetId);
    }

    @Override
    public void releaseImpl() {
        if (this.cache != null) {
            this.cache.release();
            this.cache = null;
        }
        if (this.originalDimensionalResult != null) {
            this.originalDimensionalResult.release();
            this.originalDimensionalResult = null;
        }
    }

    public Integer getNodeId() {
        return this.nodeId;
    }

    public ICubeResultSet getDimensionalResult() {
        return this.originalDimensionalResult;
    }

    @Override
    public boolean isCaching() {
        return true;
    }

    @Override
    public void optimizeCache(LinkedStack<CacheHints> hints) {
        this.cacheHints.optimizeCache(hints, this.getNumAxes());
        hints.push(this.cacheHints);
        this.originalDimensionalResult.optimizeCache(hints);
    }

    public boolean isPipelining() {
        if (this.cache != null) {
            XCellIterator cacheCellIterator = this.cache.getCellIterator();
            return cacheCellIterator.hasPipelineIterator();
        }
        return false;
    }

    private final class MDTabularIterator
    extends XTabularIterator {
        private long[] axisPositions;
        private long[] axisSizes;
        private ITuple[] currentTuples;
        private XIterator[] axisIterators;
        private XScrollableCellIterator cellIterator;
        private List<IValue> rowItems;
        private List<IValue> measures;
        private boolean eod;
        private IRow resultRow;

        private MDTabularIterator(XDataContext xDataContext, Integer theNodeId) {
            super(xDataContext, theNodeId);
            this.rowItems = new ArrayList<IValue>();
            this.measures = new ArrayList<IValue>();
            this.eod = false;
            this.resultRow = null;
            int numAxes = CubeHybridResultSet.this.getNumAxes();
            if (numAxes == 0) {
                this.eod = true;
                return;
            }
            try {
                this.axisPositions = new long[numAxes];
                this.axisIterators = new XIterator[numAxes];
                this.axisSizes = new long[numAxes];
                this.currentTuples = new ITuple[numAxes];
                for (int i = 0; i < numAxes; ++i) {
                    this.axisIterators[i] = CubeHybridResultSet.this.getAxisIterator(i);
                    this.currentTuples[i] = (ITuple)this.axisIterators[i].next();
                    this.axisSizes[i] = -1L;
                }
                if (this.currentTuples[0] == null) {
                    this.eod = true;
                }
                this.cellIterator = CubeHybridResultSet.this.getScrollableCellIterator();
            }
            catch (RuntimeException e) {
                this.release();
                throw e;
            }
        }

        private long computeCellOrdinal() {
            return this.calculateOffset(this.axisIterators.length - 1);
        }

        private long calculateOffset(int edgeOrdinal) {
            long axisPosition = this.axisPositions[edgeOrdinal];
            XDataContext dataContext = this.axisIterators[edgeOrdinal].getDataContext();
            EdgeOrdinalMapping edgeOrdinalMapping = dataContext.getCoordinateMappings(null, edgeOrdinal);
            if (edgeOrdinalMapping != null) {
                axisPosition = edgeOrdinalMapping.lookup(axisPosition);
            }
            if (edgeOrdinal == 0) {
                return axisPosition;
            }
            int previousEdgeOrdinal = edgeOrdinal - 1;
            long offset = 0L;
            long tupleOrdinal = axisPosition;
            if (tupleOrdinal > 0L) {
                offset = 1L;
                for (int i = previousEdgeOrdinal; i >= 0; --i) {
                    offset *= this.axisSizes[i];
                }
                offset *= tupleOrdinal;
            }
            return this.calculateOffset(previousEdgeOrdinal) + offset;
        }

        private ICell getCell(long cellOrdinal) {
            return this.cellIterator.byOrdinal(cellOrdinal);
        }

        private void advanceToNextTuple(int edgeOrdinal) {
            if (edgeOrdinal >= this.axisIterators.length) {
                this.eod = true;
                return;
            }
            this.currentTuples[edgeOrdinal] = (ITuple)this.axisIterators[edgeOrdinal].next();
            if (this.currentTuples[edgeOrdinal] != null) {
                int n = edgeOrdinal;
                this.axisPositions[n] = this.axisPositions[n] + 1L;
            } else {
                this.axisSizes[edgeOrdinal] = this.axisPositions[edgeOrdinal] + 1L;
                this.axisPositions[edgeOrdinal] = 0L;
                if (this.axisIterators[edgeOrdinal] != null) {
                    this.axisIterators[edgeOrdinal].release();
                }
                this.axisIterators[edgeOrdinal] = CubeHybridResultSet.this.getAxisIterator(edgeOrdinal);
                this.currentTuples[edgeOrdinal] = (ITuple)this.axisIterators[edgeOrdinal].next();
                this.advanceToNextTuple(edgeOrdinal + 1);
            }
        }

        private void consumeTuple(ITuple aTuple, List<IValue> aRowItems, List<IValue> aMeasures) {
            boolean containsCalculation = false;
            int pos = OLAPDecorationAxisIterator.containsCalculation(aTuple);
            if (pos != -1) {
                containsCalculation = true;
            }
            boolean summaryMemberConsumed = false;
            for (int j = 0; j < aTuple.size(); ++j) {
                ILevel level;
                IMember aMember = aTuple.getMember(j);
                if (!aMember.isContextMember()) continue;
                ContextMember contextMember = (ContextMember)aMember;
                do {
                    if (contextMember.getDataItemIndex() != -2) continue;
                    ContextValue contextValue = new ContextValue(DoubleValue.NULL_VALUE);
                    contextValue.assignContextFromMember(contextMember);
                    contextValue.getContextMember().setSummary(true);
                    aMeasures.add(contextValue);
                    return;
                } while ((contextMember = contextMember.getContextMember()) != null);
                contextMember = (ContextMember)aMember;
                if (this.projectsValue(contextMember, containsCalculation)) {
                    IDataType dt;
                    long cellOrdinal;
                    ICell aCell;
                    if (contextMember.isSummary()) {
                        summaryMemberConsumed = true;
                    }
                    IValue aValue = (aCell = this.getCell(cellOrdinal = this.computeCellOrdinal())) == null ? (null != (dt = contextMember.getMember().getDataType()) && dt.isTextType() ? StringValue.NULL_VALUE : DoubleValue.NULL_VALUE) : aCell.getValue();
                    if (!(aValue instanceof ContextValue)) {
                        aValue = new ContextValue(aValue);
                    }
                    ((ContextValue)aValue).assignContextFromMember(contextMember);
                    aMeasures.add(aValue);
                    continue;
                }
                if (summaryMemberConsumed || (level = aMember.getLevel()) == null || level.getDimension() == null || level.getDimension().isMeasuresDimension()) continue;
                aRowItems.add(aMember);
            }
        }

        private boolean projectsValue(ContextMember contextMember, boolean containsCalculation) {
            if (contextMember.getRowset() == null) {
                return false;
            }
            if (containsCalculation) {
                if (contextMember.isSummary()) {
                    return true;
                }
                return contextMember.isQueryCalculation() && contextMember.isMeasure();
            }
            return contextMember.isMeasure();
        }

        @Override
        public Object nextImpl() {
            int i;
            if (this.eod) {
                return null;
            }
            boolean isSummaryRow = false;
            boolean inSummaryRow = false;
            this.rowItems.clear();
            this.measures.clear();
            int numTabularMeasures = CubeHybridResultSet.this.getNumTabularMeasures();
            do {
                isSummaryRow = false;
                if (this.eod) {
                    throw new HResultSetException(XQEMessageKeys.DEC_InsufficientDataForTabularRow);
                }
                if (this.measures.size() > numTabularMeasures) {
                    String errMsg = "measures.size() > numTabularMeasures";
                    throw new HResultSetException(XQEMessageKeys.DEC_InternalError_INTERNAL, "measures.size() > numTabularMeasures");
                }
                ArrayList<IValue> tmpRowItems = new ArrayList<IValue>();
                ArrayList<IValue> tmpMeasures = new ArrayList<IValue>();
                for (int i2 = 0; i2 < this.currentTuples.length; ++i2) {
                    if (this.currentTuples[i2] == null) continue;
                    this.consumeTuple(this.currentTuples[i2], tmpRowItems, tmpMeasures);
                }
                boolean inRow = this.rowItems.size() == tmpRowItems.size();
                for (i = 0; inRow && i < this.rowItems.size(); ++i) {
                    ContextMember oldMember = (ContextMember)this.rowItems.get(i);
                    ContextMember newMember = (ContextMember)tmpRowItems.get(i);
                    inRow = oldMember.sameAs(newMember);
                }
                if (tmpMeasures.size() > 0 && this.measures.size() > 0) {
                    ContextValue newMeasure = (ContextValue)tmpMeasures.get(0);
                    for (int i3 = 0; inRow && i3 < this.measures.size(); ++i3) {
                        ContextValue oldMeasure = (ContextValue)this.measures.get(i3);
                        if (oldMeasure.getRowset() == null) continue;
                        inRow = oldMeasure.getRowset().equals(newMeasure.getRowset());
                    }
                }
                if (inRow) {
                    ContextValue potentialSummaryValue;
                    if (!inSummaryRow && !this.measures.isEmpty() && (potentialSummaryValue = (ContextValue)tmpMeasures.get(0)).isSummary()) {
                        inRow = false;
                    }
                    boolean duplicateRow = inRow && this.measures.size() == tmpMeasures.size();
                    for (int i4 = 0; duplicateRow && i4 < this.measures.size(); ++i4) {
                        ContextValue oldValue = (ContextValue)this.measures.get(i4);
                        ContextValue newValue = (ContextValue)tmpMeasures.get(i4);
                        duplicateRow = oldValue.getContextMember().sameAs(newValue.getContextMember());
                    }
                    if (duplicateRow) {
                        inRow = false;
                    }
                }
                if (!inRow && !this.rowItems.isEmpty()) break;
                if (tmpMeasures.size() == 1 && ((ContextValue)tmpMeasures.get(0)).isSummary()) {
                    numTabularMeasures = CubeHybridResultSet.this.getNumDataItemForSummary(((ContextValue)tmpMeasures.get(0)).getRowset().getRowsetId());
                    isSummaryRow = true;
                    inSummaryRow = true;
                }
                if (inSummaryRow && !isSummaryRow) break;
                this.rowItems.clear();
                this.rowItems.addAll(tmpRowItems);
                this.measures.addAll(tmpMeasures);
                this.advanceToNextTuple(0);
            } while (numTabularMeasures != 0 && this.measures.size() != numTabularMeasures && !this.eod);
            int membersOnRow = this.rowItems.size();
            int measuresOnRow = this.measures.size();
            if (this.resultRow == null || membersOnRow + measuresOnRow != this.resultRow.getNumColumns() || inSummaryRow) {
                this.resultRow = this.constructRow();
            } else if (this.resultRow != null) {
                boolean columnsChanged = false;
                for (i = 0; !columnsChanged && i < membersOnRow + measuresOnRow; ++i) {
                    ContextBase newMember = null;
                    newMember = i < membersOnRow ? (ContextBase)((Object)this.rowItems.get(i)) : (ContextBase)((Object)this.measures.get(i - membersOnRow));
                    ContextBase storedMember = (ContextBase)((Object)this.resultRow.getColumns()[i]);
                    if (newMember.getDataItemIndex() == storedMember.getDataItemIndex() && newMember.isSummary() == storedMember.isSummary()) continue;
                    columnsChanged = true;
                }
                if (columnsChanged) {
                    this.resultRow = this.constructRow();
                } else {
                    this.setupResultRowValues();
                }
            }
            return this.resultRow;
        }

        private void setupResultRowValues() {
            int membersOnRow = this.rowItems.size();
            IValue[] values = this.resultRow.getColumns();
            for (int i = 0; i < membersOnRow; ++i) {
                values[i] = this.rowItems.get(i);
            }
            String listDelimiter = ", ";
            IValue cellValue = null;
            for (int i = membersOnRow; i < values.length; ++i) {
                int j;
                ContextMember valueContextMember = ((ContextValue)values[i]).getContextMember();
                for (j = 0; j < this.measures.size(); ++j) {
                    ContextMember currMeasure = ((ContextValue)this.measures.get(j)).getContextMember();
                    if (valueContextMember.getDataItemIndex() != currMeasure.getDataItemIndex() || !valueContextMember.getName().equals(currMeasure.getName())) continue;
                    cellValue = this.measures.get(j);
                    values[i] = (IValue)cellValue.copy();
                    break;
                }
                if (j != this.measures.size()) continue;
                StringBuilder foundMeasure = new StringBuilder();
                for (j = 0; j < this.measures.size(); ++j) {
                    ContextMember currMeasure = ((ContextValue)this.measures.get(j)).getContextMember();
                    if (foundMeasure.length() > 0) {
                        foundMeasure.append(listDelimiter);
                    }
                    foundMeasure.append(currMeasure.getName());
                }
                StringBuilder memberList = new StringBuilder();
                for (int k = 0; k < membersOnRow; ++k) {
                    if (k > 0) {
                        memberList.append(listDelimiter);
                    }
                    memberList.append(((ContextMember)values[k]).getName());
                }
                throw new HResultSetException(XQEMessageKeys.EXE_InsufficientNumberOfMeasures, (Object)valueContextMember.getName(), (Object)memberList.toString(), (Object)foundMeasure.toString());
            }
        }

        private IRow constructRow() {
            int membersOnRow = this.rowItems.size();
            int measuresOnRow = this.measures.size();
            IValue[] values = new IValue[membersOnRow + measuresOnRow];
            RowValue aRow = DataValueFactory.createRowValue(values);
            for (int i = 0; i < membersOnRow; ++i) {
                IValue aValue;
                values[i] = aValue = this.rowItems.get(i);
            }
            int listIndex = 0;
            for (int i = membersOnRow; i < values.length; ++i) {
                ContextValue aValue = (ContextValue)this.measures.get(listIndex++);
                values[i] = (IValue)aValue.copy();
            }
            return aRow;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            if (this.axisIterators != null) {
                for (int i = 0; i < this.axisIterators.length; ++i) {
                    if (this.axisIterators[i] == null) continue;
                    try {
                        this.axisIterators[i].release();
                        continue;
                    }
                    catch (Exception ex) {
                        mErrorLogger.log(ex);
                        continue;
                    }
                    finally {
                        this.axisIterators[i] = null;
                    }
                }
                this.axisIterators = null;
            }
            if (this.cellIterator != null) {
                try {
                    this.cellIterator.release();
                }
                catch (Exception ex) {
                    mErrorLogger.log(ex);
                }
                finally {
                    this.cellIterator = null;
                }
            }
            this.measures.clear();
            this.resultRow = null;
            this.rowItems.clear();
            CubeHybridResultSet.this.rowSetInfo = null;
        }
    }
}

