/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets.md;

import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.util.xml.XMLWriter;
import java.util.Arrays;

public class Tuple
implements ITuple {
    private static final String CLOSE_BRACKET = ")";
    private static final String OPEN_BRACKET = "(";
    private static final int HASHING_PRIME_37 = 37;
    private static final int HASHING_PRIME_17 = 17;
    static final long serialVersionUID = 1L;
    private IMember[] members;
    private int hashCode = -1;
    private ICube cube;

    public static Tuple[] createTuplePerMember(IMember[] members) {
        Tuple[] tuples = new Tuple[members.length];
        for (int i = 0; i < members.length; ++i) {
            tuples[i] = new Tuple(members[i]);
        }
        return tuples;
    }

    public Tuple(IMember member) {
        this(new IMember[]{member}, false);
    }

    public Tuple(IMember[] pMembers) {
        this(pMembers, true);
    }

    public Tuple(IMember[] pMembers, boolean checkDimensionality) {
        this.members = pMembers;
    }

    public int compareTo(Object o) {
        return this.hashCode() - o.hashCode();
    }

    @Override
    public boolean contains(IDimension d) {
        return this.getMember(d) != null;
    }

    @Override
    public boolean contains(IHierarchy h) {
        return this.getMember(h) != null;
    }

    @Override
    public boolean contains(IMember m) {
        for (int i = 0; i < this.members.length; ++i) {
            if (m instanceof ContextMember) {
                ContextMember cm1 = (ContextMember)m;
                if (!(this.members[i] instanceof ContextMember ? cm1.getMember() == ((ContextMember)this.members[i]).getMember() : cm1.getMember() == this.members[i])) continue;
                return true;
            }
            if (!(this.members[i] instanceof ContextMember ? ((ContextMember)this.members[i]).getMember() == m : this.members[i] == m)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(ITuple t) {
        for (int i = 0; i < t.size(); ++i) {
            if (this.contains(t.getMember(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public IMember getMember(int index) {
        if (index == -1) {
            return null;
        }
        return this.members[index];
    }

    @Override
    public IMember getMember(IDimension d) {
        IMember result = null;
        boolean found = false;
        int i = 0;
        while (i < this.members.length && !found) {
            if (this.members[i].getLevel().getHierarchy().getDimension() == d) {
                found = true;
                continue;
            }
            ++i;
        }
        if (found) {
            result = this.members[i];
        }
        return result;
    }

    @Override
    public IMember getMember(IHierarchy h) {
        IMember result = null;
        boolean found = false;
        int i = 0;
        while (i < this.members.length && !found) {
            if (this.members[i].getHierarchy().equals(h)) {
                found = true;
                continue;
            }
            ++i;
        }
        if (found) {
            result = this.members[i];
        }
        return result;
    }

    @Override
    public IMember[] getMembers() {
        return this.members;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tuple)) {
            return false;
        }
        Tuple tuple = (Tuple)o;
        return Arrays.equals(this.members, tuple.members);
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = 17;
            for (int i = 0; i < this.members.length; ++i) {
                this.hashCode = 37 * this.hashCode + this.members[i].hashCode();
            }
        }
        return this.hashCode;
    }

    @Override
    public ITuple remove(IDimension d) {
        this.hashCode = -1;
        IMember[] mems = new IMember[this.members.length - 1];
        int count = 0;
        for (int i = 0; i < this.members.length; ++i) {
            if (this.members[i].getLevel().getHierarchy().getDimension() == d) continue;
            mems[count++] = this.members[i];
        }
        return new Tuple(mems, false);
    }

    @Override
    public ITuple remove(IHierarchy h) {
        this.hashCode = -1;
        IMember[] mems = new IMember[this.members.length - 1];
        int count = 0;
        for (int i = 0; i < this.members.length; ++i) {
            if (!this.members[i].getLevel().getHierarchy().equals(h)) continue;
            mems[count++] = this.members[i];
        }
        return new Tuple(mems, false);
    }

    @Override
    public IDimension[] getDimensions() {
        IDimension[] result = new IDimension[this.members.length];
        for (int i = 0; i < result.length; ++i) {
            ILevel level = this.members[i].getLevel();
            result[i] = level != null ? level.getHierarchy().getDimension() : null;
        }
        return result;
    }

    @Override
    public IHierarchy[] getHierarchies() {
        IHierarchy[] result = new IHierarchy[this.members.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.members[i].getLevel().getHierarchy();
        }
        return result;
    }

    @Override
    public int size() {
        return this.members.length;
    }

    public String toString() {
        String s = this.members.length > 0 ? OPEN_BRACKET + this.members[0].toString() : OPEN_BRACKET;
        for (int i = 1; i < this.members.length; ++i) {
            s = s + ", " + this.members[i].toString();
        }
        s = s + CLOSE_BRACKET;
        return s;
    }

    @Override
    public void toXML(XMLWriter xmlWriter) {
        xmlWriter.beginElement("Tuple", -1);
        for (int idx = 0; idx < this.size(); ++idx) {
            IMember member = this.getMember(idx);
            member.toXML(xmlWriter);
        }
        xmlWriter.endElement();
    }

    @Override
    public Object copy() {
        IMember[] memberArray = new IMember[this.members.length];
        for (int i = 0; i < this.members.length; ++i) {
            memberArray[i] = (IMember)this.members[i].copy();
        }
        Tuple t = new Tuple(memberArray);
        t.setCube(this.cube);
        return t;
    }

    @Override
    public ICube getCube() {
        if (this.cube != null) {
            return this.cube;
        }
        if (this.members != null) {
            for (IMember member : this.members) {
                if (!member.isMeasure() && member.getDimension().isShareable()) continue;
                this.cube = member.getDimension().getCube();
                break;
            }
        }
        if (this.cube == null) {
            throw new UnsupportedOperationException("Could not determine cube for Tuple.");
        }
        return this.cube;
    }

    @Override
    public void setCube(ICube c) {
        this.cube = c;
    }
}

