/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets.ndm;

import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.IIterator;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.resultsets.md.CacheHints;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.resultsets.ndm.NoDataModeAxisIterator;
import com.cognos.xqe.resultsets.ndm.NoDataModeCellIterator;
import com.cognos.xqe.resultsets.ndm.NoDataModeRowSet;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XScrollableCellIterator;
import com.cognos.xqe.runtree.XScrollableIterator;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.v5.V5OnHybridEdgeIterator;
import com.cognos.xqe.util.LinkedStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NoDataModeHybridResultSet
extends XResultSetBase
implements IHybridResultSet {
    final RSAPIDataset dataset;
    private final XDataContext xDataContext;
    private Map<Integer, IIterator> tabularIterators = new HashMap<Integer, IIterator>();

    public NoDataModeHybridResultSet(XDataContext theDataContext, RSAPIDataset theDataset, Integer theNodeId) {
        super(theDataContext, theNodeId);
        this.dataset = theDataset;
        this.xDataContext = theDataContext;
    }

    @Override
    public boolean isTabular() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ITabularIterator getTabularIterator() {
        throw new UnsupportedOperationException();
    }

    public ITabularIterator getTabularIterator(RSAPIEdge edge) {
        return new MDTabularIterator(edge, this.getDataContext(), this.nodeId);
    }

    @Override
    public XIterator getAxisIterator(int axisPositionalOrdinal) {
        return new NoDataModeAxisIterator(this.xDataContext, this.getAxisRowset(axisPositionalOrdinal), this.nodeId);
    }

    @Override
    public long getAxisSize(int axisNumber) {
        throw new UnsupportedOperationException();
    }

    @Override
    public XCellIterator getCellIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IDimension[] getDimensions(int axisNumber) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumAxes() {
        return this.dataset.getEdges().length;
    }

    @Override
    public int getNumDataItemForSummary(int rowsetId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumTabularMeasures() {
        throw new UnsupportedOperationException();
    }

    @Override
    public XScrollableIterator getScrollableAxisIterator(int axisNumber) {
        throw new UnsupportedOperationException();
    }

    @Override
    public XScrollableCellIterator getScrollableCellIterator() {
        long cellCount = 0L;
        for (Map.Entry<Integer, IIterator> entry : this.tabularIterators.entrySet()) {
            MDTabularIterator iterator = (MDTabularIterator)entry.getValue();
            long count = iterator.getRowCount();
            if (0L == count) continue;
            if (0L == cellCount) {
                cellCount = count;
                continue;
            }
            cellCount *= count;
        }
        return new NoDataModeCellIterator(this.xDataContext, cellCount);
    }

    @Override
    public ITuple getSlicer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public XScrollableCellIterator getScrollableV5CellIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IScrollableIterator getScrollableV5EdgeIterator(RSAPIEdge edge) {
        throw new UnsupportedOperationException();
    }

    @Override
    public XCellIterator getV5CellIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public XIterator getV5EdgeIterator(RSAPIEdge edge) {
        ITabularIterator iterator = this.getTabularIterator(edge);
        this.tabularIterators.put(edge.getOrdinal(), iterator);
        return new V5OnHybridEdgeIterator(this.getDataContext(), this.nodeId, edge, iterator);
    }

    @Override
    public long getV5EdgeSize(RSAPIEdge edge) {
        MDTabularIterator iterator = (MDTabularIterator)this.tabularIterators.get(edge.getOrdinal());
        return iterator.getRowCount();
    }

    private NoDataModeRowSet getAxisRowset(int axisPositionalOrdinal) {
        return new NoDataModeRowSet(this.dataset, axisPositionalOrdinal);
    }

    @Override
    public boolean isCaching() {
        return false;
    }

    @Override
    public void optimizeCache(LinkedStack<CacheHints> hints) {
    }

    @Override
    public void releaseImpl() {
    }

    private final class MDTabularIterator
    extends XTabularIterator {
        private XIterator axisIterator;
        private List<IValue> rowItems;
        private List<IValue> measures;
        private IRow resultRow;

        MDTabularIterator(RSAPIEdge edge, XDataContext theContext, Integer theNodeId) {
            super(theContext, theNodeId);
            this.rowItems = new ArrayList<IValue>();
            this.measures = new ArrayList<IValue>();
            this.resultRow = null;
            try {
                this.axisIterator = NoDataModeHybridResultSet.this.getAxisIterator(edge.getPositionalOrdinal());
            }
            catch (RuntimeException e) {
                this.release();
                throw e;
            }
        }

        @Override
        public Object nextImpl() {
            this.rowItems.clear();
            this.measures.clear();
            List values = (List)this.axisIterator.next();
            if (null == values) {
                return null;
            }
            for (IValue value : values) {
                if (value instanceof ContextValue) {
                    this.measures.add(value);
                    continue;
                }
                this.rowItems.add(value);
            }
            this.resultRow = this.constructRow();
            return this.resultRow;
        }

        @Override
        public void release() {
        }

        private IRow constructRow() {
            int membersOnRow = this.rowItems.size();
            int measuresOnRow = this.measures.size();
            IValue[] values = new IValue[membersOnRow + measuresOnRow];
            RowValue aRow = DataValueFactory.createRowValue(values);
            for (int i = 0; i < membersOnRow; ++i) {
                IValue aValue = this.rowItems.get(i);
                values[i] = aValue instanceof ContextMember ? aValue : (IValue)aValue.copy();
            }
            int listIndex = 0;
            for (int i = membersOnRow; i < values.length; ++i) {
                ContextValue aValue = (ContextValue)this.measures.get(listIndex++);
                values[i] = (IValue)aValue.copy();
            }
            return aRow;
        }

        @Override
        public long getRowCount() {
            return ((NoDataModeAxisIterator)this.axisIterator).getRowCount();
        }
    }
}

