/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets.tabular;

import com.cognos.xqe.ast.IXQEPersist;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultsets.tabular.Relation;
import com.cognos.xqe.trace.XQETrace;
import java.io.Serializable;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class Join
implements Serializable,
IXQEPersist {
    private static final long serialVersionUID = 1L;
    protected static final String ELEMENT_JOIN = "Join";
    protected static final String ELEMENT_LEFT = "left";
    protected static final String ELEMENT_RIGHT = "right";
    protected static final String ATTRIBUTE_ISNOTDISTINCTFROM = "isNotDistinctFrom";
    private Relation left;
    private Relation right;
    private boolean isNotDistinctFrom = false;

    public Join() {
    }

    public Join(Relation aLeft, Relation aRight) {
        this.left = aLeft;
        this.right = aRight;
    }

    public Relation getLeftJoin() {
        return this.left;
    }

    public Relation getRightJoin() {
        return this.right;
    }

    public boolean isNotDistinctFrom() {
        return this.isNotDistinctFrom;
    }

    public void setIsNotDistinctFrom(boolean use) {
        this.isNotDistinctFrom = use;
    }

    public void capture(PlanningEnvironment env, Element inputNode) {
        List relations = inputNode.elements();
        Attribute distinctAttr = inputNode.attribute(ATTRIBUTE_ISNOTDISTINCTFROM);
        this.isNotDistinctFrom = distinctAttr != null ? Boolean.valueOf(distinctAttr.getStringValue()) : false;
        this.left = new Relation();
        this.left.capture(env, (Element)relations.get(0));
        this.right = new Relation();
        this.right.capture(env, (Element)relations.get(1));
    }

    public void dumpExtraInfo(XQETrace trace) {
        trace.beginElement(ELEMENT_JOIN, -1);
        trace.attribute(ATTRIBUTE_ISNOTDISTINCTFROM, this.isNotDistinctFrom);
        this.getLeftJoin().dumpExtraInfo(trace);
        this.getRightJoin().dumpExtraInfo(trace);
        trace.endElement();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Join(");
        buffer.append(this.left.toString());
        buffer.append(", ");
        buffer.append(this.right.toString());
        buffer.append(")");
        return buffer.toString();
    }

    protected void persistAttributeProperties(XQEPersistContext ctx) {
        ctx.property(ATTRIBUTE_ISNOTDISTINCTFROM, this.isNotDistinctFrom);
    }

    protected void persistElementProperties(XQEPersistContext ctx) {
        if (this.left != null) {
            ctx.elementProperty(ELEMENT_LEFT, this.left);
        }
        if (this.right != null) {
            ctx.elementProperty(ELEMENT_RIGHT, this.right);
        }
    }

    @Override
    public void persist(XQEPersistContext ctx, String optionalName) {
        if (ctx.beginElement(this, optionalName, -1)) {
            this.persistAttributeProperties(ctx);
            this.persistElementProperties(ctx);
            ctx.endElement();
        }
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
        this.restoreAttributes(ctx, node);
        this.restoreChildren(ctx, node);
    }

    public void restoreChildren(XQERestoreContext ctx, Element node) {
        List childList = node.elements();
        int nChildren = childList.size();
        for (int i = 0; i < nChildren; ++i) {
            Element child = (Element)childList.get(i);
            if (child.getNamespace().getURI().isEmpty()) continue;
            this.restoreElementProperty(ctx, child, node);
        }
    }

    public void restoreAttributes(XQERestoreContext ctx, Element node) {
        int size = node.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = node.attribute(i);
            this.restoreAttributeProperty(ctx, att, node);
        }
    }

    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element node) {
        String attName = att.getName();
        if (attName.equals(ATTRIBUTE_ISNOTDISTINCTFROM)) {
            Object val = ctx.attributeValue(att);
            this.isNotDistinctFrom = (Boolean)val;
        }
    }

    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(ELEMENT_LEFT)) {
            Object val = ctx.elementValue(node);
            this.left = (Relation)val;
        } else if (pname.equals(ELEMENT_RIGHT)) {
            Object val = ctx.elementValue(node);
            this.right = (Relation)val;
        }
    }
}

