/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets.tabular;

import com.cognos.xqe.ast.IXQEPersist;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.resultsets.tabular.DimensionColumnInfo;
import java.io.Serializable;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class OrderBy
implements Serializable,
IXQEPersist {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_POSITION = "position";
    private static final String ATTRIBUTE_LEVELNO = "levelNo";
    private static final String ATTRIBUTE_ASCENDING = "ascending";
    private static final String ATTRIBUTE_NULL_ORDERING = "nullOrdering";
    private int position;
    private int levelNo;
    private boolean ascending;
    private SQLSortKey.NullOrdering nullOrdering = SQLSortKey.NullOrdering.UNSPECIFIED;

    public OrderBy() {
    }

    public OrderBy(int pPosition, boolean isAscending, SQLSortKey.NullOrdering nullOrder) {
        this.position = pPosition;
        this.levelNo = -1;
        this.ascending = isAscending;
        this.nullOrdering = nullOrder;
    }

    public OrderBy(int pPosition, boolean isAscending) {
        this.position = pPosition;
        this.levelNo = -1;
        this.ascending = isAscending;
    }

    public OrderBy(int pPosition, int pLevelNo, boolean isAscending) {
        this(pPosition, isAscending);
        this.levelNo = pLevelNo;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int pPosition) {
        this.position = pPosition;
    }

    public ILevel getLevel(DimensionColumnInfo dci) {
        List<ILevel> levels = dci.getDimension().getDefaultHierarchy().getLevels();
        if (this.levelNo < 0 || this.levelNo >= levels.size()) {
            return null;
        }
        return levels.get(this.levelNo);
    }

    public int getLevelNo() {
        return this.levelNo;
    }

    public void setLevelNo(int pLevelNo) {
        this.levelNo = pLevelNo;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public SQLSortKey.NullOrdering getNullOrdering() {
        return this.nullOrdering;
    }

    public void setNullOrdering(SQLSortKey.NullOrdering ordering) {
        if (ordering == null) {
            this.nullOrdering = SQLSortKey.NullOrdering.UNSPECIFIED;
        }
        this.nullOrdering = ordering;
    }

    protected void persistAttributeProperties(XQEPersistContext ctx) {
        ctx.property(ATTRIBUTE_POSITION, this.position);
        ctx.property(ATTRIBUTE_LEVELNO, this.levelNo);
        ctx.property(ATTRIBUTE_ASCENDING, this.ascending);
        ctx.property(ATTRIBUTE_NULL_ORDERING, (Object)this.nullOrdering);
    }

    @Override
    public void persist(XQEPersistContext ctx, String optionalName) {
        if (ctx.beginElement(this, optionalName, -1)) {
            this.persistAttributeProperties(ctx);
            ctx.endElement();
        }
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
        this.restoreAttributes(ctx, node);
    }

    public void restoreAttributes(XQERestoreContext ctx, Element node) {
        int size = node.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = node.attribute(i);
            this.restoreAttributeProperty(ctx, att, node);
        }
    }

    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element node) {
        String attName = att.getName();
        if (attName.equals(ATTRIBUTE_POSITION)) {
            Object val = ctx.attributeValue(att);
            this.position = (Integer)val;
        } else if (attName.equals(ATTRIBUTE_LEVELNO)) {
            Object val = ctx.attributeValue(att);
            this.levelNo = (Integer)val;
        } else if (attName.equals(ATTRIBUTE_ASCENDING)) {
            Object val = ctx.attributeValue(att);
            this.ascending = (Boolean)val;
        } else if (attName.equals(ATTRIBUTE_NULL_ORDERING)) {
            Object val = ctx.attributeValue(att);
            this.nullOrdering = (SQLSortKey.NullOrdering)((Object)val);
        }
    }
}

