/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets.tabular;

import com.cognos.xqe.ast.IXQEPersist;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultsets.tabular.ColumnInfo;
import com.cognos.xqe.resultsets.tabular.DimensionColumnInfo;
import com.cognos.xqe.trace.XQETrace;
import java.io.Serializable;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class Relation
implements Serializable,
IXQEPersist {
    private static final long serialVersionUID = 1L;
    protected static final String ELEMENT_RELATION = "Relation";
    protected static final String ATTRIBUTE_COLUMNNO = "columnNo";
    protected static final String ATTRIBUTE_LEVELNO = "levelNo";
    protected static final String ATTRIBUTE_LEVEL = "level";
    protected static final String ELEMENT_COLUMNINFO = "columnInfo";
    private int columnNo = 0;
    private int levelNo = 0;
    private ColumnInfo columnInfo;
    private ILevel level;

    public Relation() {
        this.columnNo = 0;
        this.columnInfo = null;
    }

    public Relation(int pColumnNo) {
        this.columnNo = pColumnNo;
        this.columnInfo = null;
    }

    public Relation(int pColumnNo, int pLevelNo) {
        this.columnNo = pColumnNo;
        this.levelNo = pLevelNo;
        this.columnInfo = null;
    }

    public Relation(DimensionColumnInfo dimensionColumInfo, ILevel aLevel) {
        this.columnInfo = dimensionColumInfo;
        this.level = aLevel;
    }

    public Relation(ColumnInfo stringColumInfo) {
        this.columnInfo = stringColumInfo;
    }

    public int getColumnNo() {
        return this.columnNo;
    }

    public void setColumnNo(int aColumnNo) {
        this.columnNo = aColumnNo;
    }

    public ColumnInfo getColumnInfo() {
        return this.columnInfo;
    }

    public ILevel getLevel(DimensionColumnInfo dci) {
        List<ILevel> levels = dci.getDimension().getDefaultHierarchy().getLevels();
        return levels.get(this.levelNo);
    }

    public ILevel getLevel() {
        return this.level;
    }

    public void capture(PlanningEnvironment env, Element inputNode) {
        this.columnNo = Integer.valueOf(inputNode.attribute(0).getValue());
    }

    public void dumpExtraInfo(XQETrace trace) {
        trace.beginElement(ELEMENT_RELATION);
        trace.attribute(ATTRIBUTE_COLUMNNO, this.getColumnNo());
        trace.endElement();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Relation(");
        buffer.append(this.columnNo);
        buffer.append(", ");
        buffer.append(this.levelNo);
        buffer.append(")");
        return buffer.toString();
    }

    protected void persistAttributeProperties(XQEPersistContext ctx) {
        ctx.property(ATTRIBUTE_COLUMNNO, this.columnNo);
        ctx.property(ATTRIBUTE_LEVELNO, this.levelNo);
        ctx.property(ATTRIBUTE_LEVEL, this.level);
    }

    protected void persistElementProperties(XQEPersistContext ctx) {
        if (this.columnInfo != null) {
            ctx.elementProperty(ELEMENT_COLUMNINFO, this.columnInfo);
        }
    }

    @Override
    public void persist(XQEPersistContext ctx, String optionalName) {
        if (ctx.beginElement(this, optionalName, -1)) {
            this.persistAttributeProperties(ctx);
            this.persistElementProperties(ctx);
            ctx.endElement();
        }
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
        this.restoreAttributes(ctx, node);
        this.restoreChildren(ctx, node);
    }

    public void restoreChildren(XQERestoreContext ctx, Element node) {
        List childList = node.elements();
        int nChildren = childList.size();
        for (int i = 0; i < nChildren; ++i) {
            Element child = (Element)childList.get(i);
            if (child.getNamespace().getURI().isEmpty()) continue;
            this.restoreElementProperty(ctx, child, node);
        }
    }

    public void restoreAttributes(XQERestoreContext ctx, Element node) {
        int size = node.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = node.attribute(i);
            this.restoreAttributeProperty(ctx, att, node);
        }
    }

    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element node) {
        String attName = att.getName();
        if (attName.equals(ATTRIBUTE_COLUMNNO)) {
            Object val = ctx.attributeValue(att);
            this.columnNo = (Integer)val;
        } else if (attName.equals(ATTRIBUTE_LEVELNO)) {
            Object val = ctx.attributeValue(att);
            this.levelNo = (Integer)val;
        } else if (attName.equals(ATTRIBUTE_LEVEL)) {
            Object val = ctx.attributeValue(att);
            this.level = (ILevel)val;
        }
    }

    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(ELEMENT_COLUMNINFO)) {
            Object val = ctx.elementValue(node);
            this.columnInfo = (ColumnInfo)val;
        }
    }
}

