/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets.tabular;

import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.ResultSetValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.resultset.interfaces.IColumnInfo;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.ColumnInfo;
import com.cognos.xqe.resultsets.tabular.OrderBy;
import com.cognos.xqe.resultsets.tabular.RowComparator;
import com.cognos.xqe.runtree.ScrollableIterator;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeSet;

public class Table
extends ResultSetValue
implements ITabularResultSet {
    static final long serialVersionUID = 1L;
    private final IRowsetInfo rowsetInfo;
    private final Collection<IRow> rows;
    private final boolean[] singleSelections;
    private final HashMap<IColumnInfo, Integer> columnInfoToIndex = new HashMap();
    private boolean uniqueRows;

    public Table(XDataContext xDataContext, IRowsetInfo theRowsetInfo, Integer theNodeId) {
        this(xDataContext, theRowsetInfo, null, theNodeId);
    }

    public Table(XDataContext xDataContext, IRowsetInfo theRowsetInfo, OrderBy[] sorts, Integer theNodeId) {
        super(xDataContext, theNodeId, xDataContext.getEnvironment().getMultiRequestContext().getResourceTracker());
        this.rowsetInfo = theRowsetInfo;
        this.singleSelections = new boolean[this.rowsetInfo.getNumColumns()];
        for (int i = 0; i < this.rowsetInfo.getNumColumns(); ++i) {
            this.columnInfoToIndex.put(this.rowsetInfo.getColumnInfo(i), XQEIntegerPool.getInteger(i));
        }
        this.rows = sorts != null ? new TreeSet<IValue>(new RowComparator(this.rowsetInfo, sorts)) : new ArrayList<IRow>();
    }

    public boolean isUniqueRows() {
        return this.uniqueRows;
    }

    public void addRow(IRow row) {
        this.rows.add(row);
    }

    public void addRow(Value[] row) {
        this.rows.add(DataValueFactory.createRowValue(row));
    }

    public void addRow(Object[] row) throws XQERuntimeException {
        Value dValue = null;
        IValue[] dRow = new Value[row.length];
        for (int i = 0; i < row.length; ++i) {
            if (row[i] instanceof String) {
                dValue = DataValueFactory.createStringValue();
            } else if (row[i] instanceof Double) {
                dValue = DataValueFactory.createDoubleValue();
            }
            if (dValue == null) continue;
            ((Value)dValue).set(row[i]);
            dRow[i] = dValue;
        }
        this.rows.add(DataValueFactory.createRowValue(dRow));
    }

    @Override
    public IRowsetInfo getTabularRowsetInfo() {
        return this.rowsetInfo;
    }

    @Override
    public long getRowCount() {
        return -1L;
    }

    public void setSingleSelection(ColumnInfo columnInfo, boolean sanityCheck) {
        if (!this.columnInfoToIndex.containsKey(columnInfo)) {
            throw new RuntimeException("ColumnInfo " + columnInfo + " not valid for table.");
        }
        Integer index = this.columnInfoToIndex.get(columnInfo);
        this.singleSelections[index.intValue()] = true;
    }

    public void setUniqueRows(boolean theUniqueRows) {
        this.uniqueRows = theUniqueRows;
    }

    @Override
    public ITabularIterator getTabularIterator() {
        return new SimpleTabularIterator(this.rowsetInfo, this.nodeId);
    }

    @Override
    public IScrollableIterator getScrollableTabularIterator() {
        return new ScrollableIterator(this.getDataContext(), this.getTabularIterator(), this.nodeId);
    }

    @Override
    public void releaseImpl() {
        this.rows.clear();
        this.columnInfoToIndex.clear();
    }

    @Override
    public boolean isVectorized() {
        return false;
    }

    private final class SimpleTabularIterator
    extends XTabularIterator {
        private long rowIndex;
        private Iterator<IRow> it;

        private SimpleTabularIterator(IRowsetInfo theRowsetInfo, Integer id) {
            super(null, id);
            this.it = Table.this.rows.iterator();
            this.rowIndex = 0L;
        }

        @Override
        public Object nextImpl() {
            IRow row;
            try {
                row = this.it.next();
            }
            catch (NoSuchElementException e) {
                row = null;
            }
            return row;
        }

        @Override
        public long getIndex() {
            return this.rowIndex;
        }

        @Override
        public XDataContext getDataContext() {
            return Table.this.getDataContext();
        }

        @Override
        public void release() {
        }
    }
}

