/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.resultsets.util;

import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IDimensionComparator;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.ILevelComparator;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.util.xml.XMLWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CubeResultSetWriter {
    private static final String ELEMENT_OLAPINFO = "OlapInfo";
    private static final String ELEMENT_CUBEINFO = "CubeInfo";
    private static final String ELEMENT_CUBE = "Cube";
    private static final String ELEMENT_CUBENAME = "CubeName";
    private static final String ELEMENT_AXESINFO = "AxesInfo";
    private static final String ELEMENT_AXISINFO = "AxisInfo";
    private static final String ELEMENT_HIERARCHYINFO = "HierarchyInfo";
    private static final String ELEMENT_CELLINFO = "CellInfo";
    private static final String ELEMENT_VALUE = "Value";
    private static final String ELEMENT_AXES = "Axes";
    private static final String ELEMENT_AXIS = "Axis";
    private static final String ATTRIBUTE_SLICERAXIS = "SlicerAxis";
    private static final String ELEMENT_TUPLES = "Tuples";
    private static final String ELEMENT_CELLDATA = "CellData";
    private static final String ELEMENT_UNAME = "UName";
    private static final String ELEMENT_CAPTION = "Caption";
    private static final String ELEMENT_LNAME = "LName";
    private static final String ELEMENT_LNUM = "LNum";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_UNIQUE_NAME = "uniqueName";
    private final ICubeResultSet mCubeResultSet;
    private final XMLWriter mXmlWriter;

    public CubeResultSetWriter(ICubeResultSet resultSet, XMLWriter writer) {
        this.mCubeResultSet = resultSet;
        this.mXmlWriter = writer;
    }

    public void toXML() {
        this.toXML(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toXML(boolean showOlapInfo) {
        StringBuilder header = new StringBuilder();
        if (this.mXmlWriter.isEmpty()) {
            header.append("<?xml-stylesheet type=\"text/xsl\" ");
            header.append("href=\"http://wottcub1:4444/stylesheets/CubeHybridResultSet.xsl\"?>\n");
            this.mXmlWriter.writeProcessingInstruction(header.toString());
        }
        this.mXmlWriter.beginElement("CubeHybridResultSet", -1);
        ITuple slicer = this.mCubeResultSet.getSlicer();
        if (showOlapInfo) {
            this.mXmlWriter.beginElement(ELEMENT_OLAPINFO, -1);
            IHierarchy[] hierarchies = this.getHierarchies(0);
            if (hierarchies != null) {
                this.mXmlWriter.beginElement(ELEMENT_CUBEINFO, -1);
                this.mXmlWriter.beginElement(ELEMENT_CUBE, -1);
                this.mXmlWriter.attribute(ATTRIBUTE_NAME, hierarchies[0].getDimension().getCube().getName());
                this.mXmlWriter.beginElement(ELEMENT_CUBENAME, -1);
                this.mXmlWriter.data(hierarchies[0].getDimension().getCube().getName());
                this.mXmlWriter.endElement();
                Map<IDimension, Map<IHierarchy, Set<ILevel>>> metadata = this.getMetadataInResult(true);
                IDimension[] dimensionArray = metadata.keySet().toArray(new IDimension[metadata.size()]);
                Arrays.sort(dimensionArray, new IDimensionComparator());
                for (int i = 0; i < dimensionArray.length; ++i) {
                    IDimension dim = dimensionArray[i];
                    this.mXmlWriter.beginElement("Dimension", -1);
                    this.mXmlWriter.attribute(ATTRIBUTE_NAME, dim.getName());
                    this.mXmlWriter.attribute(ATTRIBUTE_UNIQUE_NAME, dim.getUniqueName());
                    Map<IHierarchy, Set<ILevel>> hierarchyMap = metadata.get(dim);
                    IHierarchy[] hiers = hierarchyMap.keySet().toArray(new IHierarchy[hierarchyMap.size()]);
                    Arrays.sort(hiers, new Comparator<Object>(){

                        @Override
                        public int compare(Object arg0, Object arg1) {
                            IHierarchy left = (IHierarchy)arg0;
                            IHierarchy right = (IHierarchy)arg1;
                            return left.getUniqueName().compareTo(right.getUniqueName());
                        }
                    });
                    for (int k = 0; k < hiers.length; ++k) {
                        IHierarchy hier = hiers[k];
                        this.mXmlWriter.beginElement("Hierarchy", -1);
                        this.mXmlWriter.attribute(ATTRIBUTE_NAME, hier.getName());
                        this.mXmlWriter.attribute(ATTRIBUTE_UNIQUE_NAME, hier.getUniqueName());
                        Set<ILevel> levelSet = hierarchyMap.get(hier);
                        ILevel[] levels = levelSet.toArray(new ILevel[0]);
                        Arrays.sort(levels, new ILevelComparator());
                        for (int m = 0; m < levels.length; ++m) {
                            ILevel level = levels[m];
                            this.mXmlWriter.beginElement("Level", -1);
                            this.mXmlWriter.attribute(ATTRIBUTE_NAME, level.getName());
                            this.mXmlWriter.attribute(ATTRIBUTE_UNIQUE_NAME, level.getUniqueName());
                            this.mXmlWriter.endElement();
                        }
                        this.mXmlWriter.endElement();
                    }
                    this.mXmlWriter.endElement();
                }
                this.mXmlWriter.endElement();
                this.mXmlWriter.endElement();
            }
            this.mXmlWriter.beginElement(ELEMENT_AXESINFO, -1);
            for (int i = 0; i < this.mCubeResultSet.getNumAxes(); ++i) {
                hierarchies = this.getHierarchies(i);
                this.mXmlWriter.beginElement(ELEMENT_AXISINFO, -1);
                this.mXmlWriter.attribute(ATTRIBUTE_NAME, ELEMENT_AXIS + i);
                this.dumpHierarchyInfo(this.mXmlWriter, hierarchies);
                this.mXmlWriter.endElement();
            }
            if (slicer != null) {
                this.mXmlWriter.beginElement(ELEMENT_AXISINFO, -1);
                this.mXmlWriter.attribute(ATTRIBUTE_NAME, ATTRIBUTE_SLICERAXIS);
                this.dumpHierarchyInfo(this.mXmlWriter, slicer.getHierarchies());
                this.mXmlWriter.endElement();
            }
            this.mXmlWriter.endElement();
            this.mXmlWriter.beginElement(ELEMENT_CELLINFO, -1);
            this.mXmlWriter.beginElement(ELEMENT_VALUE, -1);
            this.mXmlWriter.attribute(ATTRIBUTE_NAME, "VALUE");
            this.mXmlWriter.endElement();
            this.mXmlWriter.endElement();
            this.mXmlWriter.endElement();
        }
        this.mXmlWriter.beginElement(ELEMENT_AXES, -1);
        for (int i = 0; i < this.mCubeResultSet.getNumAxes(); ++i) {
            XIterator edgeIterator = this.mCubeResultSet.getAxisIterator(i);
            try {
                this.mXmlWriter.beginElement(ELEMENT_AXIS, -1);
                this.mXmlWriter.attribute(ATTRIBUTE_NAME, ELEMENT_AXIS + i);
                this.mXmlWriter.beginElement(ELEMENT_TUPLES, -1);
                ITuple tuple = (ITuple)edgeIterator.next();
                while (tuple != null) {
                    tuple.toXML(this.mXmlWriter);
                    tuple = (ITuple)edgeIterator.next();
                }
            }
            finally {
                edgeIterator.release();
            }
            this.mXmlWriter.endElement();
            this.mXmlWriter.endElement();
        }
        if (slicer != null) {
            this.mXmlWriter.beginElement(ELEMENT_AXIS, -1);
            this.mXmlWriter.attribute(ATTRIBUTE_NAME, ATTRIBUTE_SLICERAXIS);
            this.mXmlWriter.beginElement(ELEMENT_TUPLES, -1);
            slicer.toXML(this.mXmlWriter);
            this.mXmlWriter.endElement();
            this.mXmlWriter.endElement();
        }
        this.mXmlWriter.endElement();
        this.mXmlWriter.beginElement(ELEMENT_CELLDATA, -1);
        XCellIterator cellIterator = this.mCubeResultSet.getCellIterator();
        try {
            while (cellIterator.hasNext()) {
                ICell value = cellIterator.next();
                if (value == null) continue;
                value.toXML(this.mXmlWriter);
            }
        }
        finally {
            cellIterator.release();
        }
        this.mXmlWriter.endElement();
        this.mXmlWriter.endElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IHierarchy[] getHierarchies(int axisNumber) {
        ITuple aTuple;
        if (axisNumber >= this.mCubeResultSet.getNumAxes()) {
            return null;
        }
        XIterator anIterator = this.mCubeResultSet.getAxisIterator(axisNumber);
        try {
            aTuple = (ITuple)anIterator.next();
        }
        finally {
            anIterator.release();
        }
        if (aTuple != null) {
            return aTuple.getHierarchies();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<IDimension, Map<IHierarchy, Set<ILevel>>> getMetadataInResult(boolean includeAncestorLevels) {
        HashMap<IDimension, Map<IHierarchy, Set<ILevel>>> dimsToHierarchies = new HashMap<IDimension, Map<IHierarchy, Set<ILevel>>>();
        int numAxes = this.mCubeResultSet.getNumAxes();
        for (int i = 0; i < numAxes; ++i) {
            XIterator anIterator = this.mCubeResultSet.getAxisIterator(i);
            try {
                ITuple aTuple = (ITuple)anIterator.next();
                while (aTuple != null) {
                    IMember[] members = aTuple.getMembers();
                    int memberCount = members.length;
                    for (int k = 0; k < memberCount; ++k) {
                        HashSet<ILevel> levels;
                        ILevel level = members[k].getLevel();
                        IHierarchy hierarchy = level.getHierarchy();
                        IDimension dimension = hierarchy.getDimension();
                        HashMap<IHierarchy, HashSet<ILevel>> hierarchiesToLevels = (HashMap<IHierarchy, HashSet<ILevel>>)dimsToHierarchies.get(dimension);
                        if (hierarchiesToLevels == null) {
                            hierarchiesToLevels = new HashMap<IHierarchy, HashSet<ILevel>>();
                            dimsToHierarchies.put(dimension, hierarchiesToLevels);
                        }
                        if ((levels = (HashSet<ILevel>)hierarchiesToLevels.get(hierarchy)) == null) {
                            levels = new HashSet<ILevel>();
                            hierarchiesToLevels.put(hierarchy, levels);
                        }
                        if (includeAncestorLevels) {
                            this.addAncestorsLevels(levels, level);
                            continue;
                        }
                        levels.add(level);
                    }
                    aTuple = (ITuple)anIterator.next();
                }
                continue;
            }
            finally {
                anIterator.release();
            }
        }
        ITuple slicer = this.mCubeResultSet.getSlicer();
        if (slicer != null) {
            IMember[] members = slicer.getMembers();
            int memberCount = members.length;
            for (int k = 0; k < memberCount; ++k) {
                HashSet<ILevel> levels;
                ILevel level = members[k].getLevel();
                IHierarchy hierarchy = level.getHierarchy();
                IDimension dimension = hierarchy.getDimension();
                HashMap<IHierarchy, HashSet<ILevel>> hierarchiesToLevels = (HashMap<IHierarchy, HashSet<ILevel>>)dimsToHierarchies.get(dimension);
                if (hierarchiesToLevels == null) {
                    hierarchiesToLevels = new HashMap<IHierarchy, HashSet<ILevel>>();
                    dimsToHierarchies.put(dimension, hierarchiesToLevels);
                }
                if ((levels = (HashSet<ILevel>)hierarchiesToLevels.get(hierarchy)) == null) {
                    levels = new HashSet<ILevel>();
                    hierarchiesToLevels.put(hierarchy, levels);
                }
                if (includeAncestorLevels) {
                    this.addAncestorsLevels(levels, level);
                    continue;
                }
                levels.add(level);
            }
        }
        return dimsToHierarchies;
    }

    private void addAncestorsLevels(Set<ILevel> set, ILevel level) {
        for (ILevel current = level; current != null; current = current.getPreviousLevel()) {
            set.add(current);
        }
    }

    private void dumpHierarchyInfo(XMLWriter xmlWriter, IHierarchy[] hierarchies) {
        if (hierarchies == null) {
            return;
        }
        for (int j = 0; j < hierarchies.length; ++j) {
            String hName = hierarchies[j].getUniqueName();
            xmlWriter.beginElement(ELEMENT_HIERARCHYINFO, -1);
            xmlWriter.attribute(ATTRIBUTE_NAME, hName);
            xmlWriter.beginElement(ELEMENT_UNAME, -1);
            xmlWriter.attribute(ATTRIBUTE_NAME, this.generateUniqueName(hName, "MEMBER_UNIQUE_NAME"));
            xmlWriter.endElement();
            xmlWriter.beginElement(ELEMENT_CAPTION, -1);
            xmlWriter.attribute(ATTRIBUTE_NAME, this.generateUniqueName(hName, "MEMBER_CAPTION"));
            xmlWriter.endElement();
            xmlWriter.beginElement(ELEMENT_LNAME, -1);
            xmlWriter.attribute(ATTRIBUTE_NAME, this.generateUniqueName(hName, "LEVEL_UNIQUE_NAME"));
            xmlWriter.endElement();
            xmlWriter.beginElement(ELEMENT_LNUM, -1);
            xmlWriter.attribute(ATTRIBUTE_NAME, this.generateUniqueName(hName, "LEVEL_NUMBER"));
            xmlWriter.endElement();
            xmlWriter.endElement();
        }
    }

    private String generateUniqueName(String part1, String part2) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(part1);
        buffer.append(".[");
        buffer.append(part2);
        buffer.append("]");
        return buffer.toString();
    }
}

