/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.rsapi;

import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeIterator;
import com.cognos.xqe.rsapi.RSAPIEdgeIteratorFactory;
import com.cognos.xqe.rsapi.RSAPIFwdEdgeIterator;
import com.cognos.xqe.rsapi.RSAPIResultSet;
import com.cognos.xqe.rsapi.RSAPIRow;

public class RSAPIBwdEdgeIterator
extends RSAPIEdgeIterator {
    private int mNumDetailRows;
    private RSAPIFwdEdgeIterator mIterator;
    private int mStartingDetailRowNumber;
    private int mNumDetailRowsToRead;

    public RSAPIBwdEdgeIterator(RSAPIEdge edge, RSAPIResultSet resultSet, int startRowNumber, int numRows, boolean includeContext, boolean allRows) {
        super(edge, resultSet, startRowNumber, numRows, includeContext, allRows);
        try {
            this.computeNumberOfDetailRows(edge, resultSet);
            this.computeStartRowNumRowsRelativeToStartOfData(startRowNumber, numRows);
            this.mIterator = (RSAPIFwdEdgeIterator)RSAPIEdgeIteratorFactory.getEdgeIterator(edge, resultSet, this.mStartingDetailRowNumber, this.mNumDetailRowsToRead, includeContext, allRows);
        }
        catch (RuntimeException e) {
            this.release();
            throw e;
        }
    }

    private void computeNumberOfDetailRows(RSAPIEdge edge, RSAPIResultSet resultSet) {
        this.mNumDetailRows = this.getNumDetailRowsFromResultSet(edge, resultSet);
        if (this.mNumDetailRows == -1) {
            this.retrieveAllRows(edge, resultSet);
            this.mNumDetailRows = this.getNumDetailRowsFromResultSet(edge, resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveAllRows(RSAPIEdge edge, RSAPIResultSet resultSet) {
        RSAPIFwdEdgeIterator it = new RSAPIFwdEdgeIterator(edge, resultSet, 1, 0, false, this.isOptimizedForAllRows());
        try {
            RSAPIRow row = it.next();
            while (row != null) {
                row = it.next();
            }
        }
        finally {
            it.release();
        }
    }

    @Override
    public boolean hasNext() {
        return this.mIterator.hasNext();
    }

    @Override
    public RSAPIRow next() {
        RSAPIRow row = this.mIterator.next();
        if (row != null && row.isDetailRow()) {
            this.adjustDetailRowNumberToRelativeToEOD(row);
        }
        return row;
    }

    @Override
    public void reset() {
        this.mIterator.reset();
    }

    private void computeStartRowNumRowsRelativeToStartOfData(int startRowNumber, int numRows) {
        if (startRowNumber == -1 && numRows == 0) {
            this.mStartingDetailRowNumber = 1;
            this.mNumDetailRowsToRead = 0;
            return;
        }
        if (-startRowNumber > this.mNumDetailRows) {
            this.mStartingDetailRowNumber = -startRowNumber;
            this.mNumDetailRowsToRead = 0;
            return;
        }
        if (numRows == 0) {
            this.mStartingDetailRowNumber = 1;
            this.mNumDetailRowsToRead = this.mNumDetailRows - numRows + 1;
        } else {
            this.mStartingDetailRowNumber = this.mNumDetailRows + startRowNumber - numRows + 2;
            this.mNumDetailRowsToRead = numRows;
            if (this.mStartingDetailRowNumber <= 0) {
                this.mStartingDetailRowNumber = 1;
                this.mNumDetailRowsToRead = this.mNumDetailRows + startRowNumber + 1;
            }
        }
    }

    private void adjustDetailRowNumberToRelativeToEOD(RSAPIRow row) {
        row.setCellCoordinate(row.getDetailRowNumber() - 1);
        row.setDetailRowNumber(row.getDetailRowNumber() - this.mNumDetailRows - 1);
    }

    private int getNumDetailRowsFromResultSet(RSAPIEdge edge, RSAPIResultSet resultSet) {
        return resultSet.getNumDetailRows(edge.getOrdinal());
    }

    @Override
    public void close() {
        this.mIterator.close();
    }

    @Override
    protected int getStartingRowNumberRelativeToSOD() {
        return this.mStartingDetailRowNumber;
    }

    @Override
    protected int getNumberOfRowsRelativeToSOD() {
        return this.mNumDetailRowsToRead;
    }

    @Override
    protected boolean open(int startDetailRow, int numRows) {
        return false;
    }

    @Override
    public void release() {
        if (this.mIterator != null) {
            this.mIterator.release();
            this.mIterator = null;
        }
    }
}

