/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.rsapi;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.BusinessKeyType;
import com.cognos.xqe.data.types.CurrencyCodeType;
import com.cognos.xqe.data.types.DimensionUniqueNameType;
import com.cognos.xqe.data.types.HierarchyUniqueNameType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.LevelLabelType;
import com.cognos.xqe.data.types.LevelNumberType;
import com.cognos.xqe.data.types.LevelUniqueNameType;
import com.cognos.xqe.data.types.MemberCaptionType;
import com.cognos.xqe.data.types.MemberDescriptionType;
import com.cognos.xqe.data.types.MemberRollupType;
import com.cognos.xqe.data.types.MemberType;
import com.cognos.xqe.data.types.MemberUniqueNameType;
import com.cognos.xqe.data.types.ParentLevelNumberType;
import com.cognos.xqe.data.types.ParentUniqueNameType;
import com.cognos.xqe.data.types.QueryItemModelIDType;
import com.cognos.xqe.data.types.StringType;
import com.cognos.xqe.data.types.VariantType;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIRowset;
import com.cognos.xqe.rsapi.RSAPIUsage;
import com.cognos.xqe.transformation.rsapi.RSAPIUtilities;
import com.cognos.xqe.util.xml.XMLWriter;
import com.cognos.xqe.xqejapi.IRSAPIColumn;
import java.util.List;
import java.util.Set;

public class RSAPIColumn
implements IRSAPIColumn {
    private static final String CONST_STRING_DATATYPE = "datatype";
    private static final String CONST_STRING_CCL_DATATYPE = "cclDatatype";
    private RSAPIDataItem mRefDataItem;
    private IDataType mDataType = null;
    private boolean mIsCanonicalProperty;
    private boolean mColumnRepresentsDataItemValue;
    private String mPropertyName;
    private ValueTypeEnum mValueType;
    RSAPIRowset ownerRowset = null;
    private static final String STRING_SLASH_UNDERSCORE = "/_";
    private static final String STRING_UNDERSCORE = "_";
    public static final int RSAPICOLUMN_XQE_DATATYPES = 0;
    public static final int RSAPICOLUMN_CCL_DATATYPES = 1;
    public static final int RSAPICOLUMN_XQE_AND_CCL_DATATYPES = 2;

    public RSAPIRowset getOwnerRowset() {
        return this.ownerRowset;
    }

    public RSAPIColumn(RSAPIRowset aRowset) {
        this.ownerRowset = aRowset;
    }

    @Override
    public IDataType getDatatype() {
        if (this.getIsCanonicalProperty()) {
            return this.mDataType;
        }
        if (this.getIsCustomMemberProperty() && this.getBaseRefDataItem().getPropertyDataType() != null) {
            return this.getBaseRefDataItem().getPropertyDataType();
        }
        return this.mDataType;
    }

    public boolean getIsCustomMemberProperty() {
        return this.getValueType() == ValueTypeEnum.CUSTOM_PROPERTY;
    }

    public ValueTypeEnum getValueType() {
        return this.mValueType;
    }

    protected IDataType getUnadjustedDataType() {
        return this.mDataType;
    }

    @Override
    public RSAPIUsage getUsage() {
        return this.mRefDataItem.getUsage();
    }

    @Override
    public String getName() {
        StringBuilder nameBuilder = new StringBuilder();
        if (this.getOwnerRowset() instanceof RSAPIEdgeRowset && ((RSAPIEdgeRowset)this.getOwnerRowset()).isCrosstabSpace() != null && ((RSAPIEdgeRowset)this.getOwnerRowset()).isCrosstabSpace() != RSAPIEdgeRowset.CrosstabSpaceType.NOT) {
            nameBuilder.append(this.getOwnerRowset().getName());
            nameBuilder.append(STRING_UNDERSCORE);
        }
        nameBuilder.append(this.mRefDataItem.getName());
        if (this.getDatatype() == MemberType.MEMBERTYPE) {
            return nameBuilder.toString();
        }
        if (this.getIsCustomMemberProperty()) {
            boolean columnIsDataItemValue = this.getColumnRepresentsDataItemValue();
            if (columnIsDataItemValue) {
                return nameBuilder.toString();
            }
            nameBuilder.append(STRING_SLASH_UNDERSCORE);
            nameBuilder.append(this.getUnadjustedDataType().getTypeName());
            return nameBuilder.toString();
        }
        if (this.getUsage() == RSAPIUsage.FACT && !this.getIsCanonicalProperty()) {
            return nameBuilder.toString();
        }
        if (this.getIsCanonicalProperty()) {
            nameBuilder.append(STRING_SLASH_UNDERSCORE);
            nameBuilder.append(this.getUnadjustedDataType().getTypeName());
            return nameBuilder.toString();
        }
        return nameBuilder.toString();
    }

    @Override
    public boolean getNullsOK() {
        if (!this.getIsCanonicalProperty()) {
            return this.mRefDataItem.getNullable();
        }
        if (this.mValueType == ValueTypeEnum.RETURN_NULL_STRING) {
            return true;
        }
        return this.getDatatype() == MemberUniqueNameType.DEFAULTMEMBERUNIQUENAMETYPE || this.getDatatype() == ParentUniqueNameType.DEFAULTPARENTUNIQUENAMETYPE || this.getDatatype() == LevelUniqueNameType.DEFAULTLEVELUNIQUENAMETYPE || this.getDatatype() == LevelLabelType.DEFAULTLEVELLABELTYPE || this.getDatatype() == CurrencyCodeType.DEFAULTCURRENCYCODETYPE || this.getDatatype() == MemberDescriptionType.DEFAULTMEMBERDESCRIPTIONTYPE || this.getDatatype() == QueryItemModelIDType.DEFAULTQUERYITEMMODELIDTYPE || this.getIsCustomMemberProperty();
    }

    @Override
    public int getLength() {
        if (this.getIsCanonicalProperty()) {
            return this.mDataType.sizeOf();
        }
        return this.getDatatype().getCCLLength();
    }

    @Override
    public int getPrecision() {
        if (this.getDatatype() == null) {
            return 0;
        }
        IDataType dType = this.getPropertyDataType() == null ? this.getDatatype() : this.getPropertyDataType();
        if (dType != null && dType.hasPrecision()) {
            return dType.getPrecision();
        }
        return 0;
    }

    @Override
    public int getScale() {
        if (this.mDataType == null) {
            return 0;
        }
        IDataType dType = this.getPropertyDataType() == null ? this.getDatatype() : this.getPropertyDataType();
        if (dType != null && dType.hasScale()) {
            return dType.getScale();
        }
        return 0;
    }

    @Override
    public String getCurrencyCode() {
        if (this.getIsCanonicalProperty()) {
            return null;
        }
        return this.mRefDataItem.getCurrencyCode();
    }

    @Override
    public String getLabel() {
        return this.mRefDataItem.getLabel();
    }

    @Override
    public String getFormat() {
        if (this.getIsCanonicalProperty()) {
            return null;
        }
        return this.mRefDataItem.getFormat();
    }

    @Override
    public FormatId getFormatID() {
        if (this.getIsCanonicalProperty()) {
            return null;
        }
        return this.mRefDataItem.getFormatId();
    }

    @Override
    public String getFormatIDString() {
        if (this.getIsCanonicalProperty() || this.mValueType == ValueTypeEnum.RETURN_NULL_STRING) {
            return null;
        }
        return FormatService.getInstance().getFormatStringId(this.mRefDataItem.getFormatId());
    }

    public void setPropertyDataTypeAndName(IDataType propertyDataType, String pName) {
        this.mDataType = propertyDataType;
        this.mPropertyName = pName;
        this.mValueType = ValueTypeEnum.CUSTOM_PROPERTY;
    }

    protected void setRefDataItem(RSAPIDataItem refDataItem, IDataType propertyDataType, boolean isDataItemValue) {
        this.mRefDataItem = refDataItem;
        if (propertyDataType == null) {
            this.mDataType = this.mRefDataItem.getDataType();
            if (this.mDataType == null) {
                this.mDataType = VariantType.VARIANT;
            }
        } else {
            this.mDataType = propertyDataType;
            this.mPropertyName = refDataItem.getPropertyName();
        }
        this.mColumnRepresentsDataItemValue = isDataItemValue;
        this.mIsCanonicalProperty = false;
        if (this.mDataType == MemberType.MEMBERTYPE) {
            this.mValueType = ValueTypeEnum.MEMBER;
        } else if (RSAPIColumn.dataTypeIsCanonicalProperty(this.mDataType)) {
            this.mValueType = ValueTypeEnum.INTRINSIC_PROPERTY;
        } else if (this.mColumnRepresentsDataItemValue && refDataItem.isCustomProperty()) {
            if (propertyDataType == null) {
                this.mValueType = ValueTypeEnum.RETURN_NULL_STRING;
                this.mDataType = StringType.DEFAULTSTRINGTYPE;
            } else {
                this.mValueType = ValueTypeEnum.CUSTOM_PROPERTY;
            }
        } else if (!this.mColumnRepresentsDataItemValue) {
            this.mValueType = ValueTypeEnum.RETURN_NULL_STRING;
            this.mDataType = StringType.DEFAULTSTRINGTYPE;
        } else {
            this.mValueType = ValueTypeEnum.SIMPLE_VALUE;
        }
        this.mIsCanonicalProperty = !this.mColumnRepresentsDataItemValue;
    }

    protected static boolean dataTypeIsCanonicalProperty(IDataType dataType) {
        return RSAPIUtilities.isCanonicalProperty(dataType);
    }

    protected static boolean dataTypeIsCanonicalProperty(String propertyName) {
        return propertyName.equals("memberUniqueName") || propertyName.equals("parentUniqueName") || propertyName.equals("levelUniqueName") || propertyName.equals("levelNumber") || propertyName.equals("parentLevelNumber") || propertyName.equals("levelLabel") || propertyName.equals("currencyCode") || propertyName.equals("memberDescription") || propertyName.equals("dimensionUniqueName") || propertyName.equals("hierarchyUniqueName") || propertyName.equals("rollupType") || propertyName.equals("memberCaption") || propertyName.equals("businessKey") || propertyName.equals("queryItemModelID");
    }

    protected static IDataType getDataTypeOfCanonicalProperty(String propertyName) {
        if (propertyName.equals("memberUniqueName")) {
            return MemberUniqueNameType.DEFAULTMEMBERUNIQUENAMETYPE;
        }
        if (propertyName.equals("parentUniqueName")) {
            return ParentUniqueNameType.DEFAULTPARENTUNIQUENAMETYPE;
        }
        if (propertyName.equals("levelUniqueName")) {
            return LevelUniqueNameType.DEFAULTLEVELUNIQUENAMETYPE;
        }
        if (propertyName.equals("levelNumber")) {
            return LevelNumberType.LEVELNUMBERTYPE;
        }
        if (propertyName.equals("parentLevelNumber")) {
            return ParentLevelNumberType.PARENTLEVELNUMBERTYPE;
        }
        if (propertyName.equals("levelLabel")) {
            return LevelLabelType.DEFAULTLEVELLABELTYPE;
        }
        if (propertyName.equals("currencyCode")) {
            return CurrencyCodeType.DEFAULTCURRENCYCODETYPE;
        }
        if (propertyName.equals("memberDescription")) {
            return MemberDescriptionType.DEFAULTMEMBERDESCRIPTIONTYPE;
        }
        if (propertyName.equals("dimensionUniqueName")) {
            return DimensionUniqueNameType.DEFAULTDIMENSIONUNIQUENAMETYPE;
        }
        if (propertyName.equals("hierarchyUniqueName")) {
            return HierarchyUniqueNameType.DEFAULTHIERARCHYUNIQUENAMETYPE;
        }
        if (propertyName.equals("hierarchyUniqueName")) {
            return MemberRollupType.DEFAULTMEMBERROLLUPTYPE;
        }
        if (propertyName.equals("rollupType")) {
            return MemberRollupType.DEFAULTMEMBERROLLUPTYPE;
        }
        if (propertyName.equals("memberCaption")) {
            return MemberCaptionType.DEFAULTMEMBERCAPTIONTYPE;
        }
        if (propertyName.equals("businessKey")) {
            return BusinessKeyType.DEFAULTBUSINESSKEYTYPE;
        }
        if (propertyName.equals("queryItemModelID")) {
            return QueryItemModelIDType.DEFAULTQUERYITEMMODELIDTYPE;
        }
        return null;
    }

    public boolean getColumnRepresentsDataItemValue() {
        return this.mColumnRepresentsDataItemValue;
    }

    public void toXMLString(XMLWriter writer, boolean completeDump, boolean internal, int datatypesToDisplay) {
        if (internal) {
            writer.beginElement("column", -1);
        } else {
            writer.beginElement("columnInfo", -1);
        }
        writer.attribute("name", this.getName());
        if (!completeDump) {
            writer.endElement();
            return;
        }
        if (internal) {
            writer.attribute("refDataItem", this.getBaseRefDataItem().getName());
        }
        if (this.getDatatype() != null) {
            if (datatypesToDisplay == 0 || datatypesToDisplay == 2) {
                writer.attribute(CONST_STRING_DATATYPE, this.getDatatype().getTypeName());
            }
            if (datatypesToDisplay == 1) {
                writer.attribute(CONST_STRING_DATATYPE, DataTypeCode.getCCLTypeName(this.getDatatype().getCCLTypeCode()));
            }
            if (datatypesToDisplay == 2) {
                writer.attribute(CONST_STRING_CCL_DATATYPE, DataTypeCode.getCCLTypeName(this.getDatatype().getCCLTypeCode()));
            }
        }
        writer.attribute("nullsOK", this.getNullsOK());
        writer.attribute("length", this.getLength());
        writer.attribute("precision", this.getPrecision());
        writer.attribute("scale", this.getScale());
        writer.attribute("label", this.getLabel());
        writer.attribute("currencyCode", this.getCurrencyCode());
        writer.attribute("format", this.getFormat());
        writer.attribute("subtype", this.getUsage().toString());
        writer.attribute("formatIDStr", this.getFormatIDString());
        writer.attribute("isPropertyColumn", this.getIsCanonicalProperty());
        if (this.getSqlColumnName() != null) {
            writer.attribute("sqlColumnName", this.getSqlColumnName());
        }
        if (this.getSqlColumnIndex() >= 0) {
            writer.attribute("sqlColumnIndex", this.getSqlColumnIndex());
        }
        writer.endElement();
    }

    public void toXMLString(XMLWriter writer, boolean completeDump, boolean internal) {
        this.toXMLString(writer, completeDump, internal, 0);
    }

    private IDataType getPropertyDataType() {
        if (this.getIsCanonicalProperty()) {
            return this.getDatatype();
        }
        return this.mRefDataItem.getPropertyDataType();
    }

    public void toXMLString(XMLWriter writer) {
        this.toXMLString(writer, true, false, 0);
    }

    public IMetadata getMetadataReference() {
        return this.mRefDataItem.getModelReference();
    }

    public String getQueryItemModelId() {
        return this.mRefDataItem.getQueryItemModelId();
    }

    public RSAPIDataItem getBaseRefDataItem() {
        return this.mRefDataItem;
    }

    @Override
    public boolean getIsCanonicalProperty() {
        return this.mIsCanonicalProperty;
    }

    public boolean getIsIntrinsicProperty() {
        return this.mValueType == ValueTypeEnum.INTRINSIC_PROPERTY;
    }

    public String getPropertyNameOfRole(IMember member, String roleName) {
        if (member == null || this.mPropertyName != null) {
            return this.mPropertyName;
        }
        IMember mbr = null;
        mbr = member.isContextMember() ? ((ContextMember)member).getMember() : member;
        if (mbr == null) {
            return null;
        }
        Set<String> keys = mbr.getAvailableProperties();
        for (String key : keys) {
            if (!key.contains(roleName)) continue;
            this.mPropertyName = key;
            break;
        }
        return this.mPropertyName;
    }

    public String getPropertyName() {
        return this.mPropertyName;
    }

    public String getResolvedAggregateType() {
        if (this.mRefDataItem != null) {
            return this.mRefDataItem.getResolvedAggregateType();
        }
        return null;
    }

    public boolean isMemberProperty() {
        return this.mRefDataItem.isMemberProperty();
    }

    public int getSqlColumnIndex() {
        return this.mRefDataItem.getSqlColumnIndex();
    }

    public String getSqlColumnName() {
        return this.mRefDataItem.getSqlColumnName();
    }

    @Override
    public List<String> getDependency() {
        return this.mRefDataItem.getDependency();
    }

    static enum ValueTypeEnum {
        SIMPLE_VALUE,
        INTRINSIC_PROPERTY,
        CUSTOM_PROPERTY,
        MEMBER,
        RETURN_NULL_STRING;

    }
}

