/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.rsapi;

import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.rsapi.RSAPIEdgeIterator;
import com.cognos.xqe.rsapi.RSAPIResultSet;

public class RSAPIEdgeCoordinates {
    private int mNumCoordinates;
    private int mNextEdgeCoordinate;
    private int mStartingCoordinate;
    private int mNumCoordinatesToRead;
    private RSAPIEdgeIterator mEdgeIterator;
    private boolean mEOD;
    private RSAPIEdgeCoordinates mPriorEdgeInfo;
    private IHybridResultSet mHybridResultSet;

    public RSAPIEdgeCoordinates(RSAPIResultSet resultSet, RSAPIEdgeIterator edgeIterator, boolean isOuterMostEdge, int startingCoordinate, int numCoordinatesToRead, int numCoordinates, RSAPIEdgeCoordinates priorEdgeInfo) {
        this.setHybridResultSet(resultSet);
        this.setEdgeIterator(edgeIterator);
        this.setPriorEdgeInfo(priorEdgeInfo);
        this.setNumCoordinatesToRead(numCoordinatesToRead);
        this.setNumCoordinates(numCoordinates);
        this.setStartingCoordinate(startingCoordinate);
        this.recomputeEdgeCoordinates();
        this.reset();
    }

    public boolean isEOD() {
        return this.mEOD;
    }

    public void reset() {
        this.setCoordinateOfNextCell(this.getStartingCoordinate());
        this.setEOD(false);
    }

    protected void toNextCoordinate() {
        boolean eod = false;
        this.incrementNextEdgeCoordinate();
        if (this.getNumCoordinatesToRead() != -1 && this.getCoordinateOfNextCell() >= this.getStartingCoordinate() + this.getNumCoordinatesToRead()) {
            this.setEOD(true);
        }
        if (!eod && this.getCoordinateOfNextCell() >= this.getNumCoordinates()) {
            this.setEOD(true);
        }
    }

    public int computeOrdinal() {
        int index = 1;
        for (RSAPIEdgeCoordinates priorEdgeInfo = this.getPriorEdgeInfo(); priorEdgeInfo != null; priorEdgeInfo = priorEdgeInfo.getPriorEdgeInfo()) {
            index *= priorEdgeInfo.getNumCoordinates();
        }
        index *= this.getCoordinateOfNextCell();
        if (this.getPriorEdgeInfo() != null) {
            index += this.getPriorEdgeInfo().computeOrdinal();
        }
        if (index == 0) {
            index = this.getCoordinateOfNextCell();
        }
        return index;
    }

    private int getNumCoordinates() {
        if (this.mNumCoordinates < 0) {
            this.setNumCoordinates(this.getNumCoordinatesFromHybridResultSet());
        }
        return this.mNumCoordinates;
    }

    public void setNumCoordinates(int numCoordinates) {
        this.mNumCoordinates = numCoordinates;
    }

    protected int getCoordinateOfNextCell() {
        return this.mNextEdgeCoordinate;
    }

    private void setCoordinateOfNextCell(int coordinateOfNextCell) {
        this.mNextEdgeCoordinate = coordinateOfNextCell;
    }

    private int getStartingCoordinate() {
        return this.mStartingCoordinate;
    }

    private void setStartingCoordinate(int startingCoordinate) {
        this.mStartingCoordinate = startingCoordinate;
    }

    private int getNumCoordinatesToRead() {
        return this.mNumCoordinatesToRead;
    }

    private void setNumCoordinatesToRead(int numCoordinatesToRead) {
        if (numCoordinatesToRead == 0) {
            numCoordinatesToRead = -1;
        }
        this.mNumCoordinatesToRead = numCoordinatesToRead;
    }

    private void setEdgeIterator(RSAPIEdgeIterator edgeIterator) {
        this.mEdgeIterator = edgeIterator;
    }

    private RSAPIEdgeIterator getEdgeIterator() {
        return this.mEdgeIterator;
    }

    private void setEOD(boolean meod) {
        this.mEOD = meod;
    }

    private void recomputeEdgeCoordinates() {
        if (this.getEdgeIterator() != null) {
            this.setStartingCoordinate(this.getEdgeIterator().getStartingRowNumberRelativeToSOD());
            this.setNumCoordinatesToRead(this.getEdgeIterator().getNumberOfRowsRelativeToSOD());
        }
        if (this.getStartingCoordinate() > 0) {
            this.setStartingCoordinate(this.getStartingCoordinate() - 1);
        }
        if (this.getNumCoordinates() > 0 && this.getStartingCoordinate() > this.getNumCoordinates()) {
            this.setEOD(true);
        }
    }

    private RSAPIEdgeCoordinates getPriorEdgeInfo() {
        return this.mPriorEdgeInfo;
    }

    private void setPriorEdgeInfo(RSAPIEdgeCoordinates priorEdgeInfo) {
        this.mPriorEdgeInfo = priorEdgeInfo;
    }

    private void incrementNextEdgeCoordinate() {
        ++this.mNextEdgeCoordinate;
    }

    private IHybridResultSet getHybridResultSet() {
        return this.mHybridResultSet;
    }

    private void setHybridResultSet(RSAPIResultSet resultSet) {
        if (resultSet != null) {
            this.mHybridResultSet = resultSet.getResultSet();
        }
    }

    private int getNumCoordinatesFromHybridResultSet() {
        if (this.getHybridResultSet() == null) {
            return this.mNumCoordinates;
        }
        int size = (int)this.getHybridResultSet().getV5EdgeSize(this.getEdgeIterator().getEdge());
        if (size < 0) {
            size = 0;
        }
        return size;
    }

    protected boolean isStartCoordinateAtEnd() {
        return this.getStartingCoordinate() >= this.getNumCoordinates();
    }
}

