/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.rsapi;

import com.cognos.xqe.exception.RequestCanceledException;
import com.cognos.xqe.rsapi.RSAPIContextInformation;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RSAPIEdgeInformation {
    protected static final int NUM_DETAIL_ROWS_UNKNOWN = -1;
    private int mNumDetailRows = -1;
    protected static final int TABULAR_ROW_NUMBER_UNKNOWN = -1;
    private ReadWriteLock mLock = new ReentrantReadWriteLock();
    private TreeMap<Integer, RSAPIContextInformation>[] mRowsetContextInformation;
    private Map<Integer, Integer> mDetailRowNumberToTabularRowNumber = new HashMap<Integer, Integer>();
    private boolean mAllRowsRead = false;

    public RSAPIEdgeInformation(int numRowsets) {
        this.mRowsetContextInformation = new TreeMap[numRowsets];
        for (int i = 0; i < numRowsets; ++i) {
            this.mRowsetContextInformation[i] = new TreeMap();
        }
    }

    protected int getNumDetailRows() {
        int numDetailRows = -1;
        try {
            this.mLock.readLock().lockInterruptibly();
            try {
                numDetailRows = this.mNumDetailRows;
            }
            finally {
                this.mLock.readLock().unlock();
            }
        }
        catch (InterruptedException ie) {
            throw new RequestCanceledException();
        }
        return numDetailRows;
    }

    protected void setNumDetailRows(int numDetailRows, boolean allRowsRead) {
        try {
            this.mLock.writeLock().lockInterruptibly();
            try {
                if (!this.mAllRowsRead) {
                    if (this.mNumDetailRows < numDetailRows) {
                        this.mNumDetailRows = numDetailRows;
                    }
                    if (allRowsRead) {
                        this.mAllRowsRead = true;
                    }
                }
            }
            finally {
                this.mLock.writeLock().unlock();
            }
        }
        catch (InterruptedException ie) {
            throw new RequestCanceledException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RSAPIContextInformation getContextInformation(int rowsetId, int detailRowNumber, RSAPIContextInformation contextInfo) {
        RSAPIContextInformation context = null;
        try {
            this.mLock.readLock().lockInterruptibly();
            try {
                context = this.getContextInfo(rowsetId, detailRowNumber);
                if (context != null) {
                    contextInfo.copyFrom(context);
                    context = contextInfo;
                }
            }
            finally {
                this.mLock.readLock().unlock();
            }
        }
        catch (InterruptedException ie) {
            throw new RequestCanceledException();
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContextInformation(int rowsetId, RSAPIContextInformation contextInfo) {
        try {
            this.mLock.writeLock().lockInterruptibly();
            try {
                RSAPIContextInformation context = this.getContextInfo(rowsetId, contextInfo.getStartingDetailRowNumber());
                if (context == null || contextInfo.getStartingDetailRowNumber() > context.getStartingDetailRowNumber()) {
                    this.addContextInformation(rowsetId, contextInfo);
                } else {
                    context.copyFrom(contextInfo);
                }
            }
            finally {
                this.mLock.writeLock().unlock();
            }
        }
        catch (InterruptedException ie) {
            throw new RequestCanceledException();
        }
    }

    private RSAPIContextInformation getContextInfo(int rowsetId, int detailRowNumber) {
        SortedMap<Integer, RSAPIContextInformation> previousRowsetContextInfo;
        RSAPIContextInformation contextInfo = this.mRowsetContextInformation[rowsetId].get(detailRowNumber);
        if (contextInfo == null && !(previousRowsetContextInfo = this.mRowsetContextInformation[rowsetId].headMap(detailRowNumber)).isEmpty()) {
            Integer previousRowNumber = previousRowsetContextInfo.lastKey();
            contextInfo = (RSAPIContextInformation)previousRowsetContextInfo.get(previousRowNumber);
        }
        return contextInfo;
    }

    private void addContextInformation(int rowsetId, RSAPIContextInformation contextInfo) {
        this.mRowsetContextInformation[rowsetId].put(contextInfo.getStartingDetailRowNumberAsInteger(), contextInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getTabularRowNumber(int detailRowNumber) {
        Integer detailRow = XQEIntegerPool.getInteger(detailRowNumber);
        int tabularRowNumber = -1;
        try {
            this.mLock.readLock().lockInterruptibly();
            try {
                Integer tabularRow = this.mDetailRowNumberToTabularRowNumber.get(detailRow);
                if (tabularRow != null) {
                    tabularRowNumber = tabularRow;
                }
            }
            finally {
                this.mLock.readLock().unlock();
            }
        }
        catch (InterruptedException ie) {
            throw new RequestCanceledException();
        }
        return tabularRowNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTabularRowNumbers(Map<Integer, Integer> detailRowToTabularRowMap) {
        try {
            this.mLock.writeLock().lockInterruptibly();
            try {
                for (Map.Entry<Integer, Integer> entry : detailRowToTabularRowMap.entrySet()) {
                    Integer detailRow = entry.getKey();
                    if (this.mDetailRowNumberToTabularRowNumber.get(detailRow) != null) continue;
                    Integer tabularRow = entry.getValue();
                    this.mDetailRowNumberToTabularRowNumber.put(detailRow, tabularRow);
                }
            }
            finally {
                this.mLock.writeLock().unlock();
            }
        }
        catch (InterruptedException ie) {
            throw new RequestCanceledException();
        }
    }

    protected boolean allRowsRead() {
        boolean result = false;
        try {
            this.mLock.readLock().lockInterruptibly();
            try {
                result = this.mAllRowsRead;
            }
            finally {
                this.mLock.readLock().unlock();
            }
        }
        catch (InterruptedException ie) {
            throw new RequestCanceledException();
        }
        return result;
    }
}

