/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.rsapi;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.RequestCanceledException;
import com.cognos.xqe.rsapi.RSAPIEdgeIterator;
import com.cognos.xqe.rsapi.RSAPIFwdEdgeIterator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.IReleasable;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RSAPIEdgeIteratorCache
implements IReleasable {
    Map<Integer, RSAPIFwdEdgeIterator> mIteratorMap;
    private ReadWriteLock mLock = new ReentrantReadWriteLock();
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    protected RSAPIEdgeIteratorCache() {
        this.mIteratorMap = new HashMap<Integer, RSAPIFwdEdgeIterator>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putIterator(int edgeOrdinal, RSAPIFwdEdgeIterator iterator) {
        Integer ordinal = XQEIntegerPool.getInteger(edgeOrdinal);
        try {
            this.mLock.writeLock().lockInterruptibly();
            try {
                RSAPIFwdEdgeIterator cachedIterator = this.mIteratorMap.get(ordinal);
                if (cachedIterator != null) {
                    cachedIterator.release();
                    this.mIteratorMap.remove(ordinal);
                }
                this.mIteratorMap.put(ordinal, iterator);
            }
            finally {
                this.mLock.writeLock().unlock();
            }
        }
        catch (InterruptedException ie) {
            throw new RequestCanceledException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RSAPIEdgeIterator getIterator(int edgeOrdinal, int startDetailRowNumber, int numRows) {
        Integer ordinal = XQEIntegerPool.getInteger(edgeOrdinal);
        RSAPIEdgeIterator cachedIterator = null;
        try {
            this.mLock.writeLock().lockInterruptibly();
            try {
                cachedIterator = this.mIteratorMap.get(ordinal);
                if (cachedIterator != null) {
                    this.mIteratorMap.remove(ordinal);
                    if (!cachedIterator.open(startDetailRowNumber, numRows)) {
                        cachedIterator.release();
                        cachedIterator = null;
                    }
                }
            }
            finally {
                this.mLock.writeLock().unlock();
            }
        }
        catch (InterruptedException ie) {
            throw new RequestCanceledException();
        }
        return cachedIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        try {
            this.mLock.writeLock().lockInterruptibly();
            try {
                if (this.mIteratorMap != null) {
                    for (Map.Entry<Integer, RSAPIFwdEdgeIterator> entry : this.mIteratorMap.entrySet()) {
                        RSAPIFwdEdgeIterator rsapiIterator = entry.getValue();
                        try {
                            rsapiIterator.release();
                        }
                        catch (Exception ex) {
                            mErrorLogger.log(ex);
                        }
                    }
                    this.mIteratorMap.clear();
                    this.mIteratorMap = null;
                }
            }
            finally {
                this.mLock.writeLock().unlock();
            }
        }
        catch (InterruptedException ie) {
            throw new RequestCanceledException();
        }
    }
}

