/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.rsapi;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.DataType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIColumn;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeElementPosition;
import com.cognos.xqe.rsapi.RSAPIRowset;
import com.cognos.xqe.rsapi.RSAPIUsage;
import com.cognos.xqe.rsapi.ValueSetReplicas;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import com.cognos.xqe.util.xml.XMLWriter;
import com.cognos.xqe.xqejapi.IRSAPIEdgeRowset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class RSAPIEdgeRowset
extends RSAPIRowset
implements IRSAPIEdgeRowset {
    public static final String STRING_REF_DATA_ITEM_PROPERTIES = "refDataItemProperties";
    public static final int REF_DATA_ITEM_ORDINAL = -1;
    public static final int NO_DATA_ITEMS_ORDINAL = -2;
    public static final int PLACE_HOLDER_MEMBER_DATA_ITEMS_ORDINAL = -3;
    private static final String STRING_PARENT_ROWSET_ID = "parentRowsetId";
    private static final String STRING_NESTED_ROWSET_ID = "nestedRowsetId";
    private static final String STRING_CHILD_ROWSET_ID = "childRowsetId";
    private static final String STRING_FOOTER_ROWSET_ID = "footerRowsetId";
    private static final String STRING_HEADER_ROWSET_ID = "headerRowsetId";
    private static final String STRING_REF_DATA_ITEM = "refDataItem";
    public static final String STRING_EDGE_ROWSET = "edgeRowset";
    public static final String STRING_GROUP_BODY_PROPERTIES = "groupBodyProperties";
    private RSAPIEdge mEdge;
    private RSAPIEdgeRowset mHeaderRowset;
    private RSAPIEdgeRowset mFooterRowset;
    private RSAPIEdgeRowset mNestedRowset;
    private RSAPIEdgeRowset mSiblingRowset;
    private RSAPIEdgeRowset mParentRowset;
    private RSAPIEdgeRowset mGroupingRowset;
    private DataType[] mRefDataItemProperties = null;
    private DataType[] mGroupBodyProperties = null;
    protected RSAPIDataItem mRefDataItem = null;
    private RSAPIColumn[] mColumns = null;
    private boolean isHeader;
    private boolean isFooter;
    private boolean isNoDataMode = false;
    private boolean isEmpty = false;
    private CrosstabSpaceType isCrosstabSpace = null;
    List<ValueSetReplicas> replicasOfThis = null;
    List<Integer> erroneousOrdinals = null;
    private String replacedWithDynamicProperty = null;
    private static final String STRING_NAME = "name";

    public RSAPIEdgeRowset() {
        this.setIsCrosstabSpace(CrosstabSpaceType.NOT);
    }

    public void setNestedRowset(RSAPIEdgeRowset rowset) {
        this.mNestedRowset = rowset;
    }

    public void setFooterRowset(RSAPIEdgeRowset rowset) {
        this.mFooterRowset = rowset;
        if (rowset != null) {
            rowset.setIsFooterRowset();
            rowset.setGroupingRowset(this);
        }
    }

    public void setHeaderRowset(RSAPIEdgeRowset rowset) {
        this.mHeaderRowset = rowset;
        if (rowset != null) {
            rowset.setIsHeaderRowset();
            rowset.setGroupingRowset(this);
        }
    }

    public void setSiblingRowset(RSAPIEdgeRowset rowset) {
        this.mSiblingRowset = rowset;
    }

    public void setParentRowset(RSAPIEdgeRowset rowset) {
        this.mParentRowset = rowset;
    }

    public void setRefDataItemProperties(DataType[] properties) {
        this.mRefDataItemProperties = this.isNoDataMode() ? new DataType[0] : properties;
    }

    public DataType[] getRefDataItemProperties() {
        return this.mRefDataItemProperties;
    }

    public DataType[] getGroupBodyProperties() {
        return this.mGroupBodyProperties;
    }

    public void setGroupBodyProperties(DataType[] properties) {
        if (!this.isNoDataMode()) {
            this.mGroupBodyProperties = properties;
        }
    }

    @Override
    public void setDataItem(int ordinal, RSAPIDataItem dataItem) {
        this.mDataItems.ensureCapacity(ordinal);
        this.mDataItems.add(ordinal, dataItem);
    }

    public void replaceDataItem(int ordinal, RSAPIDataItem dataItem) {
        if (ordinal < this.mDataItems.size()) {
            this.mDataItems.remove(ordinal);
            this.mDataItems.add(ordinal, dataItem);
        }
    }

    public void setRefDataItem(RSAPIDataItem dataItem) {
        this.mRefDataItem = dataItem;
    }

    public RSAPIDataItem getRefDataItem() {
        return this.mRefDataItem;
    }

    @Override
    public RSAPIEdgeRowset getNestedRowset() {
        return this.mNestedRowset;
    }

    @Override
    public RSAPIEdgeRowset getFooterRowset() {
        return this.mFooterRowset;
    }

    @Override
    public RSAPIEdgeRowset getHeaderRowset() {
        return this.mHeaderRowset;
    }

    @Override
    public RSAPIEdgeRowset getSiblingRowset() {
        return this.mSiblingRowset;
    }

    @Override
    public RSAPIEdgeRowset getParentRowset() {
        return this.mParentRowset;
    }

    @Override
    public int getNumColumns() {
        int numColumns = this.mGroupBodyProperties == null ? this.mDataItems.size() : this.mDataItems.size() * (this.mGroupBodyProperties.length + 1);
        if (this.getRefDataItem() != null && this.mRefDataItemProperties != null) {
            numColumns += this.mRefDataItemProperties.length + 1;
        }
        return numColumns;
    }

    @Override
    public boolean isTimeRowset() {
        return false;
    }

    @Override
    public void toXMLString(XMLWriter writer, boolean completeDump, boolean internal) {
        this.toXMLString(writer, completeDump, internal, 0);
    }

    @Override
    public void toXMLString(XMLWriter writer, boolean completeDump, boolean internal, int datatypesToDisplay) {
        if (internal) {
            writer.beginElement(STRING_EDGE_ROWSET, -1);
        } else {
            writer.beginElement("rowsetInfo", -1);
        }
        this.dumpAttributes(writer);
        if (completeDump) {
            if (internal) {
                this.dumpDataItems(writer, completeDump, internal, this.mGroupBodyProperties);
            } else {
                this.dumpRSAPIColumns(writer, completeDump, internal, datatypesToDisplay);
            }
        }
        if (internal && this.mRefDataItem != null) {
            this.mRefDataItem.toXMLString(writer, completeDump, datatypesToDisplay, true);
            if (this.mRefDataItemProperties != null) {
                RSAPIEdgeRowset.propertiesToXML(writer, this.mRefDataItemProperties);
            }
        }
        writer.endElement();
    }

    @Override
    protected void dumpAttributes(XMLWriter writer) {
        if (this.getParentRowset() != null) {
            writer.attribute(STRING_PARENT_ROWSET_ID, this.getParentRowset().getRowsetId());
        }
        if (this.getNestedRowset() != null) {
            writer.attribute(STRING_NESTED_ROWSET_ID, this.getNestedRowset().getRowsetId());
        }
        if (this.getSiblingRowset() != null) {
            writer.attribute(STRING_CHILD_ROWSET_ID, this.getSiblingRowset().getRowsetId());
        }
        if (this.getFooterRowset() != null) {
            writer.attribute(STRING_FOOTER_ROWSET_ID, this.getFooterRowset().getRowsetId());
        }
        if (this.getHeaderRowset() != null) {
            writer.attribute(STRING_HEADER_ROWSET_ID, this.getHeaderRowset().getRowsetId());
        }
        super.dumpAttributes(writer);
    }

    @Override
    public void toXMLString(XMLWriter writer) {
        this.toXMLString(writer, true, true);
    }

    @Override
    public boolean isMeasureRowset() {
        if (this.mRefDataItem != null) {
            return this.mRefDataItem.getUsage() == RSAPIUsage.FACT;
        }
        return false;
    }

    @Override
    public RSAPIColumn[] getColumns() {
        int nColumns = this.getNumColumns();
        if (nColumns == 0) {
            return null;
        }
        if (this.mColumns != null && this.mColumns.length == nColumns) {
            return this.mColumns;
        }
        this.mColumns = new RSAPIColumn[nColumns];
        for (int j = 0; j < this.mColumns.length; ++j) {
            this.mColumns[j] = new RSAPIColumn(this);
        }
        int i = 0;
        if (this.mRefDataItem != null) {
            i = this.transferDataItemToColumns(this.mRefDataItem, this.mRefDataItemProperties, this.mColumns, i);
        }
        for (RSAPIDataItem dataItem : this.mDataItems) {
            i = this.transferDataItemToColumns(dataItem, this.mGroupBodyProperties, this.mColumns, i);
        }
        return this.mColumns;
    }

    private int transferDataItemToColumns(RSAPIDataItem refDataItem, IDataType[] properties, RSAPIColumn[] columns, int index) {
        if (properties != null) {
            for (int i = 0; i < properties.length; ++i) {
                columns[index++].setRefDataItem(refDataItem, properties[i], false);
            }
        }
        columns[index++].setRefDataItem(refDataItem, refDataItem.getPropertyDataType(), true);
        return index;
    }

    @Override
    public boolean isDetailRowset() {
        if (this.isHeaderRowset() || this.isFooterRowset()) {
            return false;
        }
        return this.getNestedRowset() == null;
    }

    public boolean isHeaderRowset() {
        return this.isHeader;
    }

    public boolean isFooterRowset() {
        return this.isFooter;
    }

    protected void setIsHeaderRowset() {
        this.isHeader = true;
    }

    protected void setIsFooterRowset() {
        this.isFooter = true;
    }

    protected void capture(RSAPIEdge edge, PlanningEnvironment env, Element inputNode) {
        this.assignAttributeValues(edge, inputNode);
        List childList = inputNode.elements();
        for (Element child : childList) {
            if ("dataItems".equals(child.getName())) {
                this.captureDataItems(env, child);
                continue;
            }
            if (STRING_REF_DATA_ITEM.equals(child.getName())) {
                this.captureRefDataItem(env, child);
                continue;
            }
            if (!"properties".equals(child.getName())) continue;
            this.mRefDataItemProperties = super.captureProperties(env, child);
        }
    }

    @Override
    protected void captureDataItems(PlanningEnvironment env, Element inputNode) {
        super.captureDataItems(env, inputNode);
        List childList = inputNode.elements();
        for (Element child : childList) {
            if (!"properties".equals(child.getName())) continue;
            this.mGroupBodyProperties = super.captureProperties(env, child);
        }
    }

    private RSAPIEdgeRowset getEdgeRowset(RSAPIEdge edge, Attribute attribute) {
        RSAPIEdgeRowset edgeRowset = null;
        if (attribute != null) {
            Integer rowsetId = new Integer(attribute.getStringValue());
            if (rowsetId == -1) {
                return null;
            }
            edgeRowset = edge.getRowset(rowsetId);
            if (edgeRowset == null) {
                edgeRowset = new RSAPIEdgeRowset();
                edgeRowset.setEdge(edge);
                edgeRowset.setRowsetId(rowsetId);
            }
        }
        return edgeRowset;
    }

    private void assignAttributeValues(RSAPIEdge edge, Element inputNode) {
        Attribute attribute = inputNode.attribute(STRING_PARENT_ROWSET_ID);
        this.setParentRowset(this.getEdgeRowset(edge, attribute));
        attribute = inputNode.attribute(STRING_NESTED_ROWSET_ID);
        this.setNestedRowset(this.getEdgeRowset(edge, attribute));
        attribute = inputNode.attribute(STRING_CHILD_ROWSET_ID);
        this.setSiblingRowset(this.getEdgeRowset(edge, attribute));
        attribute = inputNode.attribute(STRING_FOOTER_ROWSET_ID);
        this.setFooterRowset(this.getEdgeRowset(edge, attribute));
        attribute = inputNode.attribute(STRING_HEADER_ROWSET_ID);
        this.setHeaderRowset(this.getEdgeRowset(edge, attribute));
        attribute = inputNode.attribute(STRING_NAME);
        this.setName(attribute.getStringValue());
        attribute = inputNode.attribute("rowsetId");
        Integer rowsetId = new Integer(attribute.getStringValue());
        this.setRowsetId(rowsetId);
    }

    private void captureRefDataItem(PlanningEnvironment env, Element inputNode) {
        RSAPIDataItem dataItem = new RSAPIDataItem();
        dataItem.capture(inputNode);
        this.setRefDataItem(dataItem);
    }

    protected void setGroupingRowset(RSAPIEdgeRowset rowset) {
        this.mGroupingRowset = rowset;
    }

    public RSAPIEdgeRowset getGroupingRowset() {
        return this.mGroupingRowset;
    }

    public void setEdge(RSAPIEdge edge) {
        this.mEdge = edge;
    }

    @Override
    public RSAPIEdge getEdge() {
        return this.mEdge;
    }

    public boolean isEmpty() {
        if (this.isEmpty) {
            return true;
        }
        return this.getNumColumns() == 0;
    }

    public void setEmpty() {
        this.isEmpty = true;
    }

    public boolean isEmptyNestedUnder(RSAPIEdgeRowset potentialParent) {
        if (!this.isEmpty()) {
            return false;
        }
        if (this.getParentRowset() == null) {
            return false;
        }
        return this.getParentRowset().getRowsetId() == potentialParent.getRowsetId();
    }

    public int getNumberOfGroupBodyMeasures() {
        int num = 0;
        if (this.mRefDataItem != null && this.mDataItems.size() > 0) {
            for (int i = 0; i < this.mDataItems.size(); ++i) {
                RSAPIDataItem currentItem = (RSAPIDataItem)this.mDataItems.get(i);
                if (currentItem == null || currentItem.isNotApplicableGroupbody() || currentItem.getUsage() != RSAPIUsage.FACT) continue;
                ++num;
            }
        }
        return num;
    }

    public boolean isMeasureRowSetForList() {
        boolean hasMeasure = false;
        for (RSAPIDataItem dataItem : this.mDataItems) {
            if (dataItem == null || dataItem.getUsage() != RSAPIUsage.FACT || dataItem.isConstant()) continue;
            hasMeasure = true;
            break;
        }
        return hasMeasure;
    }

    public boolean isNoDataMode() {
        return this.isNoDataMode;
    }

    public void setNoDataMode(boolean bNoDataMode) {
        this.isNoDataMode = bNoDataMode;
    }

    public boolean isAncestorRowset(RSAPIEdgeRowset inRowset, boolean checkHeaderFooter) {
        boolean ret = false;
        for (RSAPIEdgeRowset parent = this.getParentRowset(); parent != null; parent = parent.getParentRowset()) {
            if (parent == inRowset) {
                return true;
            }
            if (!checkHeaderFooter || parent.getFooterRowset() != inRowset && parent.getHeaderRowset() != inRowset) continue;
            return true;
        }
        return ret;
    }

    public int compareQRDOrderTo(RSAPIEdgeRowset inRowset) {
        int ret = this.getRowsetId() - inRowset.getRowsetId();
        if (ret != 0 && (inRowset.getHeaderRowset() == this || this.getHeaderRowset() == inRowset || inRowset.isFooterRowset() && this.isAncestorRowset(inRowset, true) || this.isFooterRowset() && inRowset.isAncestorRowset(this, true))) {
            ret = -ret;
        }
        return ret;
    }

    public int getNumDerivedDataItems() {
        int num = 0;
        for (int i = 0; i < this.getNumDataItems(); ++i) {
            if (this.getDataItem(i).getSourceRowsetId() == -1) continue;
            ++num;
        }
        if (this.mRefDataItem != null && this.mRefDataItem.getSourceRowsetId() != -1) {
            ++num;
        }
        return num;
    }

    public boolean isDerivedRowset() {
        if (this.isEmpty()) {
            return true;
        }
        int num = this.mDataItems.size();
        if (this.mRefDataItem != null && this.mRefDataItem.getSourceRowsetId() != -1) {
            ++num;
        }
        return this.getNumDerivedDataItems() > 0 && this.getNumDerivedDataItems() == num;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("(");
        sb.append("rowsetId");
        sb.append("=");
        sb.append(this.getRowsetId());
        if (this.getRefDataItem() != null) {
            sb.append(" ");
            sb.append(STRING_REF_DATA_ITEM);
            sb.append("=");
            sb.append(this.getRefDataItem().getName());
        }
        sb.append(")");
        return sb.toString();
    }

    public CrosstabSpaceType isCrosstabSpace() {
        return this.isCrosstabSpace;
    }

    public void setIsCrosstabSpace(CrosstabSpaceType value) {
        this.isCrosstabSpace = value;
    }

    public List<ValueSetReplicas> getReplicasOfThis() {
        return this.replicasOfThis;
    }

    public void addReplicaOfThis(RSAPIEdgeElementPosition aReplicaOfThis, int sourceDataItemOrdinal) {
        if (aReplicaOfThis == null) {
            return;
        }
        int parentValueSetRowsetId = -1;
        String parentValueSetName = null;
        if (aReplicaOfThis.getEdgeRowset().getParentRowset() != null) {
            parentValueSetRowsetId = aReplicaOfThis.getEdgeRowset().getParentRowset().getRowsetId();
            parentValueSetName = aReplicaOfThis.getEdgeRowset().getParentRowset().getName();
        }
        if (this.replicasOfThis == null) {
            this.replicasOfThis = new ArrayList<ValueSetReplicas>();
            ValueSetReplicas currValueSet = new ValueSetReplicas();
            currValueSet.setParentRowsetId(parentValueSetRowsetId);
            currValueSet.setParentName(parentValueSetName);
            currValueSet.setSourceDataItemOrdinal(sourceDataItemOrdinal);
            this.addRSAPIEPositionToVSReplicas(aReplicaOfThis, currValueSet);
            this.replicasOfThis.add(currValueSet);
        } else {
            for (ValueSetReplicas currValueSet : this.replicasOfThis) {
                if (currValueSet.getParentRowsetId() != parentValueSetRowsetId || currValueSet.getSourceDataItemOrdinal() != sourceDataItemOrdinal) continue;
                this.addRSAPIEPositionToVSReplicas(aReplicaOfThis, currValueSet);
                return;
            }
            ValueSetReplicas newValueSet = new ValueSetReplicas();
            newValueSet.setParentRowsetId(parentValueSetRowsetId);
            newValueSet.setParentName(parentValueSetName);
            newValueSet.setSourceDataItemOrdinal(sourceDataItemOrdinal);
            this.addRSAPIEPositionToVSReplicas(aReplicaOfThis, newValueSet);
            this.addReplicaOfThis(sourceDataItemOrdinal, newValueSet);
        }
    }

    public void addReplicaOfThis(int sourceDataItemOrdinal, ValueSetReplicas newValueSet) {
        for (int i = 0; i < this.replicasOfThis.size(); ++i) {
            ValueSetReplicas currValueSet = this.replicasOfThis.get(i);
            if (currValueSet.getParentRowsetId() > newValueSet.getParentRowsetId()) {
                this.replicasOfThis.add(i, newValueSet);
                return;
            }
            if (currValueSet.getParentRowsetId() != newValueSet.getParentRowsetId() || currValueSet.getSourceDataItemOrdinal() <= sourceDataItemOrdinal) continue;
            this.replicasOfThis.add(i, newValueSet);
            return;
        }
        this.replicasOfThis.add(newValueSet);
    }

    private void addRSAPIEPositionToVSReplicas(RSAPIEdgeElementPosition aReplicaOfThis, ValueSetReplicas currValueSet) {
        if (aReplicaOfThis.getEdgeRowset().isHeaderRowset()) {
            currValueSet.addGroupHeader(aReplicaOfThis);
        } else if (aReplicaOfThis.getEdgeRowset().isFooterRowset()) {
            currValueSet.addGroupFooter(aReplicaOfThis);
        } else if (aReplicaOfThis.getDataItemOrdinal() != -1) {
            currValueSet.addGroupBodyDataItemRef(aReplicaOfThis);
        } else {
            currValueSet.addGroupBodyDataItemRef(aReplicaOfThis);
        }
    }

    public List<Integer> getErroneousOrdinals() {
        return this.erroneousOrdinals;
    }

    public void addErroneousColumn(int anOrdinal) {
        if (anOrdinal < 0) {
            return;
        }
        if (this.erroneousOrdinals == null) {
            this.erroneousOrdinals = new ArrayList<Integer>();
        }
        this.erroneousOrdinals.add(XQEIntegerPool.getInteger(anOrdinal));
    }

    public String getReplacedWithDynamicPropertyName() {
        return this.replacedWithDynamicProperty;
    }

    public void setReplacedWithDynamicPropertyName(String dynamicName) {
        this.replacedWithDynamicProperty = dynamicName;
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        if (this.getParentRowset() != null) {
            ctx.property(STRING_PARENT_ROWSET_ID, this.getParentRowset().getRowsetId());
        }
        if (this.getNestedRowset() != null) {
            ctx.property(STRING_NESTED_ROWSET_ID, this.getNestedRowset().getRowsetId());
        }
        if (this.getSiblingRowset() != null) {
            ctx.property(STRING_CHILD_ROWSET_ID, this.getSiblingRowset().getRowsetId());
        }
        if (this.getFooterRowset() != null) {
            ctx.property(STRING_FOOTER_ROWSET_ID, this.getFooterRowset().getRowsetId());
        }
        if (this.getHeaderRowset() != null) {
            ctx.property(STRING_HEADER_ROWSET_ID, this.getHeaderRowset().getRowsetId());
        }
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        if (this.mGroupBodyProperties != null) {
            ctx.elementProperty(STRING_GROUP_BODY_PROPERTIES, this.mGroupBodyProperties);
        }
        if (this.mRefDataItem != null) {
            ctx.elementProperty(STRING_REF_DATA_ITEM, this.mRefDataItem);
            if (this.mRefDataItemProperties != null) {
                ctx.elementProperty(STRING_REF_DATA_ITEM_PROPERTIES, this.mRefDataItemProperties);
            }
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname != null) {
            if (pname.equals(STRING_GROUP_BODY_PROPERTIES)) {
                Object value = ctx.elementValue(node);
                this.mGroupBodyProperties = (DataType[])value;
            } else if (pname.equals(STRING_REF_DATA_ITEM)) {
                Object value = ctx.elementValue(node);
                this.mRefDataItem = (RSAPIDataItem)value;
            } else if (pname.equals(STRING_REF_DATA_ITEM_PROPERTIES)) {
                Object value = ctx.elementValue(node);
                this.mRefDataItemProperties = (DataType[])value;
            } else {
                super.restoreElementProperty(ctx, node, inputNode);
            }
        }
    }

    public void restoreRelations(Element node, Map<Integer, RSAPIEdgeRowset> rowsets) {
        Integer rowsetId;
        String id = node.attributeValue(STRING_PARENT_ROWSET_ID);
        if (id != null) {
            rowsetId = Integer.valueOf(id);
            this.setParentRowset(rowsets.get(rowsetId));
        }
        if ((id = node.attributeValue(STRING_NESTED_ROWSET_ID)) != null) {
            rowsetId = Integer.valueOf(id);
            this.setNestedRowset(rowsets.get(rowsetId));
        }
        if ((id = node.attributeValue(STRING_CHILD_ROWSET_ID)) != null) {
            rowsetId = Integer.valueOf(id);
            this.setSiblingRowset(rowsets.get(rowsetId));
        }
        if ((id = node.attributeValue(STRING_FOOTER_ROWSET_ID)) != null) {
            rowsetId = Integer.valueOf(id);
            this.setFooterRowset(rowsets.get(rowsetId));
        }
        if ((id = node.attributeValue(STRING_HEADER_ROWSET_ID)) != null) {
            rowsetId = Integer.valueOf(id);
            this.setHeaderRowset(rowsets.get(rowsetId));
        }
    }

    public static RSAPIEdgeRowset getRowset(Element node, IXQEQueryNode queryNode) {
        RSAPIEdgeRowset result = null;
        List nodes = node.elements();
        if (nodes.size() == 1) {
            Element inputNode = (Element)nodes.get(0);
            RSAPIDataset ds = (RSAPIDataset)queryNode.getAncestorOfType(401005);
            if (ds != null) {
                result = ds.getEdgeRowsetByName(inputNode.attributeValue(STRING_NAME));
            }
        }
        return result;
    }

    public static enum CrosstabSpaceType {
        NOT,
        NOCELLVALUE,
        WITHCELLVALUE;

    }
}

