/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.rsapi;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.resultsets.ContextBase;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.rsapi.RSAPIColumn;
import com.cognos.xqe.rsapi.RSAPIContextInformation;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIDataRetrievalException;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeIterator;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIResultSet;
import com.cognos.xqe.rsapi.RSAPIRow;
import com.cognos.xqe.rsapi.RSAPIRowNumberCalculator;
import com.cognos.xqe.rsapi.RSAPIRowset;
import com.cognos.xqe.rsapi.RSAPITabularIterator;
import com.cognos.xqe.rsapi.RSAPITabularRow;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.Queue;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class RSAPIFwdEdgeIterator
extends RSAPIEdgeIterator {
    private boolean mIncludeContextDefault;
    private RSAPIEdge mEdge;
    private RSAPIRow[] mRows;
    private RSAPITabularRow mNextTabularRow;
    private RSAPIRow mNextRSAPIRow;
    private boolean mNextRowRead;
    private boolean mEod;
    private Map<String, ArrayList<Integer>>[] mDataItemToColumnMaps;
    private RSAPITabularIterator mIterator;
    private Queue mContextRows;
    private Map<Integer, Integer> mDetailRowNumberToTabularRowNumberMap;
    private boolean mProcessingFinalFooters;
    private RSAPIRowNumberCalculator mRowNumberCalculator;
    private boolean mActive;
    private boolean mReadingFromContext;
    private int mStartRowNumber;
    private int mNumRows;
    private RSAPIRow mFirstNonContextRow;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    protected RSAPIFwdEdgeIterator(RSAPIEdge edge, RSAPIResultSet resultSet, int startRowNumber, int numRows, boolean includeContext, boolean allRows) {
        super(edge, resultSet, startRowNumber, numRows, includeContext, allRows);
        try {
            this.mEdge = edge;
            this.mRowNumberCalculator = new RSAPIRowNumberCalculator(edge);
            this.mRowNumberCalculator.setNumDetailRowsToRead(numRows);
            this.mIncludeContextDefault = includeContext;
            this.mRows = new RSAPIRow[edge.getNumRowsets()];
            this.mDataItemToColumnMaps = new Map[edge.getNumRowsets()];
            this.mContextRows = new Queue();
            this.mStartRowNumber = startRowNumber;
            this.mNumRows = numRows;
            if (!this.isOptimizedForAllRows()) {
                this.mDetailRowNumberToTabularRowNumberMap = new HashMap<Integer, Integer>();
            }
            this.initializeRows();
            this.reset();
            this.mActive = true;
        }
        catch (RuntimeException e) {
            this.release();
            throw e;
        }
    }

    private void initializeRows() {
        RSAPIEdgeRowset[] rowsets = this.getEdge().getRowsets();
        for (int i = 0; i < this.mRows.length; ++i) {
            this.mRows[i] = new RSAPIRow(rowsets[i], !this.isCrossTabReport(), this.getEdge().getDataset().transferMembers());
            this.initializeRow(this.mRows[i], rowsets[i]);
        }
    }

    private void initializeRow(RSAPIRow row, RSAPIEdgeRowset rowset) {
        if (rowset.getParentRowset() == null) {
            row.setAncestorRowsetId(-1);
        } else {
            row.setAncestorRowsetId(rowset.getParentRowset().getRowsetId());
        }
    }

    private boolean includeContext() {
        return this.mIncludeContextDefault;
    }

    @Override
    protected RSAPIEdge getEdge() {
        return this.mEdge;
    }

    @Override
    public void reset() {
        if (this.getEdge().isEmpty()) {
            this.setEod(true);
            return;
        }
        this.mRowNumberCalculator.reset();
        this.setEod(false);
        if (this.mIterator != null) {
            this.mIterator.release();
            this.mIterator = null;
        }
        XIterator it = this.getHybridResultSet().getV5EdgeIterator(this.getEdge());
        this.mIterator = new RSAPITabularIterator(this.getEdge(), it, this.isCrossTabReport());
        if (this.includeContext()) {
            this.mContextRows.clear();
        }
        if (!this.isOptimizedForAllRows()) {
            this.mDetailRowNumberToTabularRowNumberMap.clear();
        }
        this.setNextRowRead(true);
        this.setNextRSAPIRow(null);
        this.setLatestRSAPITabularRow(null);
        this.positionOnRow(this.mStartRowNumber);
    }

    private boolean isCrossTabReport() {
        return this.mEdge.getDataset().isCrossTabReport();
    }

    @Override
    protected boolean open(int startDetailRow, int numRows) {
        this.mStartRowNumber = startDetailRow++;
        if (!this.nextRSAPIRowHasBeenRead()) {
            // empty if block
        }
        if (this.mActive) {
            return false;
        }
        if (this.getNextDetailRowNumber() > startDetailRow) {
            return false;
        }
        this.mRowNumberCalculator.setNumDetailRowsToRead(0);
        this.setEod(false);
        if (this.includeContext()) {
            while (this.hasNext() && this.mRowNumberCalculator.peekAtNextDetailRowNumber() <= startDetailRow) {
                this.next();
                this.setNextRowRead(true);
            }
            this.mRowNumberCalculator.setNumDetailRowsRead(1);
        } else {
            while (this.hasNext() && this.mRowNumberCalculator.peekAtNextDetailRowNumber() <= startDetailRow) {
                this.next();
                this.setNextRowRead(true);
            }
            while (this.hasNext() && this.getNextRSAPIRow().isFooter()) {
                this.next();
                this.setNextRowRead(true);
            }
            if (this.getNextRSAPIRow() != null && this.getNextRSAPIRow().isDetailRow()) {
                while (this.hasNext() && this.mRowNumberCalculator.peekAtNextDetailRowNumber() <= startDetailRow) {
                    this.next();
                    this.setNextRowRead(true);
                }
            }
            if (!this.eodEncountered()) {
                if (this.getNextRSAPIRow().isDetailRow()) {
                    this.mRowNumberCalculator.setNumDetailRowsRead(1);
                } else {
                    this.mRowNumberCalculator.setNumDetailRowsRead(0);
                }
            }
        }
        if (!this.eodEncountered()) {
            RSAPITabularRow row;
            this.constructIteratorContext(startDetailRow);
            this.mRowNumberCalculator.setNumDetailRowsToRead(numRows);
            this.setNextRowRead(false);
            if (numRows == 1 && (row = this.peekAtNextTabularRow()) != null && row.isFooter()) {
                this.setProcessingFinalFooters(true);
            }
        }
        this.correctOrderOfContextAndDetailRows();
        this.mActive = true;
        return true;
    }

    @Override
    public boolean hasNext() {
        this.getNext();
        return !this.eodEncountered();
    }

    @Override
    public RSAPIRow next() {
        RSAPIRow row = null;
        try {
            this.getNext();
            this.setNextRowRead(true);
            row = this.retrieveNextRSAPIRow();
        }
        catch (RuntimeException e) {
            RSAPIDataRetrievalException exception;
            if (e instanceof NullPointerException) {
                exception = new RSAPIDataRetrievalException(XQEMessageKeys.RSA_NullPointerReference, (Throwable)e);
            } else if (e instanceof ClassCastException) {
                exception = new RSAPIDataRetrievalException(XQEMessageKeys.RSA_InvalidClassCast, (Throwable)e);
            } else {
                throw e;
            }
            throw exception;
        }
        return row;
    }

    private RSAPIRow retrieveNextRSAPIRow() {
        RSAPIRow row = this.getNextRSAPIRow();
        this.setNextRSAPIRow(null);
        return row;
    }

    private void buildDataItemToColumnMap(RSAPITabularRow tabularRow) {
        RSAPIEdgeRowset rowset = tabularRow.getRowset();
        int rowsetId = rowset.getRowsetId();
        if (rowset.getColumns() == null || this.mDataItemToColumnMaps[rowsetId] != null) {
            return;
        }
        this.mDataItemToColumnMaps[rowsetId] = new HashMap<String, ArrayList<Integer>>();
        RSAPIColumn[] columns = rowset.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            String name = columns[i].getBaseRefDataItem().getName();
            ArrayList<Integer> columnList = this.mDataItemToColumnMaps[rowsetId].get(name);
            if (columnList == null) {
                columnList = new ArrayList();
                this.mDataItemToColumnMaps[rowsetId].put(name, columnList);
            }
            Integer column = XQEIntegerPool.getInteger(i);
            columnList.add(column);
        }
    }

    private void constructRowOfData() {
        RSAPITabularRow tabularRow = this.getLatestRSAPITabularRow();
        this.buildDataItemToColumnMap(tabularRow);
        this.setNextRSAPIRow(this.mRows[tabularRow.getRowsetId()]);
        RSAPIRow rsapiRow = this.getNextRSAPIRow();
        rsapiRow.setColumnsNull();
        for (int i = 0; i < tabularRow.getNumColumns(); ++i) {
            this.constructColumns((ContextBase)((Object)tabularRow.getColumn(i)), false);
            this.constructColumns((ContextBase)((Object)tabularRow.getColumn(i)), true);
        }
        rsapiRow.setIsDetailRow(tabularRow.isDetail());
        rsapiRow.setAncestorRowsetId(tabularRow.getParentRowsetId());
        this.mRowNumberCalculator.assignRowNumber(rsapiRow);
        this.mRowNumberCalculator.assignAncestorRowNumber(rsapiRow);
        this.addDetailRowToTabularRowMap(tabularRow, rsapiRow);
    }

    private void constructColumns(ContextBase value, boolean groupBodyDataItems) {
        block7: {
            List<Integer> dataItemIndices;
            block6: {
                if (value == null || value.isNullContext()) {
                    return;
                }
                if (!value.contextIsAMember() || !groupBodyDataItems || value.getDataItemIndex() != -1) break block6;
                RSAPIEdgeRowset rowset = (RSAPIEdgeRowset)value.getRowset();
                if (rowset == null) break block7;
                for (RSAPIDataItem dataItem : rowset.getDataItems()) {
                    if (dataItem.isGroupbodyMeasure()) {
                        if (!((ContextMember)value).hasGroupBodyMeasures()) continue;
                        for (ContextValue measure : ((ContextMember)value).getGroupBodyMeasures()) {
                            this.constructColumnsForDataItem(measure.getDataItemIndex(), measure);
                        }
                        continue;
                    }
                    this.constructColumnsForDataItem(rowset.getDataItemOrdinalByName(dataItem.getName()), value);
                }
                break block7;
            }
            this.constructColumnsForDataItem(value.getDataItemIndex(), value);
            if (value.contextIsAMember() && (dataItemIndices = ((ContextMember)value).getAdditionalDataItemIndices()) != null) {
                for (int dataItemIndex : dataItemIndices) {
                    this.constructColumnsForDataItem(dataItemIndex, value);
                }
            }
        }
    }

    private void constructColumnsForDataItem(int dataItemIndex, ContextBase value) {
        RSAPIRowset rowset = value.getRowset();
        if (rowset == null) {
            return;
        }
        RSAPIDataItem dataItem = dataItemIndex == -1 ? ((RSAPIEdgeRowset)rowset).getRefDataItem() : rowset.getDataItem(dataItemIndex);
        if (dataItem == null) {
            return;
        }
        int rowsetId = this.mNextRSAPIRow.getRowsetId();
        ArrayList<Integer> columns = this.mDataItemToColumnMaps[rowsetId].get(dataItem.getName());
        this.mNextRSAPIRow.transferValues(this.getEdge().getDataset(), dataItem, columns, value);
        if (dataItem.getAdditionalDataItemIndices() != null) {
            for (int i : dataItem.getAdditionalDataItemIndices()) {
                this.constructColumnsForDataItem(i, value);
            }
        }
    }

    private boolean nextRSAPIRowHasBeenRead() {
        return this.mNextRowRead;
    }

    private void setNextRowRead(boolean nextRowRead) {
        this.mNextRowRead = nextRowRead;
    }

    private RSAPITabularRow getLatestRSAPITabularRow() {
        return this.mNextTabularRow;
    }

    private void setLatestRSAPITabularRow(RSAPITabularRow row) {
        this.mNextTabularRow = row;
    }

    @Override
    public void close() {
        if (this.getLatestRSAPITabularRow() != null) {
            this.mActive = false;
        }
        this.getRSAPIResultSet().addIteratorToCache(this.getEdge().getOrdinal(), this);
    }

    private void setEod(boolean eod) {
        this.mEod = eod;
    }

    private boolean eodEncountered() {
        return this.mEod;
    }

    private void setNextRSAPIRow(RSAPIRow row) {
        this.mNextRSAPIRow = row;
    }

    private RSAPIRow getNextRSAPIRow() {
        return this.mNextRSAPIRow;
    }

    private void positionOnRow(int detailRowNumber) {
        if (detailRowNumber == 1) {
            this.mRowNumberCalculator.setNumDetailRowsRead(0);
            this.setReadingFromContext(false);
            return;
        }
        if (!this.readUpToSpecifiedDetailRowNumber(detailRowNumber)) {
            this.setEod(true);
        }
    }

    @Override
    public long positionOnRow(long iDetailRowNumber, boolean fromTop) {
        long detailRowNumber = -1L;
        detailRowNumber = !fromTop && this.getNumberOfRowsRelativeToSOD() > 0 ? this.mIterator.positionOnRow((long)this.getNumberOfRowsRelativeToSOD() - iDetailRowNumber, true) : this.mIterator.positionOnRow(iDetailRowNumber, fromTop);
        if (detailRowNumber >= 0L) {
            if (this.getNumberOfRowsRelativeToSOD() > 0) {
                this.mRowNumberCalculator.setNumDetailRowsRead((int)detailRowNumber);
            }
            this.mRowNumberCalculator.setNextDetailRowNumber((int)detailRowNumber + 1);
            this.mRowNumberCalculator.setNextRowNumber((int)detailRowNumber);
            return detailRowNumber;
        }
        return -1L;
    }

    private boolean readUpToSpecifiedDetailRowNumber(int detailRowNumber) {
        boolean status = true;
        boolean alreadyPositionedOnDetailRow = false;
        long currentRowNumber = this.positionOnRow(detailRowNumber - 1, true);
        if (currentRowNumber >= 0L) {
            alreadyPositionedOnDetailRow = true;
        }
        if (!alreadyPositionedOnDetailRow && this.canPositionOnSpecifiedDetailRow(detailRowNumber)) {
            this.positionOnPreviouslyReadRow(detailRowNumber);
        } else if (this.moveAheadToDetailRow(detailRowNumber)) {
            this.positionOnPreviouslyReadRow(detailRowNumber);
        } else {
            status = false;
        }
        this.correctOrderOfContextAndDetailRows();
        return status;
    }

    private void correctOrderOfContextAndDetailRows() {
        if (!this.readingFromContext() || this.mContextRows.size() == 0 || this.nextRSAPIRowHasBeenRead()) {
            return;
        }
        RSAPIRow row = this.getNextRSAPIRow();
        if (!row.isDetailRow()) {
            return;
        }
        this.mFirstNonContextRow = row;
        this.setNextRSAPIRow(null);
        this.setNextRowRead(true);
    }

    private boolean moveAheadToDetailRow(int detailRowNumber) {
        this.disableRowCounting();
        while (this.mRowNumberCalculator.peekAtNextDetailRowNumber() <= detailRowNumber) {
            this.getNext();
            if (this.eodEncountered()) {
                return false;
            }
            this.setNextRowRead(true);
        }
        this.enableRowCounting();
        this.setNextRowRead(false);
        this.setNumDetailRowsRead(1);
        return true;
    }

    private boolean canPositionOnSpecifiedDetailRow(int detailRowNumber) {
        int tabularRowNumber;
        if (this.isOptimizedForAllRows()) {
            return false;
        }
        int edgeOrdinal = this.getEdge().getOrdinal();
        int maxDetailRowRead = this.getRSAPIResultSet().getNumDetailRows(edgeOrdinal);
        if (maxDetailRowRead == -1) {
            return false;
        }
        return maxDetailRowRead >= detailRowNumber && (tabularRowNumber = this.getRSAPIResultSet().getTabularRowNumber(edgeOrdinal, detailRowNumber)) != -1;
    }

    private void disableRowCounting() {
        this.mRowNumberCalculator.disableRowCounting();
    }

    private void enableRowCounting() {
        this.mRowNumberCalculator.enableRowCounting();
    }

    private void setNumDetailRowsRead(int numDetailRowsRead) {
        this.mRowNumberCalculator.setNumDetailRowsRead(numDetailRowsRead);
    }

    private void positionOnPreviouslyReadRow(int detailRowNumber) {
        if (this.isOptimizedForAllRows()) {
            this.constructIteratorContext(detailRowNumber);
            this.setNextRowRead(false);
            return;
        }
        if (this.getNextRSAPIRow() != null && this.getNextRSAPIRow().getDetailRowNumber() == detailRowNumber) {
            this.constructIteratorContext(detailRowNumber);
            this.setNextRowRead(false);
            return;
        }
        int edgeOrdinal = this.getEdge().getOrdinal();
        int tabularRowNumber = this.getRSAPIResultSet().getTabularRowNumber(edgeOrdinal, detailRowNumber);
        if (tabularRowNumber == 0) {
            this.enableRowCounting();
            this.forcedGetNext();
        } else {
            this.disableRowCounting();
            while (this.peekAtNextTabularRow() != null && this.peekAtNextTabularRow().getRowNumber() != tabularRowNumber) {
                this.forcedGetNext();
            }
            while (this.peekAtNextTabularRow() != null && !this.peekAtNextTabularRow().isDetail()) {
                this.forcedGetNext();
            }
            if (this.peekAtNextTabularRow() != null) {
                this.constructIteratorContext(detailRowNumber);
            }
            this.enableRowCounting();
        }
        this.setNextRowRead(true);
    }

    private void forcedGetNext() {
        this.setNextRowRead(true);
        this.getNext();
    }

    private void constructIteratorContext(int detailRowNumber) {
        if (!this.includeContext()) {
            this.setReadingFromContext(false);
            return;
        }
        if (this.mNextRSAPIRow == null) {
            return;
        }
        int edgeOrdinal = this.getEdge().getOrdinal();
        RSAPIContextInformation contextInfo = new RSAPIContextInformation();
        HashSet<Integer> rowsetIdsProcessed = new HashSet<Integer>();
        RSAPIEdgeRowset currentRowset = (RSAPIEdgeRowset)this.mNextRSAPIRow.getRowset();
        if (currentRowset != null) {
            for (int i = 0; i < this.getEdge().getNumRowsets(); ++i) {
                if (i != currentRowset.getRowsetId() && !currentRowset.isAncestorRowset(this.getEdge().getRowset(i), true)) continue;
                this.addToContextRows(edgeOrdinal, detailRowNumber, contextInfo, rowsetIdsProcessed, i);
            }
        }
        this.setReadingFromContext(true);
    }

    private void addToContextRows(int edgeOrdinal, int detailRowNumber, RSAPIContextInformation contextInfo, HashSet<Integer> rowsetIdsProcessed, int rowsetId) {
        RSAPIContextInformation contextInfoReturned;
        if (rowsetIdsProcessed.contains(new Integer(rowsetId))) {
            return;
        }
        RSAPIEdgeRowset rowset = this.getEdge().getRowsets()[rowsetId];
        if (rowset.getHeaderRowset() != null) {
            this.addToContextRows(edgeOrdinal, detailRowNumber, contextInfo, rowsetIdsProcessed, rowset.getHeaderRowset().getRowsetId());
        }
        if ((contextInfoReturned = this.getRSAPIResultSet().getContextInformation(edgeOrdinal, rowsetId, detailRowNumber, contextInfo)) != null) {
            RSAPITabularRow tabularRow = contextInfoReturned.getTabularRow();
            if (tabularRow != null && !tabularRow.isDetail()) {
                this.mContextRows.put(tabularRow.copy());
                this.mRowNumberCalculator.setNextRowNumber(rowsetId, contextInfoReturned.getStartingRowsetRowNumber());
            }
            this.mRowNumberCalculator.setNextRowNumber(rowsetId, contextInfoReturned.getStartingRowsetRowNumber());
            rowsetIdsProcessed.add(new Integer(rowsetId));
        }
    }

    private void getNext() {
        RSAPITabularRow row;
        if (this.eodEncountered() || !this.nextRSAPIRowHasBeenRead()) {
            return;
        }
        int maxRowsRetrieved = this.getEdge().getMaxRowsRetrieved();
        if (maxRowsRetrieved != 0 && this.getNextDetailRowNumber() - 1 > maxRowsRetrieved) {
            throw new XQERuntimeException(XQEMessageKeys.V5_MaxRowsRetrievedExceeded, new Integer(maxRowsRetrieved).toString(), this.getEdge().getDataset().getRefQueryName());
        }
        if (this.mRowNumberCalculator.readAllRequiredDetailRows() && !this.processingFinalFooters() && this.mContextRows.isEmpty()) {
            this.setEod(true);
            return;
        }
        if (this.mContextRows.isEmpty() && this.mFirstNonContextRow != null) {
            this.setNextRSAPIRow(this.mFirstNonContextRow);
            this.mRowNumberCalculator.setNextRowNumber(this.mFirstNonContextRow.getRowsetId(), this.mFirstNonContextRow.getRowNumber());
            this.mFirstNonContextRow = null;
            this.setNextRowRead(false);
            return;
        }
        this.setLatestRSAPITabularRow(this.retrieveNextRow());
        if (this.getLatestRSAPITabularRow() == null) {
            this.updateDetailRowToTabularRowMap();
            this.setNumDetailRowsInResultSet(true);
            this.setEod(true);
            this.setNextRSAPIRow(null);
            return;
        }
        this.setNextRowRead(false);
        this.constructRowOfData();
        if (this.processingFinalFooters()) {
            if (!this.getNextRSAPIRow().isFooter() && !this.getNextRSAPIRow().isHeader()) {
                this.setEod(true);
                this.setNextRSAPIRow(null);
                return;
            }
        } else if (this.mRowNumberCalculator.readAllRequiredDetailRows() && (row = this.peekAtNextTabularRow()) != null && row.isFooter()) {
            this.setProcessingFinalFooters(true);
        }
    }

    private void updateDetailRowToTabularRowMap() {
        if (!this.isOptimizedForAllRows()) {
            this.getRSAPIResultSet().setTabularRowNumbers(this.getEdge().getOrdinal(), this.mDetailRowNumberToTabularRowNumberMap);
        }
    }

    private void addDetailRowToTabularRowMap(RSAPITabularRow tabularRow, RSAPIRow rsapiRow) {
        if (!this.isOptimizedForAllRows() && rsapiRow.isDetailRow()) {
            Integer detailRowNumber = XQEIntegerPool.getInteger(rsapiRow.getDetailRowNumber());
            Integer tabularRowNumber = XQEIntegerPool.getInteger(tabularRow.getRowNumber());
            this.mDetailRowNumberToTabularRowNumberMap.put(detailRowNumber, tabularRowNumber);
        }
    }

    private RSAPITabularRow peekAtNextTabularRow() {
        return this.mIterator.peek();
    }

    private RSAPITabularRow retrieveNextRow() {
        RSAPITabularRow row = this.retrieveNextRowFromContext();
        if (row != null) {
            return row;
        }
        return this.retrieveNextRowFromIterator();
    }

    private RSAPITabularRow retrieveNextRowFromContext() {
        RSAPITabularRow row = null;
        if (!this.readingFromContext() || !this.includeContext() || this.mContextRows.isEmpty()) {
            return row;
        }
        while (this.contextRowHasSiblingInContext(row = (RSAPITabularRow)this.mContextRows.take())) {
            this.removeDescendantsFromContextRows(row);
        }
        if (this.mContextRows.isEmpty()) {
            this.setReadingFromContext(false);
        }
        return row;
    }

    private boolean contextRowHasSiblingInContext(RSAPITabularRow row) {
        if (row.getRowset().getSiblingRowset() == null) {
            return false;
        }
        for (int i = 0; i < this.mContextRows.size(); ++i) {
            RSAPITabularRow contextRow = (RSAPITabularRow)this.mContextRows.get(i);
            if (row.getRowset().getSiblingRowset() != contextRow.getRowset()) continue;
            return true;
        }
        return false;
    }

    private void removeDescendantsFromContextRows(RSAPITabularRow row) {
        for (int i = 0; i < this.mContextRows.size(); ++i) {
            RSAPITabularRow contextRow = (RSAPITabularRow)this.mContextRows.get(i);
            if (!this.mIterator.rowIsDescendant(row.getRowsetId(), contextRow.getRowsetId())) continue;
            this.mContextRows.remove(contextRow);
        }
    }

    private boolean readingFromContext() {
        return this.mReadingFromContext;
    }

    private void setReadingFromContext(boolean readFromContext) {
        this.mReadingFromContext = readFromContext;
    }

    private RSAPITabularRow retrieveNextRowFromIterator() {
        if (this.mIterator == null) {
            return null;
        }
        RSAPITabularRow row = this.mIterator.next();
        if (row == null) {
            return null;
        }
        if (this.processingFinalFooters() && !row.isFooter()) {
            this.setProcessingFinalFooters(false);
            return null;
        }
        if (row.isHeader() || row.isControlBreak()) {
            this.addRowToEdgeContextInformation(row);
        }
        return row;
    }

    private void addRowToEdgeContextInformation(RSAPITabularRow row) {
        RSAPIContextInformation contextInfo = new RSAPIContextInformation();
        this.getRSAPIResultSet().getContextInformation(this.getEdge().getOrdinal(), row.getRowsetId(), this.getPreviousDetailRowNumber(), contextInfo);
        contextInfo.setTabularRow((RSAPITabularRow)row.copy());
        contextInfo.setStartingDetailRowNumber(this.getNextDetailRowNumber());
        contextInfo.setRowsetRowNumber(this.getNextRowNumber(row.getRowsetId()));
        this.getRSAPIResultSet().setContextInformation(this.getEdge().getOrdinal(), row.getRowsetId(), contextInfo);
    }

    private int getPreviousDetailRowNumber() {
        return this.mRowNumberCalculator.peekAtNextDetailRowNumber() - 1;
    }

    protected int getNextDetailRowNumber() {
        return this.mRowNumberCalculator.peekAtNextDetailRowNumber();
    }

    private int getNextRowNumber(int rowsetId) {
        return this.mRowNumberCalculator.peekAtNextRowsetRowNumber(rowsetId);
    }

    private void setNumDetailRowsInResultSet(boolean allRowsRead) {
        this.getRSAPIResultSet().setNumDetailRows(this.getEdge().getOrdinal(), this.getNextDetailRowNumber() - 1, allRowsRead);
    }

    private void setProcessingFinalFooters(boolean value) {
        this.mProcessingFinalFooters = value;
    }

    private boolean processingFinalFooters() {
        return this.mProcessingFinalFooters;
    }

    @Override
    protected int getStartingRowNumberRelativeToSOD() {
        return this.mStartRowNumber;
    }

    @Override
    protected int getNumberOfRowsRelativeToSOD() {
        return this.mNumRows;
    }

    @Override
    public void release() {
        this.mContextRows.clear();
        this.mDataItemToColumnMaps = null;
        if (this.mDetailRowNumberToTabularRowNumberMap != null) {
            this.mDetailRowNumberToTabularRowNumberMap.clear();
        }
        if (this.mIterator != null) {
            try {
                this.mIterator.release();
            }
            catch (Exception ex) {
                mErrorLogger.log(ex);
            }
            finally {
                this.mIterator = null;
            }
        }
        this.mRows = null;
    }
}

