/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.rsapi;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.rsapi.RSAPICell;
import com.cognos.xqe.rsapi.RSAPICellIterator;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeIterator;
import com.cognos.xqe.rsapi.RSAPIEdgeIteratorFactory;
import com.cognos.xqe.rsapi.RSAPIResultSet;
import com.cognos.xqe.rsapi.RSAPIRow;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.IReleasable;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import com.cognos.xqe.util.xml.XMLWriter;
import com.cognos.xqe.xqejapi.IRSAPIPartialDataset;
import java.rmi.server.UID;
import java.util.ArrayList;

public class RSAPIPartialDataset
implements IRSAPIPartialDataset,
IReleasable {
    public static final int ALL_ROWS = 0;
    public static final int FIRST_DETAIL_ROW_NUMBER = 1;
    public static final int LAST_DETAIL_ROW_NUMBER = -1;
    private final String mUniqueId;
    private RSAPIDataset mDataset;
    private RSAPIEdgeIterator[] mEdgeIterators;
    private RSAPICellIterator mCellIterator;
    private static final XQELogger RELEASE_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Resources.Dataset", LogLevel.INFO);
    private static final XQELogger ERROR_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    private static final String ORDINAL_STRING = "ordinal";

    protected RSAPIPartialDataset() {
        this.mUniqueId = null;
        this.mDataset = null;
        this.mEdgeIterators = null;
        this.mCellIterator = null;
    }

    public RSAPIPartialDataset(RSAPIDataset dataset, RSAPIResultSet resultSet, int[] startRowNumber, int[] numRows, boolean includeContext, boolean includeContextValues) {
        try {
            this.mUniqueId = new UID().toString();
            this.mDataset = dataset;
            this.mDataset.registerPartialDataset(this);
            this.mEdgeIterators = new RSAPIEdgeIterator[this.mDataset.getNumEdges()];
            RSAPIEdge[] edges = this.mDataset.getEdges();
            for (int i = 0; i < this.mDataset.getNumEdges(); ++i) {
                this.mEdgeIterators[i] = RSAPIEdgeIteratorFactory.getEdgeIterator(edges[i], resultSet, startRowNumber[i], numRows[i], includeContext, dataset.getIsOptimizedForAllRows());
            }
            if (this.mDataset.getCellRowset() != null) {
                this.mCellIterator = new RSAPICellIterator(dataset, resultSet, startRowNumber, numRows, null, this.mEdgeIterators);
            }
        }
        catch (RuntimeException e) {
            this.release();
            throw e;
        }
        catch (Throwable e) {
            this.release();
            throw XQERuntimeException.wrap(XQEMessageKeys.GEN_UnexpectedException, e);
        }
    }

    @Override
    public String getUniqueID() {
        return this.mUniqueId;
    }

    @Override
    public RSAPIEdgeIterator edgeIterator(int edgeOrdinal) {
        if (edgeOrdinal > this.mDataset.getNumEdges()) {
            return null;
        }
        return this.mEdgeIterators[edgeOrdinal];
    }

    @Override
    public RSAPIEdgeIterator edgeIterator(String name) {
        for (RSAPIEdge edge : this.mDataset.getEdges()) {
            if (edge.getName().compareTo(name) != 0) continue;
            return this.edgeIterator(edge.getOrdinal());
        }
        return null;
    }

    @Override
    public RSAPICellIterator cellIterator() {
        return this.mCellIterator;
    }

    public RSAPIDataset getMasterDataset() {
        return this.mDataset;
    }

    public void toXMLString(XMLWriter writer) {
        this.toXMLString(writer, null, null, null, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toXMLString(XMLWriter writer, String name, ArrayList<Integer> numRowsRead, int[] numRowsToRead, boolean reset, boolean valueInfo) {
        ROLAPContext.queryEnter((ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment());
        boolean needToRemoveCubeName = ROLAPContext.setCurrentCubeName(this.mDataset.getPlanningEnvironment());
        try {
            writer.beginElement("partialDataset", -1);
            if (name != null) {
                writer.attribute("name", name);
            }
            for (int i = 0; i < this.mDataset.getNumEdges(); ++i) {
                RSAPIRow row;
                RSAPIEdgeIterator it = this.edgeIterator(i);
                writer.beginElement("edgeIterator", -1);
                writer.attribute(ORDINAL_STRING, i);
                int numRows = 0;
                if (numRowsToRead == null || numRowsToRead[i] == 0) {
                    while (it.hasNext()) {
                        row = it.next();
                        row.toXMLString(writer, valueInfo);
                        if (!row.isDetailRow()) continue;
                        ++numRows;
                    }
                } else {
                    while (numRows < numRowsToRead[i] && it.hasNext()) {
                        row = it.next();
                        row.toXMLString(writer);
                        if (!row.isDetailRow()) continue;
                        ++numRows;
                    }
                }
                writer.endElement();
                if (reset) {
                    writer.beginElement("edgeIteratorReset", -1);
                    writer.attribute(ORDINAL_STRING, i);
                    it.reset();
                    numRows = 0;
                    if (numRowsToRead == null || numRowsToRead[i] == 0) {
                        while (it.hasNext()) {
                            row = it.next();
                            row.toXMLString(writer);
                            if (!row.isDetailRow()) continue;
                            ++numRows;
                        }
                    } else {
                        while (numRows < numRowsToRead[i] && it.hasNext()) {
                            row = it.next();
                            row.toXMLString(writer);
                            if (!row.isDetailRow()) continue;
                            ++numRows;
                        }
                    }
                    writer.endElement();
                }
                if (numRowsRead == null) continue;
                if (i >= numRowsRead.size()) {
                    numRowsRead.add(i, XQEIntegerPool.getInteger(numRows));
                    continue;
                }
                numRowsRead.set(i, XQEIntegerPool.getInteger(numRows));
            }
            RSAPICellIterator it = this.cellIterator();
            if (it != null) {
                writer.beginElement("cellIterator", -1);
                if (numRowsToRead == null) {
                    while (it.hasNext()) {
                        RSAPICell cell = it.next();
                        cell.toXMLString(writer);
                    }
                } else {
                    int maxCellRowNumber = 1;
                    for (int i = 0; i < this.mDataset.getNumEdges(); ++i) {
                        maxCellRowNumber *= numRowsRead.get(i).intValue();
                    }
                    while (it.hasNext()) {
                        RSAPICell cell = it.next();
                        cell.toXMLString(writer);
                        if (cell.getRowNumber() != maxCellRowNumber) continue;
                        break;
                    }
                }
                writer.endElement();
            }
            writer.endElement();
        }
        finally {
            ROLAPContext.queryExit((ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment());
            ROLAPContext.removeCurrentCubeName(needToRemoveCubeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        if (RELEASE_LOGGER.isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Releasing RSAPIPartialDataset with id=").append(this.getUniqueID());
            RELEASE_LOGGER.log(LogLevel.INFO, buffer.toString());
        }
        if (this.mEdgeIterators != null) {
            for (int i = 0; i < this.mEdgeIterators.length; ++i) {
                if (this.mEdgeIterators[i] == null) continue;
                try {
                    this.mEdgeIterators[i].close();
                    continue;
                }
                catch (Exception ex) {
                    ERROR_LOGGER.log(LogLevel.ERROR, (Throwable)ex);
                    continue;
                }
                finally {
                    this.mEdgeIterators[i] = null;
                }
            }
            this.mEdgeIterators = null;
        }
        if (this.mCellIterator != null) {
            try {
                this.mCellIterator.release();
            }
            catch (Exception ex) {
                ERROR_LOGGER.log(LogLevel.ERROR, (Throwable)ex);
            }
            finally {
                this.mCellIterator = null;
            }
        }
        if (this.mDataset != null) {
            try {
                this.mDataset.deregisterPartialDataset(this);
            }
            catch (Exception ex) {
                ERROR_LOGGER.log(LogLevel.ERROR, (Throwable)ex);
            }
            finally {
                this.mDataset = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pause() {
        Governors gvr = this.mDataset.getGovernors();
        if (gvr == null) {
            return false;
        }
        IExecutionEnvironment execEnv = ExecutionEnvironmentContext.getExecutionEnvironment();
        switch (gvr.getCursorMode()) {
            case CURSOR_MODE_QUERY_PER_PAGE: {
                execEnv.setGovernors(gvr);
                RSAPIDataset dataset = this.mDataset;
                this.release();
                dataset.releaseResultset(execEnv);
                return true;
            }
            case CURSOR_MODE_READ_IN_BACKGROUND: {
                XDataContext dataContext = execEnv.pushDataContext();
                try {
                    this.mDataset.loadInBackground();
                    break;
                }
                finally {
                    execEnv.popDataContext(dataContext);
                }
            }
        }
        return false;
    }
}

