/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.rsapi;

import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.MemberCaptionType;
import com.cognos.xqe.data.types.MemberType;
import com.cognos.xqe.data.types.RowType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueMethodNotImplementedException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.rsapi.RSAPIColumn;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIRowset;
import com.cognos.xqe.rsapi.RSAPIValue;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.util.xml.XMLWriter;
import com.cognos.xqe.xqejapi.IRSAPIRow;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class RSAPIRow
extends RSAPIValue
implements IRSAPIRow {
    static final int NO_COMPARISON_COLUMN_OFFSET = -1;
    static final long serialVersionUID = 1298622666666116649L;
    public static final int NO_ANCESTOR_ROWSET_ID = -1;
    int rowsetId;
    private int mCellCoordinate = -1;
    private boolean isDetailRow;
    private boolean mListReport;

    protected RSAPIRow() {
        super((RSAPIRowset)null);
        this.rowsetId = -1;
    }

    protected RSAPIRow(RSAPIRowset rowset, boolean listReport, boolean transferMembers) {
        super(rowset);
        this.mListReport = listReport;
        this.rowsetId = this.getRowset().getRowsetId();
        RSAPIColumn[] columns = this.getRowset().getColumns();
        for (int i = 0; i < this.getRowset().getNumColumns(); ++i) {
            if (!(((RSAPIEdgeRowset)rowset).getRefDataItem() == null || columns[i].getIsCanonicalProperty() || columns[i].getIsCustomMemberProperty() || columns[i].getUnadjustedDataType() == null || RSAPIColumn.dataTypeIsCanonicalProperty(columns[i].getUnadjustedDataType()))) {
                this.rowData[i] = MemberCaptionType.DEFAULTMEMBERCAPTIONTYPE.createValue();
                continue;
            }
            IDataType columnDataType = columns[i].getUnadjustedDataType();
            if (columnDataType.equals(MemberType.MEMBERTYPE)) {
                if (transferMembers && columnDataType.getSubType() == DataSubType.METADATATYPE) {
                    this.rowData[i] = DataValueFactory.createMemberRSAPIValue();
                    continue;
                }
                this.rowData[i] = DataValueFactory.createStringValue();
                continue;
            }
            this.rowData[i] = columnDataType.createValue();
            if (!columnDataType.isDate() || !"SAP_BUSINESS_KEY".equals(columns[i].getPropertyName())) continue;
            ((DateValue)this.rowData[i]).setFormat("yyyyMMdd");
        }
    }

    protected RSAPIRow(RSAPIRow source) {
        super(source.getRowset());
        this.mListReport = source.mListReport;
        this.rowsetId = source.getRowset().getRowsetId();
        for (int i = 0; i < source.rowData.length; ++i) {
            this.rowData[i] = source.rowData[i] instanceof ContextMember ? source.rowData[i] : (IValue)source.rowData[i].copy();
        }
    }

    @Override
    public IValue[] getColumns() {
        return this.rowData;
    }

    @Override
    public IValue getColumn(int i) {
        return this.rowData[i];
    }

    @Override
    public int getNumColumns() {
        if (this.rowData == null) {
            return 0;
        }
        return this.rowData.length;
    }

    @Override
    public int getCellCoordinate() {
        return this.mCellCoordinate;
    }

    protected void setCellCoordinate(int coordinate) {
        if (this.isListReport() || coordinate < 0) {
            coordinate = -1;
        }
        this.mCellCoordinate = coordinate;
    }

    protected void setIsDetailRow(boolean isDetail) {
        this.isDetailRow = isDetail;
    }

    @Override
    public boolean isDetailRow() {
        return this.isDetailRow;
    }

    @Override
    public IDataType getDataType() {
        return RowType.ROWTYPE;
    }

    @Override
    public FormatId getFormatId() {
        throw new XQERuntimeException(XQEMessageKeys.GEN_MethodNotImplemented_INTERNAL, this.getClass().getName() + ".getFormatId()");
    }

    public void toXMLString(XMLWriter writer, boolean valueInfo) {
        writer.beginElement("row", -1);
        writer.attribute("rowsetId", this.getRowsetId());
        writer.attribute("rowNumber", this.getRowNumber());
        writer.attribute("detailRowNumber", this.getDetailRowNumber());
        writer.attribute("ancestorRowsetId", this.getAncestorRowsetId());
        writer.attribute("ancestorRowNumber", this.getAncestorRowNumber());
        writer.attribute("coordinate", this.getCellCoordinate());
        RSAPIColumn[] columnInfo = this.getRowset().getColumns();
        for (int i = 0; i < this.getNumColumns(); ++i) {
            this.valueToXMLString((Value)this.getColumn(i), columnInfo[i], writer, valueInfo);
        }
        writer.endElement();
    }

    @Override
    public void toXMLString(XMLWriter writer) {
        this.toXMLString(writer, false);
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public Object copy() {
        RSAPIRow row = new RSAPIRow(this);
        row.copyColumnValues(this);
        row.setAncestorRowNumber(this.getAncestorRowNumber());
        row.setAncestorRowsetId(this.getAncestorRowsetId());
        row.setDetailRowNumber(this.getDetailRowNumber());
        row.setCellCoordinate(this.getCellCoordinate());
        row.setRowNumber(this.getRowNumber());
        row.setIsDetailRow(this.isDetailRow);
        return row;
    }

    @Override
    public void copyFrom(IValue dValue) throws ValueMethodNotImplementedException {
        throw new ValueMethodNotImplementedException(this.getClass().getName() + ".copyFrom(Value dValue)");
    }

    @Override
    public void decode(XDataContext context, DataInput iStream) throws IOException {
        throw new IOException("Reading unknown type:" + this.getClass().getName());
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream) throws IOException {
        throw new IOException("Writing unknown type:" + this.getClass().getName());
    }

    @Override
    public boolean isSummary() {
        return this.isHeader() || this.isFooter();
    }

    protected boolean isHeader() {
        return ((RSAPIEdgeRowset)this.getRowset()).isHeaderRowset();
    }

    protected boolean isFooter() {
        return ((RSAPIEdgeRowset)this.getRowset()).isFooterRowset();
    }

    @Override
    public boolean isListReport() {
        return this.mListReport;
    }

    @Override
    protected boolean isRow() {
        return true;
    }

    @Override
    protected boolean isCell() {
        return false;
    }
}

