/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.rsapi;

import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIRow;

public class RSAPIRowNumberCalculator {
    private int mNextDetailRowNumber;
    private int[] mNextRowNumber;
    private int mInitialNumDetailRowsToRead;
    private boolean mDetailRowCountingEnabled = true;
    private int mNumDetailRowsRead;

    protected RSAPIRowNumberCalculator(RSAPIEdge edge) {
        this.mNextRowNumber = new int[edge.getNumRowsets()];
        this.reset();
    }

    protected void reset() {
        this.mNumDetailRowsRead = 1;
        this.mNextDetailRowNumber = 1;
        for (int i = 0; i < this.mNextRowNumber.length; ++i) {
            this.mNextRowNumber[i] = 0;
        }
    }

    protected void assignRowNumber(RSAPIRow row) {
        int n = row.getRowsetId();
        int n2 = this.mNextRowNumber[n] + 1;
        this.mNextRowNumber[n] = n2;
        row.setRowNumber(n2);
        if (row.isDetailRow()) {
            row.setDetailRowNumber(this.getNextDetailRowNumber());
            row.setCellCoordinate(row.getDetailRowNumber() - 1);
        } else {
            row.setDetailRowNumber(0);
            row.setCellCoordinate(-1);
        }
    }

    protected void assignAncestorRowNumber(RSAPIRow row) {
        int ancestorRowsetId = row.getAncestorRowsetId();
        if (ancestorRowsetId == -1) {
            row.setAncestorRowNumber(-1);
        } else {
            row.setAncestorRowNumber(this.getPreviousRowNumber(row.getAncestorRowsetId()));
        }
    }

    protected void setNumDetailRowsToRead(int numRowsToRead) {
        this.mInitialNumDetailRowsToRead = numRowsToRead;
    }

    protected boolean readAllRequiredDetailRows() {
        if (!this.mDetailRowCountingEnabled) {
            return false;
        }
        if (this.mInitialNumDetailRowsToRead == 0) {
            return false;
        }
        return this.mNumDetailRowsRead >= this.mInitialNumDetailRowsToRead;
    }

    protected int getNextDetailRowNumber() {
        ++this.mNumDetailRowsRead;
        return this.mNextDetailRowNumber++;
    }

    protected int peekAtNextDetailRowNumber() {
        return this.mNextDetailRowNumber;
    }

    protected void setNextDetailRowNumber(int detailRowNumber) {
        this.mNextDetailRowNumber = detailRowNumber;
    }

    protected int peekAtNextRowsetRowNumber(int rowsetId) {
        return this.mNextRowNumber[rowsetId];
    }

    protected void setNextRowNumber(int rowsetId, int rowNumber) {
        this.mNextRowNumber[rowsetId] = rowNumber;
    }

    protected void setNextRowNumber(int rowNumber) {
        for (int i = 0; i < this.mNextRowNumber.length; ++i) {
            this.mNextRowNumber[i] = rowNumber;
        }
    }

    private int getPreviousRowNumber(int rowsetId) {
        return this.mNextRowNumber[rowsetId];
    }

    protected void disableRowCounting() {
        this.mDetailRowCountingEnabled = false;
    }

    protected void enableRowCounting() {
        this.mDetailRowCountingEnabled = true;
        this.mNumDetailRowsRead = 0;
    }

    protected void setNumDetailRowsRead(int numDetailRowsRead) {
        this.mNumDetailRowsRead = numDetailRowsRead;
    }
}

