/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.rsapi;

import com.cognos.xqe.ast.IXQEPersist;
import com.cognos.xqe.ast.IXQEProperty;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.DataType;
import com.cognos.xqe.data.types.BusinessKeyType;
import com.cognos.xqe.data.types.CurrencyCodeType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.DimensionUniqueNameType;
import com.cognos.xqe.data.types.HierarchyUniqueNameType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.LevelLabelType;
import com.cognos.xqe.data.types.LevelNumberType;
import com.cognos.xqe.data.types.LevelUniqueNameType;
import com.cognos.xqe.data.types.MemberCaptionType;
import com.cognos.xqe.data.types.MemberDescriptionType;
import com.cognos.xqe.data.types.MemberRollupType;
import com.cognos.xqe.data.types.MemberType;
import com.cognos.xqe.data.types.MemberUniqueNameType;
import com.cognos.xqe.data.types.ParentUniqueNameType;
import com.cognos.xqe.data.types.QueryItemModelIDType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIColumn;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.util.xml.XMLWriter;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public abstract class RSAPIRowset
implements IXQEProperty,
IXQEPersist {
    protected String mName;
    protected int mRowsetId = -1;
    protected ArrayList<RSAPIDataItem> mDataItems = new ArrayList();
    private boolean mContainsHeaderReturningFirstValue = false;
    private static final String STRING_DATAITEMS = "dataItems";
    protected static final String STRING_NAME = "name";
    protected static final String ROWSET_ID = "rowsetId";
    protected static final String STRING_PROPERTIES = "properties";

    public void setName(String name) {
        this.mName = name != null ? name : null;
    }

    public void setRowsetId(int id) {
        this.mRowsetId = id;
    }

    public void setDataItem(int ordinal, RSAPIDataItem dataItem) {
        this.mDataItems.ensureCapacity(ordinal + 1);
        this.mDataItems.add(ordinal, dataItem);
    }

    public RSAPIDataItem getDataItem(int ordinal) {
        if (ordinal >= this.mDataItems.size()) {
            return null;
        }
        return this.mDataItems.get(ordinal);
    }

    public int getDataItemOrdinal(RSAPIDataItem dataItemRef) {
        for (int idx = 0; idx < this.mDataItems.size(); ++idx) {
            RSAPIDataItem dataItem = this.mDataItems.get(idx);
            if (dataItem != dataItemRef) continue;
            return idx;
        }
        return -1;
    }

    public int getDataItemOrdinalByName(String dataItemName) {
        for (int idx = 0; idx < this.mDataItems.size(); ++idx) {
            RSAPIDataItem dataItem = this.mDataItems.get(idx);
            if (dataItem.getName().compareTo(dataItemName) != 0) continue;
            return idx;
        }
        return -1;
    }

    public RSAPIDataItem[] getDataItems() {
        return this.mDataItems.toArray(new RSAPIDataItem[0]);
    }

    public int getNumRows() {
        return 0;
    }

    public String getName() {
        return this.mName;
    }

    public abstract int getNumColumns();

    public abstract RSAPIColumn[] getColumns();

    public int getRowsetId() {
        return this.mRowsetId;
    }

    public boolean isMeasureRowset() {
        return false;
    }

    public void toXMLString(XMLWriter writer, boolean completeDump, boolean internal) {
        this.toXMLString(writer, completeDump, internal, 0);
    }

    public abstract void toXMLString(XMLWriter var1, boolean var2, boolean var3, int var4);

    protected void dumpRSAPIColumns(XMLWriter writer, boolean completeDump, boolean internal, int datatypesToDisplay) {
        if (this.getNumColumns() > 0) {
            for (RSAPIColumn column : this.getColumns()) {
                column.toXMLString(writer, completeDump, internal, datatypesToDisplay);
            }
        }
    }

    protected void dumpDataItems(XMLWriter writer, boolean completeDump, boolean internal, DataType[] properties) {
        RSAPIDataItem[] dataItems = this.getDataItems();
        if (dataItems.length > 0) {
            writer.beginElement(STRING_DATAITEMS, -1);
            for (RSAPIDataItem dataItem : dataItems) {
                dataItem.toXMLString(writer, completeDump, internal);
            }
            if (properties != null) {
                RSAPIRowset.propertiesToXML(writer, properties);
            }
            writer.endElement();
        }
    }

    protected void dumpAttributes(XMLWriter writer) {
        writer.attribute(STRING_NAME, this.getName());
        writer.attribute(ROWSET_ID, this.getRowsetId());
    }

    protected static void propertiesToXML(XMLWriter writer, DataType[] properties) {
        writer.beginElement(STRING_PROPERTIES, -1);
        for (DataType dType : properties) {
            writer.beginElement("canonicalProperty", -1);
            if (dType == MemberCaptionType.DEFAULTMEMBERCAPTIONTYPE || dType == MemberType.MEMBERTYPE) {
                writer.attribute(STRING_NAME, "memberCaption");
            } else if (dType == CurrencyCodeType.DEFAULTCURRENCYCODETYPE) {
                writer.attribute(STRING_NAME, "currencyCode");
            } else if (dType == DimensionUniqueNameType.DEFAULTDIMENSIONUNIQUENAMETYPE) {
                writer.attribute(STRING_NAME, "dimensionUniqueName");
            } else if (dType == HierarchyUniqueNameType.DEFAULTHIERARCHYUNIQUENAMETYPE) {
                writer.attribute(STRING_NAME, "hierarchyUniqueName");
            } else if (dType == LevelUniqueNameType.DEFAULTLEVELUNIQUENAMETYPE) {
                writer.attribute(STRING_NAME, "levelUniqueName");
            } else if (dType == MemberUniqueNameType.DEFAULTMEMBERUNIQUENAMETYPE) {
                writer.attribute(STRING_NAME, "memberUniqueName");
            } else if (dType == LevelLabelType.DEFAULTLEVELLABELTYPE) {
                writer.attribute(STRING_NAME, "levelLabel");
            } else if (dType == LevelNumberType.LEVELNUMBERTYPE) {
                writer.attribute(STRING_NAME, "levelNumber");
            } else if (dType == MemberDescriptionType.DEFAULTMEMBERDESCRIPTIONTYPE) {
                writer.attribute(STRING_NAME, "memberDescription");
            } else if (dType == ParentUniqueNameType.DEFAULTPARENTUNIQUENAMETYPE) {
                writer.attribute(STRING_NAME, "parentUniqueName");
            } else if (dType == QueryItemModelIDType.DEFAULTQUERYITEMMODELIDTYPE) {
                writer.attribute(STRING_NAME, "queryItemModelID");
            } else if (dType == MemberRollupType.DEFAULTMEMBERROLLUPTYPE) {
                writer.attribute(STRING_NAME, "rollupType");
            } else if (dType == BusinessKeyType.DEFAULTBUSINESSKEYTYPE) {
                writer.attribute(STRING_NAME, "businessKey");
            } else if (dType == QueryItemModelIDType.DEFAULTQUERYITEMMODELIDTYPE) {
                writer.attribute(STRING_NAME, "queryItemModelID");
            }
            writer.endElement();
        }
        writer.endElement();
    }

    @Override
    public void toXMLString(XMLWriter writer) {
        this.toXMLString(writer, true, true);
    }

    protected void captureDataItems(PlanningEnvironment env, Element inputNode) {
        List childList = inputNode.elements();
        int nChildren = childList.size();
        for (int i = 0; i < nChildren; ++i) {
            Element child = (Element)childList.get(i);
            if (!"dataItem".equals(child.getName())) continue;
            RSAPIDataItem dataItem = new RSAPIDataItem();
            dataItem.capture(child);
            this.setDataItem(i, dataItem);
        }
    }

    protected DataType[] captureProperties(PlanningEnvironment env, Element inputNode) {
        List childList = inputNode.elements();
        ArrayList<IDataType> propertyList = new ArrayList<IDataType>();
        for (Element child : childList) {
            Attribute attribute = child.attribute(STRING_NAME);
            propertyList.add(DataTypeFactory.getType(attribute.getStringValue()));
        }
        DataType[] dataTypes = new DataType[propertyList.size()];
        for (int i = 0; i < propertyList.size(); ++i) {
            dataTypes[i] = (DataType)propertyList.get(i);
        }
        return dataTypes;
    }

    public int getNumDataItems() {
        return this.mDataItems.size();
    }

    public RSAPIEdge getEdge() {
        return null;
    }

    public void setContainsHeaderReturningFirstValue(boolean b) {
        this.mContainsHeaderReturningFirstValue = b;
    }

    public boolean getContainsHeaderReturningFirstValue() {
        return this.mContainsHeaderReturningFirstValue;
    }

    public boolean isDetailRowset() {
        return false;
    }

    @Override
    public void persist(XQEPersistContext ctx, String optionalName) {
        if (ctx.beginElement(this, optionalName, -1)) {
            this.persistAttributeProperties(ctx);
            this.persistElementProperties(ctx);
            ctx.endElement();
        }
    }

    protected void persistAttributeProperties(XQEPersistContext ctx) {
        ctx.property(STRING_NAME, this.getName());
        ctx.property(ROWSET_ID, this.getRowsetId());
    }

    protected void persistElementProperties(XQEPersistContext ctx) {
        if (this.mDataItems != null) {
            ctx.elementProperty(STRING_DATAITEMS, this.mDataItems);
        }
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
        this.restoreAttributes(ctx, node);
        this.restoreChildren(ctx, node);
    }

    public void restoreAttributes(XQERestoreContext ctx, Element node) {
        int size = node.attributeCount();
        for (int i = 0; i < size; ++i) {
            Object value;
            Attribute att = node.attribute(i);
            String attname = att.getName();
            if (attname.equals(STRING_NAME)) {
                value = ctx.attributeValue(att);
                this.mName = (String)value;
                continue;
            }
            if (!attname.equals(ROWSET_ID)) continue;
            value = ctx.attributeValue(att);
            this.mRowsetId = (Integer)value;
        }
    }

    protected void restoreChildren(XQERestoreContext ctx, Element node) {
        ctx.setOwner(this);
        List childList = node.elements();
        int nChildren = childList.size();
        for (int i = 0; i < nChildren; ++i) {
            Element child = (Element)childList.get(i);
            String pname = child.attributeValue("pname");
            if (pname == null) continue;
            this.restoreElementProperty(ctx, child, node);
        }
        ctx.resetOwner();
    }

    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname != null && pname.equals(STRING_DATAITEMS)) {
            Object value = ctx.elementValue(node);
            this.mDataItems = (ArrayList)value;
        }
    }
}

