/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.rsapi;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.MemberType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPITabularIterator;
import com.cognos.xqe.rsapi.RSAPIUsage;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.ibm.icu.text.Collator;

public class RSAPITabularRow {
    private int mRowNumber;
    private IValue[] mColumns;
    private boolean mDetail;
    private IValue mPreviousRefDataItemValue;
    private RSAPIEdgeRowset mRowset;
    private boolean mGrouped;
    protected static final int NO_ANCESTOR_ROWSET = -1;
    private boolean mFirstRowRead;
    private RSAPITabularIterator mIterator;
    private boolean mControlBreakEncountered;
    private static final int REF_DATA_ITEM_OFFSET = 0;
    private boolean mCrossTabReport;
    private int mParentRowsetId;

    protected RSAPITabularRow(RSAPIEdgeRowset rowset, RSAPITabularIterator it, boolean isCrossTabReport) {
        this.mIterator = it;
        this.mCrossTabReport = isCrossTabReport;
        this.mRowset = rowset;
        this.buildColumns(rowset);
        if (this.getRowset().isDetailRowset()) {
            this.setIsDetail(true);
        }
        if (this.getRowset().getRefDataItem() != null) {
            if (this.getRowset().getNestedRowset() != null) {
                this.setIsGrouped();
            }
            IDataType type = this.getRowset().getRefDataItem().getDataType();
            RSAPIUsage usage = this.getRowset().getRefDataItem().getUsage();
            this.mPreviousRefDataItemValue = type == MemberType.MEMBERTYPE || this.getRowset().getRefDataItem().isCustomProperty() || (usage == RSAPIUsage.FACT || usage == RSAPIUsage.IDENTIFIER) && this.mCrossTabReport ? MemberType.MEMBERTYPE.createValue() : type.createValue(it.getDataContext().getLocalCollator());
            this.mPreviousRefDataItemValue.setNull();
        }
    }

    public Object copy() {
        RSAPITabularRow row = new RSAPITabularRow(this.getRowset(), this.mIterator, this.mCrossTabReport);
        row.setIsDetail(this.isDetail());
        row.setRowNumber(this.getRowNumber());
        row.setParentRowsetId(this.getParentRowsetId());
        for (int i = 0; i < this.getNumColumns(); ++i) {
            row.copyColumnValue(i, this.getColumn(i));
        }
        if (this.isControlBreak()) {
            row.setControlBreakEncountered();
            row.setFirstRowRead(this.getFirstRowRead());
        }
        return row;
    }

    private void setFirstRowRead(boolean firstRowRead) {
        this.mFirstRowRead = firstRowRead;
    }

    public boolean getFirstRowRead() {
        return this.mFirstRowRead;
    }

    private void buildColumns(RSAPIEdgeRowset rowset) {
        int numDataItems = 0;
        if (rowset.getRefDataItem() != null) {
            ++numDataItems;
        }
        this.mColumns = new IValue[numDataItems += rowset.getDataItems().length];
    }

    public RSAPIEdgeRowset getRowset() {
        return this.mRowset;
    }

    public int getRowsetId() {
        return this.getRowset().getRowsetId();
    }

    public int getRowNumber() {
        return this.mRowNumber;
    }

    public void setRowNumber(int rowNumber) {
        this.mRowNumber = rowNumber;
    }

    public IValue getColumn(int index) {
        return this.mColumns[index];
    }

    protected void copyColumnValue(int index, IValue value) {
        if (index == -1) {
            index = 0;
        }
        this.mColumns[index] = value == null ? null : (value instanceof ContextMember ? value : (IValue)value.copy());
    }

    protected void assignColumnValue(int index, IValue value) {
        if (index == -2) {
            return;
        }
        if (index == -1) {
            index = 0;
        } else if (this.getRowset().getRefDataItem() != null) {
            ++index;
        }
        this.mColumns[index] = value;
        this.checkForControlBreak(index);
    }

    private void checkForControlBreak(int index) {
        if (index != 0) {
            return;
        }
        if (this.isGrouped()) {
            if (this.getFirstRowRead()) {
                Object obj = this.getColumn(0);
                RSAPIDataItem dataItem = this.getRowset().getRefDataItem();
                if (!this.mPreviousRefDataItemValue.isMetadata()) {
                    if (dataItem.isCustomProperty()) {
                        ContextMember contextMember = (ContextMember)obj;
                        obj = contextMember.getProperty(dataItem.getPropertyName());
                    } else if (obj.getDataType() == MemberType.MEMBERTYPE) {
                        ContextMember contextMember = (ContextMember)obj;
                        if (contextMember.getMember() != null) {
                            obj = contextMember.getMember().getCaptionValue();
                        }
                    } else {
                        obj = ((ContextValue)obj).getValue();
                    }
                }
                if (this.compareValue(this.mPreviousRefDataItemValue, obj)) {
                    this.setNoControlBreakEncountered();
                } else {
                    this.setControlBreaksInThisAndRelatedRows();
                }
            } else {
                this.setControlBreaksInThisAndRelatedRows();
            }
        }
    }

    private boolean compareValue(IValue column1, Object obj) {
        if (column1 instanceof TextValue) {
            return ((TextValue)column1).compareTo(obj, (Collator)null) == 0;
        }
        if (column1 != obj && column1 instanceof ContextMember && ((ContextMember)column1).getMember() instanceof CalculatedMember && obj instanceof ContextMember && ((ContextMember)obj).getMember() instanceof CalculatedMember) {
            CalculatedMember column1Calc = (CalculatedMember)((ContextMember)column1).getMember();
            CalculatedMember objCalc = (CalculatedMember)((ContextMember)obj).getMember();
            return column1Calc.getUniqueName().equals(objCalc.getUniqueName());
        }
        return column1.compareTo(obj) == 0;
    }

    private void setNoControlBreakEncountered() {
        this.mControlBreakEncountered = false;
    }

    protected void setControlBreakEncountered() {
        this.mControlBreakEncountered = true;
    }

    private void setControlBreaksInThisAndRelatedRows() {
        this.setControlBreakEncountered();
        this.setFirstRowRead(true);
        if (this.isGrouped()) {
            if (this.mPreviousRefDataItemValue.isMetadata()) {
                IValue value = this.getColumn(0);
                if (value instanceof ContextMember) {
                    this.mPreviousRefDataItemValue = this.getColumn(0);
                } else {
                    this.mPreviousRefDataItemValue.copyFrom(this.getColumn(0));
                }
            } else if (this.getRowset().getRefDataItem().isCustomProperty()) {
                ContextMember member = (ContextMember)this.getColumn(0);
                ((Value)this.mPreviousRefDataItemValue).set(member.getProperty(this.getRowset().getRefDataItem().getPropertyName()));
            } else if (this.getColumn(0).getDataType() == MemberType.MEMBERTYPE) {
                ContextMember member = (ContextMember)this.getColumn(0);
                if (member.getMember() != null) {
                    if (this.mPreviousRefDataItemValue.getDataType().getCCLTypeCode() == 22) {
                        this.mPreviousRefDataItemValue = (Value)member.getMember().getCaptionValue().copy();
                    } else {
                        ((Value)this.mPreviousRefDataItemValue).set(member.getMember().getCaptionValue());
                    }
                }
            } else {
                IValue value = ((ContextValue)this.getColumn(0)).getValue();
                this.mPreviousRefDataItemValue.copyFrom(value);
            }
            this.mIterator.resetRowsetControlBreaks(this.getRowset().getNestedRowset());
        }
    }

    protected boolean isGrouped() {
        return this.mGrouped;
    }

    protected void resetControlBreak() {
        this.setNoControlBreakEncountered();
        this.setFirstRowRead(false);
    }

    public int getNumColumns() {
        return this.mColumns.length;
    }

    private void setIsGrouped() {
        this.mGrouped = true;
    }

    protected void setIsDetail(boolean value) {
        RSAPIEdgeRowset nestedRowset;
        if (this.getRowset().isDetailRowset()) {
            this.mDetail = true;
            return;
        }
        if (this.getRowset().getNestedRowset() != null && this.getRowset().getNestedRowset().isEmpty() && ((nestedRowset = this.getRowset().getNestedRowset()).getHeaderRowset() == null || nestedRowset.getHeaderRowset().isEmpty()) && (nestedRowset.getFooterRowset() == null || nestedRowset.getFooterRowset().isEmpty())) {
            this.mDetail = false;
            return;
        }
        this.mDetail = value ? !this.isFooter() && !this.isHeader() : false;
    }

    public boolean isFooter() {
        return this.getRowset().isFooterRowset();
    }

    public boolean isHeader() {
        return this.getRowset().isHeaderRowset();
    }

    public boolean isSummary() {
        return this.isHeader() || this.isFooter();
    }

    public boolean isDetail() {
        if (this.getRowset().isDetailRowset()) {
            return true;
        }
        return this.mDetail;
    }

    protected void setColumnsNull() {
        for (int i = 0; i < this.getNumColumns(); ++i) {
            this.mColumns[i] = null;
        }
    }

    public boolean isControlBreak() {
        return this.mControlBreakEncountered;
    }

    public int getParentRowsetId() {
        return this.mParentRowsetId;
    }

    public void setParentRowsetId(int rowsetId) {
        this.mParentRowsetId = rowsetId;
    }

    public int getGroupingRowsetId() {
        return this.mRowset.getGroupingRowset().getRowsetId();
    }

    public int getParentRowsetIdAsPerReportLayout() {
        if (this.mRowset.getParentRowset() == null) {
            return -1;
        }
        return this.mRowset.getParentRowset().getRowsetId();
    }
}

